/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.IOException;
import java.util.Set;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.history.CommitFileDiffViewer;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.osgi.util.NLS;

public class FileDiffContentProvider
implements IStructuredContentProvider {
    static final int INTERESTING_MARK_TREE_FILTER_INDEX = 0;
    private TreeWalk walk;
    private RevCommit commit;
    private FileDiff[] diff;
    private TreeFilter markTreeFilter = TreeFilter.ALL;
    private Repository repo;

    public void inputChanged(Viewer newViewer, Object oldInput, Object newInput) {
        if (newInput != null) {
            this.repo = ((CommitFileDiffViewer)newViewer).getRepository();
            this.walk = ((CommitFileDiffViewer)newViewer).getTreeWalk();
            this.commit = (RevCommit)newInput;
        } else {
            this.repo = null;
            this.walk = null;
            this.commit = null;
        }
        this.diff = null;
    }

    void setInterestingPaths(Set<String> interestingPaths) {
        this.markTreeFilter = interestingPaths != null ? PathFilterGroup.createFromStrings(interestingPaths) : TreeFilter.ALL;
        this.diff = null;
    }

    public Object[] getElements(Object inputElement) {
        if (this.diff == null && this.walk != null && this.commit != null) {
            try {
                this.diff = FileDiff.compute(this.repo, this.walk, this.commit, this.markTreeFilter);
            }
            catch (IOException err) {
                Activator.handleError(NLS.bind((String)UIText.FileDiffContentProvider_errorGettingDifference, (Object)this.commit.getId()), err, false);
            }
        }
        return this.diff != null ? this.diff : new Object[]{};
    }

    public void dispose() {
    }
}

