/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.utils.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.common.utils.Joiner;
import org.eclipse.titan.common.utils.StringUtils;

public final class PreferenceUtils {
    private PreferenceUtils() {
    }

    private static String serializeToString(Iterable<String> items, String delimiter, String escape) {
        Joiner joiner = new Joiner(delimiter);
        for (String item : items) {
            joiner.join(PreferenceUtils.escape(item, delimiter, escape));
        }
        return joiner.toString();
    }

    private static String escape(String original, String delimiter, String escape) {
        return original.replace(escape, escape + escape).replace(delimiter, escape + delimiter);
    }

    public static String serializeToString(Iterable<String> items) {
        return PreferenceUtils.serializeToString(items, ";", "#");
    }

    public static List<String> deserializeFromString(String stringList) {
        return PreferenceUtils.deserializeFromString(stringList, ';', '#');
    }

    private static List<String> deserializeFromString(String input, char delimiter, char escape) {
        ArrayList<String> results = new ArrayList<String>();
        if (StringUtils.isNullOrEmpty(input)) {
            return results;
        }
        StringBuilder tempResult = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (escape == c) {
                if (input.length() <= i + 1) continue;
                tempResult.append(input.charAt(i + 1));
                ++i;
                continue;
            }
            if (delimiter == c) {
                results.add(tempResult.toString());
                tempResult = new StringBuilder();
                continue;
            }
            tempResult.append(c);
        }
        results.add(tempResult.toString());
        return results;
    }
}

