/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST;

import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IASTNode;
import org.eclipse.titan.designer.AST.IIdentifierContainer;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_ModulePar;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definitions;
import org.eclipse.titan.designer.editors.T3Doc;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public abstract class ASTNode
implements IASTNode,
IIdentifierContainer,
IVisitableNode {
    protected Scope myScope;
    private INamedNode nameParent;

    public Location getCommentLocation() {
        return null;
    }

    @Override
    public String getFullName() {
        return this.getFullName(this).toString();
    }

    public T3Doc getT3Doc(Location location) {
        if (this instanceof Def_ModulePar) {
            String st1 = this.getFullName().toString();
            String st = st1.substring(st1.lastIndexOf(46) + 1);
            return new T3Doc(this.getCommentLocation(), st);
        }
        if (this.getCommentLocation() != null) {
            return new T3Doc(this.getCommentLocation());
        }
        if (this instanceof ILocateableNode) {
            ILocateableNode iloc = (ILocateableNode)((Object)this);
            Scope scope = this.getMyScope();
            Assignment assignment = scope.getModuleScope().getEnclosingAssignment(iloc.getLocation().getOffset());
            if (assignment == null || assignment == this || assignment.getMyScope() instanceof Definitions) {
                return null;
            }
            T3Doc parentT3doc = assignment.getT3Doc(location);
            if (parentT3doc != null) {
                if (assignment.getAssignmentType() == Assignment.Assignment_type.A_TYPE) {
                    String desc;
                    IType type = assignment.getType(CompilationTimeStamp.getBaseTimestamp());
                    if (type == null) {
                        return null;
                    }
                    ReferenceFinder rf = new ReferenceFinder(assignment);
                    rf.scope = this.getMyScope().getModuleScope().getSmallestEnclosingScope(iloc.getLocation().getOffset());
                    rf.type = assignment.getType(CompilationTimeStamp.getBaseTimestamp());
                    type.getEnclosingField(location.getOffset(), rf);
                    String st = null;
                    if (rf.fieldId != null) {
                        st = rf.fieldId.getDisplayName();
                    } else {
                        String st1 = this.getFullName().toString();
                        st = st1.substring(st1.lastIndexOf(46) + 1);
                    }
                    if (parentT3doc.getMembers() != null && (desc = parentT3doc.getMembers().get(st)) != null) {
                        return new T3Doc(desc);
                    }
                } else if (assignment.getAssignmentType() == Assignment.Assignment_type.A_TEMPLATE) {
                    String st1 = this.getFullName().toString();
                    String st = st1.substring(st1.lastIndexOf(46) + 1);
                    String desc = null;
                    if (parentT3doc.getMembers() != null) {
                        desc = parentT3doc.getMembers().get(st);
                    }
                    if (parentT3doc.getParams() != null) {
                        desc = parentT3doc.getParams().get(st);
                    }
                    if (desc != null) {
                        return new T3Doc(desc);
                    }
                } else if (assignment.getAssignmentType() == Assignment.Assignment_type.A_FUNCTION || assignment.getAssignmentType() == Assignment.Assignment_type.A_FUNCTION_RTEMP || assignment.getAssignmentType() == Assignment.Assignment_type.A_FUNCTION_RVAL) {
                    String desc;
                    String st1 = this.getFullName().toString();
                    String st = st1.substring(st1.lastIndexOf(46) + 1);
                    if (parentT3doc.getParams() != null && (desc = parentT3doc.getParams().get(st)) != null) {
                        return new T3Doc(desc);
                    }
                }
            }
        }
        return null;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        if (null != this.nameParent) {
            return this.nameParent.getFullName(this);
        }
        return new StringBuilder();
    }

    @Override
    public final void setFullNameParent(INamedNode nameParent) {
        this.nameParent = nameParent;
    }

    @Override
    public INamedNode getNameParent() {
        return this.nameParent;
    }

    @Override
    public void setMyScope(Scope scope) {
        this.myScope = scope;
    }

    @Override
    public final Scope getMyScope() {
        return this.myScope;
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
    }

    protected abstract boolean memberAccept(ASTVisitor var1);

    @Override
    public boolean accept(ASTVisitor v) {
        switch (v.visit(this)) {
            case 2: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        if (!this.memberAccept(v)) {
            return false;
        }
        return v.leave(this) != 2;
    }
}

