/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.editors.ISemanticTITANEditor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public final class MarkerHandler {
    private static final String MARKER_HANDLING_ERROR = "Marker handling error";
    private static String[] allMarkerTypes = new String[]{"org.eclipse.titan.designer.compilerErrorMarker", "org.eclipse.titan.designer.compilerWarningMarker", "org.eclipse.titan.designer.compilerInfoMarker", "org.eclipse.titan.designer.ontheflySemanticMarker", "org.eclipse.titan.designer.ontheflySyntacticMarker", "org.eclipse.titan.designer.ontheflyTaskMarker", "org.eclipse.titan.designer.ontheflyMixedMarker"};
    private static final Map<String, Map<IResource, List<InternalMarker>>> MARKERS = new HashMap<String, Map<IResource, List<InternalMarker>>>();
    private static final Map<String, Map<IResource, Set<Long>>> MARKERS_TO_BE_REMOVED = new HashMap<String, Map<IResource, Set<Long>>>();

    private MarkerHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markMarkersForRemoval(String markerTypeID, IResource file) {
        if (!MARKERS.containsKey(markerTypeID)) {
            return;
        }
        Map<String, Map<IResource, List<InternalMarker>>> map = MARKERS;
        synchronized (map) {
            Set<Long> markerIdstobeRemoved;
            Map<Object, Object> typeSpecificRemovable;
            Map<IResource, List<InternalMarker>> typeSpecificMarkers = MARKERS.get(markerTypeID);
            if (!typeSpecificMarkers.containsKey(file)) {
                return;
            }
            List<InternalMarker> fileSpecificMarkers = typeSpecificMarkers.get(file);
            if (fileSpecificMarkers == null || fileSpecificMarkers.isEmpty()) {
                return;
            }
            if (MARKERS_TO_BE_REMOVED.containsKey(markerTypeID)) {
                typeSpecificRemovable = MARKERS_TO_BE_REMOVED.get(markerTypeID);
            } else {
                typeSpecificRemovable = new HashMap();
                MARKERS_TO_BE_REMOVED.put(markerTypeID, typeSpecificRemovable);
            }
            if (typeSpecificRemovable.containsKey(file)) {
                markerIdstobeRemoved = (Set)typeSpecificRemovable.get(file);
            } else {
                markerIdstobeRemoved = new HashSet();
                typeSpecificRemovable.put(file, markerIdstobeRemoved);
            }
            for (InternalMarker marker : fileSpecificMarkers) {
                markerIdstobeRemoved.add(marker.markerID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markMarkersForRemoval(String markerTypeID, IResource file, int startOffset, int endOffset) {
        if (!MARKERS.containsKey(markerTypeID)) {
            return;
        }
        Map<String, Map<IResource, List<InternalMarker>>> map = MARKERS;
        synchronized (map) {
            Set<Long> markerIds;
            Map<Object, Object> typeSpecificRemovable;
            Map<IResource, List<InternalMarker>> typeSpecificMarkers = MARKERS.get(markerTypeID);
            if (!typeSpecificMarkers.containsKey(file)) {
                return;
            }
            List<InternalMarker> fileSpecificMarkers = typeSpecificMarkers.get(file);
            if (fileSpecificMarkers == null || fileSpecificMarkers.isEmpty()) {
                return;
            }
            if (MARKERS_TO_BE_REMOVED.containsKey(markerTypeID)) {
                typeSpecificRemovable = MARKERS_TO_BE_REMOVED.get(markerTypeID);
            } else {
                typeSpecificRemovable = new HashMap();
                MARKERS_TO_BE_REMOVED.put(markerTypeID, typeSpecificRemovable);
            }
            if (typeSpecificRemovable.containsKey(file)) {
                markerIds = (Set)typeSpecificRemovable.get(file);
            } else {
                markerIds = new HashSet();
                typeSpecificRemovable.put(file, markerIds);
            }
            for (InternalMarker marker : fileSpecificMarkers) {
                if (marker.offset < startOffset || marker.endoffset > endOffset) continue;
                markerIds.add(marker.markerID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeMarkedMarkers(String markerTypeID, IResource file) {
        if (!MARKERS_TO_BE_REMOVED.containsKey(markerTypeID)) {
            return;
        }
        ArrayList markersTobeDeleted = new ArrayList();
        Object object = MARKERS;
        synchronized (object) {
            Map<IResource, Set<Long>> typeSpecificRemovable = MARKERS_TO_BE_REMOVED.get(markerTypeID);
            if (!typeSpecificRemovable.containsKey(file)) {
                return;
            }
            markersTobeDeleted.addAll(typeSpecificRemovable.get(file));
            typeSpecificRemovable.remove(file);
        }
        object = markersTobeDeleted.iterator();
        while (object.hasNext()) {
            long markerID = (Long)object.next();
            try {
                IMarker externalMarker = file.findMarker(markerID);
                if (externalMarker == null) continue;
                externalMarker.delete();
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)MARKER_HANDLING_ERROR, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isMarkerdForRemoval(String markerTypeID, IResource file, long markerID) {
        if (!MARKERS_TO_BE_REMOVED.containsKey(markerTypeID)) {
            return false;
        }
        Map<String, Map<IResource, List<InternalMarker>>> map = MARKERS;
        synchronized (map) {
            Map<IResource, Set<Long>> specificRemovable = MARKERS_TO_BE_REMOVED.get(markerTypeID);
            if (!specificRemovable.containsKey(file)) {
                return false;
            }
            Set<Long> markerIds = specificRemovable.get(file);
            return markerIds.contains(markerID);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markUsed(String markerTypeID, IResource file, long markerId) {
        if (!MARKERS_TO_BE_REMOVED.containsKey(markerTypeID)) {
            return;
        }
        Map<String, Map<IResource, List<InternalMarker>>> map = MARKERS;
        synchronized (map) {
            Map<IResource, Set<Long>> typeSpecificRemovable = MARKERS_TO_BE_REMOVED.get(markerTypeID);
            if (!typeSpecificRemovable.containsKey(file)) {
                return;
            }
            Set<Long> markerIds = typeSpecificRemovable.get(file);
            markerIds.remove(markerId);
            if (markerIds.isEmpty()) {
                typeSpecificRemovable.remove(file);
                if (typeSpecificRemovable.isEmpty()) {
                    MARKERS_TO_BE_REMOVED.remove(markerTypeID);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMarker(String markerTypeID, IResource file, int lineNumber, int offset, int endoffset, long markerId) {
        Map<String, Map<IResource, List<InternalMarker>>> map = MARKERS;
        synchronized (map) {
            List<InternalMarker> fileSpecificMarkers;
            Map<Object, Object> typeSpecificMarkers;
            if (MARKERS.containsKey(markerTypeID)) {
                typeSpecificMarkers = MARKERS.get(markerTypeID);
            } else {
                typeSpecificMarkers = new HashMap();
                MARKERS.put(markerTypeID, typeSpecificMarkers);
            }
            if (typeSpecificMarkers.containsKey(file)) {
                fileSpecificMarkers = (List)typeSpecificMarkers.get(file);
            } else {
                fileSpecificMarkers = new ArrayList();
                typeSpecificMarkers.put(file, fileSpecificMarkers);
            }
            InternalMarker temp = new InternalMarker();
            temp.row = lineNumber;
            temp.offset = offset;
            temp.endoffset = endoffset;
            temp.markerID = markerId;
            fileSpecificMarkers.add(temp);
            MarkerHandler.markUsed(markerTypeID, file, markerId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IMarker hasMarker(String markerTypeID, IResource file, int lineNumber, int offset, int endoffset, int severity, String text) {
        if (!MARKERS.containsKey(markerTypeID)) {
            return null;
        }
        Map<String, Map<IResource, List<InternalMarker>>> map = MARKERS;
        synchronized (map) {
            Map<IResource, List<InternalMarker>> typeSpecificMarkers = MARKERS.get(markerTypeID);
            if (!typeSpecificMarkers.containsKey(file)) {
                return null;
            }
            List<InternalMarker> fileSpecificMarkers = typeSpecificMarkers.get(file);
            for (InternalMarker internalMarker : fileSpecificMarkers) {
                if (internalMarker.row != lineNumber || internalMarker.offset != offset || internalMarker.endoffset != endoffset) continue;
                try {
                    IMarker externalMarker = file.findMarker(internalMarker.markerID);
                    if (externalMarker == null || severity != externalMarker.getAttribute("severity", 2) || !externalMarker.getAttribute("message", "").equals(text)) continue;
                    return externalMarker;
                }
                catch (CoreException e) {
                    ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                }
            }
            return null;
        }
    }

    public static void updateMarkers(IResource file, int lineOffset, int lineShift, int offset, int shift) {
        for (String markerTypeID : MARKERS.keySet()) {
            MarkerHandler.updateMarkers(markerTypeID, file, lineOffset, lineShift, offset, shift);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateMarkers(String markerTypeID, IResource file, int lineOffset, int lineShift, int offset, int shift) {
        if (!MARKERS.containsKey(markerTypeID)) {
            return;
        }
        Map<String, Map<IResource, List<InternalMarker>>> map = MARKERS;
        synchronized (map) {
            Map<IResource, List<InternalMarker>> typeSpecificMarkers = MARKERS.get(markerTypeID);
            if (!typeSpecificMarkers.containsKey(file)) {
                return;
            }
            List<InternalMarker> fileSpecificMarkers = typeSpecificMarkers.get(file);
            if (fileSpecificMarkers == null || fileSpecificMarkers.isEmpty()) {
                return;
            }
            for (InternalMarker marker : fileSpecificMarkers) {
                if (marker.row < lineOffset || marker.offset <= offset) continue;
                marker.row += lineShift;
                if (marker.offset != -1) {
                    marker.offset += shift;
                }
                if (marker.endoffset == -1) continue;
                marker.endoffset += shift;
            }
        }
    }

    public static void updateInsertMarkers(IResource file, int lineOffset, int lineShift, int offset, int shift) {
        for (String markerTypeID : MARKERS.keySet()) {
            MarkerHandler.updateInsertMarkers(markerTypeID, file, lineOffset, lineShift, offset, shift);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateInsertMarkers(String markerTypeID, IResource file, int lineOffset, int lineShift, int offset, int shift) {
        if (!MARKERS.containsKey(markerTypeID)) {
            return;
        }
        Map<String, Map<IResource, List<InternalMarker>>> map = MARKERS;
        synchronized (map) {
            Map<IResource, List<InternalMarker>> typeSpecificMarkers = MARKERS.get(markerTypeID);
            if (!typeSpecificMarkers.containsKey(file)) {
                return;
            }
            List<InternalMarker> fileSpecificMarkers = typeSpecificMarkers.get(file);
            if (fileSpecificMarkers == null || fileSpecificMarkers.isEmpty()) {
                return;
            }
            Iterator<InternalMarker> iterator = fileSpecificMarkers.iterator();
            while (iterator.hasNext()) {
                InternalMarker marker = iterator.next();
                if (marker.row < lineOffset || marker.offset <= offset) continue;
                marker.row += lineShift;
                if (marker.offset != -1) {
                    marker.offset += shift;
                }
                if (marker.endoffset != -1) {
                    marker.endoffset += shift;
                }
                try {
                    IMarker externalMarker = file.findMarker(marker.markerID);
                    if (externalMarker != null) continue;
                    iterator.remove();
                }
                catch (CoreException e) {
                    ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                }
            }
        }
    }

    public static void updateRemoveMarkers(IResource file, int lineOffset, int lineShift, int offset, int shift) {
        for (String markerTypeID : MARKERS.keySet()) {
            MarkerHandler.updateRemoveMarkers(markerTypeID, file, lineOffset, lineShift, offset, shift);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateRemoveMarkers(String markerTypeID, IResource file, int lineOffset, int lineShift, int offset, int shift) {
        if (!MARKERS.containsKey(markerTypeID)) {
            return;
        }
        ArrayList<Long> markersTobeDeleted = new ArrayList<Long>();
        Object object = MARKERS;
        synchronized (object) {
            Map<IResource, List<InternalMarker>> typeSpecificMarkers = MARKERS.get(markerTypeID);
            if (!typeSpecificMarkers.containsKey(file)) {
                return;
            }
            List<InternalMarker> fileSpecificMarkers = typeSpecificMarkers.get(file);
            if (fileSpecificMarkers == null || fileSpecificMarkers.isEmpty()) {
                return;
            }
            Iterator<InternalMarker> iterator = fileSpecificMarkers.iterator();
            while (iterator.hasNext()) {
                InternalMarker marker = iterator.next();
                if (marker.offset >= offset && marker.offset + shift <= offset) {
                    iterator.remove();
                    markersTobeDeleted.add(marker.markerID);
                    continue;
                }
                if (marker.row != -1 && marker.row > lineOffset) {
                    marker.row -= lineShift;
                }
                if (marker.offset != -1 && marker.offset > offset - shift) {
                    marker.offset += shift;
                }
                if (marker.endoffset != -1 && marker.endoffset > offset - shift) {
                    marker.endoffset += shift;
                }
                try {
                    IMarker externalMarker = file.findMarker(marker.markerID);
                    if (externalMarker != null) continue;
                    iterator.remove();
                }
                catch (CoreException e) {
                    ErrorReporter.logExceptionStackTrace((String)MARKER_HANDLING_ERROR, (Throwable)e);
                }
            }
        }
        object = markersTobeDeleted.iterator();
        while (object.hasNext()) {
            long markerID = (Long)object.next();
            try {
                IMarker externalMarker = file.findMarker(markerID);
                if (externalMarker == null) continue;
                externalMarker.delete();
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)MARKER_HANDLING_ERROR, (Throwable)e);
            }
        }
    }

    public static void markAllMarkersForRemoval(IResource resource) {
        MarkerHandler.markAllMarkersForRemoval(resource, true);
    }

    public static void markAllMarkersForRemoval(IResource resource, boolean effectsChildren) {
        ArrayList<Object> resources = new ArrayList<Object>();
        resources.add(resource);
        if (effectsChildren && !(resource instanceof IFile)) {
            FileFinder finder = new FileFinder();
            try {
                resource.accept((IResourceVisitor)finder);
                for (IFile file : finder.getFiles()) {
                    resources.add(file);
                }
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)MARKER_HANDLING_ERROR, (Throwable)e);
            }
        }
        int size = resources.size();
        for (int i = 0; i < size; ++i) {
            IResource tempResource = (IResource)resources.get(i);
            MarkerHandler.markMarkersForRemoval("org.eclipse.titan.designer.compilerErrorMarker", tempResource);
            MarkerHandler.markMarkersForRemoval("org.eclipse.titan.designer.compilerWarningMarker", tempResource);
            MarkerHandler.markMarkersForRemoval("org.eclipse.titan.designer.compilerInfoMarker", tempResource);
            MarkerHandler.markMarkersForRemoval("org.eclipse.titan.designer.ontheflySemanticMarker", tempResource);
            MarkerHandler.markMarkersForRemoval("org.eclipse.titan.designer.ontheflySyntacticMarker", tempResource);
            MarkerHandler.markMarkersForRemoval("org.eclipse.titan.designer.ontheflyMixedMarker", tempResource);
        }
    }

    public static void markAllMarkersForRemoval(IResource resource, String markerTypeID) {
        ArrayList<Object> resources = new ArrayList<Object>();
        resources.add(resource);
        if (!(resource instanceof IFile)) {
            FileFinder finder = new FileFinder();
            try {
                resource.accept((IResourceVisitor)finder);
                for (IFile file : finder.getFiles()) {
                    resources.add(file);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        int size = resources.size();
        for (int i = 0; i < size; ++i) {
            IResource tempResource = (IResource)resources.get(i);
            MarkerHandler.markMarkersForRemoval(markerTypeID, tempResource);
        }
    }

    public static void markAllOnTheFlyMarkersForRemoval(IResource resource) {
        ArrayList<Object> resources = new ArrayList<Object>();
        resources.add(resource);
        if (!(resource instanceof IFile)) {
            FileFinder finder = new FileFinder();
            try {
                resource.accept((IResourceVisitor)finder);
                for (IFile file : finder.getFiles()) {
                    resources.add(file);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        int size = resources.size();
        for (int i = 0; i < size; ++i) {
            IResource tempResource = (IResource)resources.get(i);
            MarkerHandler.markMarkersForRemoval("org.eclipse.titan.designer.ontheflySemanticMarker", tempResource);
            MarkerHandler.markMarkersForRemoval("org.eclipse.titan.designer.ontheflySyntacticMarker", tempResource);
            MarkerHandler.markMarkersForRemoval("org.eclipse.titan.designer.ontheflyTaskMarker", tempResource);
            MarkerHandler.markMarkersForRemoval("org.eclipse.titan.designer.ontheflyMixedMarker", tempResource);
        }
    }

    public static void markAllOnTheFlyMarkersForRemoval(IResource resource, int startOffset, int endOffset) {
        ArrayList<Object> resources = new ArrayList<Object>();
        resources.add(resource);
        if (!(resource instanceof IFile)) {
            FileFinder finder = new FileFinder();
            try {
                resource.accept((IResourceVisitor)finder);
                for (IFile file : finder.getFiles()) {
                    resources.add(file);
                }
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)MARKER_HANDLING_ERROR, (Throwable)e);
            }
        }
        int size = resources.size();
        for (int i = 0; i < size; ++i) {
            IResource tempResource = (IResource)resources.get(i);
            MarkerHandler.markMarkersForRemoval("org.eclipse.titan.designer.ontheflySyntacticMarker", tempResource, startOffset, endOffset);
            MarkerHandler.markMarkersForRemoval("org.eclipse.titan.designer.ontheflySemanticMarker", tempResource, startOffset, endOffset);
            MarkerHandler.markMarkersForRemoval("org.eclipse.titan.designer.ontheflyTaskMarker", tempResource);
            MarkerHandler.markMarkersForRemoval("org.eclipse.titan.designer.ontheflyMixedMarker", tempResource);
        }
    }

    public static void markAllTaskMarkersForRemoval(IFile resource) {
        MarkerHandler.markMarkersForRemoval("org.eclipse.titan.designer.ontheflyTaskMarker", (IResource)resource);
    }

    public static void markAllSemanticMarkersForRemoval(IFile resource) {
        MarkerHandler.markMarkersForRemoval("org.eclipse.titan.designer.ontheflySemanticMarker", (IResource)resource);
        MarkerHandler.markMarkersForRemoval("org.eclipse.titan.designer.ontheflyMixedMarker", (IResource)resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reEnableAllMarkers(IFile file) {
        Map<String, Map<IResource, List<InternalMarker>>> map = MARKERS;
        synchronized (map) {
            for (String qualifier : allMarkerTypes) {
                Map<IResource, Set<Long>> typeSpecificRemovable = MARKERS_TO_BE_REMOVED.get(qualifier);
                if (typeSpecificRemovable == null || !typeSpecificRemovable.containsKey(file)) continue;
                typeSpecificRemovable.remove(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reEnableAllSemanticMarkers(IFile file, int startOffset, int endOffset) {
        Map<String, Map<IResource, List<InternalMarker>>> map = MARKERS;
        synchronized (map) {
            if (!MARKERS_TO_BE_REMOVED.containsKey("org.eclipse.titan.designer.ontheflySemanticMarker")) {
                return;
            }
            Map<IResource, Set<Long>> typeSpecificRemovable = MARKERS_TO_BE_REMOVED.get("org.eclipse.titan.designer.ontheflySemanticMarker");
            if (typeSpecificRemovable != null && typeSpecificRemovable.containsKey(file)) {
                Set<Long> markerIds = typeSpecificRemovable.get(file);
                List<InternalMarker> fileSpecificMarkers = MARKERS.get("org.eclipse.titan.designer.ontheflySemanticMarker").get(file);
                if (fileSpecificMarkers == null || fileSpecificMarkers.isEmpty()) {
                    markerIds.clear();
                    return;
                }
                for (InternalMarker marker : fileSpecificMarkers) {
                    if (marker.offset < startOffset || marker.endoffset > endOffset) continue;
                    markerIds.remove(marker.markerID);
                }
            }
        }
    }

    public static void removeAllMarkedMarkers(IResource resource) {
        ArrayList<Object> resources = new ArrayList<Object>();
        resources.add(resource);
        if (!(resource instanceof IFile)) {
            FileFinder finder = new FileFinder();
            try {
                resource.accept((IResourceVisitor)finder);
                for (IFile file : finder.getFiles()) {
                    resources.add(file);
                }
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)MARKER_HANDLING_ERROR, (Throwable)e);
            }
        }
        int size = resources.size();
        for (int i = 0; i < size; ++i) {
            IResource tempResource = (IResource)resources.get(i);
            for (String qualifier : allMarkerTypes) {
                MarkerHandler.removeMarkedMarkers(qualifier, tempResource);
            }
        }
    }

    public static void removeAllOnTheFlySyntacticMarkedMarkers(IResource resource) {
        ArrayList<Object> resources = new ArrayList<Object>();
        resources.add(resource);
        if (!(resource instanceof IFile)) {
            FileFinder finder = new FileFinder();
            try {
                resource.accept((IResourceVisitor)finder);
                for (IFile file : finder.getFiles()) {
                    resources.add(file);
                }
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)MARKER_HANDLING_ERROR, (Throwable)e);
            }
        }
        int size = resources.size();
        for (int i = 0; i < size; ++i) {
            IResource tempResource = (IResource)resources.get(i);
            MarkerHandler.removeMarkedMarkers("org.eclipse.titan.designer.ontheflySyntacticMarker", tempResource);
            MarkerHandler.removeMarkedMarkers("org.eclipse.titan.designer.ontheflyTaskMarker", tempResource);
            MarkerHandler.removeMarkedMarkers("org.eclipse.titan.designer.ontheflyMixedMarker", tempResource);
        }
    }

    public static void removeAllOnTheFlyMarkedMarkers(IResource resource) {
        ArrayList<Object> resources = new ArrayList<Object>();
        resources.add(resource);
        if (!(resource instanceof IFile)) {
            FileFinder finder = new FileFinder();
            try {
                resource.accept((IResourceVisitor)finder);
                for (IFile file : finder.getFiles()) {
                    resources.add(file);
                }
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)MARKER_HANDLING_ERROR, (Throwable)e);
            }
        }
        int size = resources.size();
        for (int i = 0; i < size; ++i) {
            IResource tempResource = (IResource)resources.get(i);
            MarkerHandler.removeMarkedMarkers("org.eclipse.titan.designer.ontheflySemanticMarker", tempResource);
            MarkerHandler.removeMarkedMarkers("org.eclipse.titan.designer.ontheflySyntacticMarker", tempResource);
            MarkerHandler.removeMarkedMarkers("org.eclipse.titan.designer.ontheflyTaskMarker", tempResource);
            MarkerHandler.removeMarkedMarkers("org.eclipse.titan.designer.ontheflyMixedMarker", tempResource);
        }
    }

    public static void deprecateMarkers(ISemanticTITANEditor editor, IMarker[] markers) {
        if (editor == null || markers == null) {
            return;
        }
        try {
            AbstractDecoratedTextEditor textEditor = null;
            IFile fileInput = null;
            if (editor instanceof AbstractDecoratedTextEditor && (textEditor = (AbstractDecoratedTextEditor)editor).getEditorInput() instanceof FileEditorInput) {
                FileEditorInput input = (FileEditorInput)textEditor.getEditorInput();
                fileInput = input.getFile();
            }
            for (IMarker marker : markers) {
                if (fileInput != null && textEditor != null && fileInput.equals(marker.getResource())) {
                    IEditorInput editorInput = textEditor.getEditorInput();
                    IDocumentProvider provider = textEditor.getDocumentProvider();
                    if (editorInput != null && provider != null) {
                        IAnnotationModel model = provider.getAnnotationModel((Object)editorInput);
                        Iterator e = model.getAnnotationIterator();
                        while (e.hasNext()) {
                            Annotation annotation = (Annotation)e.next();
                            if (!(annotation instanceof MarkerAnnotation) || !marker.equals((Object)((MarkerAnnotation)annotation).getMarker())) continue;
                            annotation.markDeleted(true);
                        }
                        continue;
                    }
                    if (marker.getAttribute("deprecated", false)) continue;
                    marker.setAttribute("deprecated", true);
                    continue;
                }
                if (marker.getAttribute("deprecated", false)) continue;
                marker.setAttribute("deprecated", true);
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)MARKER_HANDLING_ERROR, (Throwable)e);
        }
    }

    public static void handleResourceChanges(IResourceChangeEvent event) {
        for (String qualifier : allMarkerTypes) {
            IMarkerDelta[] markerDeltas = event.findMarkerDeltas(qualifier, false);
            if (markerDeltas == null) continue;
            block6: for (int i = 0; i < markerDeltas.length; ++i) {
                IMarker marker;
                IResource resource;
                IMarkerDelta markerDelta = markerDeltas[i];
                if (markerDelta == null || (resource = markerDelta.getResource()) == null || (marker = markerDelta.getMarker()) == null) continue;
                switch (markerDelta.getKind()) {
                    case 1: {
                        MarkerHandler.handleMarkerAddition(marker, qualifier);
                        continue block6;
                    }
                    case 2: {
                        MarkerHandler.handleMarkerRemoval(marker, qualifier);
                        continue block6;
                    }
                    case 4: {
                        MarkerHandler.handleMarkerChange(marker, qualifier);
                        continue block6;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleMarkerAddition(IMarker marker, String type) {
        IResource resource = marker.getResource();
        int lineNumber = marker.getAttribute("lineNumber", -1);
        int offset = marker.getAttribute("charStart", -1);
        int endoffset = marker.getAttribute("charEnd", -1);
        long markerId = marker.getId();
        Map<String, Map<IResource, List<InternalMarker>>> map = MARKERS;
        synchronized (map) {
            List<InternalMarker> fileSpecificMarkers;
            Map<Object, Object> typeSpecificMarkers;
            if (MARKERS.containsKey(type)) {
                typeSpecificMarkers = MARKERS.get(type);
            } else {
                typeSpecificMarkers = new HashMap();
                MARKERS.put(type, typeSpecificMarkers);
            }
            if (typeSpecificMarkers.containsKey(resource)) {
                fileSpecificMarkers = (List)typeSpecificMarkers.get(resource);
            } else {
                fileSpecificMarkers = new ArrayList();
                typeSpecificMarkers.put(resource, fileSpecificMarkers);
            }
            boolean found = false;
            for (int i = 0; !found && i < fileSpecificMarkers.size(); ++i) {
                if (((InternalMarker)fileSpecificMarkers.get((int)i)).markerID != markerId) continue;
                found = true;
            }
            if (!found) {
                InternalMarker temp = new InternalMarker();
                temp.row = lineNumber;
                temp.offset = offset;
                temp.endoffset = endoffset;
                temp.markerID = markerId;
                fileSpecificMarkers.add(temp);
            }
            MarkerHandler.markUsed(type, resource, markerId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleMarkerRemoval(IMarker marker, String type) {
        IResource resource = marker.getResource();
        long markerId = marker.getId();
        Map<String, Map<IResource, List<InternalMarker>>> map = MARKERS;
        synchronized (map) {
            Map<IResource, List<InternalMarker>> typeSpecificMarkers = MARKERS.get(type);
            if (typeSpecificMarkers == null) {
                return;
            }
            List<InternalMarker> resourceSpecificMarkers = typeSpecificMarkers.get(resource);
            if (resourceSpecificMarkers == null) {
                return;
            }
            boolean found = false;
            for (int i = 0; !found && i < resourceSpecificMarkers.size(); ++i) {
                if (resourceSpecificMarkers.get((int)i).markerID != markerId) continue;
                resourceSpecificMarkers.remove(i);
                found = true;
            }
            if (resourceSpecificMarkers.isEmpty()) {
                typeSpecificMarkers.remove(resource);
            }
        }
    }

    private static void handleMarkerChange(IMarker marker, String type) {
        MarkerHandler.handleMarkerRemoval(marker, type);
        MarkerHandler.handleMarkerAddition(marker, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasMarker(String markerTypeID, IResource file) {
        if (!MARKERS.containsKey(markerTypeID)) {
            return false;
        }
        Map<String, Map<IResource, List<InternalMarker>>> map = MARKERS;
        synchronized (map) {
            Map<IResource, List<InternalMarker>> typeSpecificMarkers = MARKERS.get(markerTypeID);
            List<InternalMarker> fileSpecificMarkers = typeSpecificMarkers.get(file);
            return fileSpecificMarkers != null && !fileSpecificMarkers.isEmpty();
            {
            }
        }
    }

    public static final class FileFinder
    implements IResourceVisitor {
        private List<IFile> files = new ArrayList<IFile>();

        public boolean visit(IResource resource) throws CoreException {
            if (resource instanceof IFile) {
                this.files.add((IFile)resource);
                return false;
            }
            return true;
        }

        public List<IFile> getFiles() {
            return this.files;
        }
    }

    private static final class InternalMarker {
        public int row;
        public int offset;
        public int endoffset;
        public long markerID;

        private InternalMarker() {
        }
    }
}

