/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST;

import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.titan.common.utils.Joiner;
import org.eclipse.titan.designer.AST.CachedReferenceChain;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IReferenceChainElement;
import org.eclipse.titan.designer.AST.Location;

public final class ReferenceChain
implements IReferenceChain {
    private static final Queue<ReferenceChain> CHAIN_CACHE = new ConcurrentLinkedQueue<ReferenceChain>();
    private final List<IReferenceChainElement> chainLinks = new ArrayList<IReferenceChainElement>();
    private final Deque<Integer> markedStates = new ArrayDeque<Integer>();
    private String message;
    private boolean isError;

    private ReferenceChain(String message, boolean isError) {
        this.message = message;
        this.isError = isError;
    }

    public static ReferenceChain getInstance(String message, boolean isError) {
        ReferenceChain result = CHAIN_CACHE.poll();
        if (result != null) {
            result.message = message;
            result.isError = isError;
            return result;
        }
        return new ReferenceChain(message, isError);
    }

    @Override
    public void release() {
        if (!this.chainLinks.isEmpty()) {
            this.chainLinks.clear();
            this.markedStates.clear();
        }
        CHAIN_CACHE.offer(this);
    }

    @Override
    public boolean add(IReferenceChainElement chainLink) {
        int index = this.chainLinks.indexOf(chainLink);
        if (index >= 0) {
            this.reportError(index);
            return false;
        }
        this.chainLinks.add(chainLink);
        return true;
    }

    private void reportError(int firstIndex) {
        for (int i = firstIndex; i < this.chainLinks.size(); ++i) {
            int i2;
            Joiner joiner = new Joiner(" -> ");
            for (i2 = i; i2 < this.chainLinks.size(); ++i2) {
                joiner.join((Object)this.chainLinks.get(i2).chainedDescription());
            }
            for (i2 = firstIndex; i2 < i; ++i2) {
                joiner.join((Object)this.chainLinks.get(i2).chainedDescription());
            }
            joiner.join((Object)this.chainLinks.get(i).chainedDescription());
            Location location = this.chainLinks.get(i).getChainLocation();
            if (location == null) continue;
            if (this.isError) {
                location.reportSingularSemanticError(MessageFormat.format(this.message, joiner.toString()));
                continue;
            }
            location.reportSingularSemanticWarning(MessageFormat.format(this.message, joiner.toString()));
        }
    }

    @Override
    public void markState() {
        this.markedStates.add(this.chainLinks.size());
    }

    @Override
    public void previousState() {
        if (this.markedStates.isEmpty()) {
            return;
        }
        int markedLimit = this.markedStates.pollLast();
        for (int i = this.chainLinks.size() - 1; i >= markedLimit; --i) {
            this.chainLinks.remove(i);
        }
    }

    public CachedReferenceChain toCachedReferenceChain() {
        int i;
        CachedReferenceChain result = new CachedReferenceChain(this.message, this.isError);
        int idx1 = 0;
        for (int idx2 : this.markedStates) {
            for (int i2 = idx1; i2 < idx2; ++i2) {
                result.add(this.chainLinks.get(i2));
            }
            result.markState();
            idx1 = idx2;
        }
        int n = i = this.markedStates.isEmpty() ? 0 : this.markedStates.peek();
        while (i < this.chainLinks.size()) {
            result.add(this.chainLinks.get(i));
            ++i;
        }
        return result;
    }
}

