/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ArraySubReference;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NamingConventionHelper;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Timer;
import org.eclipse.titan.designer.AST.TTCN3.types.ComponentTypeBody;
import org.eclipse.titan.designer.AST.TTCN3.values.ArrayDimensions;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Real_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SequenceOf_Value;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.IdentifierReparser;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Def_Timer
extends Definition {
    private static final String NEGATIVDURATIONERROR = "A non-negative float value was expected as timer duration instead of {0}";
    private static final String INFINITYDURATIONERROR = "{0} can not be used as the default timer duration";
    private static final String OPERANDERROR = "The default timer duration should be a float value";
    private static final String FULLNAMEPART1 = ".<dimensions>";
    private static final String FULLNAMEPART2 = ".<default_duration>";
    private static final String KIND = "timer";
    private final ArrayDimensions dimensions;
    private final Value defaultDuration;

    public Def_Timer(Identifier identifier, ArrayDimensions dimensions, Value defaultDuration) {
        super(identifier);
        this.dimensions = dimensions;
        this.defaultDuration = defaultDuration;
        if (dimensions != null) {
            dimensions.setFullNameParent(this);
        }
        if (defaultDuration != null) {
            defaultDuration.setFullNameParent(this);
        }
    }

    @Override
    public Assignment.Assignment_type getAssignmentType() {
        return Assignment.Assignment_type.A_TIMER;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.dimensions != null) {
            this.dimensions.setMyScope(scope);
        }
        if (this.defaultDuration != null) {
            this.defaultDuration.setMyScope(scope);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.dimensions == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.defaultDuration == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    @Override
    public String getAssignmentName() {
        return KIND;
    }

    @Override
    public String getDescription() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getAssignmentName()).append(" `");
        if (this.isLocal()) {
            builder.append(this.identifier.getDisplayName());
        } else {
            builder.append(this.getFullName());
        }
        builder.append('\'');
        return builder.toString();
    }

    @Override
    public String getOutlineIcon() {
        return "timer.gif";
    }

    @Override
    public String getProposalKind() {
        return KIND;
    }

    public ArrayDimensions getDimensions() {
        return this.dimensions;
    }

    public boolean hasDefaultDuration(CompilationTimeStamp timestamp, Reference reference) {
        int nofReferences;
        if (this.defaultDuration == null) {
            return false;
        }
        if (this.dimensions == null || reference == null) {
            return true;
        }
        IValue v = this.defaultDuration;
        List<ISubReference> subreferences = reference.getSubreferences();
        int nofDimensions = this.dimensions.size();
        int upperLimit = nofDimensions < (nofReferences = subreferences.size() - 1) ? nofDimensions : nofReferences;
        for (int i = 0; i < upperLimit; ++i) {
            if (!IValue.Value_type.SEQUENCEOF_VALUE.equals((Object)(v = v.getValueRefdLast(timestamp, null)).getValuetype())) continue;
            ISubReference ref = subreferences.get(i + 1);
            if (!ISubReference.Subreference_type.arraySubReference.equals((Object)ref.getReferenceType())) {
                return true;
            }
            Value index = ((ArraySubReference)ref).getValue();
            if (!IValue.Value_type.INTEGER_VALUE.equals((Object)index.getValuetype())) {
                return true;
            }
            long realIndex = ((Integer_Value)index).getValue() - this.dimensions.get(i).getOffset();
            if (realIndex < 0L || realIndex >= (long)((SequenceOf_Value)v).getNofComponents()) continue;
            v = ((SequenceOf_Value)v).getValueByIndex((int)realIndex);
        }
        return !IValue.Value_type.NOTUSED_VALUE.equals((Object)v.getValuetype());
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        this.check(timestamp, null);
    }

    @Override
    public void check(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.isUsed = false;
        if (this.getMyScope() instanceof ComponentTypeBody) {
            NamingConventionHelper.checkConvention("org.eclipse.titan.designer.reportNamingConventionComponentTimer", this.identifier, this);
        } else if (this.isLocal()) {
            NamingConventionHelper.checkConvention("org.eclipse.titan.designer.reportNamingConventionLocalTimer", this.identifier, this);
        } else {
            NamingConventionHelper.checkConvention("org.eclipse.titan.designer.reportNamingConventionGlobalTimer", this.identifier, this);
        }
        NamingConventionHelper.checkNameContents(this.identifier, this.getMyScope().getModuleScope().getIdentifier(), this.getDescription());
        if (this.dimensions != null) {
            this.dimensions.check(timestamp);
        }
        if (this.defaultDuration != null) {
            if (this.dimensions == null) {
                this.defaultDuration.setLoweridToReference(timestamp);
                IType.Type_type tempType = this.defaultDuration.getExpressionReturntype(timestamp, this.isLocal() ? Expected_Value_type.EXPECTED_DYNAMIC_VALUE : Expected_Value_type.EXPECTED_STATIC_VALUE);
                switch (tempType) {
                    case TYPE_REAL: {
                        IValue last = this.defaultDuration.getValueRefdLast(timestamp, null);
                        if (!last.isUnfoldable(timestamp)) {
                            Real_Value real = (Real_Value)last;
                            double value = real.getValue();
                            if (value < 0.0) {
                                this.defaultDuration.getLocation().reportSemanticError(MessageFormat.format(NEGATIVDURATIONERROR, value));
                            } else if (real.isPositiveInfinity()) {
                                String message = MessageFormat.format(INFINITYDURATIONERROR, real.createStringRepresentation());
                                this.defaultDuration.getLocation().reportSemanticError(message);
                            }
                        }
                        return;
                    }
                    case TYPE_UNDEFINED: {
                        return;
                    }
                }
                this.location.reportSemanticError(OPERANDERROR);
            } else {
                this.checkArrayDuration(this.defaultDuration, 0);
            }
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.checkGlobalAttributes(timestamp, false);
            this.withAttributesPath.checkAttributes(timestamp);
        }
        this.lastTimeChecked = timestamp;
    }

    private void checkArrayDuration(IValue duration, int startDimension) {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean checkIdentical(CompilationTimeStamp timestamp, Definition definition) {
        this.check(timestamp);
        definition.check(timestamp);
        if (!Assignment.Assignment_type.A_TIMER.equals(definition.getAssignmentType())) {
            this.location.reportSemanticError(MessageFormat.format("Local definition `{0}'' is a timer, but the definition inherited from component type `{1}'' is a {2}", this.identifier.getDisplayName(), definition.getMyScope().getFullName(), definition.getAssignmentName()));
            return false;
        }
        Def_Timer otherTimer = (Def_Timer)definition;
        if (this.dimensions != null) {
            if (otherTimer.dimensions == null) {
                this.location.reportSemanticError(MessageFormat.format("Local definition `{0}'' is a timer array, but the definition inherited from component type `{1}'' is a single timer", this.identifier.getDisplayName(), otherTimer.getMyScope().getFullName()));
                return false;
            }
            if (!this.dimensions.isIdenticial(timestamp, otherTimer.dimensions)) {
                this.location.reportSemanticError(MessageFormat.format("Local timer `{0}'' and the timer inherited from component type `{1}'' have different array dimensions", this.identifier.getDisplayName(), otherTimer.getMyScope().getFullName()));
                return false;
            }
        } else if (otherTimer.dimensions != null) {
            this.location.reportSemanticError(MessageFormat.format("Local definition `{0}'' is a single timer, but the definition inherited from component type `{1}'' is a timer array", this.identifier.getDisplayName(), otherTimer.getMyScope().getFullName()));
            return false;
        }
        if (this.defaultDuration == null) {
            if (otherTimer.defaultDuration == null) return true;
            this.location.reportSemanticWarning(MessageFormat.format("Local timer `{0}'' does not have default duration, but the timer inherited from component type `{1}'' has", this.identifier.getDisplayName(), otherTimer.getMyScope().getFullName()));
            return true;
        }
        if (otherTimer.defaultDuration != null) {
            if (this.defaultDuration.isUnfoldable(timestamp)) return true;
            if (otherTimer.defaultDuration.isUnfoldable(timestamp)) return true;
            if (this.defaultDuration.checkEquality(timestamp, otherTimer.defaultDuration)) return true;
            String message = MessageFormat.format("Local timer `{0}'' and the timer inherited from component type `{1}'' have different default durations", this.identifier.getDisplayName(), otherTimer.getMyScope().getFullName());
            this.defaultDuration.getLocation().reportSemanticWarning(message);
            return true;
        }
        String message = MessageFormat.format("Local timer `{0}'' has default duration, but the timer inherited from component type `{1}'' does not", this.identifier.getDisplayName(), otherTimer.getMyScope().getFullName());
        this.defaultDuration.getLocation().reportSemanticWarning(message);
        return true;
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int i) {
        List<ISubReference> subrefs = propCollector.getReference().getSubreferences();
        if (subrefs.size() <= i || !ISubReference.Subreference_type.fieldSubReference.equals((Object)subrefs.get(i).getReferenceType())) {
            return;
        }
        if (subrefs.size() == i + 1 && this.identifier.getName().toLowerCase().startsWith(subrefs.get(i).getId().getName().toLowerCase())) {
            super.addProposal(propCollector, i);
        }
        if (this.identifier.getName().equals(subrefs.get(i).getId().getName())) {
            Timer.addProposal(propCollector, i + 1);
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
        List<ISubReference> subrefs = declarationCollector.getReference().getSubreferences();
        if (subrefs.size() > i && this.identifier.getName().equals(subrefs.get(i).getId().getName()) && subrefs.size() == i + 1 && ISubReference.Subreference_type.fieldSubReference.equals((Object)subrefs.get(i).getReferenceType())) {
            declarationCollector.addDeclaration(this);
        }
    }

    @Override
    public List<Integer> getPossibleExtensionStarterTokens() {
        List<Integer> result = super.getPossibleExtensionStarterTokens();
        if (this.defaultDuration == null) {
            result.add(218);
        }
        return result;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            this.lastTimeChecked = null;
            int result = 1;
            Location tempIdentifier = this.identifier.getLocation();
            if (reparser.envelopsDamage(tempIdentifier) || reparser.isExtending(tempIdentifier)) {
                reparser.extendDamagedRegion(tempIdentifier);
                IdentifierReparser r = new IdentifierReparser(reparser);
                result = r.parseAndSetNameChanged();
                this.identifier = r.getIdentifier();
                if (result != 0) {
                    throw new ReParseException(result);
                }
                if (this.dimensions != null) {
                    this.dimensions.updateSyntax(reparser, false);
                }
                if (this.defaultDuration != null) {
                    this.defaultDuration.updateSyntax(reparser, false);
                    reparser.updateLocation(this.defaultDuration.getLocation());
                }
                if (this.withAttributesPath != null) {
                    this.withAttributesPath.updateSyntax(reparser, false);
                    reparser.updateLocation(this.withAttributesPath.getLocation());
                }
                return;
            }
            throw new ReParseException();
        }
        reparser.updateLocation(this.identifier.getLocation());
        if (this.dimensions != null) {
            this.dimensions.updateSyntax(reparser, false);
        }
        if (this.defaultDuration != null) {
            this.defaultDuration.updateSyntax(reparser, false);
            reparser.updateLocation(this.defaultDuration.getLocation());
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.updateSyntax(reparser, false);
            reparser.updateLocation(this.withAttributesPath.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.dimensions != null) {
            this.dimensions.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.defaultDuration != null) {
            this.defaultDuration.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.dimensions != null && !this.dimensions.accept(v)) {
            return false;
        }
        return this.defaultDuration == null || this.defaultDuration.accept(v);
    }
}

