/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NamedBridgeScope;
import org.eclipse.titan.designer.AST.NamingConventionHelper;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.attributes.AttributeSpecification;
import org.eclipse.titan.designer.AST.TTCN3.attributes.ExtensionAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.MultipleWithAttributes;
import org.eclipse.titan.designer.AST.TTCN3.attributes.Qualifier;
import org.eclipse.titan.designer.AST.TTCN3.attributes.Qualifiers;
import org.eclipse.titan.designer.AST.TTCN3.attributes.SingleWithAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.WithAttributesPath;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.types.Address_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Altstep_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Function_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Testcase_Type;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.T3Doc;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.extensionattributeparser.ExtensionAttributeAnalyzer;
import org.eclipse.titan.designer.parsers.ttcn3parser.IdentifierReparser;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Def_Type
extends Definition {
    private final Type type;
    private NamedBridgeScope bridgeScope = null;

    public Def_Type(Identifier identifier, Type type) {
        super(identifier);
        this.type = type;
        if (type != null) {
            type.setFullNameParent(this);
        }
    }

    @Override
    public Assignment.Assignment_type getAssignmentType() {
        return Assignment.Assignment_type.A_TYPE;
    }

    @Override
    public String getAssignmentName() {
        return "type";
    }

    @Override
    public String getOutlineIcon() {
        if (this.type != null) {
            return this.type.getOutlineIcon();
        }
        return "type.gif";
    }

    @Override
    public int category() {
        int result = super.category();
        if (this.type != null) {
            result += this.type.category();
        }
        return result;
    }

    @Override
    public Type getType(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.type;
    }

    @Override
    public Type getSetting(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.type;
    }

    @Override
    public void setMyScope(Scope scope) {
        if (this.bridgeScope != null && this.bridgeScope.getParentScope() == scope) {
            return;
        }
        this.bridgeScope = new NamedBridgeScope();
        this.bridgeScope.setParentScope(scope);
        scope.addSubScope(this.getLocation(), this.bridgeScope);
        this.bridgeScope.setScopeMacroName(this.identifier.getDisplayName());
        super.setMyScope(this.bridgeScope);
        if (this.type != null) {
            this.type.setMyScope(this.bridgeScope);
        }
    }

    @Override
    public void setWithAttributes(MultipleWithAttributes attributes) {
        if (this.type == null) {
            return;
        }
        if (this.withAttributesPath == null) {
            this.withAttributesPath = new WithAttributesPath();
            this.type.setAttributeParentPath(this.withAttributesPath);
        }
        this.type.setWithAttributes(attributes);
    }

    @Override
    public void setAttributeParentPath(WithAttributesPath parent) {
        super.setAttributeParentPath(parent);
        if (this.type == null) {
            return;
        }
        this.type.setAttributeParentPath(this.getAttributePath());
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        this.check(timestamp, null);
    }

    @Override
    public void check(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.isUsed = false;
        if (!"ADDRESS".equals(this.identifier.getTtcnName()) && !"anytype".equals(this.identifier.getTtcnName())) {
            NamingConventionHelper.checkConvention("org.eclipse.titan.designer.reportNamingConventionType", this.identifier, this);
            NamingConventionHelper.checkNameContents(this.identifier, this.getMyScope().getModuleScope().getIdentifier(), this.getDescription());
        }
        if (this.type == null) {
            return;
        }
        T3Doc.check(this.getCommentLocation(), this.type.getTypetypeTtcn3().toString());
        this.type.check(timestamp);
        this.type.checkConstructorName(this.identifier.getName());
        if ("ADDRESS".equals(this.identifier.getTtcnName())) {
            Address_Type.checkAddress(timestamp, this.type);
        }
        ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        this.type.checkRecursions(timestamp, chain);
        chain.release();
        if (this.withAttributesPath != null) {
            this.withAttributesPath.checkGlobalAttributes(timestamp, false);
            this.withAttributesPath.checkAttributes(timestamp, this.type.getTypetype());
            this.hasImplicitOmitAttribute(timestamp);
            this.analyzeExtensionAttributes(timestamp, this.withAttributesPath);
        }
        switch (this.type.getTypetype()) {
            case TYPE_FUNCTION: {
                ((Function_Type)this.type).getFormalParameters().setMyDefinition(this);
                break;
            }
            case TYPE_ALTSTEP: {
                ((Altstep_Type)this.type).getFormalParameters().setMyDefinition(this);
                break;
            }
            case TYPE_TESTCASE: {
                ((Testcase_Type)this.type).getFormalParameters().setMyDefinition(this);
                break;
            }
        }
    }

    @Override
    public void postCheck() {
        super.postCheck();
        this.postCheckPrivateness();
    }

    public void analyzeExtensionAttributes(CompilationTimeStamp timestamp, WithAttributesPath withAttributesPath) {
        int i;
        List<SingleWithAttribute> realAttributes = withAttributesPath.getRealAttributes(timestamp);
        ArrayList<AttributeSpecification> specifications = null;
        int size = realAttributes.size();
        for (int i2 = 0; i2 < size; ++i2) {
            SingleWithAttribute attribute = realAttributes.get(i2);
            if (!SingleWithAttribute.Attribute_Type.Extension_Attribute.equals((Object)attribute.getAttributeType())) continue;
            Qualifiers qualifiers = attribute.getQualifiers();
            if (qualifiers == null || qualifiers.getNofQualifiers() == 0) {
                if (specifications == null) {
                    specifications = new ArrayList<AttributeSpecification>();
                }
                specifications.add(attribute.getAttributeSpecification());
                continue;
            }
            int size2 = qualifiers.getNofQualifiers();
            for (int j = 0; j < size2; ++j) {
                Qualifier tempQualifier = qualifiers.getQualifierByIndex(i2);
                ISubReference tempSubReference = tempQualifier.getSubReferenceByIndex(0);
                if (tempSubReference.getReferenceType() == ISubReference.Subreference_type.arraySubReference) {
                    tempQualifier.getLocation().reportSemanticError("Invalid field qualifier [-]");
                    continue;
                }
                tempQualifier.getLocation().reportSemanticError(MessageFormat.format("Invalid field qualifier {0}", tempSubReference.getId().getDisplayName()));
            }
        }
        if (specifications == null) {
            return;
        }
        ArrayList<ExtensionAttribute> attributes = new ArrayList<ExtensionAttribute>();
        for (i = 0; i < specifications.size(); ++i) {
            AttributeSpecification specification = (AttributeSpecification)specifications.get(i);
            ExtensionAttributeAnalyzer analyzer = new ExtensionAttributeAnalyzer();
            analyzer.parse(specification);
            List<ExtensionAttribute> temp = analyzer.getAttributes();
            if (temp == null) continue;
            attributes.addAll(temp);
        }
        block6: for (i = 0; i < attributes.size(); ++i) {
            ExtensionAttribute extensionAttribute = (ExtensionAttribute)attributes.get(i);
            switch (extensionAttribute.getAttributeType()) {
                case ANYTYPE: 
                case VERSION: 
                case REQUIRES: 
                case TITANVERSION: {
                    continue block6;
                }
                default: {
                    extensionAttribute.getLocation().reportSemanticError("Extension attributes are not supported for types");
                }
            }
        }
    }

    @Override
    public String getProposalKind() {
        if (this.type != null) {
            return this.type.getProposalDescription(new StringBuilder()).toString();
        }
        return "unknown type";
    }

    @Override
    public Object[] getOutlineChildren() {
        if (this.type == null) {
            return super.getOutlineChildren();
        }
        return this.type.getOutlineChildren();
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int i) {
        List<ISubReference> subrefs = propCollector.getReference().getSubreferences();
        if (subrefs.size() <= i) {
            return;
        }
        if (subrefs.size() == i + 1 && this.identifier.getName().toLowerCase().startsWith(subrefs.get(i).getId().getName().toLowerCase())) {
            super.addProposal(propCollector, i);
        } else if (subrefs.size() > i + 1 && this.type != null && this.identifier.getName().equals(subrefs.get(i).getId().getName())) {
            this.type.addProposal(propCollector, i + 1);
        }
        if (this.type != null && IType.Type_type.TYPE_TTCN3_ENUMERATED.equals((Object)this.type.getTypetype())) {
            this.type.addProposal(propCollector, i);
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
        List<ISubReference> subrefs = declarationCollector.getReference().getSubreferences();
        if (subrefs.size() > i && this.identifier.getName().equals(subrefs.get(i).getId().getName())) {
            if (subrefs.size() > i + 1 && this.type != null) {
                this.type.addDeclaration(declarationCollector, i + 1);
            } else if (subrefs.size() == i + 1 && ISubReference.Subreference_type.fieldSubReference.equals((Object)subrefs.get(i).getReferenceType())) {
                declarationCollector.addDeclaration(this);
            }
        } else if (this.type != null && IType.Type_type.TYPE_TTCN3_SEQUENCE.equals((Object)this.type.getTypetype()) && (declarationCollector.getReference().getModuleIdentifier() != null && i == 1 || i == 0)) {
            this.type.addDeclaration(declarationCollector, i);
        }
        if (this.type != null && IType.Type_type.TYPE_TTCN3_ENUMERATED.equals((Object)this.type.getTypetype()) && (declarationCollector.getReference().getModuleIdentifier() != null && i == 1 || i == 0)) {
            this.type.addDeclaration(declarationCollector, i);
        }
    }

    @Override
    public List<Integer> getPossibleExtensionStarterTokens() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.add(251);
        result.add(76);
        result.add(249);
        if (this.withAttributesPath == null || this.withAttributesPath.getAttributes() == null) {
            result.add(155);
        }
        return result;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            this.lastTimeChecked = null;
            boolean enveloped = false;
            Location temporalIdentifier = this.identifier.getLocation();
            if (reparser.envelopsDamage(temporalIdentifier) || reparser.isExtending(temporalIdentifier)) {
                reparser.extendDamagedRegion(temporalIdentifier);
                IdentifierReparser r = new IdentifierReparser(reparser);
                int result = r.parseAndSetNameChanged();
                this.identifier = r.getIdentifier();
                if (result == 0) {
                    enveloped = true;
                } else {
                    this.removeBridge();
                    throw new ReParseException(result);
                }
            }
            if (this.type != null) {
                if (enveloped) {
                    this.type.updateSyntax(reparser, false);
                    reparser.updateLocation(this.type.getLocation());
                } else if (reparser.envelopsDamage(this.type.getLocation())) {
                    try {
                        this.type.updateSyntax(reparser, true);
                        enveloped = true;
                        reparser.updateLocation(this.type.getLocation());
                    }
                    catch (ReParseException e) {
                        this.removeBridge();
                        throw e;
                    }
                }
            }
            if (this.withAttributesPath != null) {
                if (enveloped) {
                    this.withAttributesPath.updateSyntax(reparser, false);
                    reparser.updateLocation(this.withAttributesPath.getLocation());
                } else if (reparser.envelopsDamage(this.withAttributesPath.getLocation())) {
                    try {
                        this.withAttributesPath.updateSyntax(reparser, true);
                        enveloped = true;
                        reparser.updateLocation(this.withAttributesPath.getLocation());
                    }
                    catch (ReParseException e) {
                        this.removeBridge();
                        throw e;
                    }
                }
            }
            if (!enveloped) {
                this.removeBridge();
                throw new ReParseException();
            }
            return;
        }
        reparser.updateLocation(this.identifier.getLocation());
        if (this.type != null) {
            this.type.updateSyntax(reparser, false);
            reparser.updateLocation(this.type.getLocation());
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.updateSyntax(reparser, false);
            reparser.updateLocation(this.withAttributesPath.getLocation());
        }
    }

    private void removeBridge() {
        if (this.bridgeScope != null) {
            this.bridgeScope.remove();
            this.bridgeScope = null;
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.type != null) {
            this.type.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        return this.type == null || this.type.accept(v);
    }
}

