/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ActualParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.templates.ParsedActualParameters;
import org.eclipse.titan.designer.AST.TTCN3.types.Altstep_Type;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Activate_Referenced_Statement
extends Statement {
    private static final String ALTSTEPEXPECTED = "A value of type altstep was expected in the argument of `derefers()'' instead of `{0}''";
    private static final String RUNONSELFERROR = "the argument of `derefers()' cannot be an altstep reference with 'runs on self' clause";
    private static final String FULLNAMEPART1 = ".referenced";
    private static final String FULLNAMEPART2 = ".<parameters>";
    private static final String STATEMENT_NAME = "activate";
    private final Value dereferredValue;
    private final ParsedActualParameters actualParameterList;

    public Activate_Referenced_Statement(Value dereferredValue, ParsedActualParameters actualParameterList) {
        this.dereferredValue = dereferredValue;
        this.actualParameterList = actualParameterList;
        if (dereferredValue != null) {
            dereferredValue.setFullNameParent(this);
        }
        if (actualParameterList != null) {
            actualParameterList.setFullNameParent(this);
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_ACTIVATE_REFERENCED;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.dereferredValue == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.actualParameterList == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.dereferredValue != null) {
            this.dereferredValue.setMyScope(scope);
        }
        if (this.actualParameterList != null) {
            this.actualParameterList.setMyScope(scope);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        if (this.dereferredValue == null) {
            this.setIsErroneous();
            return;
        }
        this.dereferredValue.setLoweridToReference(timestamp);
        IType type = this.dereferredValue.getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
        if (type != null) {
            type = type.getTypeRefdLast(timestamp);
        }
        if (type == null || type.getIsErroneous(timestamp)) {
            this.setIsErroneous();
            return;
        }
        if (!IType.Type_type.TYPE_ALTSTEP.equals((Object)type.getTypetype())) {
            this.dereferredValue.getLocation().reportSemanticError(MessageFormat.format(ALTSTEPEXPECTED, type.getTypename()));
            this.setIsErroneous();
            return;
        }
        if (((Altstep_Type)type).isRunsOnSelf()) {
            this.dereferredValue.getLocation().reportSemanticError(RUNONSELFERROR);
            this.setIsErroneous();
            return;
        }
        if (this.myStatementBlock != null) {
            this.myStatementBlock.checkRunsOnScope(timestamp, type, (ILocateableNode)this, STATEMENT_NAME);
        }
        ActualParameterList tempActualParameters = new ActualParameterList();
        FormalParameterList formalParameterList = ((Altstep_Type)type).getFormalParameters();
        if (formalParameterList.checkActualParameterList(timestamp, this.actualParameterList, tempActualParameters)) {
            this.setIsErroneous();
            return;
        }
        tempActualParameters.setFullNameParent(this);
        tempActualParameters.setMyScope(this.getMyScope());
        if (!formalParameterList.checkActivateArgument(timestamp, tempActualParameters, this.getFullName())) {
            this.setIsErroneous();
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.dereferredValue != null) {
            this.dereferredValue.updateSyntax(reparser, false);
            reparser.updateLocation(this.dereferredValue.getLocation());
        }
        if (this.actualParameterList != null) {
            this.actualParameterList.updateSyntax(reparser, false);
            reparser.updateLocation(this.actualParameterList.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.dereferredValue != null) {
            this.dereferredValue.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.actualParameterList != null) {
            this.actualParameterList.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.dereferredValue != null && !this.dereferredValue.accept(v)) {
            return false;
        }
        return this.actualParameterList == null || this.actualParameterList.accept(v);
    }
}

