/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuards;
import org.eclipse.titan.designer.AST.TTCN3.statements.If_Clause;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class If_Clauses
extends ASTNode
implements IIncrementallyUpdateable {
    private static final String FULLNAMEPART = ".if_clause_";
    private final List<If_Clause> ifclauses = new ArrayList<If_Clause>();

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        int size = this.ifclauses.size();
        for (int i = 0; i < size; ++i) {
            if (this.ifclauses.get(i) != child) continue;
            return builder.append(FULLNAMEPART).append(Integer.toString(i + 1));
        }
        return builder;
    }

    public void setMyStatementBlock(StatementBlock statementBlock, int index) {
        int size = this.ifclauses.size();
        for (int i = 0; i < size; ++i) {
            this.ifclauses.get(i).setMyStatementBlock(statementBlock, index);
        }
    }

    public void setMyDefinition(Definition definition) {
        int size = this.ifclauses.size();
        for (int i = 0; i < size; ++i) {
            this.ifclauses.get(i).setMyDefinition(definition);
        }
    }

    public void addIfClause(If_Clause ifClause) {
        this.ifclauses.add(ifClause);
        ifClause.setFullNameParent(this);
    }

    public void addFrontIfClause(If_Clause ifClause) {
        this.ifclauses.add(0, ifClause);
        ifClause.setFullNameParent(this);
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        int size = this.ifclauses.size();
        for (int i = 0; i < size; ++i) {
            this.ifclauses.get(i).setMyScope(scope);
        }
    }

    public void setMyAltguards(AltGuards altGuards) {
        int size = this.ifclauses.size();
        for (int i = 0; i < size; ++i) {
            this.ifclauses.get(i).setMyAltguards(altGuards);
        }
    }

    public StatementBlock.ReturnStatus_type hasReturn(CompilationTimeStamp timestamp, StatementBlock elseBlock) {
        StatementBlock.ReturnStatus_type result = StatementBlock.ReturnStatus_type.RS_MAYBE;
        int size = this.ifclauses.size();
        block8: for (int i = 0; i < size; ++i) {
            switch (this.ifclauses.get(i).hasReturn(timestamp)) {
                case RS_NO: {
                    if (result == StatementBlock.ReturnStatus_type.RS_YES) {
                        return StatementBlock.ReturnStatus_type.RS_MAYBE;
                    }
                    result = StatementBlock.ReturnStatus_type.RS_NO;
                    continue block8;
                }
                case RS_YES: {
                    if (result == StatementBlock.ReturnStatus_type.RS_NO) {
                        return StatementBlock.ReturnStatus_type.RS_MAYBE;
                    }
                    result = StatementBlock.ReturnStatus_type.RS_YES;
                    continue block8;
                }
                default: {
                    return StatementBlock.ReturnStatus_type.RS_MAYBE;
                }
            }
        }
        StatementBlock.ReturnStatus_type elseStatus = elseBlock != null ? elseBlock.hasReturn(timestamp) : StatementBlock.ReturnStatus_type.RS_NO;
        switch (elseStatus) {
            case RS_NO: {
                if (result == StatementBlock.ReturnStatus_type.RS_YES) {
                    return StatementBlock.ReturnStatus_type.RS_MAYBE;
                }
                result = StatementBlock.ReturnStatus_type.RS_NO;
                break;
            }
            case RS_YES: {
                if (result == StatementBlock.ReturnStatus_type.RS_NO) {
                    return StatementBlock.ReturnStatus_type.RS_MAYBE;
                }
                result = StatementBlock.ReturnStatus_type.RS_YES;
                break;
            }
            default: {
                return StatementBlock.ReturnStatus_type.RS_MAYBE;
            }
        }
        return result;
    }

    public boolean check(CompilationTimeStamp timestamp, boolean unreachable) {
        boolean temporalUnreachable = unreachable;
        int size = this.ifclauses.size();
        for (int i = 0; i < size; ++i) {
            temporalUnreachable = this.ifclauses.get(i).check(timestamp, temporalUnreachable);
        }
        return temporalUnreachable;
    }

    public void checkAllowedInterleave() {
        int size = this.ifclauses.size();
        for (int i = 0; i < size; ++i) {
            this.ifclauses.get(i).checkAllowedInterleave();
        }
    }

    public void postCheck() {
        int size = this.ifclauses.size();
        for (int i = 0; i < size; ++i) {
            this.ifclauses.get(i).postCheck();
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        int size = this.ifclauses.size();
        for (int i = 0; i < size; ++i) {
            If_Clause clause = this.ifclauses.get(i);
            clause.updateSyntax(reparser, false);
            reparser.updateLocation(clause.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.ifclauses == null) {
            return;
        }
        for (If_Clause ic : this.ifclauses) {
            ic.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    public boolean isExactlyOne() {
        return this.ifclauses != null && this.ifclauses.size() == 1;
    }

    public boolean isExactlyOneNegated() {
        return this.ifclauses != null && this.ifclauses.size() == 1 && this.ifclauses.get(0).isNegatedCondition();
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.ifclauses != null) {
            for (If_Clause ic : this.ifclauses) {
                if (ic.accept(v)) continue;
                return false;
            }
        }
        return true;
    }

    public List<If_Clause> getClauses() {
        return this.ifclauses;
    }
}

