/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ActualParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.templates.ParsedActualParameters;
import org.eclipse.titan.designer.AST.TTCN3.types.Testcase_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Real_Value;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Referenced_Testcase_Instance_Statement
extends Statement {
    private static final String FLOATEXPECTED = "float value expected";
    private static final String FLOATEXPECTED2 = "{0} can not be used as the testcase quard timer duration";
    private static final String DEFINITIONWITHOUTRUNSONEXPECTED = "A definition that has `runs on' clause cannot execute testcases";
    private static final String NEGATIVEDURATION = "The testcase quard timer has negative duration: `{0}''";
    private static final String FULLNAMEPART1 = ".testcasereference";
    private static final String FULLNAMEPART2 = ".<parameters>";
    private static final String FULLNAMEPART3 = ".timerValue";
    private static final String STATEMENT_NAME = "execute";
    private final Value dereferredValue;
    private final ParsedActualParameters actualParameterList;
    private final Value timerValue;

    public Referenced_Testcase_Instance_Statement(Value dereferredValue, ParsedActualParameters actualParameterList, Value timerValue) {
        this.dereferredValue = dereferredValue;
        this.actualParameterList = actualParameterList;
        this.timerValue = timerValue;
        if (dereferredValue != null) {
            dereferredValue.setFullNameParent(this);
        }
        if (actualParameterList != null) {
            actualParameterList.setFullNameParent(this);
        }
        if (timerValue != null) {
            timerValue.setFullNameParent(this);
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_REFERENCED_TESTCASE_INSTANCE;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.dereferredValue == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.actualParameterList == child) {
            return builder.append(FULLNAMEPART2);
        }
        if (this.timerValue == child) {
            return builder.append(FULLNAMEPART3);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.dereferredValue != null) {
            this.dereferredValue.setMyScope(scope);
        }
        if (this.actualParameterList != null) {
            this.actualParameterList.setMyScope(scope);
        }
        if (this.timerValue != null) {
            this.timerValue.setMyScope(scope);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        if (this.dereferredValue == null) {
            return;
        }
        IValue temporalValue = this.dereferredValue.setLoweridToReference(timestamp);
        IType type = temporalValue.getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_TEMPLATE);
        if (type != null) {
            type = type.getTypeRefdLast(timestamp);
        }
        if (type == null) {
            return;
        }
        if (!IType.Type_type.TYPE_TESTCASE.equals((Object)type.getTypetype())) {
            this.dereferredValue.getLocation().reportSemanticError(MessageFormat.format("A value of type testcase was expected in the argument of `derefers()'' instead of `{0}''", type.getTypename()));
            return;
        }
        if (this.myStatementBlock.getScopeRunsOn() != null) {
            this.dereferredValue.getLocation().reportSemanticError(DEFINITIONWITHOUTRUNSONEXPECTED);
            return;
        }
        ActualParameterList tempActualParameters = new ActualParameterList();
        FormalParameterList formalParameterList = ((Testcase_Type)type).getFormalParameters();
        formalParameterList.checkActualParameterList(timestamp, this.actualParameterList, tempActualParameters);
        if (this.timerValue != null) {
            this.timerValue.setLoweridToReference(timestamp);
            IType.Type_type temporalType = this.timerValue.getExpressionReturntype(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
            switch (temporalType) {
                case TYPE_REAL: {
                    IValue last = this.timerValue.getValueRefdLast(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null);
                    if (last.isUnfoldable(timestamp)) break;
                    Real_Value real = (Real_Value)last;
                    double i = real.getValue();
                    if (i < 0.0) {
                        this.timerValue.getLocation().reportSemanticError(MessageFormat.format(NEGATIVEDURATION, real.createStringRepresentation()));
                        break;
                    }
                    if (!real.isPositiveInfinity()) break;
                    this.timerValue.getLocation().reportSemanticError(MessageFormat.format(FLOATEXPECTED2, real.createStringRepresentation()));
                    break;
                }
                default: {
                    this.timerValue.getLocation().reportSemanticError(FLOATEXPECTED);
                }
            }
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.dereferredValue != null) {
            this.dereferredValue.updateSyntax(reparser, false);
            reparser.updateLocation(this.dereferredValue.getLocation());
        }
        if (this.actualParameterList != null) {
            this.actualParameterList.updateSyntax(reparser, false);
            reparser.updateLocation(this.actualParameterList.getLocation());
        }
        if (this.timerValue != null) {
            this.timerValue.updateSyntax(reparser, false);
            reparser.updateLocation(this.timerValue.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.dereferredValue != null) {
            this.dereferredValue.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.actualParameterList != null) {
            this.actualParameterList.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.timerValue != null) {
            this.timerValue.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.dereferredValue != null && !this.dereferredValue.accept(v)) {
            return false;
        }
        if (this.actualParameterList != null && !this.actualParameterList.accept(v)) {
            return false;
        }
        return this.timerValue == null || this.timerValue.accept(v);
    }
}

