/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.ValueList_Template;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReparseUtilities;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Return_Statement
extends Statement {
    private static final String SPECIFICVALUEEXPECTED = "A specific value without matching symbols was expected as return value";
    private static final String MISSINGTEMPLATE = "Missing return template. The function should return a template of type `{0}''";
    private static final String MISSINGVALUE = "Missing return value. The function should return a value of type `{0}''";
    private static final String UNEXPECTEDRETURNVALUE = "Unexpected return value. The function does not have return type";
    private static final String UNEXPETEDRETURNSTATEMENT = "Return statement cannot be used in a {0}. It is allowed only in functions and altsteps";
    private static final String ALTSTEPRETURNINGVALUE = "An altstep cannot return a value";
    private static final String USAGEINCONTROLPART = "Return statement cannot be used in the control part. It is alowed only in functions and altsteps";
    private static final String FULLNAMEPART = ".returnexpression";
    private static final String STATEMENT_NAME = "return";
    private final TTCN3Template template;

    public Return_Statement(TTCN3Template template) {
        this.template = template;
        if (template != null) {
            template.setFullNameParent(this);
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_RETURN;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.template == child) {
            return builder.append(FULLNAMEPART);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.template != null) {
            this.template.setMyScope(scope);
        }
    }

    @Override
    public boolean isTerminating(CompilationTimeStamp timestamp) {
        return true;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        Definition definition = this.myStatementBlock.getMyDefinition();
        if (definition == null) {
            this.location.reportSemanticError(USAGEINCONTROLPART);
            return;
        }
        switch (definition.getAssignmentType()) {
            case A_FUNCTION: {
                if (this.template == null) break;
                this.template.getLocation().reportSemanticError(UNEXPECTEDRETURNVALUE);
                break;
            }
            case A_FUNCTION_RVAL: {
                Type returnType = ((Def_Function)definition).getType(timestamp);
                if (this.template == null) {
                    this.location.reportSemanticError(MessageFormat.format(MISSINGVALUE, returnType.getTypename()));
                    break;
                }
                switch (this.template.getTemplatetype()) {
                    case SPECIFIC_VALUE: {
                        break;
                    }
                    case VALUE_LIST: {
                        if (((ValueList_Template)this.template).getNofTemplates() == 1) break;
                    }
                    default: {
                        if (this.template.isValue(timestamp)) break;
                        this.template.getLocation().reportSemanticError(SPECIFICVALUEEXPECTED);
                    }
                }
                this.template.setMyGovernor(returnType);
                ITTCN3Template temporalTemplate = returnType.checkThisTemplateRef(timestamp, this.template, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null);
                temporalTemplate.checkThisTemplateGeneric(timestamp, returnType, false, false, true, true, false);
                TemplateRestriction.check(timestamp, definition, temporalTemplate, null);
                break;
            }
            case A_FUNCTION_RTEMP: {
                if (this.template == null) {
                    this.location.reportSemanticError(MessageFormat.format(MISSINGTEMPLATE, ((Def_Function)definition).getType(timestamp).getTypename()));
                    break;
                }
                Type returnType1 = ((Def_Function)definition).getType(timestamp);
                this.template.setMyGovernor(returnType1);
                ITTCN3Template temporalTemplate1 = returnType1.checkThisTemplateRef(timestamp, this.template, Expected_Value_type.EXPECTED_TEMPLATE, null);
                temporalTemplate1.checkThisTemplateGeneric(timestamp, returnType1, true, true, true, true, true);
                TemplateRestriction.check(timestamp, definition, temporalTemplate1, null);
                break;
            }
            case A_ALTSTEP: {
                if (this.template == null) break;
                this.template.getLocation().reportSemanticError(ALTSTEPRETURNINGVALUE);
                break;
            }
            default: {
                this.location.reportSemanticError(MessageFormat.format(UNEXPETEDRETURNSTATEMENT, definition.getAssignmentName()));
            }
        }
    }

    @Override
    public void checkAllowedInterleave() {
        this.location.reportSemanticError("Return statement is not allowed within an interleave statement");
    }

    @Override
    public List<Integer> getPossibleExtensionStarterTokens() {
        if (this.template != null) {
            return null;
        }
        return ReparseUtilities.getAllValidTokenTypes();
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.template != null) {
            this.template.updateSyntax(reparser, false);
            reparser.updateLocation(this.template.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.template == null) {
            return;
        }
        this.template.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.template == null || this.template.accept(v);
    }
}

