/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferencingType;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ActualParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.statements.Port_Utility;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.templates.ParsedActualParameters;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Function_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Start_Referenced_Component_Statement
extends Statement {
    private static final String FULLNAMEPART1 = ".componentreference";
    private static final String FULLNAMEPART2 = ".functionreference";
    private static final String FULLNAMEPART3 = ".<parameters>";
    private static final String STATEMENT_NAME = "start test component";
    private final Value componentReference;
    private final Value dereferredValue;
    private final ParsedActualParameters parameters;

    public Start_Referenced_Component_Statement(Value componentReference, Value dereferredValue, ParsedActualParameters parameters) {
        this.componentReference = componentReference;
        this.dereferredValue = dereferredValue;
        this.parameters = parameters;
        if (componentReference != null) {
            componentReference.setFullNameParent(this);
        }
        if (dereferredValue != null) {
            dereferredValue.setFullNameParent(this);
        }
        if (parameters != null) {
            parameters.setFullNameParent(this);
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_START_REFERENCED_COMPONENT;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.componentReference == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.dereferredValue == child) {
            return builder.append(FULLNAMEPART2);
        }
        if (this.parameters == child) {
            return builder.append(FULLNAMEPART3);
        }
        return builder;
    }

    public Value getDereferredValue() {
        return this.dereferredValue;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.componentReference != null) {
            this.componentReference.setMyScope(scope);
        }
        if (this.dereferredValue != null) {
            this.dereferredValue.setMyScope(scope);
        }
        if (this.parameters != null) {
            this.parameters.setMyScope(scope);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        Type returnType;
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        Component_Type compType = null;
        if (this.componentReference != null) {
            compType = Port_Utility.checkComponentReference(timestamp, this, this.componentReference, false, false);
        }
        if (this.dereferredValue == null) {
            return;
        }
        switch (this.dereferredValue.getValuetype()) {
            case EXPRESSION_VALUE: {
                if (!Expression_Value.Operation_type.REFERS_OPERATION.equals((Object)((Expression_Value)this.dereferredValue).getOperationType())) break;
                this.dereferredValue.getLocation().reportSemanticError("A value of a function type was expected in the argument instead of a `refers' operation, which does not specify any function type.");
                return;
            }
            case TTCN3_NULL_VALUE: 
            case FAT_NULL_VALUE: {
                this.dereferredValue.getLocation().reportSemanticError("A value of a function type was expected in the argument instead of a `null' value, which does not specify any function type.");
                return;
            }
        }
        this.dereferredValue.setLoweridToReference(timestamp);
        IType type = this.dereferredValue.getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
        if (type != null) {
            type = type.getTypeRefdLast(timestamp);
        }
        if (type == null || type.getIsErroneous(timestamp)) {
            return;
        }
        if (!IType.Type_type.TYPE_FUNCTION.equals((Object)type.getTypetype())) {
            this.dereferredValue.getLocation().reportSemanticError(MessageFormat.format("A value of type function was expected in the argument of `{0}''", type.getTypename()));
            return;
        }
        Function_Type functionType = (Function_Type)type;
        if (functionType.isRunsOnSelf()) {
            this.dereferredValue.getLocation().reportSemanticError("The argument cannot be a function reference with 'runs on self' clause");
            return;
        }
        if (!functionType.checkStartable(timestamp, this.getLocation())) {
            return;
        }
        Component_Type runsOnType = functionType.getRunsOnType(timestamp);
        if (compType != null && runsOnType != null && !runsOnType.isCompatible(timestamp, compType, null, null, null)) {
            String message = MessageFormat.format("Component type mismatch: the component reference os of type `{0}'', but functions of type `{1}'' run on `{2}''", compType.getTypename(), functionType.getTypename(), runsOnType.getTypename());
            this.componentReference.getLocation().reportSemanticError(message);
        }
        if ((returnType = functionType.getReturnType()) != null) {
            if (functionType.returnsTemplate()) {
                this.dereferredValue.getLocation().reportSemanticWarning(MessageFormat.format("Function of type `{0}'' return a template of type `{1}'', which cannot be retrieved when the test component terminates", functionType.getTypename(), returnType.getTypename()));
            } else {
                IType lastType = returnType;
                boolean returnTypeCorrect = false;
                while (!returnTypeCorrect) {
                    if (lastType.hasDoneAttribute()) {
                        returnTypeCorrect = true;
                        break;
                    }
                    if (!(lastType instanceof IReferencingType)) break;
                    ReferenceChain refChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                    IType refd = ((IReferencingType)((Object)lastType)).getTypeRefd(timestamp, refChain);
                    refChain.release();
                    if (lastType == refd) break;
                    lastType = refd;
                }
                if (!returnTypeCorrect) {
                    this.dereferredValue.getLocation().reportSemanticWarning(MessageFormat.format("Return type of function type `{0}'' is `{1}'', which does not have the `done'' extension attibute. When the test component terminates the returnes value cannot be retrived with a `done'' operation", functionType.getTypename(), returnType.getTypename()));
                }
            }
        }
        ActualParameterList tempActualParameters = new ActualParameterList();
        FormalParameterList formalParameters = functionType.getFormalParameters();
        if (!formalParameters.checkActualParameterList(timestamp, this.parameters, tempActualParameters)) {
            tempActualParameters.setFullNameParent(this);
            tempActualParameters.setMyScope(this.getMyScope());
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.componentReference != null) {
            this.componentReference.updateSyntax(reparser, false);
            reparser.updateLocation(this.componentReference.getLocation());
        }
        if (this.dereferredValue != null) {
            this.dereferredValue.updateSyntax(reparser, false);
            reparser.updateLocation(this.dereferredValue.getLocation());
        }
        if (this.parameters != null) {
            this.parameters.updateSyntax(reparser, false);
            reparser.updateLocation(this.parameters.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.componentReference != null) {
            this.componentReference.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.dereferredValue != null) {
            this.dereferredValue.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.parameters != null) {
            this.parameters.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.componentReference != null && !this.componentReference.accept(v)) {
            return false;
        }
        if (this.dereferredValue != null && !this.dereferredValue.accept(v)) {
            return false;
        }
        return this.parameters == null || this.parameters.accept(v);
    }
}

