/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class HexString_Pattern_Template
extends TTCN3Template {
    private final String pattern;

    public HexString_Pattern_Template(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public ITTCN3Template.Template_type getTemplatetype() {
        return ITTCN3Template.Template_type.HSTR_PATTERN;
    }

    @Override
    public String getTemplateTypeName() {
        if (this.isErroneous) {
            return "erroneous hexstring pattern";
        }
        return "hexstring pattern";
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder("'");
        builder.append(this.pattern);
        builder.append("'H");
        if (this.lengthRestriction != null) {
            builder.append(this.lengthRestriction.createStringRepresentation());
        }
        if (this.isIfpresent) {
            builder.append("ifpresent");
        }
        return builder.toString();
    }

    public boolean containsAnyornoneSymbol() {
        return this.pattern.indexOf(42) > -1;
    }

    public int getMinLengthOfPattern() {
        int starCount = 0;
        int index = this.pattern.indexOf(42, 0);
        while (index != -1) {
            ++index;
            ++starCount;
            index = this.pattern.indexOf(42, index);
        }
        return this.pattern.length() - starCount;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.getIsErroneous(timestamp)) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        return IType.Type_type.TYPE_HEXSTRING;
    }

    @Override
    public void checkSpecificValue(CompilationTimeStamp timestamp, boolean allowOmit) {
        this.getLocation().reportSemanticError("A specific value expected instead of an hexstring pattern");
    }

    @Override
    protected void checkTemplateSpecificLengthRestriction(CompilationTimeStamp timestamp, IType.Type_type typeType) {
        if (IType.Type_type.TYPE_HEXSTRING.equals((Object)typeType)) {
            boolean hasAnyOrNone = this.containsAnyornoneSymbol();
            this.lengthRestriction.checkNofElements(timestamp, this.getMinLengthOfPattern(), hasAnyOrNone, false, hasAnyOrNone, this);
        }
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
    }
}

