/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.Referenced_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class TemplateInstance
extends ASTNode
implements ILocateableNode,
IIncrementallyUpdateable {
    private static final String FULLNAMEPART1 = ".<type>";
    private static final String FULLNAMEPART2 = ".<derivedReference>";
    private static final String INCOMATIBLEEXPLICITETYPE = "Incompatible explicit type specification: `{0}'' was expected instead of {1}";
    private static final String INCOMPATIBLEBASETYPE = "Base template `{0}'' has incompatible type: `{1}'' was expected instead of `{2}''";
    private static final String TEMPLATEREFERENCEXPECTED = "Reference to a template was expected instead of {0}";
    private final Type type;
    private final Reference derivedReference;
    private final TTCN3Template templateBody;
    private CompilationTimeStamp lastTimeChecked;
    private Location location;

    public TemplateInstance(Type type, Reference derivedReference, TTCN3Template templateBody) {
        this.type = type;
        this.derivedReference = derivedReference;
        this.templateBody = templateBody;
        this.location = NULL_Location.INSTANCE;
        if (type != null && type.getNameParent() == null) {
            type.setFullNameParent(this);
        }
        if (derivedReference != null && derivedReference.getNameParent() == null) {
            derivedReference.setFullNameParent(this);
        }
        if (templateBody.getNameParent() == null) {
            templateBody.setFullNameParent(this);
        }
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public Type getType() {
        return this.type;
    }

    public Reference getDerivedReference() {
        return this.derivedReference;
    }

    public TTCN3Template getTemplateBody() {
        return this.templateBody;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.type != null) {
            this.type.setMyScope(scope);
        }
        if (this.derivedReference != null) {
            this.derivedReference.setMyScope(scope);
        }
        this.templateBody.setMyScope(scope);
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.type == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.derivedReference == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        if (this.type != null) {
            builder.append(this.type.getTypename()).append(" : ");
        }
        if (this.derivedReference != null) {
            builder.append("modifies ").append(this.derivedReference.getDisplayName()).append(" := ");
        }
        builder.append(this.templateBody.createStringRepresentation());
        return builder.toString();
    }

    public IType getExpressionGovernor(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        IType result;
        if (this.type != null) {
            return this.type;
        }
        if (this.derivedReference != null && (result = this.checkDerivedReference(timestamp, null)) != null) {
            return result;
        }
        return this.templateBody.getExpressionGovernor(timestamp, expectedValue);
    }

    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        IType result;
        IType tempType = this.type;
        if (tempType == null && this.derivedReference != null && (result = this.checkDerivedReference(timestamp, null)) != null) {
            tempType = result;
        }
        if (tempType == null) {
            return this.templateBody.getExpressionReturntype(timestamp, expectedValue);
        }
        tempType.check(timestamp);
        return tempType.getTypeRefdLast(timestamp).getTypetypeTtcn3();
    }

    public IType checkType(CompilationTimeStamp timestamp, IType governor) {
        if (this.type == null) {
            return governor;
        }
        if (governor == null || governor.getIsErroneous(timestamp)) {
            return this.type;
        }
        if (governor.isCompatible(timestamp, this.type, null, null, null)) {
            return governor;
        }
        if (!this.type.getIsErroneous(timestamp)) {
            this.type.getLocation().reportSemanticError(MessageFormat.format(INCOMATIBLEEXPLICITETYPE, governor.getTypename(), this.type.getTypename()));
        }
        return this.type;
    }

    public IType checkDerivedReference(CompilationTimeStamp timestamp, IType governor) {
        if (this.derivedReference == null) {
            return governor;
        }
        Assignment assignment = this.derivedReference.getRefdAssignment(timestamp, true);
        if (assignment == null) {
            return governor;
        }
        switch (assignment.getAssignmentType()) {
            case A_TEMPLATE: {
                return this.checkBaseTypeCompatibility(timestamp, governor, assignment, true);
            }
            case A_VAR_TEMPLATE: {
                return this.checkBaseTypeCompatibility(timestamp, governor, assignment, false);
            }
            case A_PAR_TEMP_IN: {
                return this.checkBaseTypeCompatibility(timestamp, governor, assignment, false);
            }
            case A_PAR_TEMP_OUT: {
                return this.checkBaseTypeCompatibility(timestamp, governor, assignment, false);
            }
            case A_PAR_TEMP_INOUT: {
                return this.checkBaseTypeCompatibility(timestamp, governor, assignment, false);
            }
            case A_FUNCTION_RTEMP: {
                return this.checkBaseTypeCompatibility(timestamp, governor, assignment, false);
            }
            case A_EXT_FUNCTION_RTEMP: {
                return this.checkBaseTypeCompatibility(timestamp, governor, assignment, false);
            }
        }
        this.derivedReference.getLocation().reportSemanticError(MessageFormat.format(TEMPLATEREFERENCEXPECTED, assignment.getAssignmentName()));
        return governor;
    }

    private IType checkBaseTypeCompatibility(CompilationTimeStamp timestamp, IType governor, Assignment derivedAssignment, boolean setBaseTemplate) {
        boolean internalSetBase = setBaseTemplate;
        IType tempGovernor = governor;
        if (tempGovernor == null) {
            tempGovernor = this.type;
        }
        IType baseTemplateType = derivedAssignment.getType(timestamp);
        if (tempGovernor != null) {
            if (!tempGovernor.isCompatible(timestamp, baseTemplateType, null, null, null)) {
                this.derivedReference.getLocation().reportSemanticError(MessageFormat.format(INCOMPATIBLEBASETYPE, derivedAssignment.getFullName(), tempGovernor.getTypename(), baseTemplateType.getTypename()));
                if (this.type == null) {
                    tempGovernor = baseTemplateType;
                }
                internalSetBase = false;
            }
        } else {
            tempGovernor = baseTemplateType;
        }
        if (internalSetBase && derivedAssignment instanceof Def_Template) {
            this.templateBody.setBaseTemplate(((Def_Template)derivedAssignment).getTemplate(timestamp));
        }
        return tempGovernor;
    }

    public void check(CompilationTimeStamp timestamp, IType governor) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        if (this.type != null) {
            this.type.setIsErroneous(false);
        }
        this.templateBody.setIsErroneous(false);
        if (governor == null) {
            this.lastTimeChecked = timestamp;
            return;
        }
        IType localGovernor = this.checkType(timestamp, governor);
        localGovernor = this.checkDerivedReference(timestamp, localGovernor);
        ITTCN3Template temporalBody = localGovernor.checkThisTemplateRef(timestamp, this.templateBody);
        temporalBody.checkThisTemplateGeneric(timestamp, localGovernor, this.derivedReference != null, true, true, true, false);
        this.lastTimeChecked = timestamp;
    }

    public boolean checkRestriction(CompilationTimeStamp timestamp, Definition definition) {
        boolean needsRuntimeCheck = false;
        if (this.derivedReference != null) {
            Assignment ass = this.derivedReference.getRefdAssignment(timestamp, true);
            switch (ass.getAssignmentType()) {
                case A_TEMPLATE: 
                case A_VAR_TEMPLATE: {
                    needsRuntimeCheck = TemplateRestriction.check(timestamp, definition, this.templateBody, null);
                    break;
                }
                case A_PAR_TEMP_IN: 
                case A_PAR_TEMP_OUT: 
                case A_FUNCTION_RTEMP: 
                case A_EXT_FUNCTION_RTEMP: {
                    Referenced_Template temp = new Referenced_Template(this.derivedReference);
                    temp.setLocation(this.derivedReference.getLocation());
                    this.templateBody.setBaseTemplate(temp);
                    needsRuntimeCheck = TemplateRestriction.check(timestamp, definition, this.templateBody, null);
                    this.templateBody.setBaseTemplate(null);
                    break;
                }
            }
        } else {
            needsRuntimeCheck = TemplateRestriction.check(timestamp, definition, this.templateBody, null);
        }
        return needsRuntimeCheck;
    }

    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        this.templateBody.checkRecursions(timestamp, referenceChain);
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.type != null) {
            this.type.updateSyntax(reparser, false);
            reparser.updateLocation(this.type.getLocation());
        }
        if (this.derivedReference != null) {
            this.derivedReference.updateSyntax(reparser, false);
            reparser.updateLocation(this.derivedReference.getLocation());
        }
        this.templateBody.updateSyntax(reparser, false);
        reparser.updateLocation(this.templateBody.getLocation());
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.type != null) {
            this.type.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.derivedReference != null) {
            this.derivedReference.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.templateBody != null) {
            this.templateBody.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.type != null && !this.type.accept(v)) {
            return false;
        }
        if (this.derivedReference != null && !this.derivedReference.accept(v)) {
            return false;
        }
        return this.templateBody == null || this.templateBody.accept(v);
    }
}

