/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Sequence_Type;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.NamedTemplate;
import org.eclipse.titan.designer.AST.TTCN3.templates.Named_Template_List;
import org.eclipse.titan.designer.AST.TTCN3.templates.OmitValue_Template;
import org.eclipse.titan.designer.AST.TTCN3.types.Array_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.AST.TTCN3.types.CompFieldMap;
import org.eclipse.titan.designer.AST.TTCN3.types.SequenceOf_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Set_Seq_Choice_BaseType;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.SubType;
import org.eclipse.titan.designer.AST.TTCN3.values.NamedValue;
import org.eclipse.titan.designer.AST.TTCN3.values.Omit_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SequenceOf_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Sequence_Value;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class TTCN3_Sequence_Type
extends TTCN3_Set_Seq_Choice_BaseType {
    public static final String INCOMPLETEPRESENTERROR = "Not used symbol `-' is not allowed in this context";
    private static final String UNSUPPERTED_FIELDNAME = "Sorry, but it is not supported for sequence types to have a field with a name (`{0}'') which exactly matches the name of the type definition.";
    private static final String SEQUANCEEPECTED = "sequence value was expected for type `{0}''";
    private static final String NONEXISTENTFIELDERRORASN1 = "Reference to a non-existent component `{0}'' of SEQUENCE type `{1}''";
    private static final String DUPLICATEDFIELDFIRSTASN1 = "Component `{0}'' is already given here";
    private static final String DUPLICATEDFIELDAGAINASN1 = "Duplicated SEQUENCE component `{0}''";
    private static final String WRONGFIELDORDERASN1 = "Component `{0}'' cannot appear after component `{1}'' in SEQUENCE value";
    private static final String UNEXPECTEDFIELDASN1 = "Unexpected component `{0}'' in SEQUENCE value, expecting `{1}''";
    private static final String MISSINGFIELDASN1 = "Mandatory component `{0}'' is missing from SEQUENCE value";
    private static final String NONEXISTENTFIELDERRORTTCN3 = "Reference to a non-existent field `{0}'' in record value for type `{1}''";
    private static final String DUPLICATEDFIELDFIRSTTTCN3 = "Field `{0}'' is already given here";
    private static final String DUPLICATEDFIELDAGAINTTCN3 = "Duplicated record field `{0}''";
    private static final String WRONGFIELDORDERTTCN3 = "Field `{0}'' cannot appear after field `{1}'' in record value";
    private static final String UNEXPECTEDFIELDTTCN3 = "Unexpected field `{0}'' in record value, expecting `{1}''";
    private static final String MISSINGFIELDTTCN3 = "Field `{0}'' is missing from record value";
    private static final String TEMPLATENOTALLOWED = "{0} cannot be used for record type `{1}''";
    private static final String LENGTHRESTRICTIONNOTALLOWED = "Length restriction is not allowed for record type `{0}''";
    private static final String DUPLICATETEMPLATEFIELDFIRST = "Duplicate field `{0}'' in template";
    private static final String DUPLICATETEMPLATEFIELDAGAIN = "Field `{0}'' is already given here";
    private static final String INCORRECTTEMPLATEFIELDORDER = "Field `{0}'' cannot appear after field `{1}'' in a template for record type `{2}''";
    private static final String UNEXPECTEDTEMPLATEFIELD = "Unexpected field `{0}'' in record template, expecting `{1}''";
    private static final String NONEXISTENTTEMPLATEFIELDREFERENCE = "Reference to non-existing field `{0}'' in record template for type `{1}''";
    private static final String MISSINGTEMPLATEFIELD = "Field `{0}'' is missing from template for record type `{1}''";
    private static final String NOFFIELDSDONTMATCH = "The number of fields in record/SEQUENCE types must be the same";
    private static final String NOFFIELDSDIMENSIONDONTMATCH = "The number of fields in record types ({0}) and the size of the array ({1}) must be the same";
    private static final String BADOPTIONALITY = "The optionality of fields in record/SEQUENCE types must be the same";
    private static final String NOTCOMPATIBLESETSETOF = "set/SET and set of/SET OF types are compatible only with other set/SET and set of/SET OF types";
    private static final String NOTCOMPATIBLEUNIONANYTYPE = "union/CHOICE/anytype types are compatible only with other union/CHOICE/anytype types";
    private static boolean strictConstantCheckingSeverity;

    public TTCN3_Sequence_Type(CompFieldMap compFieldMap) {
        super(compFieldMap);
    }

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_TTCN3_SEQUENCE;
    }

    @Override
    public SubType.SubType_type getSubtypeType() {
        return SubType.SubType_type.ST_RECORD;
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType temp = otherType.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp) || this == temp) {
            return true;
        }
        if (info == null || noStructuredTypeCompatibility) {
            return this == temp;
        }
        switch (temp.getTypetype()) {
            case TYPE_ASN1_SEQUENCE: {
                ASN1_Sequence_Type tempType = (ASN1_Sequence_Type)temp;
                if (this.getNofComponents() != tempType.getNofComponents(timestamp)) {
                    info.setErrorStr(NOFFIELDSDONTMATCH);
                    return false;
                }
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(tempType);
                }
                int size = this.getNofComponents();
                for (int i = 0; i < size; ++i) {
                    CompField cf = this.getComponentByIndex(i);
                    CompField tempTypeCf = tempType.getComponentByIndex(i);
                    IType cfType = cf.getType().getTypeRefdLast(timestamp);
                    IType tempTypeCfType = tempTypeCf.getType().getTypeRefdLast(timestamp);
                    if (cf.isOptional() != tempTypeCf.isOptional()) {
                        String cfName = cf.getIdentifier().getDisplayName();
                        String tempTypeCfName = tempTypeCf.getIdentifier().getDisplayName();
                        info.appendOp1Ref("." + cfName);
                        info.appendOp2Ref("." + tempTypeCfName);
                        info.setOp1Type(cfType);
                        info.setOp2Type(tempTypeCfType);
                        info.setErrorStr(BADOPTIONALITY);
                        return false;
                    }
                    TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(cfType, tempTypeCfType, false);
                    lChain.markState();
                    rChain.markState();
                    lChain.add(cfType);
                    rChain.add(tempTypeCfType);
                    if (!(cfType.equals(tempTypeCfType) || lChain.hasRecursion() && rChain.hasRecursion() || cfType.isCompatible(timestamp, tempTypeCfType, infoTemp, lChain, rChain))) {
                        String cfName = cf.getIdentifier().getDisplayName();
                        String tempTypeCfName = tempTypeCf.getIdentifier().getDisplayName();
                        info.appendOp1Ref("." + cfName + infoTemp.getOp1RefStr());
                        info.appendOp2Ref("." + tempTypeCfName + infoTemp.getOp2RefStr());
                        info.setOp1Type(infoTemp.getOp1Type());
                        info.setOp2Type(infoTemp.getOp2Type());
                        info.setErrorStr(infoTemp.getErrorStr());
                        lChain.previousState();
                        rChain.previousState();
                        return false;
                    }
                    lChain.previousState();
                    rChain.previousState();
                }
                info.setNeedsConversion(true);
                return true;
            }
            case TYPE_TTCN3_SEQUENCE: {
                TTCN3_Sequence_Type tempType = (TTCN3_Sequence_Type)temp;
                if (this == tempType) {
                    return true;
                }
                if (this.getNofComponents() != tempType.getNofComponents()) {
                    info.setErrorStr(NOFFIELDSDONTMATCH);
                    return false;
                }
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(tempType);
                }
                int size = this.getNofComponents();
                for (int i = 0; i < size; ++i) {
                    CompField cf = this.getComponentByIndex(i);
                    CompField tempTypeCf = tempType.getComponentByIndex(i);
                    IType cfType = cf.getType().getTypeRefdLast(timestamp);
                    IType tempTypeCfType = tempTypeCf.getType().getTypeRefdLast(timestamp);
                    if (cf.isOptional() != tempTypeCf.isOptional()) {
                        String cfName = cf.getIdentifier().getDisplayName();
                        String tempTypeCfName = tempTypeCf.getIdentifier().getDisplayName();
                        info.appendOp1Ref("." + cfName);
                        info.appendOp2Ref("." + tempTypeCfName);
                        info.setOp1Type(cfType);
                        info.setOp2Type(tempTypeCfType);
                        info.setErrorStr(BADOPTIONALITY);
                        return false;
                    }
                    TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(cfType, tempTypeCfType, false);
                    lChain.markState();
                    rChain.markState();
                    lChain.add(cfType);
                    rChain.add(tempTypeCfType);
                    if (!(cfType.equals(tempTypeCfType) || lChain.hasRecursion() && rChain.hasRecursion() || cfType.isCompatible(timestamp, tempTypeCfType, infoTemp, lChain, rChain))) {
                        String cfName = cf.getIdentifier().getDisplayName();
                        String tempTypeCfName = tempTypeCf.getIdentifier().getDisplayName();
                        info.appendOp1Ref("." + cfName + infoTemp.getOp1RefStr());
                        info.appendOp2Ref("." + tempTypeCfName + infoTemp.getOp2RefStr());
                        info.setOp1Type(infoTemp.getOp1Type());
                        info.setOp2Type(infoTemp.getOp2Type());
                        info.setErrorStr(infoTemp.getErrorStr());
                        lChain.previousState();
                        rChain.previousState();
                        return false;
                    }
                    lChain.previousState();
                    rChain.previousState();
                }
                info.setNeedsConversion(true);
                return true;
            }
            case TYPE_SEQUENCE_OF: {
                SequenceOf_Type tempType = (SequenceOf_Type)temp;
                if (!tempType.isSubtypeCompatible(timestamp, this)) {
                    info.setErrorStr("Incompatible record of/SEQUENCE OF subtypes");
                    return false;
                }
                int nofComps = this.getNofComponents();
                if (nofComps == 0) {
                    return false;
                }
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(tempType);
                }
                for (int i = 0; i < nofComps; ++i) {
                    CompField cf = this.getComponentByIndex(i);
                    IType cfType = cf.getType().getTypeRefdLast(timestamp);
                    IType tempTypeOfType = tempType.getOfType().getTypeRefdLast(timestamp);
                    TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(cfType, tempTypeOfType, false);
                    lChain.markState();
                    rChain.markState();
                    lChain.add(cfType);
                    rChain.add(tempTypeOfType);
                    if (!(cfType.equals(tempTypeOfType) || lChain.hasRecursion() && rChain.hasRecursion() || cfType.isCompatible(timestamp, tempTypeOfType, infoTemp, lChain, rChain))) {
                        info.appendOp1Ref("." + cf.getIdentifier().getDisplayName() + infoTemp.getOp1RefStr());
                        if (infoTemp.getOp2RefStr().length() > 0) {
                            info.appendOp2Ref("[]");
                        }
                        info.appendOp2Ref(infoTemp.getOp2RefStr());
                        info.setOp1Type(infoTemp.getOp1Type());
                        info.setOp2Type(infoTemp.getOp2Type());
                        info.setErrorStr(infoTemp.getErrorStr());
                        lChain.previousState();
                        rChain.previousState();
                        return false;
                    }
                    lChain.previousState();
                    rChain.previousState();
                }
                info.setNeedsConversion(true);
                return true;
            }
            case TYPE_ARRAY: {
                Array_Type tempType = (Array_Type)temp;
                int nofComps = this.getNofComponents();
                if (nofComps == 0) {
                    return false;
                }
                long tempTypeNOfComps = tempType.getDimension().getSize();
                if ((long)nofComps != tempTypeNOfComps) {
                    info.setErrorStr(MessageFormat.format(NOFFIELDSDIMENSIONDONTMATCH, nofComps, tempTypeNOfComps));
                    return false;
                }
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(tempType);
                }
                for (int i = 0; i < nofComps; ++i) {
                    CompField cf = this.getComponentByIndex(i);
                    IType cfType = cf.getType().getTypeRefdLast(timestamp);
                    IType tempTypeElementType = tempType.getElementType().getTypeRefdLast(timestamp);
                    TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(cfType, tempTypeElementType, false);
                    lChain.markState();
                    rChain.markState();
                    lChain.add(cfType);
                    rChain.add(tempTypeElementType);
                    if (!(cfType.equals(tempTypeElementType) || lChain.hasRecursion() && rChain.hasRecursion() || cfType.isCompatible(timestamp, tempTypeElementType, infoTemp, lChain, rChain))) {
                        info.appendOp1Ref("." + cf.getIdentifier().getDisplayName() + infoTemp.getOp1RefStr());
                        info.appendOp2Ref(infoTemp.getOp2RefStr());
                        info.setOp1Type(infoTemp.getOp1Type());
                        info.setOp2Type(infoTemp.getOp2Type());
                        info.setErrorStr(infoTemp.getErrorStr());
                        lChain.previousState();
                        rChain.previousState();
                        return false;
                    }
                    lChain.previousState();
                    rChain.previousState();
                }
                info.setNeedsConversion(true);
                return true;
            }
            case TYPE_ASN1_CHOICE: 
            case TYPE_TTCN3_CHOICE: 
            case TYPE_ANYTYPE: {
                info.setErrorStr(NOTCOMPATIBLEUNIONANYTYPE);
                return false;
            }
            case TYPE_ASN1_SET: 
            case TYPE_TTCN3_SET: 
            case TYPE_SET_OF: {
                info.setErrorStr(NOTCOMPATIBLESETSETOF);
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isIdentical(CompilationTimeStamp timestamp, IType type) {
        this.check(timestamp);
        type.check(timestamp);
        IType temp = type.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp)) {
            return true;
        }
        return this == temp;
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        if (this.isErroneous) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        return this.getTypetype();
    }

    @Override
    public String getTypename() {
        return this.getFullName();
    }

    @Override
    public String getOutlineIcon() {
        return "record.gif";
    }

    @Override
    public void checkConstructorName(String definitionName) {
        if (this.hasComponentWithName(definitionName)) {
            CompField field = this.getComponentByName(definitionName);
            field.getIdentifier().getLocation().reportSemanticError(MessageFormat.format(UNSUPPERTED_FIELDNAME, field.getIdentifier().getDisplayName()));
        }
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this)) {
            int size = this.getNofComponents();
            for (int i = 0; i < size; ++i) {
                CompField field = this.getComponentByIndex(i);
                Type type = field.getType();
                if (field.isOptional() || type == null) continue;
                referenceChain.markState();
                type.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
        }
    }

    @Override
    public void checkThisValue(CompilationTimeStamp timestamp, IValue value, IType.ValueCheckingOptions valueCheckingOptions) {
        if (this.getIsErroneous(timestamp)) {
            return;
        }
        super.checkThisValue(timestamp, value, valueCheckingOptions);
        IValue last = value.getValueRefdLast(timestamp, valueCheckingOptions.expected_value, null);
        if (last == null || last.getIsErroneous(timestamp)) {
            return;
        }
        switch (value.getValuetype()) {
            case OMIT_VALUE: 
            case REFERENCED_VALUE: {
                return;
            }
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                if (!IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) break;
                return;
            }
        }
        switch (last.getValuetype()) {
            case SEQUENCE_VALUE: {
                if (last.isAsn()) {
                    this.checkThisValueSeq(timestamp, (Sequence_Value)last, valueCheckingOptions.expected_value, false, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                    break;
                }
                this.checkThisValueSeq(timestamp, (Sequence_Value)last, valueCheckingOptions.expected_value, valueCheckingOptions.incomplete_allowed, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                break;
            }
            case SEQUENCEOF_VALUE: {
                if (((SequenceOf_Value)last).isIndexed()) {
                    value.getLocation().reportSemanticError(MessageFormat.format("Indexed assignment notation cannot be used for record type `{0}''", this.getFullName()));
                    value.setIsErroneous(true);
                    break;
                }
                if ((last = last.setValuetype(timestamp, IValue.Value_type.SEQUENCE_VALUE)).isAsn()) {
                    this.checkThisValueSeq(timestamp, (Sequence_Value)last, valueCheckingOptions.expected_value, false, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                    break;
                }
                this.checkThisValueSeq(timestamp, (Sequence_Value)last, valueCheckingOptions.expected_value, valueCheckingOptions.incomplete_allowed, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                break;
            }
            case UNDEFINED_BLOCK: {
                last = last.setValuetype(timestamp, IValue.Value_type.SEQUENCE_VALUE);
                this.checkThisValueSeq(timestamp, (Sequence_Value)last, valueCheckingOptions.expected_value, false, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                break;
            }
            case EXPRESSION_VALUE: 
            case MACRO_VALUE: {
                break;
            }
            default: {
                value.getLocation().reportSemanticError(MessageFormat.format(SEQUANCEEPECTED, this.getFullName()));
                value.setIsErroneous(true);
            }
        }
        if (valueCheckingOptions.sub_check && this.subType != null) {
            this.subType.checkThisValue(timestamp, last);
        }
        value.setLastTimeChecked(timestamp);
    }

    private void checkThisValueSeq(CompilationTimeStamp timestamp, Sequence_Value value, Expected_Value_type expectedValue, boolean incompleteAllowed, boolean implicitOmit, boolean strElem) {
        CompilationTimeStamp valueTimeStamp = value.getLastTimeChecked();
        if (valueTimeStamp == null || valueTimeStamp.isLess(timestamp)) {
            value.removeGeneratedValues();
        }
        HashMap<String, NamedValue> componentMap = new HashMap<String, NamedValue>();
        Map<String, CompField> realComponents = this.compFieldMap.getComponentFieldMap(timestamp);
        boolean isAsn = value.isAsn();
        boolean inSnyc = true;
        int nofTypeComponents = realComponents.size();
        int nofValueComponents = value.getNofComponents();
        int nextIndex = 0;
        CompField lastCompField = null;
        int sequenceIndex = 0;
        int i = 0;
        while (i < nofValueComponents) {
            NamedValue namedValue = value.getSeqValueByIndex(i);
            Identifier valueId = namedValue.getName();
            if (!realComponents.containsKey(valueId.getName())) {
                namedValue.getLocation().reportSemanticError(MessageFormat.format(isAsn ? NONEXISTENTFIELDERRORASN1 : NONEXISTENTFIELDERRORTTCN3, namedValue.getName().getDisplayName(), this.getTypename()));
                inSnyc = false;
            } else {
                if (componentMap.containsKey(valueId.getName())) {
                    String duplicateAgain = MessageFormat.format(isAsn ? DUPLICATEDFIELDAGAINASN1 : DUPLICATEDFIELDAGAINTTCN3, valueId.getDisplayName());
                    namedValue.getLocation().reportSemanticError(duplicateAgain);
                    String duplicateFirst = MessageFormat.format(isAsn ? DUPLICATEDFIELDFIRSTASN1 : "Field `{0}'' is already given here", valueId.getDisplayName());
                    ((NamedValue)componentMap.get(valueId.getName())).getLocation().reportSingularSemanticError(duplicateFirst);
                    inSnyc = false;
                } else {
                    componentMap.put(valueId.getName(), namedValue);
                }
                CompField componentField = realComponents.get(valueId.getName());
                if (inSnyc) {
                    if (incompleteAllowed) {
                        boolean found = false;
                        for (int j = nextIndex; j < nofTypeComponents && !found; ++j) {
                            CompField field2 = this.getComponentByIndex(j);
                            if (!valueId.getName().equals(field2.getIdentifier().getName())) continue;
                            lastCompField = field2;
                            nextIndex = j + 1;
                            found = true;
                        }
                        if (lastCompField != null && !found) {
                            namedValue.getLocation().reportSemanticError(MessageFormat.format(isAsn ? WRONGFIELDORDERASN1 : WRONGFIELDORDERTTCN3, valueId.getDisplayName(), lastCompField.getIdentifier().getDisplayName()));
                            inSnyc = false;
                        }
                    } else {
                        CompField field2;
                        CompField field2Original = field2 = this.getComponentByIndex(sequenceIndex);
                        while (implicitOmit && sequenceIndex < this.getNofComponents() && componentField != field2 && field2.isOptional()) {
                            field2 = this.getComponentByIndex(sequenceIndex);
                        }
                        if (sequenceIndex >= this.getNofComponents() || componentField != field2) {
                            namedValue.getLocation().reportSemanticError(MessageFormat.format(isAsn ? UNEXPECTEDFIELDASN1 : UNEXPECTEDFIELDTTCN3, valueId.getDisplayName(), field2Original.getIdentifier().getDisplayName()));
                        }
                    }
                }
                Type type = componentField.getType();
                IValue componentValue = namedValue.getValue();
                if (componentValue != null) {
                    componentValue.setMyGovernor(type);
                    if (IValue.Value_type.NOTUSED_VALUE.equals((Object)componentValue.getValuetype())) {
                        if (!incompleteAllowed) {
                            componentValue.getLocation().reportSemanticError(INCOMPLETEPRESENTERROR);
                        }
                    } else {
                        IValue tempValue = type.checkThisValueRef(timestamp, componentValue);
                        type.checkThisValue(timestamp, tempValue, new IType.ValueCheckingOptions(expectedValue, incompleteAllowed, componentField.isOptional(), true, implicitOmit, strElem));
                    }
                }
            }
            ++i;
            ++sequenceIndex;
        }
        if (!incompleteAllowed || strictConstantCheckingSeverity) {
            for (i = 0; i < nofTypeComponents; ++i) {
                Identifier id = this.compFieldMap.fields.get(i).getIdentifier();
                if (componentMap.containsKey(id.getName())) continue;
                if (this.getComponentByIndex(i).isOptional() && implicitOmit) {
                    value.addNamedValue(new NamedValue(new Identifier(Identifier.Identifier_type.ID_TTCN, id.getDisplayName()), new Omit_Value(), false));
                    continue;
                }
                value.getLocation().reportSemanticError(MessageFormat.format(isAsn ? MISSINGFIELDASN1 : MISSINGFIELDTTCN3, id.getDisplayName()));
            }
        }
        value.setLastTimeChecked(timestamp);
    }

    @Override
    public void checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit) {
        this.registerUsage(template);
        template.setMyGovernor(this);
        switch (template.getTemplatetype()) {
            case TEMPLATE_LIST: {
                ITTCN3Template transformed = template.setTemplatetype(timestamp, ITTCN3Template.Template_type.NAMED_TEMPLATE_LIST);
                this.checkThisNamedTemplateList(timestamp, (Named_Template_List)transformed, isModified, implicitOmit);
                break;
            }
            case NAMED_TEMPLATE_LIST: {
                this.checkThisNamedTemplateList(timestamp, (Named_Template_List)template, isModified, implicitOmit);
                break;
            }
            default: {
                template.getLocation().reportSemanticError(MessageFormat.format(TEMPLATENOTALLOWED, template.getTemplateTypeName(), this.getTypename()));
            }
        }
        if (template.getLengthRestriction() != null) {
            template.getLocation().reportSemanticError(LENGTHRESTRICTIONNOTALLOWED);
        }
    }

    private void checkThisNamedTemplateList(CompilationTimeStamp timestamp, Named_Template_List templateList, boolean isModified, boolean implicitOmit) {
        int i;
        templateList.removeGeneratedValues();
        HashMap<String, NamedTemplate> componentMap = new HashMap<String, NamedTemplate>();
        int nofTypeComponents = this.getNofComponents();
        int nofTemplateComponents = templateList.getNofTemplates();
        boolean inSync = true;
        Map<String, CompField> realComponents = this.compFieldMap.getComponentFieldMap(timestamp);
        CompField lastComponentField = null;
        int nextIndex = 0;
        for (i = 0; i < nofTemplateComponents; ++i) {
            NamedTemplate namedTemplate = templateList.getTemplateByIndex(i);
            Identifier identifier = namedTemplate.getName();
            String templateName = identifier.getName();
            if (realComponents.containsKey(templateName)) {
                if (componentMap.containsKey(templateName)) {
                    namedTemplate.getLocation().reportSemanticError(MessageFormat.format(DUPLICATETEMPLATEFIELDFIRST, identifier.getDisplayName()));
                    ((NamedTemplate)componentMap.get(templateName)).getLocation().reportSemanticError(MessageFormat.format("Field `{0}'' is already given here", identifier.getDisplayName()));
                } else {
                    componentMap.put(templateName, namedTemplate);
                }
                CompField componentField = this.getComponentByName(identifier.getName());
                if (inSync) {
                    CompField componentField2;
                    if (isModified) {
                        boolean found = false;
                        for (int j = nextIndex; j < nofTypeComponents && !found; ++j) {
                            CompField componentField22 = this.getComponentByIndex(j);
                            if (!templateName.equals(componentField22.getIdentifier().getName())) continue;
                            lastComponentField = componentField22;
                            nextIndex = j + 1;
                            found = true;
                        }
                        if (!found && lastComponentField != null) {
                            String message = MessageFormat.format(INCORRECTTEMPLATEFIELDORDER, identifier.getDisplayName(), lastComponentField.getIdentifier().getDisplayName(), this.getFullName());
                            namedTemplate.getLocation().reportSemanticError(message);
                            inSync = false;
                        }
                    } else if (strictConstantCheckingSeverity && (componentField2 = this.getComponentByIndex(i)) != componentField && (!componentField2.isOptional() || componentField2.isOptional() && !implicitOmit)) {
                        String message = MessageFormat.format(UNEXPECTEDTEMPLATEFIELD, identifier.getDisplayName(), componentField2.getIdentifier().getDisplayName());
                        namedTemplate.getLocation().reportSemanticError(message);
                        inSync = false;
                    }
                }
                Type type = componentField.getType();
                ITTCN3Template componentTemplate = namedTemplate.getTemplate();
                componentTemplate.setMyGovernor(type);
                componentTemplate = type.checkThisTemplateRef(timestamp, componentTemplate);
                boolean isOptional = componentField.isOptional();
                componentTemplate.checkThisTemplateGeneric(timestamp, type, isModified, isOptional, isOptional, true, implicitOmit);
                continue;
            }
            namedTemplate.getLocation().reportSemanticError(MessageFormat.format(NONEXISTENTTEMPLATEFIELDREFERENCE, identifier.getDisplayName(), this.getTypename()));
            inSync = false;
        }
        if (!isModified && strictConstantCheckingSeverity) {
            for (i = 0; i < nofTypeComponents; ++i) {
                Identifier identifier = this.getComponentIdentifierByIndex(i);
                if (componentMap.containsKey(identifier.getName())) continue;
                if (this.getComponentByIndex(i).isOptional() && implicitOmit) {
                    templateList.addNamedValue(new NamedTemplate(new Identifier(Identifier.Identifier_type.ID_TTCN, identifier.getDisplayName()), new OmitValue_Template(), false));
                    continue;
                }
                templateList.getLocation().reportSemanticError(MessageFormat.format(MISSINGTEMPLATEFIELD, identifier.getDisplayName(), this.getTypename()));
            }
        }
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        return builder.append("sequence");
    }

    static {
        final IPreferencesService ps = Platform.getPreferencesService();
        if (ps != null) {
            strictConstantCheckingSeverity = ps.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportStrictConstants", false, null);
            Activator activator = Activator.getDefault();
            if (activator != null) {
                activator.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent event) {
                        String property = event.getProperty();
                        if ("org.eclipse.titan.designer.reportStrictConstants".equals(property)) {
                            strictConstantCheckingSeverity = ps.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportStrictConstants", false, null);
                        }
                    }
                });
            }
        }
    }
}

