/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class TypeSet
extends ASTNode {
    private final ArrayList<IType> types = new ArrayList();
    private final Map<String, IType> typeMap = new HashMap<String, IType>();

    public void addType(IType type) {
        if (type != null) {
            this.types.add(type);
            this.types.trimToSize();
            this.typeMap.put(type.getTypename(), type);
        }
    }

    public int getNofTypes() {
        return this.types.size();
    }

    public IType getTypeByIndex(int index) {
        return this.types.get(index);
    }

    public boolean hasType(CompilationTimeStamp timestamp, IType type) {
        if (type == null) {
            return false;
        }
        IType tempType = type.getTypeRefdLast(timestamp);
        if (tempType.getIsErroneous(timestamp)) {
            return true;
        }
        return this.typeMap.containsKey(tempType.getTypename());
    }

    public int getNofCompatibleTypes(CompilationTimeStamp timestamp, IType type) {
        if (type.getTypeRefdLast(timestamp).getIsErroneous(timestamp)) {
            return 1;
        }
        int result = 0;
        int size = this.types.size();
        for (int i = 0; i < size; ++i) {
            if (!this.types.get(i).isCompatible(timestamp, type, null, null, null)) continue;
            ++result;
        }
        return result;
    }

    public boolean hasTypeWithName(String name) {
        return this.typeMap.containsKey(name);
    }

    public IType getTypeByName(String name) {
        return this.typeMap.get(name);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.types != null) {
            for (IType t : this.types) {
                if (t.accept(v)) continue;
                return false;
            }
        }
        return true;
    }
}

