/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values;

import java.text.MessageFormat;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public abstract class ArrayDimension
extends ASTNode
implements ILocateableNode,
IIncrementallyUpdateable {
    private static final String INTEGEREXPECTED = "Integer value expected as array index";
    private static final String INDEXUNDERFLOW = "Array index underflow: the index value must be at least {0} instead of {1}";
    private static final String INDEXOVERFLOW = "Array index oveflow: the index value must be at most {0} instead of {1}";
    protected CompilationTimeStamp lastTimeChecked;
    private boolean isErroneous = false;
    private Location location = NULL_Location.INSTANCE;

    @Override
    public final void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public final Location getLocation() {
        return this.location;
    }

    public abstract long getSize();

    public abstract long getOffset();

    public abstract String createStringRepresentation();

    public final boolean getIsErroneous(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.isErroneous;
        }
        return false;
    }

    public final void setIsErroneous(boolean isErroneous) {
        this.isErroneous = isErroneous;
    }

    public abstract void check(CompilationTimeStamp var1);

    public final void checkIndex(CompilationTimeStamp timestamp, IValue index, Expected_Value_type expectedValue) {
        this.check(timestamp);
        if (index == null) {
            return;
        }
        index.setLoweridToReference(timestamp);
        IType.Type_type temporalType = index.getExpressionReturntype(timestamp, expectedValue);
        switch (temporalType) {
            case TYPE_INTEGER: {
                break;
            }
            case TYPE_UNDEFINED: {
                this.setIsErroneous(true);
                break;
            }
            default: {
                index.getLocation().reportSemanticError(INTEGEREXPECTED);
                this.setIsErroneous(true);
            }
        }
        if (this.getIsErroneous(timestamp) || index.isUnfoldable(timestamp)) {
            return;
        }
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue last = index.getValueRefdLast(timestamp, referenceChain);
        referenceChain.release();
        long indexValue = ((Integer_Value)last).getValue();
        if (indexValue < this.getOffset()) {
            index.getLocation().reportSemanticError(MessageFormat.format(INDEXUNDERFLOW, this.getOffset(), indexValue));
            index.setIsErroneous(true);
        } else if (indexValue >= this.getOffset() + this.getSize()) {
            index.getLocation().reportSemanticError(MessageFormat.format(INDEXOVERFLOW, this.getOffset() + this.getSize() - 1L, indexValue));
            index.setIsErroneous(true);
        }
    }

    public final boolean isIdentical(CompilationTimeStamp timestamp, ArrayDimension other) {
        if (other == null) {
            return true;
        }
        this.check(timestamp);
        other.check(timestamp);
        if (this.getIsErroneous(timestamp) || other.getIsErroneous(timestamp)) {
            return true;
        }
        return this.getSize() == other.getSize() && this.getOffset() == other.getOffset();
    }

    @Override
    public abstract void updateSyntax(TTCN3ReparseUpdater var1, boolean var2) throws ReParseException;
}

