/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public abstract class Expression_Value
extends Value {
    private static final String CONSTANTEXPECTED = "An evaluatable constant value was expected instead of operation `{0}''";
    private static final String STATICVALUEEXPECTED = "A static value was expected instead of operation `{0}''";
    private static final String NOTINCONTROLPART = "Operation `{0}'' is not allowed in the control part";
    private static final String NOTINRUNSON = "Operation `{0}'' cannot be used in a definition that has `runs on'' clause";
    private static final String ONLYINRUNSON = "Operation `{0}'' can be used only in a definition that has `runs on'' clause";
    private static final String ONLYINSTATEMENTS = "Operation `{0}'' is allowed only within statements";
    protected static final String OPERAND = ".<operand>";
    protected static final String OPERAND1 = ".<operand1>";
    protected static final String OPERAND2 = ".<operand2>";
    protected static final String OPERAND3 = ".<operand3>";
    protected static final String OPERAND4 = ".<operand4>";
    protected IValue lastValue;

    @Override
    public final IValue.Value_type getValuetype() {
        return IValue.Value_type.EXPRESSION_VALUE;
    }

    public abstract Operation_type getOperationType();

    @Override
    public final String chainedDescription() {
        return "expression: " + this.getFullName();
    }

    @Override
    public final IValue getReferencedSubValue(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, IReferenceChain refChain) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (this.getIsErroneous(timestamp) || subreferences.size() <= actualSubReference) {
            return this;
        }
        IValue result = this.getValueRefdLast(timestamp, refChain);
        if (result != null && result != this && (result = result.getReferencedSubValue(timestamp, reference, actualSubReference, refChain)) != null && result.getIsErroneous(timestamp)) {
            this.setIsErroneous(true);
        }
        return this;
    }

    public abstract IValue evaluateValue(CompilationTimeStamp var1, Expected_Value_type var2, IReferenceChain var3);

    @Override
    public final IValue getValueRefdLast(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        boolean newChain = null == referenceChain;
        IReferenceChain tempReferenceChain = newChain ? ReferenceChain.getInstance("Circular reference chain: `{0}''", true) : referenceChain;
        IValue last = this;
        tempReferenceChain.markState();
        if (tempReferenceChain.add(this)) {
            last = this.evaluateValue(timestamp, expectedValue, tempReferenceChain);
        } else {
            this.setIsErroneous(true);
        }
        tempReferenceChain.previousState();
        if (newChain) {
            tempReferenceChain.release();
        }
        if (last == null) {
            return this;
        }
        return last;
    }

    @Override
    public final boolean checkEquality(CompilationTimeStamp timestamp, IValue other) {
        return this == other;
    }

    protected final void checkExpressionDynamicPart(Expected_Value_type expectedValue, String operationName, boolean allowControlpart, boolean allowRunsOn, boolean requireRunsOn) {
        switch (expectedValue) {
            case EXPECTED_CONSTANT: {
                this.location.reportSemanticError(MessageFormat.format(CONSTANTEXPECTED, operationName));
                this.setIsErroneous(true);
                return;
            }
            case EXPECTED_STATIC_VALUE: {
                this.location.reportSemanticError(MessageFormat.format(STATICVALUEEXPECTED, operationName));
                this.setIsErroneous(true);
                return;
            }
        }
        if (this.myScope == null) {
            return;
        }
        if (!allowRunsOn && this.myScope.getScopeRunsOn() != null) {
            this.location.reportSemanticError(MessageFormat.format(NOTINRUNSON, operationName));
            this.setIsErroneous(true);
        } else if (requireRunsOn && this.myScope.getScopeRunsOn() == null) {
            this.location.reportSemanticError(MessageFormat.format(ONLYINRUNSON, operationName));
            this.setIsErroneous(true);
        } else {
            StatementBlock myStatementBlock = this.myScope.getStatementBlockScope();
            if (myStatementBlock == null) {
                this.location.reportSemanticError(MessageFormat.format(ONLYINSTATEMENTS, operationName));
                this.setIsErroneous(true);
            } else if (!allowControlpart && myStatementBlock.getMyDefinition() == null) {
                this.location.reportSemanticError(MessageFormat.format(NOTINCONTROLPART, operationName));
                this.setIsErroneous(true);
            }
        }
    }

    @Override
    public abstract void updateSyntax(TTCN3ReparseUpdater var1, boolean var2) throws ReParseException;

    public static enum Operation_type {
        UNARYPLUS_OPERATION,
        UNARYMINUS_OPERATION,
        NOT_OPERATION,
        NOT4B_OPERATION,
        ADD_OPERATION,
        SUBSTRACT_OPERATION,
        MULTIPLY_OPERARTION,
        DIVIDE_OPERATION,
        MODULO_OPERATION,
        REMAINDER_OPERATION,
        AND_OPERATION,
        OR_OPERATION,
        XOR_OPERATION,
        AND4B_OPERATION,
        OR4B_OPERATION,
        XOR4B_OPERATION,
        SHIFTLEFT_OPERATION,
        SHIFTRIGHT_OPERATION,
        ROTATELEFT_OPERATION,
        ROTATERIGHT_OPERATION,
        CONCATENATION_OPERATION,
        EQUALS_OPERATION,
        NOTEQUALS_OPERATION,
        LESSTHAN_OPERATION,
        GREATERTHAN_OPERATION,
        GREATERTHANOREQUAL_OPERATION,
        LESSTHANOREQUAL_OPERATION,
        BIT2HEX_OPERATION,
        BIT2INT_OPERATION,
        BIT2OCT_OPERATION,
        BIT2STR_OPERATION,
        CHAR2STR_OPERATION,
        CHAR2OCT_OPERATION,
        FLOAT2INT_OPERATION,
        FLOAT2STR_OPERATION,
        HEX2BIT_OPERATION,
        HEX2INT_OPERATION,
        HEX2OCT_OPERATION,
        HEX2STR_OPERATION,
        INT2CHAR_OPERATION,
        INT2FLOAT_OPERATION,
        INT2STR_OPERATION,
        INT2UNICHAR_OPERATION,
        OCT2BIT_OPERATION,
        OCT2CHAR_OPERATION,
        OCT2HEX_OPERATION,
        OCT2INT_OPERATION,
        OCT2STR_OPERATION,
        STR2BIT_OPERATION,
        STR2FLOAT_OPERATION,
        STR2HEX_OPERATION,
        STR2INT_OPERATION,
        STR2OCT_OPERATION,
        UNICHAR2INT_OPERATION,
        UNICHAR2CHAR_OPERATION,
        ENUM2INT_OPERATION,
        ENCODE_OPERATION,
        DECODE_OPERATION,
        INT2BIT_OPERATION,
        INT2HEX_OPERATION,
        INT2OCT_OPERATION,
        DECOMP_OPERATION,
        REPLACE_OPERATION,
        SUBSTR_OPERATION,
        RND_OPERATION,
        RNDWITHVALUE_OPERATION,
        ISBOUND_OPERATION,
        ISVALUE_OPERATION,
        LENGTHOF_OPERATION,
        ISPRESENT_OPERATION,
        ISCHOOSEN_OPERATION,
        SIZEOF_OPERATION,
        REGULAREXPRESSION_OPERATION,
        VALUEOF_OPERATION,
        MATCH_OPERATION,
        GETVERDICT_OPERATION,
        COMPONENT_NULL_OPERATION,
        MTC_COMPONENT_OPERATION,
        SYSTEM_COMPONENT_OPERATION,
        SELF_COMPONENT_OPERATION,
        ANY_COMPONENT_RUNNING_OPERATION,
        ALL_COMPONENT_RUNNING_OPERATION,
        ANY_COMPONENT_ALIVE_OPERATION,
        ALL_COMPONENT_ALIVE_OPERATION,
        ANY_TIMER_RUNNING_OPERATION,
        COMPONENT_RUNNING_OPERATION,
        COMPONENT_ALIVE_OPERATION,
        TIMER_READ_OPERATION,
        UNDEFINED_RUNNING_OPERATION,
        TIMER_RUNNING_OPERATION,
        COMPONENT_CREATE_OPERATION,
        ACTIVATE_OPERATION,
        ACTIVATE_REFERENCED_OPERATION,
        EXECUTE_OPERATION,
        EXECUTE_REFERENCED_OPERATION,
        REFERS_OPERATION,
        APPLY_OPERATION,
        LOG2STR_OPERATION,
        TESTCASENAME_OPERATION,
        TTCN2STRING_OPERATION,
        GET_STRINGENCODING_OPERATION,
        OCT2UNICHAR_OPERATION,
        REMOVE_BOM_OPERATION,
        UNICHAR2OCT_OPERATION,
        ENCODE_BASE64_OPERATION,
        DECODE_BASE64_OPERATION,
        PROFILER_RUNNING_OPERATION;

    }
}

