/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.values.NamedValue;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class NamedValues
extends ASTNode
implements IIncrementallyUpdateable {
    public static final String DUPLICATEIDENTIFIERFIRST = "Duplicate field name `{0}'' was first used here";
    public static final String DUPLICATEIDENTIFIERREPEATED = "Duplicate identifier `{0}''";
    private final ArrayList<NamedValue> values = new ArrayList();
    private Map<String, NamedValue> namedValuesMap;
    private List<NamedValue> duplicatedNames;
    private CompilationTimeStamp lastUniquenessCheck;

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        this.values.trimToSize();
        for (int i = 0; i < this.values.size(); ++i) {
            this.values.get(i).setMyScope(scope);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        for (int i = 0; i < this.values.size(); ++i) {
            NamedValue nv = this.values.get(i);
            if (nv != child) continue;
            return builder.append(".").append(nv.getName().getDisplayName());
        }
        return builder;
    }

    public void addNamedValue(NamedValue value) {
        if (value == null || value.getName() == null) {
            return;
        }
        this.values.add(value);
        value.setFullNameParent(this);
    }

    public void removeGeneratedValues() {
        if (this.values != null) {
            Iterator<NamedValue> iterator = this.values.iterator();
            while (iterator.hasNext()) {
                NamedValue temp = iterator.next();
                if (temp.isParsed()) continue;
                iterator.remove();
            }
        }
    }

    public int getSize() {
        return this.values.size();
    }

    public NamedValue getNamedValueByIndex(int index) {
        return this.values.get(index);
    }

    public boolean hasNamedValueWithName(Identifier name) {
        if (this.lastUniquenessCheck == null) {
            this.checkUniqueness(CompilationTimeStamp.getBaseTimestamp());
        }
        return this.namedValuesMap.containsKey(name.getName());
    }

    public NamedValue getNamedValueByName(Identifier name) {
        if (this.lastUniquenessCheck == null) {
            this.checkUniqueness(CompilationTimeStamp.getBaseTimestamp());
        }
        return this.namedValuesMap.get(name.getName());
    }

    public void checkUniqueness(CompilationTimeStamp timestamp) {
        String name;
        Identifier identifier;
        if (this.lastUniquenessCheck != null && !this.lastUniquenessCheck.isLess(timestamp)) {
            return;
        }
        if (this.lastUniquenessCheck == null) {
            this.namedValuesMap = new HashMap<String, NamedValue>(this.values.size());
            this.duplicatedNames = new ArrayList<NamedValue>();
            for (NamedValue value : this.values) {
                identifier = value.getName();
                name = identifier.getName();
                if (this.namedValuesMap.containsKey(name)) {
                    if (this.duplicatedNames == null) {
                        this.duplicatedNames = new ArrayList<NamedValue>();
                    }
                    this.duplicatedNames.add(value);
                    continue;
                }
                this.namedValuesMap.put(name, value);
            }
            if (this.duplicatedNames != null) {
                for (NamedValue value : this.duplicatedNames) {
                    this.values.remove(value);
                }
            }
        }
        if (this.duplicatedNames != null) {
            for (NamedValue value : this.duplicatedNames) {
                identifier = value.getName();
                name = identifier.getName();
                this.namedValuesMap.get(name).getName().getLocation().reportSingularSemanticError(MessageFormat.format(DUPLICATEIDENTIFIERFIRST, identifier.getDisplayName()));
                value.getLocation().reportSemanticError(MessageFormat.format(DUPLICATEIDENTIFIERREPEATED, identifier.getDisplayName()));
            }
        }
        this.lastUniquenessCheck = timestamp;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        NamedValue value;
        int i;
        if (isDamaged) {
            throw new ReParseException();
        }
        int size = this.values.size();
        for (i = 0; i < size; ++i) {
            value = this.values.get(i);
            value.updateSyntax(reparser, false);
            reparser.updateLocation(value.getLocation());
        }
        if (this.duplicatedNames != null) {
            size = this.duplicatedNames.size();
            for (i = 0; i < size; ++i) {
                value = this.duplicatedNames.get(i);
                value.updateSyntax(reparser, false);
                reparser.updateLocation(value.getLocation());
            }
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.values == null) {
            return;
        }
        for (NamedValue nv : this.values) {
            nv.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.values != null) {
            for (NamedValue nv : this.values) {
                if (nv.accept(v)) continue;
                return false;
            }
        }
        return true;
    }
}

