/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ArraySubReference;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.types.OctetString_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Bitstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Hexstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.Bit2OctExpression;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.Hex2OctExpression;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Octetstring_Value
extends Value {
    private final String value;

    public Octetstring_Value(String value) {
        this.value = value;
    }

    Octetstring_Value(Bitstring_Value original) {
        this.value = Bit2OctExpression.bit2oct(original.getValue());
        this.copyGeneralProperties(original);
    }

    Octetstring_Value(Hexstring_Value original) {
        this.value = Hex2OctExpression.hex2oct(original.getValue());
        this.copyGeneralProperties(original);
    }

    @Override
    public IValue.Value_type getValuetype() {
        return IValue.Value_type.OCTETSTRING_VALUE;
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append('\'').append(this.value).append("'O");
        return builder.toString();
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_OCTETSTRING;
    }

    @Override
    public IType getExpressionGovernor(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.myGovernor != null) {
            return this.myGovernor;
        }
        return new OctetString_Type();
    }

    @Override
    public IValue getReferencedSubValue(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, IReferenceChain refChain) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (this.getIsErroneous(timestamp) || subreferences.size() <= actualSubReference) {
            return this;
        }
        IType type = this.myGovernor.getTypeRefdLast(timestamp);
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                Value arrayIndex = ((ArraySubReference)subreference).getValue();
                IValue valueIndex = arrayIndex.getValueRefdLast(timestamp, refChain);
                if (!valueIndex.isUnfoldable(timestamp)) {
                    if (IValue.Value_type.INTEGER_VALUE.equals((Object)valueIndex.getValuetype())) {
                        int index = ((Integer_Value)valueIndex).intValue();
                        return this.getStringElement(index, arrayIndex.getLocation());
                    }
                    arrayIndex.getLocation().reportSemanticError("An integer value was expected as index");
                    return null;
                }
                return null;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), type.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError("Invalid reference: internal parameterisation is not supported");
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        return false;
    }

    public String getValue() {
        return this.value;
    }

    public int getValueLength() {
        if (this.value == null || this.isErroneous) {
            return 0;
        }
        return this.value.length() / 2;
    }

    public Octetstring_Value getStringElement(int index, Location location) {
        if (this.value == null) {
            return null;
        }
        if (index < 0) {
            location.reportSemanticError(MessageFormat.format("A non-negative integer value was expected instead of {0} for indexing a string element", index));
            return null;
        }
        if (index >= this.value.length() / 2) {
            location.reportSemanticError(MessageFormat.format("Index overflow when accessing a string element: the index is {0}, but the string has only {1} elements", index, this.value.length() / 2));
            return null;
        }
        return new Octetstring_Value(this.value.substring(2 * index, 2 * index + 2));
    }

    @Override
    public boolean checkEquality(CompilationTimeStamp timestamp, IValue other) {
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue last = other.getValueRefdLast(timestamp, referenceChain);
        referenceChain.release();
        return IValue.Value_type.OCTETSTRING_VALUE.equals((Object)last.getValuetype()) && this.value.equals(((Octetstring_Value)last).getValue());
    }

    @Override
    public boolean evaluateIsvalue(boolean fromSequence) {
        return true;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return true;
    }
}

