/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASN1.values.Named_Integer_Value;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.values.Enumerated_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Referenced_Value;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Undefined_LowerIdentifier_Value
extends Value {
    private final Identifier identifier;
    private Value realValue;
    private Reference asReference;

    public Undefined_LowerIdentifier_Value(Identifier identifier) {
        this.identifier = identifier;
    }

    @Override
    public IValue.Value_type getValuetype() {
        return IValue.Value_type.UNDEFINED_LOWERIDENTIFIER_VALUE;
    }

    @Override
    public String createStringRepresentation() {
        return this.identifier.getName();
    }

    @Override
    public Location getLocation() {
        return new Location(this.identifier.getLocation());
    }

    @Override
    public void setLocation(Location location) {
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.lastTimeChecked == null || this.lastTimeChecked.isLess(timestamp)) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        if (this.realValue == null || this.realValue.getIsErroneous(timestamp)) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        return this.realValue.getExpressionReturntype(timestamp, expectedValue);
    }

    @Override
    public IType getExpressionGovernor(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.lastTimeChecked == null || this.lastTimeChecked.isLess(timestamp)) {
            return null;
        }
        if (this.realValue == null || this.realValue.getIsErroneous(timestamp)) {
            return null;
        }
        return this.realValue.getExpressionGovernor(timestamp, expectedValue);
    }

    @Override
    public IValue getReferencedSubValue(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, IReferenceChain refChain) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (this.getIsErroneous(timestamp) || subreferences.size() <= actualSubReference) {
            return this;
        }
        IValue result = this.getValueRefdLast(timestamp, refChain);
        if (result != null && result != this) {
            if ((result = result.getReferencedSubValue(timestamp, reference, actualSubReference, refChain)) != null && result.getIsErroneous(timestamp)) {
                this.setIsErroneous(true);
            }
            return result;
        }
        IType type = this.myGovernor.getTypeRefdLast(timestamp);
        if (type.getIsErroneous(timestamp)) {
            return null;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid array element reference: type `{0}'' can not be indexed", type.getTypename()));
                return null;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), type.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError("Invalid reference: internal parameterisation is not supported");
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked == null || this.lastTimeChecked.isLess(timestamp)) {
            return true;
        }
        if (this.realValue == null || this.realValue.getIsErroneous(timestamp)) {
            return true;
        }
        return this.realValue.isUnfoldable(timestamp, expectedValue, referenceChain);
    }

    @Override
    public boolean checkEquality(CompilationTimeStamp timestamp, IValue other) {
        if (this.realValue == null || this.realValue.getIsErroneous(timestamp)) {
            return false;
        }
        return this.realValue.checkEquality(timestamp, other);
    }

    @Override
    public IValue getValueRefdLast(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.myGovernor != null && this.myGovernor.getIsErroneous(timestamp)) {
            this.setIsErroneous(true);
            return this;
        }
        this.setLoweridToReference(timestamp);
        return this.realValue.getValueRefdLast(timestamp, expectedValue, referenceChain);
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public Reference getAsReference() {
        if (this.asReference != null) {
            return this.asReference;
        }
        this.asReference = new Reference(null);
        this.asReference.addSubReference(new FieldSubReference(this.identifier));
        this.asReference.setLocation(this.getLocation());
        this.asReference.setFullNameParent(this);
        this.asReference.setMyScope(this.myScope);
        return this.asReference;
    }

    @Override
    public Value setValuetype(CompilationTimeStamp timestamp, IValue.Value_type newType) {
        this.lastTimeChecked = timestamp;
        switch (newType) {
            case ENUMERATED_VALUE: {
                this.realValue = new Enumerated_Value(this);
                this.realValue.copyGeneralProperties(this);
                break;
            }
            case REFERENCED_VALUE: {
                this.realValue = new Referenced_Value(this);
                this.realValue.copyGeneralProperties(this);
                break;
            }
            case NAMED_INTEGER_VALUE: {
                this.realValue = new Named_Integer_Value(this);
                this.realValue.copyGeneralProperties(this);
                break;
            }
            default: {
                this.realValue = super.setValuetype(timestamp, newType);
            }
        }
        return this.realValue;
    }

    @Override
    public IValue setLoweridToReference(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.realValue;
        }
        this.lastTimeChecked = timestamp;
        this.realValue = this.setValuetype(timestamp, IValue.Value_type.REFERENCED_VALUE);
        return this.realValue;
    }

    @Override
    public boolean evaluateIsvalue(boolean fromSequence) {
        if (this.realValue == null) {
            return false;
        }
        return this.realValue.evaluateIsvalue(fromSequence);
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        reparser.updateLocation(this.identifier.getLocation());
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.realValue != null) {
            this.realValue.findReferences(referenceFinder, foundIdentifiers);
        } else if (this.asReference != null) {
            this.asReference.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return !(this.realValue != null ? !this.realValue.accept(v) : this.asReference != null && !this.asReference.accept(v));
    }
}

