/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.core;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.path.TITANPathUtilities;
import org.eclipse.titan.designer.core.ReferencedProjectResourceVisitor;
import org.eclipse.titan.designer.core.TITANBuilderResourceVisitor;

public final class ProjectBasedBuilder {
    static final String EMPTY_STRING = "";
    static final String BUILD_FAILED = "Build failed for project ";
    static final String INVALID_WORKINGDIRECTORY1 = "Invalid working directory";
    static final String INVALID_WORKINGDIRECTORY2 = "The working directory and the project's directory must not be the same";
    private static final Map<IProject, ProjectBasedBuilder> BUILDERS = new HashMap<IProject, ProjectBasedBuilder>();
    private static final Map<IProject, Boolean> FORCED_BUILD_SET = new HashMap<IProject, Boolean>();
    private static final Map<IProject, Boolean> FORCED_MAKEFILE_REBUILD_SET = new HashMap<IProject, Boolean>();
    private final IProject project;

    public ProjectBasedBuilder(IProject project) {
        this.project = project;
    }

    public static ProjectBasedBuilder getProjectBasedBuilder(IProject project) {
        ProjectBasedBuilder builder;
        if (BUILDERS.containsKey(project)) {
            builder = BUILDERS.get(project);
        } else {
            builder = new ProjectBasedBuilder(project);
            BUILDERS.put(project, builder);
        }
        return builder;
    }

    public URI getWorkingDirectoryURI(boolean reportError) {
        String workingDirectory;
        if (!this.project.isAccessible()) {
            return null;
        }
        try {
            workingDirectory = this.project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "workingDir"));
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            workingDirectory = null;
        }
        if (workingDirectory == null || EMPTY_STRING.equals(workingDirectory)) {
            if (reportError) {
                ErrorReporter.parallelErrorDisplayInMessageDialog((String)(BUILD_FAILED + this.project.getName()), (String)INVALID_WORKINGDIRECTORY1);
            }
            return null;
        }
        return TITANPathUtilities.resolvePath((String)workingDirectory, (URI)this.project.getLocationURI());
    }

    public IPath getWorkingDirectoryPath(boolean reportError) {
        URI uri = this.getWorkingDirectoryURI(reportError);
        if (uri == null) {
            return null;
        }
        return URIUtil.toPath((URI)uri);
    }

    public IContainer[] getWorkingDirectoryResources(boolean reportError) {
        URI uri = this.getWorkingDirectoryURI(reportError);
        if (uri == null) {
            return new IContainer[0];
        }
        IWorkspaceRoot wroot = ResourcesPlugin.getWorkspace().getRoot();
        return wroot.findContainersForLocationURI(uri);
    }

    public IProject[] getReferencedProjects() {
        if (this.project == null) {
            return new IProject[0];
        }
        try {
            if (this.project.isAccessible()) {
                return this.project.getReferencedProjects();
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        return new IProject[0];
    }

    public List<IProject> getAllReachableProjects() {
        ArrayList<IProject> referenceChain = new ArrayList<IProject>();
        ArrayList<IProject> knownProjects = new ArrayList<IProject>();
        this.getAllReachableProjects(referenceChain, this.project, knownProjects);
        return knownProjects;
    }

    private void getAllReachableProjects(List<IProject> referenceChain, IProject actualProject, List<IProject> knownProjects) {
        if (knownProjects.contains(actualProject)) {
            return;
        }
        if (referenceChain.contains(actualProject)) {
            knownProjects.add(actualProject);
            return;
        }
        IProject[] referencedProjects = ProjectBasedBuilder.getProjectBasedBuilder(actualProject).getReferencedProjects();
        if (referencedProjects.length == 0) {
            knownProjects.add(actualProject);
        }
        int size = referenceChain.size();
        referenceChain.add(actualProject);
        for (IProject temporalProject : referencedProjects) {
            this.getAllReachableProjects(referenceChain, temporalProject, knownProjects);
        }
        referenceChain.remove(size);
        if (!knownProjects.contains(actualProject)) {
            knownProjects.add(actualProject);
        }
    }

    public List<IProject> getAllReferencingProjects() {
        ArrayList<IProject> referenceChain = new ArrayList<IProject>();
        ArrayList<IProject> knownProjects = new ArrayList<IProject>();
        this.getAllReferencingProjects(referenceChain, this.project, knownProjects);
        return knownProjects;
    }

    private void getAllReferencingProjects(List<IProject> referenceChain, IProject actualProject, List<IProject> knownProjects) {
        if (knownProjects.contains(actualProject)) {
            return;
        }
        if (referenceChain.contains(actualProject)) {
            knownProjects.add(actualProject);
            return;
        }
        IProject[] referencingProjects = ProjectBasedBuilder.getProjectBasedBuilder(actualProject).getReferencingProjects();
        if (referencingProjects.length == 0) {
            knownProjects.add(actualProject);
        }
        int size = referenceChain.size();
        referenceChain.add(actualProject);
        for (IProject temporalProject : referencingProjects) {
            this.getAllReferencingProjects(referenceChain, temporalProject, knownProjects);
        }
        referenceChain.remove(size);
        if (!knownProjects.contains(actualProject)) {
            knownProjects.add(actualProject);
        }
    }

    public IProject[] getReferencingProjects() {
        return this.project.getReferencingProjects();
    }

    public static void setForcedBuild(IProject project) {
        FORCED_BUILD_SET.put(project, Boolean.TRUE);
    }

    public static Boolean getForcedBuild(IProject project) {
        if (FORCED_BUILD_SET.containsKey(project)) {
            return FORCED_BUILD_SET.get(project);
        }
        return Boolean.FALSE;
    }

    public static void clearForcedBuild(IProject project) {
        FORCED_BUILD_SET.remove(project);
    }

    public static void setForcedMakefileRebuild(IProject project) {
        FORCED_MAKEFILE_REBUILD_SET.put(project, Boolean.TRUE);
    }

    public static Boolean getForcedMakefileRebuild(IProject project) {
        if (FORCED_MAKEFILE_REBUILD_SET.containsKey(project)) {
            return FORCED_MAKEFILE_REBUILD_SET.get(project);
        }
        return Boolean.FALSE;
    }

    public static void clearForcedMakefileRebuild(IProject project) {
        FORCED_MAKEFILE_REBUILD_SET.remove(project);
    }

    public TITANBuilderResourceVisitor getResourceVisitor() {
        TITANBuilderResourceVisitor visitor = new TITANBuilderResourceVisitor(this.getWorkingDirectoryResources(false));
        try {
            if (this.project.isAccessible()) {
                this.project.accept((IResourceVisitor)visitor);
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        return visitor;
    }

    public Map<String, IFile> getFilesofReferencedProjects() {
        HashSet<IProject> projectSet = new HashSet<IProject>();
        projectSet.add(this.project);
        return this.getFilesofReferencedProjects(projectSet);
    }

    private Map<String, IFile> getFilesofReferencedProjects(Set<IProject> visitedProjects) {
        IProject[] projects = this.getReferencedProjects();
        HashMap<String, IFile> files = new HashMap<String, IFile>();
        for (IProject tempProject : projects) {
            try {
                if (tempProject.isAccessible() && !visitedProjects.contains(tempProject)) {
                    IContainer[] workingDirectories = ProjectBasedBuilder.getProjectBasedBuilder(tempProject).getWorkingDirectoryResources(false);
                    IPath workingDir = ProjectBasedBuilder.getProjectBasedBuilder(tempProject).getWorkingDirectoryPath(false);
                    ReferencedProjectResourceVisitor visitor = new ReferencedProjectResourceVisitor(workingDirectories, workingDir);
                    visitedProjects.add(tempProject);
                    Map<String, IFile> tempFiles = ProjectBasedBuilder.getProjectBasedBuilder(tempProject).getFilesofReferencedProjects(visitedProjects);
                    files.putAll(tempFiles);
                    tempProject.accept((IResourceVisitor)visitor);
                    files.putAll(visitor.getFiles());
                }
                visitedProjects.remove(tempProject);
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("While gathering the files of project " + tempProject.getName()), (Throwable)e);
            }
        }
        return files;
    }
}

