/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.decorators;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class OverlayImageIcon
extends CompositeImageDescriptor {
    private final Image baseImage;
    private final Point sizeOfImage;
    private final Image decorator;
    private final Position position;

    public OverlayImageIcon(Image baseImage, Image decorator, Position position) {
        this.baseImage = baseImage;
        this.decorator = decorator;
        this.position = position;
        this.sizeOfImage = new Point(baseImage.getBounds().width, baseImage.getBounds().height);
    }

    protected void drawCompositeImage(int width, int height) {
        this.drawImage(this.baseImage.getImageData(), 0, 0);
        ImageData imageData = this.decorator.getImageData();
        switch (this.position) {
            case TOP_LEFT: {
                this.drawImage(imageData, 0, 0);
                break;
            }
            case TOP_RIGHT: {
                this.drawImage(imageData, this.sizeOfImage.x - imageData.width, 0);
                break;
            }
            case BOTTOM_LEFT: {
                this.drawImage(imageData, 0, this.sizeOfImage.y - imageData.height);
                break;
            }
            case BOTTOM_RIGHT: {
                this.drawImage(imageData, this.sizeOfImage.x - imageData.width, this.sizeOfImage.y - imageData.height);
                break;
            }
        }
    }

    protected Point getSize() {
        return this.sizeOfImage;
    }

    public Image getImage() {
        return this.createImage();
    }

    public static enum Position {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_RIGHT,
        BOTTOM_LEFT;

    }
}

