/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public final class AnnotationHover
implements IAnnotationHover {
    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        List<IMarker> markers = this.getMarkerForLine(sourceViewer, lineNumber);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < markers.size(); ++i) {
            String message = markers.get(i).getAttribute("message", (String)null);
            if (message == null || (message = message.trim()).length() <= 0) continue;
            message = message.replaceAll("\\<([A-Z]+)\\>", "$1");
            if (i != 0) {
                builder.append("<BR></BR>");
            }
            builder.append(message);
        }
        return builder.toString();
    }

    protected List<IMarker> getMarkerForLine(ISourceViewer sourceViewer, int lineNumber) {
        ArrayList<IMarker> markers = new ArrayList<IMarker>();
        IAnnotationModel annotationModel = sourceViewer.getAnnotationModel();
        if (annotationModel == null) {
            return markers;
        }
        Iterator iterator = annotationModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (!(o instanceof MarkerAnnotation)) continue;
            MarkerAnnotation actuaMarkerl = (MarkerAnnotation)o;
            try {
                int actualLine = sourceViewer.getDocument().getLineOfOffset(annotationModel.getPosition((Annotation)actuaMarkerl).getOffset());
                if (actualLine != lineNumber) continue;
                markers.add(actuaMarkerl.getMarker());
            }
            catch (BadLocationException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            }
        }
        return markers;
    }
}

