/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.titan.designer.AST.ASTLocationChainVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.declarationsearch.Declaration;
import org.eclipse.titan.designer.declarationsearch.IdentifierFinderVisitor;
import org.eclipse.titan.designer.editors.IReferenceParser;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titan.designer.preferences.SubscribedBoolean;
import org.eclipse.titan.designer.preferences.SubscribedInt;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class OccurencesMarker {
    private static final String ANNOTATION_TYPE = "org.eclipse.titan.occurrences";
    private static SubscribedBoolean reportDebugInformation;
    private static SubscribedBoolean printASTElem;
    private static SubscribedBoolean enabled;
    private static SubscribedInt delay;
    private static SubscribedBoolean keepMarks;
    private final ITextEditor editor;
    private Annotation[] occurrenceAnnotations = null;
    private MarkerJob markerJob = new MarkerJob();
    private IPropertyChangeListener listener = null;

    public OccurencesMarker(ITextEditor editor) {
        this.editor = editor;
        this.listener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if ("org.eclipse.titan.designer.markOccurrencesEnabled".equals(property) || "org.eclipse.titan.designer.markOccurrencesAsn1Assignments".equals(property) || "org.eclipse.titan.designer.markOccurrencesTtcn3Assignments".equals(property) || "org.eclipse.titan.designer.markOccurrencesKeepMarks".equals(property)) {
                    OccurencesMarker.this.removeOccurences(true);
                    return;
                }
            }
        };
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.listener);
    }

    public void dispose() {
        if (this.listener != null) {
            Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.listener);
        }
    }

    private void error(IDocument document, int offset, String reason) {
        if (!((Boolean)reportDebugInformation.getValue()).booleanValue()) {
            return;
        }
        String fileName = this.editor.getEditorInput() == null ? "unknown" : this.editor.getEditorInput().getName();
        try {
            int line = document.getLineOfOffset(offset);
            int offsetInLine = offset - document.getLineOffset(line);
            TITANDebugConsole.println("Mark occurrences failed: " + reason + "\nFile: " + fileName + "\nLine: " + line + "\nOffset: " + offsetInLine);
        }
        catch (BadLocationException e) {
            TITANDebugConsole.println("Mark occurrences failed: invalid offset\nFile: " + fileName + "\nOffset: " + offset);
        }
    }

    public void markOccurences(IDocument document, int offset) {
        this.markerJob.cancel();
        if (!((Boolean)enabled.getValue()).booleanValue()) {
            return;
        }
        this.markerJob.setParam(document, offset);
        this.markerJob.schedule(((Integer)delay.getValue()).intValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMark(IDocument document, int offset) {
        Reference reference;
        IAnnotationModel annotationModel = this.getAnnotationModel();
        if (annotationModel == null) {
            this.removeOccurences(false);
            this.error(document, offset, "AnnotationModel is null");
            return;
        }
        IFile file = (IFile)this.editor.getEditorInput().getAdapter(IFile.class);
        if (file == null) {
            this.removeOccurences(false);
            this.error(document, offset, "can not determine the file in the editor.");
            return;
        }
        ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser(file.getProject());
        if (projectSourceParser == null) {
            this.removeOccurences(false);
            this.error(document, offset, "Can not find the projectsourceparser for the project: " + file.getProject());
            return;
        }
        Module module = projectSourceParser.containedModule(file);
        if (module == null) {
            this.removeOccurences(false);
            this.error(document, offset, "The module can not be found in the project.");
            return;
        }
        if (((Boolean)printASTElem.getValue()).booleanValue()) {
            ASTLocationChainVisitor locVisitor = new ASTLocationChainVisitor(offset);
            module.accept(locVisitor);
            locVisitor.printChain();
        }
        if ((reference = this.getReferenceParser().findReferenceForOpening(file, offset, document)) == null) {
            this.removeOccurences(false);
            return;
        }
        Location referenceLocaton = reference.getLocation();
        if (referenceLocaton.getOffset() == referenceLocaton.getEndOffset()) {
            this.removeOccurences(false);
            return;
        }
        List<ReferenceFinder.Hit> result = this.findOccurrences(document, reference, module, offset);
        if (result.isEmpty()) {
            return;
        }
        HashMap<Annotation, Position> annotationMap = new HashMap<Annotation, Position>();
        for (ReferenceFinder.Hit hit : result) {
            if (hit.identifier == null) continue;
            int n = hit.identifier.getLocation().getOffset();
            int hitEndOffset = hit.identifier.getLocation().getEndOffset();
            if (n < 0 || hitEndOffset < 0 || hitEndOffset < n) continue;
            Annotation annotationToAdd = new Annotation(ANNOTATION_TYPE, false, hit.identifier.getDisplayName());
            Position position = new Position(n, hitEndOffset - n);
            annotationMap.put(annotationToAdd, position);
        }
        Object object = this.getLockObject(annotationModel);
        synchronized (object) {
            if (annotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)annotationModel).replaceAnnotations(this.occurrenceAnnotations, annotationMap);
            } else {
                if (this.occurrenceAnnotations != null) {
                    for (Annotation annotationToRemove : this.occurrenceAnnotations) {
                        annotationModel.removeAnnotation(annotationToRemove);
                    }
                }
                for (Map.Entry entry : annotationMap.entrySet()) {
                    annotationModel.addAnnotation((Annotation)entry.getKey(), (Position)entry.getValue());
                }
            }
            this.occurrenceAnnotations = annotationMap.keySet().toArray(new Annotation[annotationMap.keySet().size()]);
        }
    }

    protected abstract List<ReferenceFinder.Hit> findOccurrences(IDocument var1, Reference var2, Module var3, int var4);

    protected List<ReferenceFinder.Hit> findOccurrencesLocationBased(Module module, int offset) {
        IdentifierFinderVisitor visitor = new IdentifierFinderVisitor(offset);
        module.accept(visitor);
        Declaration def = visitor.getReferencedDeclaration();
        if (def == null || !def.shouldMarkOccurrences()) {
            this.removeOccurences(false);
            return new ArrayList<ReferenceFinder.Hit>();
        }
        return def.getReferences(module);
    }

    protected List<ReferenceFinder.Hit> findOccurrencesReferenceBased(IDocument document, Reference reference, Module module, int offset) {
        ReferenceFinder referenceFinder;
        Assignment assignment;
        Scope scope = module.getSmallestEnclosingScope(offset);
        if (scope == null) {
            this.removeOccurences(false);
            this.error(document, offset, "Can not determine the smallest enclosing scope.");
            return new ArrayList<ReferenceFinder.Hit>();
        }
        reference.setMyScope(scope);
        if (reference.getId() == null) {
            this.removeOccurences(false);
            this.error(document, offset, "The identifier of the reference is null.");
            return new ArrayList<ReferenceFinder.Hit>();
        }
        if (reference.getSubreferences().size() > 1) {
            this.removeOccurences(false);
            return new ArrayList<ReferenceFinder.Hit>();
        }
        List<ReferenceFinder.Hit> result = null;
        boolean found = false;
        if (scope.hasAssignmentWithId(CompilationTimeStamp.getBaseTimestamp(), reference.getId()) || scope.getModuleScope().hasImportedAssignmentWithID(CompilationTimeStamp.getBaseTimestamp(), reference.getId())) {
            assignment = reference.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false);
            if (assignment == null) {
                this.error(document, offset, "The assignment could not be determined from the reference: " + reference.getDisplayName());
                this.removeOccurences(false);
                return new ArrayList<ReferenceFinder.Hit>();
            }
            if (!assignment.shouldMarkOccurrences()) {
                this.removeOccurences(false);
                return new ArrayList<ReferenceFinder.Hit>();
            }
            try {
                referenceFinder = new ReferenceFinder(assignment);
            }
            catch (IllegalArgumentException e) {
                this.removeOccurences(false);
                return new ArrayList<ReferenceFinder.Hit>();
            }
            result = referenceFinder.findReferencesInModule(module);
            if (assignment.getLocation().containsOffset(offset)) {
                found = true;
            } else {
                for (ReferenceFinder.Hit hit : result) {
                    if (!hit.identifier.getLocation().containsOffset(offset)) continue;
                    found = true;
                    break;
                }
            }
            if (found && assignment.getMyScope().getModuleScope() == module && assignment.getIdentifier() != null) {
                result.add(new ReferenceFinder.Hit(assignment.getIdentifier()));
            }
        }
        if (!found) {
            referenceFinder = new ReferenceFinder();
            referenceFinder.detectAssignmentDataByOffset(module, offset, (IEditorPart)this.editor, false, false);
            assignment = referenceFinder.assignment;
            if (assignment == null) {
                this.removeOccurences(false);
                this.error(document, offset, "Could not detect the assignment.");
                return new ArrayList<ReferenceFinder.Hit>();
            }
            if (assignment.getAssignmentType() != null && assignment.getAssignmentType() != Assignment.Assignment_type.A_TYPE || referenceFinder.fieldId == null || !assignment.shouldMarkOccurrences()) {
                this.removeOccurences(false);
                return new ArrayList<ReferenceFinder.Hit>();
            }
            result = referenceFinder.findReferencesInModule(module);
            if (referenceFinder.fieldId != null) {
                result.add(new ReferenceFinder.Hit(referenceFinder.fieldId));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOccurences(boolean force) {
        if (!force && ((Boolean)keepMarks.getValue()).booleanValue()) {
            return;
        }
        this.markerJob.cancel();
        IAnnotationModel annotationModel = this.getAnnotationModel();
        if (annotationModel == null) {
            return;
        }
        Object object = this.getLockObject(annotationModel);
        synchronized (object) {
            if (this.occurrenceAnnotations == null) {
                return;
            }
            for (Annotation annotaion : this.occurrenceAnnotations) {
                annotationModel.removeAnnotation(annotaion);
            }
            this.occurrenceAnnotations = null;
        }
    }

    private IAnnotationModel getAnnotationModel() {
        IEditorInput editorInput = this.editor.getEditorInput();
        if (editorInput == null) {
            if (((Boolean)reportDebugInformation.getValue()).booleanValue()) {
                TITANDebugConsole.println("Mark occurrences failed: Can not find the file associated with the editor.");
            }
            return null;
        }
        IDocumentProvider documentProvider = this.editor.getDocumentProvider();
        if (documentProvider == null) {
            if (((Boolean)reportDebugInformation.getValue()).booleanValue()) {
                TITANDebugConsole.println("Mark occurrences failed: The editor is closed.");
            }
            return null;
        }
        return documentProvider.getAnnotationModel((Object)editorInput);
    }

    private Object getLockObject(IAnnotationModel annotationModel) {
        Object lock;
        if (annotationModel instanceof ISynchronizable && (lock = ((ISynchronizable)annotationModel).getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    protected abstract IReferenceParser getReferenceParser();

    static {
        enabled = new SubscribedBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.markOccurrencesEnabled", false);
        delay = new SubscribedInt("org.eclipse.titan.designer", "org.eclipse.titan.designer.markOccurrencesDelay", 100);
        keepMarks = new SubscribedBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.markOccurrencesKeepMarks", false);
        reportDebugInformation = new SubscribedBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", false);
        printASTElem = new SubscribedBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.debug.console.astelem", false);
    }

    private class MarkerJob
    extends WorkspaceJob {
        private IDocument document;
        private int offset;

        public MarkerJob() {
            super("Marking occurrences");
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setParam(IDocument document, int offset) {
            IAnnotationModel annotationModel = OccurencesMarker.this.getAnnotationModel();
            if (annotationModel == null) {
                OccurencesMarker.this.removeOccurences(false);
                OccurencesMarker.this.error(document, offset, "AnnotationModel is null");
                return;
            }
            Object object = OccurencesMarker.this.getLockObject(annotationModel);
            synchronized (object) {
                this.document = document;
                this.offset = offset;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInWorkspace(IProgressMonitor pMonitor) throws CoreException {
            IAnnotationModel annotationModel = OccurencesMarker.this.getAnnotationModel();
            if (annotationModel == null) {
                OccurencesMarker.this.removeOccurences(false);
                OccurencesMarker.this.error(this.document, this.offset, "AnnotationModel is null");
                return Status.CANCEL_STATUS;
            }
            Object object = OccurencesMarker.this.getLockObject(annotationModel);
            synchronized (object) {
                OccurencesMarker.this.doMark(this.document, this.offset);
            }
            return Status.OK_STATUS;
        }
    }
}

