/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.NamedBridgeScope;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ControlPart;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Altstep;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Const;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_ModulePar;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Port;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Testcase;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Sequence_Type;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.editors.EditorTracker;
import org.eclipse.titan.designer.editors.IReferenceParser;
import org.eclipse.titan.designer.editors.ISemanticTITANEditor;
import org.eclipse.titan.designer.editors.actions.DeclarationCollectionHelper;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.ui.IEditorPart;

public final class T3Doc {
    private static final String LINE_BREAK = "<br></br>";
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String[][] PARAGRAPHS = new String[][]{{"@author", "Author:"}, {"@config", "Configuration:"}, {"@desc", "Description:"}, {"@exception", "Exception:"}, {"@purpose", "Purpose:"}, {"@remark", "Remark:"}, {"@return", "Return:"}, {"@see", "See:"}, {"@since", "Since:"}, {"@status", "Status:"}, {"@remark", "Remark:"}, {"@url", "Url:"}, {"@verdict", "Verdict:"}, {"@version", "Version:"}, {"@priority", "Priority:"}, {"@requirement", "Requirement:"}, {"@reference", "Reference:"}};
    private static final String[] TEST_CASE = new String[]{"@exception", "@member", "@return"};
    private static final String[] PORT = new String[]{"@config", "@exception", "@param", "@priority", "@purpose", "@requirement", "@return", "@verdict"};
    private static final String[] CONSTANT = new String[]{"@config", "@exception", "@member", "@param", "@priority", "@purpose", "@requirement", "@return", "@verdict"};
    private static final String[] CONSTANT_MEMBER_CAPABLE = new String[]{"@config", "@exception", "@param", "@priority", "@purpose", "@requirement", "@return", "@verdict"};
    private static final String[] TEMPLATE = new String[]{"@config", "@exception", "@priority", "@purpose", "@requirement", "@return", "@verdict"};
    private static final String[] ALTSTEP = new String[]{"@config", "@exception", "@member", "@priority", "@purpose", "@return"};
    private static final String[] FUNCTION = new String[]{"@config", "@exception", "@member", "@priority", "@purpose"};
    private static final String[] TYPE_SIGNATURE = new String[]{"@config", "@member", "@priority", "@purpose", "@requirement", "@verdict"};
    private static final String[] MODULE = new String[]{"@config", "@exception", "@member", "@param", "@priority", "@return"};
    private static final String[] GROUP = new String[]{"@config", "@exception", "@member", "@param", "@priority", "@purpose", "@requirement", "@return", "@verdict"};
    private static final String[] TTCN3_SEQUENCE = new String[]{"@config", "@exception", "@param", "@priority", "@purpose", "@requirement", "@return", "@verdict"};
    private static final String[] TTCN3_SEQUENCE_OF = new String[]{"@config", "@exception", "@member", "@param", "@priority", "@purpose", "@requirement", "@return", "@verdict"};
    private static final String[] TTCN3_MEMBER_CAPABLE = new String[]{IType.Type_type.TYPE_TTCN3_CHOICE.toString(), IType.Type_type.TYPE_TTCN3_ENUMERATED.toString(), IType.Type_type.TYPE_TTCN3_SET.toString(), IType.Type_type.TYPE_TTCN3_SEQUENCE.toString(), IType.Type_type.TYPE_REFERENCED.toString()};
    private static boolean documentationEnabled;
    private static Location location;
    private Map<String, String> params;
    private List<String> paramsArraylist;
    private Map<String, String> members;
    private String signature;
    private List<String> author;
    private List<String> config;
    private List<String> desc;
    private List<String> exception;
    private List<String> purpose;
    private List<String> remark;
    private List<String> creturn;
    private List<String> see;
    private List<String> since;
    private List<String> status;
    private List<String> url;
    private List<String> verdict;
    private List<String> version;
    private List<String> priority;
    private List<String> requirement;
    private List<String> reference;

    public T3Doc(String desc) {
        this.desc = new ArrayList<String>();
        this.desc.add(desc);
    }

    public T3Doc(Location commentLocation) {
        this.t3DocFillContentFromCommentLocation(commentLocation);
        List<String> membersArraylist = T3Doc.getCommentStrings(commentLocation, "@member");
        if (!membersArraylist.isEmpty()) {
            this.members = new HashMap<String, String>();
        }
        for (String stringItem : membersArraylist) {
            String value;
            String key;
            String stringItemTrim = stringItem.trim();
            String strWithoutMember = stringItemTrim.substring("@member".length()).trim();
            int cnt = strWithoutMember.indexOf(" ");
            if (cnt == -1) {
                key = strWithoutMember;
                value = "";
            } else {
                key = strWithoutMember.substring(0, strWithoutMember.indexOf(" "));
                value = strWithoutMember.substring(key.length());
            }
            this.members.put(key, value);
        }
        List<String> paramsArraylistTemp = T3Doc.getCommentStrings(commentLocation, "@param");
        if (!paramsArraylistTemp.isEmpty()) {
            this.params = new HashMap<String, String>();
            this.paramsArraylist = new ArrayList<String>();
        }
        for (String stringItem : paramsArraylistTemp) {
            String value;
            String key;
            String stringItemTrim = stringItem.trim();
            String strWithoutParam = stringItemTrim.substring("@param".length()).trim();
            int cnt = strWithoutParam.indexOf(" ");
            if (cnt == -1) {
                key = strWithoutParam;
                value = "";
            } else {
                key = strWithoutParam.substring(0, strWithoutParam.indexOf(" "));
                value = strWithoutParam.substring(key.length());
            }
            this.paramsArraylist.add(key.toString() + value.toString());
            this.params.put(key, value);
        }
    }

    public T3Doc(Location commentLocation, String str) {
        String value;
        String key;
        int cnt;
        this.t3DocFillContentFromCommentLocation(commentLocation);
        List<String> membersArraylist = T3Doc.getCommentStrings(commentLocation, "@member");
        if (!membersArraylist.isEmpty()) {
            this.members = new HashMap<String, String>();
        }
        for (String stringItem : membersArraylist) {
            String strWithoutMember = stringItem.substring("@member".length()).trim();
            if (strWithoutMember.indexOf(str) == -1) continue;
            cnt = strWithoutMember.indexOf(" ");
            if (cnt == -1) {
                key = strWithoutMember;
                value = "";
            } else {
                key = str;
                value = strWithoutMember;
            }
            this.members.put(key, value);
        }
        this.paramsArraylist = T3Doc.getCommentStrings(commentLocation, "@param");
        if (!this.paramsArraylist.isEmpty()) {
            this.params = new HashMap<String, String>();
        }
        for (String stringItem : this.paramsArraylist) {
            String strWithoutParam = stringItem.substring("@param".length()).trim();
            cnt = strWithoutParam.indexOf(" ");
            if (cnt == -1) {
                key = strWithoutParam;
                value = "";
            } else {
                key = str;
                value = strWithoutParam;
            }
            this.params.put(key, value);
        }
    }

    public static boolean isT3DocEnable() {
        return documentationEnabled;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public Map<String, String> getMembers() {
        return this.members;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    private static String replace(String str) {
        String localStr = str.replaceAll("\\/\\/\\*", "");
        if (str.indexOf("@") == -1) {
            return str;
        }
        for (String[] item : PARAGRAPHS) {
            localStr = localStr.replaceAll(item[0], item[1]);
        }
        return localStr;
    }

    public static void check(Location commentLocation, String type) {
        if (!documentationEnabled) {
            return;
        }
        T3Doc.check(commentLocation, type, null);
    }

    public static void check(Location commentLocation, String type, IType.Type_type typeType) {
        if (!documentationEnabled) {
            return;
        }
        if (commentLocation != null) {
            IFile file = (IFile)commentLocation.getFile();
            try {
                String str;
                Object temp;
                if (Def_Testcase.getKind().equals(type)) {
                    temp = TEST_CASE;
                } else if (Def_Port.getKind().equals(type) || Def_ModulePar.getKind().equals(type) || Def_Const.getKind().equals(type)) {
                    boolean memberCapable = false;
                    if (typeType != null) {
                        for (String string : TTCN3_MEMBER_CAPABLE) {
                            if (!typeType.toString().equals(string)) continue;
                            memberCapable = true;
                        }
                    } else {
                        memberCapable = true;
                    }
                    temp = memberCapable ? CONSTANT_MEMBER_CAPABLE : CONSTANT;
                } else {
                    temp = Def_Template.getKind().equals(type) ? TEMPLATE : (Def_Altstep.getKind().equals(type) ? ALTSTEP : (Def_Function.getKind().equals(type) ? FUNCTION : ("TYPE_SIGNATURE".equals(type) ? TYPE_SIGNATURE : ("module".equals(type) ? MODULE : ("group".equals(type) || ControlPart.getKind().equals(type) ? GROUP : ("TYPE_TTCN3_SEQUENCE".equals(type) || "TYPE_TTCN3_CHOICE".equals(type) || "TYPE_TTCN3_SET".equals(type) ? TTCN3_SEQUENCE : ("TYPE_SEQUENCE_OF".equals(type) ? TTCN3_SEQUENCE_OF : ("TYPE_TTCN3_ENUMERATED".equals(type) ? TTCN3_SEQUENCE : ("TYPE_PORT".equals(type) || "TYPE_COMPONENT".equals(type) ? PORT : null)))))))));
                }
                File realFile = file.getLocation().toFile();
                BufferedReader in = new BufferedReader(new FileReader(realFile));
                in.skip(commentLocation.getOffset());
                int lineCnt = 0;
                int offset = commentLocation.getOffset();
                while ((str = in.readLine()) != null && str.indexOf("//") != -1) {
                    int loc = -1;
                    if (temp != null) {
                        for (String item : temp) {
                            loc = str.indexOf(item);
                            if (loc == -1) continue;
                            location = new Location(commentLocation.getFile(), commentLocation.getLine() + lineCnt, offset + lineCnt, offset + str.length() + lineCnt);
                            location.reportSemanticWarning(MessageFormat.format("Comment `{0}'' cannot be used with this type!", item));
                        }
                    }
                    offset += str.length();
                    ++lineCnt;
                }
                in.close();
            }
            catch (Exception e) {
                ErrorReporter.logExceptionStackTrace((String)"Comment is not reachable", (Throwable)e);
            }
        }
    }

    public static String getCommentStrings(List<String> arraylistIn) {
        StringBuilder strb = new StringBuilder();
        int i = 0;
        for (String str : arraylistIn) {
            if (str.indexOf("//*") == -1) break;
            int loc = str.indexOf("//*");
            if (-1 != loc) {
                if (i > 0) {
                    strb.append("<BR></BR>");
                }
                strb.append(str.substring("//*".length()));
            }
            ++i;
        }
        return strb.toString();
    }

    private static List<String> getAllCommentStrings(Location commentLocation) {
        ArrayList<String> arraylist = new ArrayList<String>();
        if (commentLocation != null) {
            IFile file = (IFile)commentLocation.getFile();
            List<String> arraylistMemory = T3Doc.getArrayListFromEditorTracker(file, commentLocation);
            if (arraylistMemory != null) {
                return arraylistMemory;
            }
            try {
                String str;
                File realFile = file.getLocation().toFile();
                BufferedReader in = new BufferedReader(new FileReader(realFile));
                in.skip(commentLocation.getOffset());
                while ((str = in.readLine()) != null && str.indexOf("//") != -1) {
                    String strTrim = str.trim();
                    arraylist.add(strTrim);
                }
                in.close();
            }
            catch (Exception e) {
                ErrorReporter.logExceptionStackTrace((String)"Comment is not reachable", (Throwable)e);
            }
        }
        return arraylist;
    }

    public static List<String> getCommentStrings(List<String> arraylistIn, String toSearch) {
        ArrayList<String> arraylist = new ArrayList<String>();
        String member = null;
        boolean memberFound = false;
        for (String str : arraylistIn) {
            if (str.indexOf("//*") == -1) continue;
            String strOld = str;
            int loc = str.indexOf(toSearch);
            int loc2 = str.indexOf("@");
            if (loc2 != -1) {
                memberFound = false;
                if (member != null) {
                    arraylist.add(T3Doc.replace(member));
                    member = null;
                }
            }
            if (-1 == loc && !memberFound) continue;
            if (member == null) {
                member = strOld.substring(loc > 0 ? loc : "//*".length());
            } else if (!strOld.matches("//\\**//$")) {
                member = member + strOld.substring("//*".length());
            }
            memberFound = true;
            if (-1 != loc) continue;
            arraylist.add(T3Doc.replace(member));
            member = null;
        }
        if (member != null) {
            arraylist.add(T3Doc.replace(member));
        }
        return arraylist;
    }

    public static List<String> getCommentStrings(Location commentLocation, String toSearch) {
        if (commentLocation == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> arraylist = new ArrayList<String>();
        IFile file = (IFile)commentLocation.getFile();
        List<String> arraylistMemory = T3Doc.getArrayListFromEditorTracker(file, commentLocation);
        String toSearchExact = " " + toSearch;
        if (arraylistMemory != null) {
            String member = null;
            boolean memberFound = false;
            for (String str : arraylistMemory) {
                if (str.indexOf("//") == -1) break;
                String strOld = str;
                int loc = str.indexOf(toSearchExact);
                int loc2 = str.indexOf("@");
                if (loc2 != -1) {
                    memberFound = false;
                    if (member != null) {
                        arraylist.add(T3Doc.replace(member));
                        member = null;
                    }
                }
                if (-1 == loc && !memberFound) continue;
                int length = 0;
                length = strOld.indexOf("//*") > 0 ? "//*".length() : "//".length();
                member = member == null ? strOld.substring(loc > 0 ? loc : length) : member + strOld.substring(length);
                memberFound = true;
                if (-1 != loc) continue;
                arraylist.add(T3Doc.replace(member));
                member = null;
            }
            if (member != null) {
                arraylist.add(T3Doc.replace(member));
            }
            return arraylist;
        }
        try {
            String str;
            File realFile = file.getLocation().toFile();
            BufferedReader in = new BufferedReader(new FileReader(realFile));
            in.skip(commentLocation.getOffset());
            String member = null;
            boolean memberFound = false;
            while ((str = in.readLine()) != null && str.indexOf("//") != -1) {
                String strOld = str;
                int loc = str.indexOf(toSearch);
                int loc2 = str.indexOf("@");
                if (loc2 != -1) {
                    memberFound = false;
                    if (member != null) {
                        arraylist.add(T3Doc.replace(member));
                        member = null;
                    }
                }
                if (-1 == loc && !memberFound) continue;
                member = member == null ? strOld.substring(loc > 0 ? loc : "//*".length()) : member + strOld.substring("//*".length());
                memberFound = true;
                if (-1 != loc) continue;
                arraylist.add(T3Doc.replace(member));
                member = null;
            }
            if (member != null) {
                arraylist.add(T3Doc.replace(member));
            }
            in.close();
        }
        catch (Exception e) {
            ErrorReporter.logExceptionStackTrace((String)"Comment is not reachable", (Throwable)e);
        }
        return arraylist;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        if (this.signature != null) {
            str.append(this.signature);
        }
        if (this.author != null && !this.author.isEmpty()) {
            for (String item : this.author) {
                str.append(item);
                str.append(LINE_BREAK);
            }
        }
        if (this.config != null && !this.config.isEmpty()) {
            for (String item : this.config) {
                str.append(item);
            }
            str.append(LINE_BREAK);
        }
        if (this.desc != null && !this.desc.isEmpty()) {
            for (String item : this.desc) {
                str.append(item);
            }
            str.append(LINE_BREAK);
        }
        if (this.exception != null && !this.exception.isEmpty()) {
            for (String item : this.exception) {
                str.append(item);
            }
            str.append(LINE_BREAK);
        }
        if (this.members != null && !this.members.isEmpty()) {
            Set<Map.Entry<String, String>> set = this.members.entrySet();
            Iterator<Map.Entry<String, String>> i = set.iterator();
            if (this.members.size() > 1) {
                str.append("Members: <br></br>");
            }
            while (i.hasNext()) {
                Map.Entry<String, String> me = i.next();
                str.append(me.getKey() + " ");
                str.append(me.getValue());
                str.append(LINE_BREAK);
            }
        }
        if (this.paramsArraylist != null && !this.paramsArraylist.isEmpty()) {
            str.append("Params: <br></br>");
            for (int index = 0; index < this.paramsArraylist.size(); ++index) {
                str.append(this.paramsArraylist.get(index));
                str.append(LINE_BREAK);
            }
        }
        if (this.purpose != null && !this.purpose.isEmpty()) {
            for (String item : this.purpose) {
                str.append(item);
            }
            str.append(LINE_BREAK);
        }
        if (this.remark != null && !this.remark.isEmpty()) {
            for (String item : this.remark) {
                str.append(item);
            }
            str.append(LINE_BREAK);
        }
        if (this.creturn != null && !this.creturn.isEmpty()) {
            for (String item : this.creturn) {
                str.append(item);
            }
            str.append(LINE_BREAK);
        }
        if (this.see != null && !this.see.isEmpty()) {
            for (String item : this.see) {
                str.append(item);
            }
            str.append(LINE_BREAK);
        }
        if (this.since != null && !this.since.isEmpty()) {
            for (String item : this.since) {
                str.append(item);
            }
            str.append(LINE_BREAK);
        }
        if (this.status != null && !this.status.isEmpty()) {
            for (String item : this.status) {
                str.append(item);
            }
            str.append(LINE_BREAK);
        }
        if (this.url != null && !this.url.isEmpty()) {
            for (String item : this.url) {
                str.append(item);
            }
            str.append(LINE_BREAK);
        }
        if (this.verdict != null && !this.verdict.isEmpty()) {
            for (String item : this.verdict) {
                str.append(item);
            }
            str.append(LINE_BREAK);
        }
        if (this.version != null && !this.version.isEmpty()) {
            for (String item : this.version) {
                str.append(item);
            }
            str.append(LINE_BREAK);
        }
        if (this.priority != null && !this.priority.isEmpty()) {
            for (String item : this.priority) {
                str.append(item);
            }
            str.append(LINE_BREAK);
        }
        if (this.requirement != null && !this.requirement.isEmpty()) {
            for (String item : this.requirement) {
                str.append(item);
            }
            str.append(LINE_BREAK);
        }
        if (this.reference != null && !this.reference.isEmpty()) {
            for (String item : this.reference) {
                str.append(item);
            }
            str.append(LINE_BREAK);
        }
        return str.toString();
    }

    public void setDesciption(String desc) {
        this.desc = new ArrayList<String>();
        this.desc.add(desc);
    }

    void t3DocFillContentFromCommentLocation(Location commentLocation) {
        if (commentLocation != null) {
            List<String> commentstorage = T3Doc.getAllCommentStrings(commentLocation);
            this.author = T3Doc.getCommentStrings(commentstorage, "@author");
            this.config = T3Doc.getCommentStrings(commentstorage, "@config");
            this.desc = T3Doc.getCommentStrings(commentstorage, "@desc");
            this.exception = T3Doc.getCommentStrings(commentstorage, "@exception");
            this.purpose = T3Doc.getCommentStrings(commentstorage, "@purpose");
            this.remark = T3Doc.getCommentStrings(commentstorage, "@remark");
            this.creturn = T3Doc.getCommentStrings(commentstorage, "@return");
            this.see = T3Doc.getCommentStrings(commentstorage, "@see");
            this.since = T3Doc.getCommentStrings(commentstorage, "@since");
            this.status = T3Doc.getCommentStrings(commentstorage, "@status");
            this.url = T3Doc.getCommentStrings(commentstorage, "@url");
            this.verdict = T3Doc.getCommentStrings(commentstorage, "@verdic");
            this.version = T3Doc.getCommentStrings(commentstorage, "@version");
            this.priority = T3Doc.getCommentStrings(commentstorage, "@priority");
            this.requirement = T3Doc.getCommentStrings(commentstorage, "@requirement");
            this.reference = T3Doc.getCommentStrings(commentstorage, "@reference");
        }
    }

    private static List<String> getArrayListFromEditorTracker(IFile file, Location commentLocation) {
        String completeFile;
        if (file == null || commentLocation == null) {
            return null;
        }
        if (!EditorTracker.containsKey(file)) {
            return null;
        }
        List<ISemanticTITANEditor> editors = EditorTracker.getEditor(file);
        ISemanticTITANEditor editor = editors.get(0);
        IDocument document = editor.getDocument();
        if (document == null) {
            return null;
        }
        ArrayList<String> arraylistMemory = new ArrayList<String>();
        try {
            completeFile = document.get(commentLocation.getOffset(), commentLocation.getEndOffset() - commentLocation.getOffset());
        }
        catch (BadLocationException e1) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e1));
            return null;
        }
        int offset = 0;
        boolean circulate = true;
        boolean simpleNewline = false;
        while (circulate) {
            int loc = completeFile.indexOf(NEWLINE, offset);
            if (loc < 0) {
                loc = completeFile.indexOf(10, offset);
                if (loc < 0) {
                    circulate = false;
                    break;
                }
                simpleNewline = true;
            } else {
                simpleNewline = false;
            }
            String stringLine = completeFile.substring(offset, loc);
            arraylistMemory.add(stringLine);
            if (simpleNewline) {
                offset = loc + "\n".length();
                continue;
            }
            offset = loc + NEWLINE.length();
        }
        return arraylistMemory;
    }

    public static String getCommentStringBasedOnReference(DeclarationCollector declarationCollector, List<DeclarationCollectionHelper> collected, IEditorPart targetEditor, IRegion hoverRegion, IReferenceParser referenceParser, ITextViewer textViewer) {
        if (!T3Doc.isT3DocEnable()) {
            return null;
        }
        Reference ref = declarationCollector.getReference();
        if (ref == null) {
            return null;
        }
        if ((ref.getMyScope() instanceof NamedBridgeScope || ref.getMyScope() instanceof FormalParameterList) && !collected.isEmpty()) {
            IFile file;
            ProjectSourceParser projectSourceParser;
            Module tempModule;
            Assignment ass;
            DeclarationCollectionHelper declaration = collected.get(0);
            if ((declaration.node instanceof TTCN3_Sequence_Type || declaration.node instanceof FormalParameter) && (ass = (tempModule = (projectSourceParser = GlobalParser.getProjectSourceParser((file = (IFile)targetEditor.getEditorInput().getAdapter(IFile.class)).getProject())).containedModule(file)).getEnclosingAssignment(hoverRegion.getOffset())) != null) {
                Reference reference = referenceParser.findReferenceForOpening(file, hoverRegion.getOffset(), textViewer.getDocument());
                String str = reference.getDisplayName();
                List<String> al = T3Doc.getCommentStrings(ass.getCommentLocation(), str);
                if (!al.isEmpty()) {
                    StringBuilder sb = new StringBuilder();
                    for (String string : al) {
                        sb.append(string);
                    }
                    return sb.toString();
                }
            }
        }
        return null;
    }

    static {
        final IPreferencesService prefService = Platform.getPreferencesService();
        documentationEnabled = prefService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.T3DocEnable", false, null);
        Activator activator = Activator.getDefault();
        if (activator != null) {
            activator.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    String property = event.getProperty();
                    if ("org.eclipse.titan.designer.T3DocEnable".equals(property)) {
                        documentationEnabled = prefService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.T3DocEnable", false, null);
                        return;
                    }
                }
            });
        }
    }
}

