/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.configeditor.pages.execute;

import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.titan.common.parsers.cfg.ConfigTreeNodeUtilities;
import org.eclipse.titan.common.parsers.cfg.indices.ExecuteSectionHandler;
import org.eclipse.titan.designer.editors.configeditor.ConfigEditor;
import org.eclipse.titan.designer.editors.configeditor.pages.execute.ExecuteItemTransfer;

public final class ExecuteSectionDropTargetListener
implements DropTargetListener {
    private TableViewer viewer;
    private ConfigEditor editor;

    public ExecuteSectionDropTargetListener(TableViewer viewer, ConfigEditor editor) {
        this.viewer = viewer;
        this.editor = editor;
    }

    public void dragEnter(DropTargetEvent event) {
        if (event.detail == 16 && (event.operations & 3) == 0) {
            event.detail = 0;
        }
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
        if (event.detail == 16 && (event.operations & 3) == 0) {
            event.detail = 0;
        }
    }

    public void dragOver(DropTargetEvent event) {
        if (event.item == null) {
            event.feedback = 8;
            event.detail = 0;
        } else {
            event.feedback = event.item.getData() instanceof ExecuteSectionHandler.ExecuteItem ? 25 : 10;
            if (event.detail == 0) {
                if ((event.operations & 2) != 0) {
                    event.detail = 2;
                } else if ((event.operations & 1) != 0) {
                    event.detail = 1;
                }
            }
        }
    }

    public void drop(DropTargetEvent event) {
        if (ExecuteItemTransfer.getInstance().isSupportedType(event.currentDataType) && event.item != null && this.viewer.getInput() != null) {
            ExecuteSectionHandler executeSectionHandler = (ExecuteSectionHandler)this.viewer.getInput();
            ExecuteSectionHandler.ExecuteItem element = (ExecuteSectionHandler.ExecuteItem)event.item.getData();
            ExecuteSectionHandler.ExecuteItem[] items = (ExecuteSectionHandler.ExecuteItem[])event.data;
            int baseindex = executeSectionHandler.getExecuteitems().indexOf(element);
            ParserRuleContext parent = executeSectionHandler.getLastSectionRoot();
            ConfigTreeNodeUtilities.removeChild((ParseTree)parent, (ParseTree)element.getRoot());
            ConfigTreeNodeUtilities.addChild((ParseTree)parent, (ParseTree)element.getRoot(), (int)baseindex);
            if (items.length > 0) {
                for (int i = 0; i < items.length - 1; ++i) {
                    executeSectionHandler.getExecuteitems().add(++baseindex, items[i]);
                }
                executeSectionHandler.getExecuteitems().add(++baseindex, items[items.length - 1]);
            }
            this.viewer.refresh(true);
            this.editor.setDirty();
        }
    }

    public void dropAccept(DropTargetEvent event) {
    }
}

