/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.swt.graphics.Image;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.SkeletonTemplateProposal;
import org.eclipse.titan.designer.graphics.ImageCache;

public final class TTCN3CodeSkeletons {
    public static final String CONTEXT_IDENTIFIER = "TTCN3_SOURCE_CODE";
    public static final String CONTEXT_NAME = "TTCN3 Code Skeleton Context";
    private static final String NEWLINE = System.getProperty("line.separator");
    public static final Image SKELETON_IMAGE = ImageCache.getImage("skeleton.gif");
    public static final SkeletonTemplateProposal[] FORMAL_VALUE_PARAMETER_PROPOSALS = new SkeletonTemplateProposal[]{new SkeletonTemplateProposal("in", new Template("formal value parameter", "in", "TTCN3_SOURCE_CODE", "in ${parameterType} pl_${parameterName}", false)), new SkeletonTemplateProposal("out", new Template("formal value parameter", "out", "TTCN3_SOURCE_CODE", "out ${parameterType} pl_${parameterName}", false)), new SkeletonTemplateProposal("inout", new Template("formal value parameter", "inout", "TTCN3_SOURCE_CODE", "inout ${parameterType} pl_${parameterName}", false))};
    public static final SkeletonTemplateProposal[] FORMAL_TEMPLATE_PARAMETER_PROPOSALS = new SkeletonTemplateProposal[]{new SkeletonTemplateProposal("in", new Template("formal template parameter", "in", "TTCN3_SOURCE_CODE", "in template ${parameterType} pl_${parameterName}", false)), new SkeletonTemplateProposal("out", new Template("formal template parameter", "out", "TTCN3_SOURCE_CODE", "out template ${parameterType} pl_${parameterName}", false)), new SkeletonTemplateProposal("inout", new Template("formal template parameter", "inout", "TTCN3_SOURCE_CODE", "inout template ${parameterType} pl_${parameterName}", false)), new SkeletonTemplateProposal("in", new Template("formal restricted template parameter", "in", "TTCN3_SOURCE_CODE", "in template(${parameterRestriction}) ${parameterType} pl_${parameterName}", false)), new SkeletonTemplateProposal("out", new Template("formal restricted template parameter", "out", "TTCN3_SOURCE_CODE", "out template(${parameterRestriction}) ${parameterType} pl_${parameterName}", false)), new SkeletonTemplateProposal("inout", new Template("formal restricted template parameter", "inout", "TTCN3_SOURCE_CODE", "inout template(${parameterRestriction}) ${parameterType} pl_${parameterName}", false))};
    public static final SkeletonTemplateProposal[] FORMAL_TIMER_PARAMETER_PROPOSALS = new SkeletonTemplateProposal[]{new SkeletonTemplateProposal("in", new Template("formal timer parameter", "inout", "TTCN3_SOURCE_CODE", "${inout} timer pl_${parameterName}", false))};
    public static final SkeletonTemplateProposal[] MODULE_LEVEL_SKELETON_PROPOSALS = new SkeletonTemplateProposal[]{new SkeletonTemplateProposal("function", new Template("function", "", "TTCN3_SOURCE_CODE", "function f_${functionName}(" + NEWLINE + "  ${inout} ${parameterType} pl_${parameterName} )" + NEWLINE + "{" + NEWLINE + "  //local declarations" + NEWLINE + "  ${}" + NEWLINE + "  //dynamic behavior" + NEWLINE + "}" + NEWLINE, false)), new SkeletonTemplateProposal("function", new Template("function", "with return statement", "TTCN3_SOURCE_CODE", "function f_${functionName}(" + NEWLINE + "  ${inout} ${parameterType} pl_${parameterName} )" + NEWLINE + "return ${returnType}" + NEWLINE + "{" + NEWLINE + "  //local declarations" + NEWLINE + "  ${}" + NEWLINE + "  //dynamic behavior" + NEWLINE + "}" + NEWLINE, false)), new SkeletonTemplateProposal("function", new Template("function", "with runs on statement", "TTCN3_SOURCE_CODE", "function f_${functionName}(" + NEWLINE + "  ${inout} ${parameterType} pl_${parameterName} )" + NEWLINE + "runs on ${TestComponentTypeName}" + NEWLINE + "{" + NEWLINE + "  //local declarations" + NEWLINE + "  ${}" + NEWLINE + "  //dynamic behavior" + NEWLINE + "}" + NEWLINE, false)), new SkeletonTemplateProposal("function", new Template("function", "with runs on and return statement", "TTCN3_SOURCE_CODE", "function f_${functionName}(" + NEWLINE + "  ${inout} ${parameterType} pl_${parameterName} )" + NEWLINE + "runs on ${TestComponentTypeName}" + NEWLINE + "return ${returnType}" + NEWLINE + "{" + NEWLINE + "  //local declarations" + NEWLINE + "  ${}" + NEWLINE + "  //dynamic behavior" + NEWLINE + "}" + NEWLINE, false)), new SkeletonTemplateProposal("external", new Template("external function", "", "TTCN3_SOURCE_CODE", "external function f_${functionName}(" + NEWLINE + "  ${inout} ${parameterType} pl_${parameterName} );", false)), new SkeletonTemplateProposal("testcase", new Template("testcase", "", "TTCN3_SOURCE_CODE", "testcase tc_${testcaseName}(" + NEWLINE + "  ${inout} ${parameterType} pl_${parameterName} )" + NEWLINE + "runs on ${TestComponentTypeName}" + NEWLINE + "system ${SystemComponentTypeName}" + NEWLINE + '{' + NEWLINE + "  //local declarations" + NEWLINE + "  ${}" + NEWLINE + "  //dynamic behavior" + NEWLINE + '}' + NEWLINE, false)), new SkeletonTemplateProposal("control", new Template("control part", "", "TTCN3_SOURCE_CODE", "control" + NEWLINE + '{' + NEWLINE + "  //local declarations" + NEWLINE + "  ${}" + NEWLINE + "  //dynamic behavior" + NEWLINE + '}' + NEWLINE, false)), new SkeletonTemplateProposal("altstep", new Template("altstep", "", "TTCN3_SOURCE_CODE", "altstep as_${altstepName}(" + NEWLINE + "  ${inout} ${parameterType} pl_${parameterName} )" + NEWLINE + "runs on ${TestComponentTypeName}" + NEWLINE + '{' + NEWLINE + "  [${guard1}] ${portName}.${receivingOperation}" + NEWLINE + "    {" + NEWLINE + "      ${}" + NEWLINE + "    }" + NEWLINE + "  [${guard2}] ${timerName}.timeout" + NEWLINE + "    {" + NEWLINE + "      ${}" + NEWLINE + "    }" + NEWLINE + "  [else]" + NEWLINE + "    {" + NEWLINE + "      ${}" + NEWLINE + "    }" + NEWLINE + '}' + NEWLINE, false)), new SkeletonTemplateProposal("signature", new Template("signature", "", "TTCN3_SOURCE_CODE", "signature S_${ProvedureSignatureID}(" + NEWLINE + "  ${inout} ${parameterType} pl_${parameterName} )" + NEWLINE + "return ${returnType}" + NEWLINE + "exception( ${exceptionType1}, ${exceptionType2} );" + NEWLINE, false)), new SkeletonTemplateProposal("import", new Template("import", "short format", "TTCN3_SOURCE_CODE", "import from ${moduleName} all;" + NEWLINE, false)), new SkeletonTemplateProposal("import", new Template("import", "full format", "TTCN3_SOURCE_CODE", "import from ${moduleName}.objid{${objid}} language  \"${language_description}\" all;" + NEWLINE, false)), new SkeletonTemplateProposal("import", new Template("import", "import of imports format", "TTCN3_SOURCE_CODE", "import from ${moduleName} {import all};" + NEWLINE, false)), new SkeletonTemplateProposal("type", new Template("component", "", "TTCN3_SOURCE_CODE", "type component ${componentName}_CT" + NEWLINE + '{' + NEWLINE + "  //constant definitions" + NEWLINE + "  ${}" + NEWLINE + "  //variable definitions" + NEWLINE + "  port ${testPortTypeName}_PT ${portname};" + NEWLINE + '}' + NEWLINE, false)), new SkeletonTemplateProposal("component", new Template("component", "(postfix)", "TTCN3_SOURCE_CODE", "component ${componentName}_CT" + NEWLINE + '{' + NEWLINE + "  //constant definitions" + NEWLINE + "  ${}" + NEWLINE + "  //variable definitions" + NEWLINE + "  port ${testPortTypeName}_PT ${portname};" + NEWLINE + '}' + NEWLINE, false)), new SkeletonTemplateProposal("type", new Template("port", "message based", "TTCN3_SOURCE_CODE", "type port ${testPortName}_PT message" + NEWLINE + '{' + NEWLINE + "  in ${inType1}, ${inType2};" + NEWLINE + "  out ${outType1}, ${outType2};" + NEWLINE + "  inout ${inoutType1}, ${inoutType2};" + NEWLINE + '}' + NEWLINE, false)), new SkeletonTemplateProposal("port", new Template("port", "message based (postfixed)", "TTCN3_SOURCE_CODE", "port ${testPortName}_PT message" + NEWLINE + '{' + NEWLINE + "  in ${inType1}, ${inType2};" + NEWLINE + "  out ${outType1}, ${outType2};" + NEWLINE + "  inout ${inoutType1}, ${inoutType2};" + NEWLINE + '}' + NEWLINE, false)), new SkeletonTemplateProposal("type", new Template("port", "procedure based", "TTCN3_SOURCE_CODE", "type port ${testPortName}_PT procedure" + NEWLINE + '{' + NEWLINE + "  in ${inType1}, ${inType2};" + NEWLINE + "  out ${outType1}, ${outType2};" + NEWLINE + "  inout ${inoutType1}, ${inoutType2};" + NEWLINE + '}' + NEWLINE, false)), new SkeletonTemplateProposal("port", new Template("port", "procedure based (postfixed)", "TTCN3_SOURCE_CODE", "port ${testPortName}_PT procedure" + NEWLINE + '{' + NEWLINE + "  in ${inType1}, ${inType2};" + NEWLINE + "  out ${outType1}, ${outType2};" + NEWLINE + "  inout ${inoutType1}, ${inoutType2};" + NEWLINE + '}' + NEWLINE, false)), new SkeletonTemplateProposal("type", new Template("record", "top level", "TTCN3_SOURCE_CODE", "type record ${recordName}" + NEWLINE + '{' + NEWLINE + "  ${subType1} ${field1}," + NEWLINE + "  ${subType2} ${field2}" + NEWLINE + "};" + NEWLINE, false)), new SkeletonTemplateProposal("record", new Template("record", "top level (postfix)", "TTCN3_SOURCE_CODE", "record ${recordName}" + NEWLINE + '{' + NEWLINE + "  ${subType1} ${field1}," + NEWLINE + "  ${subType2} ${field2}" + NEWLINE + "};" + NEWLINE, false)), new SkeletonTemplateProposal("record", new Template("record", "nested", "TTCN3_SOURCE_CODE", "record" + NEWLINE + '{' + NEWLINE + "  ${subType1} ${field1}," + NEWLINE + "  ${subType2} ${field2}" + NEWLINE + "}  ${fieldIdentifier}" + NEWLINE, false)), new SkeletonTemplateProposal("type", new Template("record of", "top level", "TTCN3_SOURCE_CODE", "type record length(${sizeConstraint}) of ${baseType} ${newTypeName};" + NEWLINE, false)), new SkeletonTemplateProposal("record", new Template("record of", "top level (postfix)", "TTCN3_SOURCE_CODE", "record length(${sizeConstraint}) of ${baseType} ${newTypeName};" + NEWLINE, false)), new SkeletonTemplateProposal("record", new Template("record of", "nested", "TTCN3_SOURCE_CODE", "record length(${sizeConstraint}) of ${baseType} ${fieldIdentifier}", false)), new SkeletonTemplateProposal("type", new Template("set", "top level", "TTCN3_SOURCE_CODE", "type set ${setName}" + NEWLINE + '{' + NEWLINE + "  ${subType1} ${field1}," + NEWLINE + "  ${subType2} ${field2}" + NEWLINE + "};" + NEWLINE, false)), new SkeletonTemplateProposal("set", new Template("set", "top level (postfix)", "TTCN3_SOURCE_CODE", "set ${setName}" + NEWLINE + '{' + NEWLINE + "  ${subType1} ${field1}," + NEWLINE + "  ${subType2} ${field2}" + NEWLINE + "};" + NEWLINE, false)), new SkeletonTemplateProposal("set", new Template("set", "nested", "TTCN3_SOURCE_CODE", "set" + NEWLINE + '{' + NEWLINE + "  ${subType1} ${field1}," + NEWLINE + "  ${subType2} ${field2}" + NEWLINE + "}  ${fieldIdentifier}" + NEWLINE, false)), new SkeletonTemplateProposal("type", new Template("set of", "top level", "TTCN3_SOURCE_CODE", "type set length(${sizeConstraint}) of ${baseType} ${newTypeName};" + NEWLINE, false)), new SkeletonTemplateProposal("set", new Template("set of", "top level (postfix)", "TTCN3_SOURCE_CODE", "set length(${sizeConstraint}) of ${baseType} ${newTypeName};" + NEWLINE, false)), new SkeletonTemplateProposal("set", new Template("set of", "nested", "TTCN3_SOURCE_CODE", "set length(${sizeConstraint}) of ${baseType} ${fieldIdentifier}", false)), new SkeletonTemplateProposal("type", new Template("union", "top level", "TTCN3_SOURCE_CODE", "type union ${unionName}" + NEWLINE + '{' + NEWLINE + "  ${subType1} ${field1}," + NEWLINE + "  ${subType2} ${field2}" + NEWLINE + "};" + NEWLINE, false)), new SkeletonTemplateProposal("union", new Template("union", "top level (postfix)", "TTCN3_SOURCE_CODE", "union ${unionName}" + NEWLINE + '{' + NEWLINE + "  ${subType1} ${field1}," + NEWLINE + "  ${subType2} ${field2}" + NEWLINE + "};" + NEWLINE, false)), new SkeletonTemplateProposal("union", new Template("union", "nested", "TTCN3_SOURCE_CODE", "union" + NEWLINE + '{' + NEWLINE + "  ${subType1} ${field1}," + NEWLINE + "  ${subType2} ${field2}" + NEWLINE + "}  ${fieldIdentifier}" + NEWLINE, false)), new SkeletonTemplateProposal("type", new Template("enumerated", "top level", "TTCN3_SOURCE_CODE", "type enumerated ${enumerationName}" + NEWLINE + '{' + NEWLINE + "  ${item1}(${0})," + NEWLINE + "  ${item2}" + NEWLINE + "};" + NEWLINE, false)), new SkeletonTemplateProposal("enumerated", new Template("enumerated", "top level (postfix)", "TTCN3_SOURCE_CODE", "enumerated ${enumerationName}" + NEWLINE + '{' + NEWLINE + "  ${item1}(${0})," + NEWLINE + "  ${item2}" + NEWLINE + "};" + NEWLINE, false)), new SkeletonTemplateProposal("enumerated", new Template("enumerated", "nested", "TTCN3_SOURCE_CODE", "enumerated" + NEWLINE + '{' + NEWLINE + "  ${item1}(${0})," + NEWLINE + "  ${item2}" + NEWLINE + "}  ${fieldIdentifier}" + NEWLINE, false)), new SkeletonTemplateProposal("modulepar", new Template("modulepar", "without default value", "TTCN3_SOURCE_CODE", "modulepar ${typeName} tsp_${typeName}_${descriptiveName};" + NEWLINE, false)), new SkeletonTemplateProposal("modulepar", new Template("modulepar", "with default value", "TTCN3_SOURCE_CODE", "modulepar ${typeName} tsp_${typeName}_${descriptiveName} := ${default_value};" + NEWLINE, false)), new SkeletonTemplateProposal("modulepar", new Template("modulepar", "multiple parameter form", "TTCN3_SOURCE_CODE", "modulepar ${typeName} tsp_${typeName}_${descriptiveName} := ${default_value}," + NEWLINE + "  tsp_${typeName}_${descriptiveName2} := ${default_value2};" + NEWLINE, false)), new SkeletonTemplateProposal("template", new Template("template", "simple", "TTCN3_SOURCE_CODE", "template ${typeName} t_${typeName}_${descriptiveName} := ${matchingSymbol}", false)), new SkeletonTemplateProposal("template", new Template("template", "structured", "TTCN3_SOURCE_CODE", "template ${typeName} t_${typeName}_${descriptiveName} :=" + NEWLINE + '{' + NEWLINE + "  ${field1} := ${matchingSymbol}" + NEWLINE + '}' + NEWLINE, false)), new SkeletonTemplateProposal("template", new Template("template", "with parameter", "TTCN3_SOURCE_CODE", "template ${typeName} t_${typeName}_${descriptiveName} ( " + NEWLINE + "in ${parameterType1} pl_${parameter1}," + NEWLINE + "in template ${parameterType2} pl_${parameter2}) :=" + NEWLINE + '{' + NEWLINE + "  ${field1} := ${matchingSymbol}" + NEWLINE + '}' + NEWLINE, false)), new SkeletonTemplateProposal("template", new Template("template", "with modifies clause", "TTCN3_SOURCE_CODE", "template ${typeName} t_${typeName}_${descriptiveName}" + NEWLINE + "modifies ${baseTemplateName} :=" + NEWLINE + '{' + NEWLINE + "  ${field1} := ${matchingSymbol}" + NEWLINE + '}' + NEWLINE, false)), new SkeletonTemplateProposal("template", new Template("template", "with parameter and modifies clause", "TTCN3_SOURCE_CODE", "template ${typeName} t_${typeName}_${descriptiveName} ( " + NEWLINE + "in ${parameterType1} pl_${parameter1}," + NEWLINE + "in template ${parameterType2} pl_${parameter2})" + NEWLINE + "modifies ${baseTemplateName} :=" + NEWLINE + '{' + NEWLINE + "  ${field1} := ${matchingSymbol}" + NEWLINE + '}' + NEWLINE, false)), new SkeletonTemplateProposal("template", new Template("template", "simple restricted", "TTCN3_SOURCE_CODE", "template(${restriction}) ${typeName} t_${typeName}_${descriptiveName} := ${matchingSymbol}", false)), new SkeletonTemplateProposal("template", new Template("template", "structured restricted", "TTCN3_SOURCE_CODE", "template(${restriction}) ${typeName} t_${typeName}_${descriptiveName} :=" + NEWLINE + '{' + NEWLINE + "  ${field1} := ${matchingSymbol}" + NEWLINE + '}' + NEWLINE, false)), new SkeletonTemplateProposal("template", new Template("template", "with parameter restricted", "TTCN3_SOURCE_CODE", "template(${restriction}) ${typeName} t_${typeName}_${descriptiveName} ( " + NEWLINE + "in ${parameterType1} pl_${parameter1}," + NEWLINE + "in template(${parameterRestriction}) ${parameterType2} pl_${parameter2}) :=" + NEWLINE + '{' + NEWLINE + "  ${field1} := ${matchingSymbol}" + NEWLINE + '}' + NEWLINE, false)), new SkeletonTemplateProposal("template", new Template("template", "with modifies clause restricted", "TTCN3_SOURCE_CODE", "template(${restriction}) ${typeName} t_${typeName}_${descriptiveName}" + NEWLINE + "modifies ${baseTemplateName} :=" + NEWLINE + '{' + NEWLINE + "  ${field1} := ${matchingSymbol}" + NEWLINE + '}' + NEWLINE, false)), new SkeletonTemplateProposal("template", new Template("template", "with parameter and modifies clause restricted", "TTCN3_SOURCE_CODE", "template(${restriction}) ${typeName} t_${typeName}_${descriptiveName} ( " + NEWLINE + "in ${parameterType1} pl_${parameter1}," + NEWLINE + "in template(${parameterRestriction}) ${parameterType2} pl_${parameter2})" + NEWLINE + "modifies ${baseTemplateName} :=" + NEWLINE + '{' + NEWLINE + "  ${field1} := ${matchingSymbol}" + NEWLINE + '}' + NEWLINE, false)), new SkeletonTemplateProposal("const", new Template("const", "simple on module level", "TTCN3_SOURCE_CODE", "const ${typeName} cg_${constantName} := ${constant_value};" + NEWLINE, false)), new SkeletonTemplateProposal("const", new Template("const", "structured on module level", "TTCN3_SOURCE_CODE", "const ${typeName} cg_${constantName} := {${constant_sub_value1}, ${constant_sub_value2}};" + NEWLINE, false)), new SkeletonTemplateProposal("const", new Template("const", "multiple constant form on module level", "TTCN3_SOURCE_CODE", "const ${typeName} cg_${constantName1} := ${constant_value1}, cg_${constantName2} := ${constant_value2};" + NEWLINE, false))};
    public static final SkeletonTemplateProposal[] STATEMENT_LEVEL_SKELETON_PROPOSALS = new SkeletonTemplateProposal[]{new SkeletonTemplateProposal("for", new Template("for", "iterate over array", "TTCN3_SOURCE_CODE", "for ( var integer ${loopCounter} := ${initialValue}; ${loopCounter} < ${limit} ; ${loopCounter} := ${loopCounter}+1 )" + NEWLINE + '{' + NEWLINE + "  ${}" + NEWLINE + '}' + NEWLINE, false)), new SkeletonTemplateProposal("while", new Template("while", "while loop", "TTCN3_SOURCE_CODE", "while ( ${booleanExpression} )" + NEWLINE + '{' + NEWLINE + "  ${}" + NEWLINE + '}' + NEWLINE, false)), new SkeletonTemplateProposal("do", new Template("do", "do while loop", "TTCN3_SOURCE_CODE", "do" + NEWLINE + '{' + NEWLINE + "  ${}" + NEWLINE + "} while ( ${booleanExpression} )" + NEWLINE, false)), new SkeletonTemplateProposal("if", new Template("if", "if statment", "TTCN3_SOURCE_CODE", "if ( ${booleanExpression} )" + NEWLINE + '{' + NEWLINE + "  ${}" + NEWLINE + '}' + NEWLINE, false)), new SkeletonTemplateProposal("if", new Template("if elseif", "if elseif statment", "TTCN3_SOURCE_CODE", "if ( ${booleanExpression1} )" + NEWLINE + '{' + NEWLINE + "  ${}" + NEWLINE + '}' + NEWLINE + "else if ( ${booleanExpression2} )" + NEWLINE + '{' + NEWLINE + "  ${}" + NEWLINE + '}' + NEWLINE, false)), new SkeletonTemplateProposal("if", new Template("if else", "if else statment", "TTCN3_SOURCE_CODE", "if ( ${booleanExpression} )" + NEWLINE + '{' + NEWLINE + "  ${}" + NEWLINE + '}' + NEWLINE + "else" + NEWLINE + '{' + NEWLINE + "  ${}" + NEWLINE + '}' + NEWLINE, false)), new SkeletonTemplateProposal("elseif", new Template("elseif", "else if statment", "TTCN3_SOURCE_CODE", "else if ( ${booleanExpression2} )" + NEWLINE + '{' + NEWLINE + "  ${}" + NEWLINE + '}' + NEWLINE, false)), new SkeletonTemplateProposal("else", new Template("else", "else statment", "TTCN3_SOURCE_CODE", "else" + NEWLINE + '{' + NEWLINE + "  ${}" + NEWLINE + '}' + NEWLINE, false)), new SkeletonTemplateProposal("select", new Template("select", "select statment with case else branch", "TTCN3_SOURCE_CODE", "select( ${expression} )" + NEWLINE + '{' + NEWLINE + "  case ( ${template_instance} )" + NEWLINE + "  {" + NEWLINE + "    ${}" + NEWLINE + "  }" + NEWLINE + "  case else" + NEWLINE + "  {" + NEWLINE + "    ${}" + NEWLINE + "  }" + NEWLINE + '}' + NEWLINE, false)), new SkeletonTemplateProposal("case", new Template("case", "select case branch statment", "TTCN3_SOURCE_CODE", "case ( ${template_instance} )" + NEWLINE + "  {" + NEWLINE + "    ${}" + NEWLINE + "  }" + NEWLINE, false)), new SkeletonTemplateProposal("alt", new Template("alt", "", "TTCN3_SOURCE_CODE", "alt" + NEWLINE + '{' + NEWLINE + "  [${guard1}] ${portName}.${receivingOperation}" + NEWLINE + "    {" + NEWLINE + "      ${}" + NEWLINE + "    }" + NEWLINE + "  [${guard2}] ${timerName}.timeout" + NEWLINE + "    {" + NEWLINE + "      ${}" + NEWLINE + "    }" + NEWLINE + "  [else]" + NEWLINE + "    {" + NEWLINE + "      ${}" + NEWLINE + "    }" + NEWLINE + "};" + NEWLINE, false)), new SkeletonTemplateProposal("interleave", new Template("interleave", "", "TTCN3_SOURCE_CODE", "interleave" + NEWLINE + '{' + NEWLINE + "  [${guard1}] ${portName}.${receivingOperation}" + NEWLINE + "    {" + NEWLINE + "      ${}" + NEWLINE + "    }" + NEWLINE + "  [${guard2}] ${portName2}.${receivingOperation2}" + NEWLINE + "    {" + NEWLINE + "      ${}" + NEWLINE + "    }" + NEWLINE + "};" + NEWLINE, false)), new SkeletonTemplateProposal("template", new Template("template", "simple", "TTCN3_SOURCE_CODE", "template ${typeName} t_${typeName}_${descriptiveName} := ${matchingSymbol}", false)), new SkeletonTemplateProposal("template", new Template("template", "structured", "TTCN3_SOURCE_CODE", "template ${typeName} t_${typeName}_${descriptiveName} :=" + NEWLINE + '{' + NEWLINE + "  ${field1} := ${matchingSymbol}" + NEWLINE + '}' + NEWLINE, false)), new SkeletonTemplateProposal("template", new Template("template", "with parameter", "TTCN3_SOURCE_CODE", "template ${typeName} t_${typeName}_${descriptiveName} (" + NEWLINE + "in ${parameterType1} pl_${parameter1}," + NEWLINE + "in template ${parameterType2} pl_${parameter2}) :=" + NEWLINE + '{' + NEWLINE + "  ${field1} := ${matchingSymbol}" + NEWLINE + '}' + NEWLINE, false)), new SkeletonTemplateProposal("template", new Template("template", "with modifies clause", "TTCN3_SOURCE_CODE", "template ${typeName} t_${typeName}_${descriptiveName}" + NEWLINE + "modifies ${baseTemplateName} :=" + NEWLINE + '{' + NEWLINE + "  ${field1} := ${matchingSymbol}" + NEWLINE + '}' + NEWLINE, false)), new SkeletonTemplateProposal("template", new Template("template", "with parameter and modifies clause", "TTCN3_SOURCE_CODE", "template ${typeName} t_${typeName}_${descriptiveName} (" + NEWLINE + "in ${parameterType1} pl_${parameter1}," + NEWLINE + "in template ${parameterType2} pl_${parameter2})" + NEWLINE + "modifies ${baseTemplateName} :=" + NEWLINE + '{' + NEWLINE + "  ${field1} := ${matchingSymbol}" + NEWLINE + '}' + NEWLINE, false)), new SkeletonTemplateProposal("template", new Template("template", "simple restricted", "TTCN3_SOURCE_CODE", "template(${restriction}) ${typeName} t_${typeName}_${descriptiveName} := ${matchingSymbol}", false)), new SkeletonTemplateProposal("template", new Template("template", "structured restricted", "TTCN3_SOURCE_CODE", "template(${restriction}) ${typeName} t_${typeName}_${descriptiveName} :=" + NEWLINE + '{' + NEWLINE + "  ${field1} := ${matchingSymbol}" + NEWLINE + '}' + NEWLINE, false)), new SkeletonTemplateProposal("template", new Template("template", "with parameter restricted", "TTCN3_SOURCE_CODE", "template(${restriction}) ${typeName} t_${typeName}_${descriptiveName} (" + NEWLINE + "in ${parameterType1} pl_${parameter1}," + NEWLINE + "in template(${parameterRestriction}) ${parameterType2} pl_${parameter2}) :=" + NEWLINE + '{' + NEWLINE + "  ${field1} := ${matchingSymbol}" + NEWLINE + '}' + NEWLINE, false)), new SkeletonTemplateProposal("template", new Template("template", "with modifies clause restricted", "TTCN3_SOURCE_CODE", "template(${restriction}) ${typeName} t_${typeName}_${descriptiveName}" + NEWLINE + "modifies ${baseTemplateName} :=" + NEWLINE + '{' + NEWLINE + "  ${field1} := ${matchingSymbol}" + NEWLINE + '}' + NEWLINE, false)), new SkeletonTemplateProposal("template", new Template("template", "with parameter and modifies clause restricted", "TTCN3_SOURCE_CODE", "template(${restriction}) ${typeName} t_${typeName}_${descriptiveName} (" + NEWLINE + "in ${parameterType1} pl_${parameter1}," + NEWLINE + "in template(${parameterRestriction}) ${parameterType2} pl_${parameter2})" + NEWLINE + "modifies ${baseTemplateName} :=" + NEWLINE + '{' + NEWLINE + "  ${field1} := ${matchingSymbol}" + NEWLINE + '}' + NEWLINE, false)), new SkeletonTemplateProposal("const", new Template("const", "simple in statement block", "TTCN3_SOURCE_CODE", "const ${typeName} cl_${constantName} := ${constant_value};" + NEWLINE, false)), new SkeletonTemplateProposal("const", new Template("const", "structured in statement block", "TTCN3_SOURCE_CODE", "const ${typeName} cl_${constantName} := {${constant_sub_value1}, ${constant_sub_value2}};" + NEWLINE, false)), new SkeletonTemplateProposal("const", new Template("const", "multiple constant form in statement block", "TTCN3_SOURCE_CODE", "const ${typeName} cl_${constantName1} := ${constant_value1}, cl_${constantName2} := ${constant_value2};" + NEWLINE, false)), new SkeletonTemplateProposal("var", new Template("variable", "simple in statement block", "TTCN3_SOURCE_CODE", "var ${typeName} vl_${variableName} := ${initial_value};" + NEWLINE, false)), new SkeletonTemplateProposal("var", new Template("variable", "structured in statement block", "TTCN3_SOURCE_CODE", "var ${typeName} vl_${variableName} := {${initial_sub_value1}, ${initial_sub_value2}};" + NEWLINE, false)), new SkeletonTemplateProposal("var", new Template("variable", "multiple variable form in statement block", "TTCN3_SOURCE_CODE", "var ${typeName} vl_${variableName1} := ${initial_value1}, vl_${variableName2} := ${initial_value2};" + NEWLINE, false)), new SkeletonTemplateProposal("var", new Template("variable template", "simple in statement block", "TTCN3_SOURCE_CODE", "var template ${typeName} vtl_${variableName} := ${initial_value};" + NEWLINE, false)), new SkeletonTemplateProposal("var", new Template("variable template", "structured in statement block", "TTCN3_SOURCE_CODE", "var template ${typeName} vtl_${variableName} := {${initial_sub_value1}, ${initial_sub_value2}};" + NEWLINE, false)), new SkeletonTemplateProposal("var", new Template("variable template", "multiple variable form in statement block", "TTCN3_SOURCE_CODE", "var template ${typeName} vtl_${variableName1} := ${initial_value1}, vtl_${variableName2} := ${initial_value2};" + NEWLINE, false)), new SkeletonTemplateProposal("var", new Template("variable restricted template", "simple in statement block", "TTCN3_SOURCE_CODE", "var template(${restriction}) ${typeName} vtl_${variableName} := ${initial_value};" + NEWLINE, false)), new SkeletonTemplateProposal("var", new Template("variable restricted template", "structured in statement block", "TTCN3_SOURCE_CODE", "var template(${restriction}) ${typeName} vtl_${variableName} := {${initial_sub_value1}, ${initial_sub_value2}};" + NEWLINE, false)), new SkeletonTemplateProposal("var", new Template("variable restricted template", "multiple variable form in statement block", "TTCN3_SOURCE_CODE", "var template(${restriction}) ${typeName} vtl_${variableName1} := ${initial_value1}, vtl_${variableName2} := ${initial_value2};" + NEWLINE, false)), new SkeletonTemplateProposal("timer", new Template("timer", "in statement block", "TTCN3_SOURCE_CODE", "timer T_${timerName} := ${initial_duration};" + NEWLINE, false)), new SkeletonTemplateProposal("log", new Template("log", "", "TTCN3_SOURCE_CODE", "log ( ${} );" + NEWLINE, false)), new SkeletonTemplateProposal("match", new Template("match", "", "TTCN3_SOURCE_CODE", "match ( ${Value}, ${Template} )" + NEWLINE, false)), new SkeletonTemplateProposal("setverdict", new Template("setverdict", "set a non-pass verdict", "TTCN3_SOURCE_CODE", "setverdict ( ${verdict}, \"${reason}\" );" + NEWLINE, false)), new SkeletonTemplateProposal("setverdict", new Template("setverdict", "set pass as the verdict", "TTCN3_SOURCE_CODE", "setverdict ( pass );" + NEWLINE, false)), new SkeletonTemplateProposal("any", new Template("any component", "", "TTCN3_SOURCE_CODE", "any component", false)), new SkeletonTemplateProposal("any", new Template("any port", "", "TTCN3_SOURCE_CODE", "any port", false)), new SkeletonTemplateProposal("any", new Template("any timer", "", "TTCN3_SOURCE_CODE", "any timer", false)), new SkeletonTemplateProposal("all", new Template("all component", "", "TTCN3_SOURCE_CODE", "all component", false)), new SkeletonTemplateProposal("all", new Template("all port", "", "TTCN3_SOURCE_CODE", "all port", false)), new SkeletonTemplateProposal("all", new Template("all timer", "", "TTCN3_SOURCE_CODE", "all timer", false)), new SkeletonTemplateProposal("@try", new Template("@try{} @catch{}", "@try{} @catch{} blocks", "TTCN3_SOURCE_CODE", NEWLINE + "@try {" + NEWLINE + "  " + NEWLINE + '}' + NEWLINE + "@catch(${dte_string}) {" + NEWLINE + "  " + NEWLINE + '}' + NEWLINE, false))};
    public static final SkeletonTemplateProposal[] COMPONENT_INTERNAL_SKELETON_TEMPLATE_PROPOSALS = new SkeletonTemplateProposal[]{new SkeletonTemplateProposal("const", new Template("const", "simple in component", "TTCN3_SOURCE_CODE", "const ${typeName} c_${constantName} := ${constant_value};" + NEWLINE, false)), new SkeletonTemplateProposal("const", new Template("const", "structured in component", "TTCN3_SOURCE_CODE", "const ${typeName} c_${constantName} := {${constant_sub_value1}, ${constant_sub_value2}};" + NEWLINE, false)), new SkeletonTemplateProposal("const", new Template("const", "multiple constant form in component", "TTCN3_SOURCE_CODE", "const ${typeName} c_${constantName1} := ${constant_value1}, c_${constantName2} := ${constant_value2};" + NEWLINE, false)), new SkeletonTemplateProposal("var", new Template("variable", "simple in component", "TTCN3_SOURCE_CODE", "var ${typeName} v_${variableName} := ${initial_value};" + NEWLINE, false)), new SkeletonTemplateProposal("var", new Template("variable", "structured in component", "TTCN3_SOURCE_CODE", "var ${typeName} v_${variableName} := {${initial_sub_value1}, ${initial_sub_value2}};" + NEWLINE, false)), new SkeletonTemplateProposal("var", new Template("variable", "multiple variable form in component", "TTCN3_SOURCE_CODE", "var ${typeName} v_${variableName1} := ${initial_value1}, v_${variableName2} := ${initial_value2};" + NEWLINE, false)), new SkeletonTemplateProposal("var", new Template("variable template", "simple in component", "TTCN3_SOURCE_CODE", "var template ${typeName} vt_${variableName} := ${initial_value};" + NEWLINE, false)), new SkeletonTemplateProposal("var", new Template("variable template", "structured in component", "TTCN3_SOURCE_CODE", "var template ${typeName} vt_${variableName} := {${initial_sub_value1}, ${initial_sub_value2}};" + NEWLINE, false)), new SkeletonTemplateProposal("var", new Template("variable template", "multiple variable form in component", "TTCN3_SOURCE_CODE", "var template ${typeName} vt_${variableName1} := ${initial_value1}, vt_${variableName2} := ${initial_value2};" + NEWLINE, false)), new SkeletonTemplateProposal("var", new Template("variable restricted template", "simple in component", "TTCN3_SOURCE_CODE", "var template(${restriction}) ${typeName} vt_${variableName} := ${initial_value};" + NEWLINE, false)), new SkeletonTemplateProposal("var", new Template("variable restricted template", "structured in component", "TTCN3_SOURCE_CODE", "var template(${restriction}) ${typeName} vt_${variableName} := {${initial_sub_value1}, ${initial_sub_value2}};" + NEWLINE, false)), new SkeletonTemplateProposal("var", new Template("variable restricted template", "multiple variable form in component", "TTCN3_SOURCE_CODE", "var template(${restriction}) ${typeName} vt_${variableName1} := ${initial_value1}, vt_${variableName2} := ${initial_value2};" + NEWLINE, false)), new SkeletonTemplateProposal("timer", new Template("timer", "in component", "TTCN3_SOURCE_CODE", "timer T_${timerName} := ${initial_duration};" + NEWLINE, false))};
    public static final SkeletonTemplateProposal[] PREDEFINED_FUNCTIONS = new SkeletonTemplateProposal[]{new SkeletonTemplateProposal("bit2hex", new Template("bit2hex", "predefined function", "TTCN3_SOURCE_CODE", "bit2hex(${expression})", false)), new SkeletonTemplateProposal("bit2int", new Template("bit2int", "predefined function", "TTCN3_SOURCE_CODE", "bit2int(${expression})", false)), new SkeletonTemplateProposal("bit2oct", new Template("bit2oct", "predefined function", "TTCN3_SOURCE_CODE", "bit2oct(${expression})", false)), new SkeletonTemplateProposal("bit2str", new Template("bit2str", "predefined function", "TTCN3_SOURCE_CODE", "bit2str(${expression})", false)), new SkeletonTemplateProposal("char2int", new Template("char2int", "predefined function", "TTCN3_SOURCE_CODE", "char2int(${expression})", false)), new SkeletonTemplateProposal("char2oct", new Template("char2oct", "predefined function", "TTCN3_SOURCE_CODE", "char2oct(${expression})", false)), new SkeletonTemplateProposal("float2int", new Template("float2int", "predefined function", "TTCN3_SOURCE_CODE", "float2int(${expression})", false)), new SkeletonTemplateProposal("float2str", new Template("float2str", "predefined function", "TTCN3_SOURCE_CODE", "float2str(${expression})", false)), new SkeletonTemplateProposal("hex2bit", new Template("hex2bit", "predefined function", "TTCN3_SOURCE_CODE", "hex2bit(${expression})", false)), new SkeletonTemplateProposal("hex2int", new Template("hex2int", "predefined function", "TTCN3_SOURCE_CODE", "hex2int(${expression})", false)), new SkeletonTemplateProposal("hex2oct", new Template("hex2oct", "predefined function", "TTCN3_SOURCE_CODE", "hex2oct(${expression})", false)), new SkeletonTemplateProposal("hex2str", new Template("hex2str", "predefined function", "TTCN3_SOURCE_CODE", "hex2str(${expression})", false)), new SkeletonTemplateProposal("int2char", new Template("int2char", "predefined function", "TTCN3_SOURCE_CODE", "int2char(${expression})", false)), new SkeletonTemplateProposal("int2char(9)", new Template("int2char(9)", "HORIZONTAL TABULATION", "TTCN3_SOURCE_CODE", "int2char(9)", false)), new SkeletonTemplateProposal("int2char(10)", new Template("int2char(10)", "LINE FEED", "TTCN3_SOURCE_CODE", "int2char(10)", false)), new SkeletonTemplateProposal("int2char(11)", new Template("int2char(11)", "VERTICAL TABULATION", "TTCN3_SOURCE_CODE", "int2char(11)", false)), new SkeletonTemplateProposal("int2char(12)", new Template("int2char(12)", "FORM FEED", "TTCN3_SOURCE_CODE", "int2char(12)", false)), new SkeletonTemplateProposal("int2char(13)", new Template("int2char(10)", "CARRIAGE RETURN", "TTCN3_SOURCE_CODE", "int2char(13)", false)), new SkeletonTemplateProposal("int2float", new Template("int2float", "predefined function", "TTCN3_SOURCE_CODE", "int2float(${expression})", false)), new SkeletonTemplateProposal("int2str", new Template("int2str", "predefined function", "TTCN3_SOURCE_CODE", "int2str(${expression})", false)), new SkeletonTemplateProposal("int2unichar", new Template("int2unichar", "predefined function", "TTCN3_SOURCE_CODE", "int2unichar(${expression})", false)), new SkeletonTemplateProposal("int2unichar(9)", new Template("int2unichar(9)", "HORIZONTAL TABULATION", "TTCN3_SOURCE_CODE", "int2unichar(9)", false)), new SkeletonTemplateProposal("int2unichar(10)", new Template("int2unichar(10)", "LINE FEED", "TTCN3_SOURCE_CODE", "int2unichar(10)", false)), new SkeletonTemplateProposal("int2unichar(11)", new Template("int2unichar(11)", "VERTICAL TABULATION", "TTCN3_SOURCE_CODE", "int2unichar(11)", false)), new SkeletonTemplateProposal("int2unichar(12)", new Template("int2unichar(12)", "FORM FEED", "TTCN3_SOURCE_CODE", "int2unichar(12)", false)), new SkeletonTemplateProposal("int2unichar(13)", new Template("int2unichar(10)", "CARRIAGE RETURN", "TTCN3_SOURCE_CODE", "int2unichar(13)", false)), new SkeletonTemplateProposal("oct2bit", new Template("oct2bit", "predefined function", "TTCN3_SOURCE_CODE", "oct2bit(${expression})", false)), new SkeletonTemplateProposal("oct2char", new Template("oct2char", "predefined function", "TTCN3_SOURCE_CODE", "oct2char(${expression})", false)), new SkeletonTemplateProposal("oct2int", new Template("oct2int", "predefined function", "TTCN3_SOURCE_CODE", "oct2int(${expression})", false)), new SkeletonTemplateProposal("oct2str", new Template("oct2str", "predefined function", "TTCN3_SOURCE_CODE", "oct2str(${expression})", false)), new SkeletonTemplateProposal("str2bit", new Template("str2bit", "predefined function", "TTCN3_SOURCE_CODE", "str2bit(${expression})", false)), new SkeletonTemplateProposal("str2float", new Template("str2float", "predefined function", "TTCN3_SOURCE_CODE", "str2float(${expression})", false)), new SkeletonTemplateProposal("str2hex", new Template("str2hex", "predefined function", "TTCN3_SOURCE_CODE", "str2hex(${expression})", false)), new SkeletonTemplateProposal("str2int", new Template("str2int", "predefined function", "TTCN3_SOURCE_CODE", "str2int(${expression})", false)), new SkeletonTemplateProposal("str2int", new Template("str2int", "predefined function", "TTCN3_SOURCE_CODE", "str2int(${expression})", false)), new SkeletonTemplateProposal("unichar2int", new Template("unichar2int", "predefined function", "TTCN3_SOURCE_CODE", "unichar2int(${expression})", false)), new SkeletonTemplateProposal("unichar2char", new Template("unichar2char", "predefined function", "TTCN3_SOURCE_CODE", "unichar2char(${expression})", false)), new SkeletonTemplateProposal("enum2int", new Template("enum2int", "predefined function", "TTCN3_SOURCE_CODE", "enum2int(${expression})", false)), new SkeletonTemplateProposal("encvalue", new Template("encvalue", "predefined function", "TTCN3_SOURCE_CODE", "encvalue(${expression})", false)), new SkeletonTemplateProposal("get_stringencoding", new Template("get_stringencoding", "predefined function", "TTCN3_SOURCE_CODE", "get_stringencoding(${expression})", false)), new SkeletonTemplateProposal("oct2unichar", new Template("oct2unichar", "predefined function", "TTCN3_SOURCE_CODE", "oct2unichar(${expression})", false)), new SkeletonTemplateProposal("remove_bom", new Template("remove_bom", "predefined function", "TTCN3_SOURCE_CODE", "remove_bom(${expression})", false)), new SkeletonTemplateProposal("unichar2oct", new Template("unichar2oct", "predefined function", "TTCN3_SOURCE_CODE", "unichar2oct(${expression})", false)), new SkeletonTemplateProposal("encode_base64", new Template("encode_base64", "predefined function", "TTCN3_SOURCE_CODE", "encode_base64(${expression})", false)), new SkeletonTemplateProposal("decode_base64", new Template("decode_base64", "predefined function", "TTCN3_SOURCE_CODE", "decode_base64(${expression})", false)), new SkeletonTemplateProposal("int2bit", new Template("int2bit", "predefined function", "TTCN3_SOURCE_CODE", "int2bit(${expression1},${expression2})", false)), new SkeletonTemplateProposal("int2hex", new Template("int2hex", "predefined function", "TTCN3_SOURCE_CODE", "int2hex(${expression1},${expression2})", false)), new SkeletonTemplateProposal("int2oct", new Template("int2oct", "predefined function", "TTCN3_SOURCE_CODE", "int2oct(${expression1},${expression2})", false)), new SkeletonTemplateProposal("decvalue", new Template("decvalue", "predefined function", "TTCN3_SOURCE_CODE", "decvalue(${expression1}, ${expression2})", false)), new SkeletonTemplateProposal("decomp", new Template("decomp", "predefined function", "TTCN3_SOURCE_CODE", "decomp(${expression1},${expression2}, ${expression3})", false)), new SkeletonTemplateProposal("regexp", new Template("regexp", "predefined function", "TTCN3_SOURCE_CODE", "regexp(${expression1},${expression2}, ${expression3})", false)), new SkeletonTemplateProposal("substr", new Template("substr", "predefined function", "TTCN3_SOURCE_CODE", "substr(${expression1},${expression2}, ${expression3})", false)), new SkeletonTemplateProposal("replace", new Template("replace", "predefined function", "TTCN3_SOURCE_CODE", "replace(${expression1},${expression2}, ${expression3}, ${expression4})", false)), new SkeletonTemplateProposal("log2str", new Template("log2str", "predefined function", "TTCN3_SOURCE_CODE", "log2str( ${} )", false)), new SkeletonTemplateProposal("isbound", new Template("isbound", "predefined function", "TTCN3_SOURCE_CODE", "isbound(${templateInstance})", false)), new SkeletonTemplateProposal("isvalue", new Template("isvalue", "predefined function", "TTCN3_SOURCE_CODE", "isvalue(${templateInstance})", false)), new SkeletonTemplateProposal("lengthof", new Template("lengthof", "predefined function", "TTCN3_SOURCE_CODE", "lengthof(${templateInstance})", false)), new SkeletonTemplateProposal("ischosen", new Template("ischosen", "predefined function", "TTCN3_SOURCE_CODE", "ischosen(${templateInstance})", false)), new SkeletonTemplateProposal("ispresent", new Template("ispresent", "predefined function", "TTCN3_SOURCE_CODE", "ispresent(${templateInstance})", false)), new SkeletonTemplateProposal("rnd", new Template("rnd", "predefined function", "TTCN3_SOURCE_CODE", "rnd(${expression})", false)), new SkeletonTemplateProposal("sizeof", new Template("sizeof", "predefined function", "TTCN3_SOURCE_CODE", "sizeof(${expression})", false))};
    public static final SkeletonTemplateProposal[] CONTROL_PART_FUNCTIONS = new SkeletonTemplateProposal[]{new SkeletonTemplateProposal("execute", new Template("execute", "simple", "TTCN3_SOURCE_CODE", "execute(${tc_testcase}());", false)), new SkeletonTemplateProposal("execute", new Template("execute", "with timeout", "TTCN3_SOURCE_CODE", "execute(${tc_testcase}(),${timeout_value});", false))};
    private static final String MODULE_KEYWORD = "module ";
    private static final String TTCN3_MODULE_HEADER_SKELETON = "/*" + NEWLINE + "//AUTHOR: " + NEWLINE + "//DATE: " + NEWLINE + "//VERSION: " + NEWLINE + "*/" + NEWLINE;
    private static final String TTCN3_MODULE_BODY_SKELETON = "// [.objid{ itu_t(0) identified_organization(4) etsi(0)" + NEWLINE + "// identified_organization(127) ericsson(5) testing(0)" + NEWLINE + "// <put further nodes here if needed>}]" + NEWLINE + "{" + NEWLINE + NEWLINE + "//=========================================================================" + NEWLINE + "// Import Part" + NEWLINE + "//=========================================================================" + NEWLINE + NEWLINE + "// Insert imports here if applicable!" + NEWLINE + "// You can use the import_part skeleton!" + NEWLINE + NEWLINE + "//=========================================================================" + NEWLINE + "// Module Parameters" + NEWLINE + "//=========================================================================" + NEWLINE + NEWLINE + "// Insert module parameters here if applicable!" + NEWLINE + "// You can use the module_param skeleton!" + NEWLINE + NEWLINE + "//=========================================================================" + NEWLINE + "// Data Types" + NEWLINE + "//=========================================================================" + NEWLINE + NEWLINE + "// Insert data type defintions here if applicable!" + NEWLINE + "// You can use the data_type skeleton!" + NEWLINE + NEWLINE + "//=========================================================================" + NEWLINE + "// Signatures" + NEWLINE + "//=========================================================================" + NEWLINE + NEWLINE + "// Insert signature definitions here if applicable!" + NEWLINE + "// You can use the signature skeleton!" + NEWLINE + NEWLINE + "//=========================================================================" + NEWLINE + "//Port Types" + NEWLINE + "//=========================================================================" + NEWLINE + NEWLINE + "// Insert port type defintions here if applicable!" + NEWLINE + "// You can use the port_type skeleton!" + NEWLINE + NEWLINE + "//=========================================================================" + NEWLINE + "//Component Types" + NEWLINE + "//=========================================================================" + NEWLINE + NEWLINE + "// Insert component type defintions here if applicable!" + NEWLINE + "// You can use the component_type skeleton!" + NEWLINE + NEWLINE + "//=========================================================================" + NEWLINE + "// Constants" + NEWLINE + "//=========================================================================" + NEWLINE + NEWLINE + "// Insert constants here if applicable!" + NEWLINE + "// You can use the constant skeleton!" + NEWLINE + NEWLINE + "//=========================================================================" + NEWLINE + "// Templates" + NEWLINE + "//=========================================================================" + NEWLINE + NEWLINE + "// Insert templates here if applicable!" + NEWLINE + "// You can use the template skeleton!" + NEWLINE + NEWLINE + "//=========================================================================" + NEWLINE + "// Altsteps" + NEWLINE + "//=========================================================================" + NEWLINE + NEWLINE + "// Insert altsteps here if applicable!" + NEWLINE + "// You can use the altstep skeleton!" + NEWLINE + NEWLINE + "//=========================================================================" + NEWLINE + "// Functions" + NEWLINE + "//=========================================================================" + NEWLINE + NEWLINE + "// Insert functions here if applicable!" + NEWLINE + "// You can use the function skeleton!" + NEWLINE + NEWLINE + "//=========================================================================" + NEWLINE + "// Testcases" + NEWLINE + "//=========================================================================" + NEWLINE + NEWLINE + "// Insert test cases here if applicable!" + NEWLINE + "// You can use the test_case skeleton!" + NEWLINE + NEWLINE + "//=========================================================================" + NEWLINE + "// Control" + NEWLINE + "//=========================================================================" + NEWLINE + NEWLINE + "// Insert control part here if applicable!" + NEWLINE + NEWLINE + "}  // end of module" + NEWLINE;

    private TTCN3CodeSkeletons() {
    }

    public static void addPredefinedSkeletonProposals(IDocument doc, int offset, ProposalCollector collector) {
        for (SkeletonTemplateProposal templateProposal : PREDEFINED_FUNCTIONS) {
            collector.addTemplateProposal(templateProposal.getPrefix(), templateProposal.getProposal(), SKELETON_IMAGE);
        }
    }

    public static void addSkeletonProposals(IDocument doc, int offset, ProposalCollector collector) {
        for (SkeletonTemplateProposal templateProposal : FORMAL_VALUE_PARAMETER_PROPOSALS) {
            collector.addTemplateProposal(templateProposal.getPrefix(), templateProposal.getProposal(), SKELETON_IMAGE);
        }
        for (SkeletonTemplateProposal templateProposal : FORMAL_TEMPLATE_PARAMETER_PROPOSALS) {
            collector.addTemplateProposal(templateProposal.getPrefix(), templateProposal.getProposal(), SKELETON_IMAGE);
        }
        for (SkeletonTemplateProposal templateProposal : FORMAL_TIMER_PARAMETER_PROPOSALS) {
            collector.addTemplateProposal(templateProposal.getPrefix(), templateProposal.getProposal(), SKELETON_IMAGE);
        }
        for (SkeletonTemplateProposal templateProposal : MODULE_LEVEL_SKELETON_PROPOSALS) {
            collector.addTemplateProposal(templateProposal.getPrefix(), templateProposal.getProposal(), SKELETON_IMAGE);
        }
        for (SkeletonTemplateProposal templateProposal : STATEMENT_LEVEL_SKELETON_PROPOSALS) {
            collector.addTemplateProposal(templateProposal.getPrefix(), templateProposal.getProposal(), SKELETON_IMAGE);
        }
        for (SkeletonTemplateProposal templateProposal : COMPONENT_INTERNAL_SKELETON_TEMPLATE_PROPOSALS) {
            collector.addTemplateProposal(templateProposal.getPrefix(), templateProposal.getProposal(), SKELETON_IMAGE);
        }
    }

    public static String getTTCN3ModuleWithEmptyBody(String moduleName) {
        StringBuilder buffer = new StringBuilder(MODULE_KEYWORD);
        buffer.append(moduleName).append(" {\n\n}\n");
        return buffer.toString();
    }

    public static String getTTCN3ModuleSkeleton(String moduleName) {
        StringBuilder buffer = new StringBuilder(TTCN3_MODULE_HEADER_SKELETON);
        buffer.append(MODULE_KEYWORD).append(moduleName).append(NEWLINE).append(TTCN3_MODULE_BODY_SKELETON);
        return buffer.toString();
    }
}

