/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.finddefinition;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.titan.designer.AST.ASN1.ASN1Assignment;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Altstep;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Const;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_ExternalConst;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Extfunction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_ModulePar;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Testcase;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Timer;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var_Template;
import org.eclipse.titan.designer.preferences.SubscribedBoolean;

public final class StoredDefinitionFilter {
    private static StoredDefinitionFilter instance = null;
    private IProject currentProject;
    private SubscribedBoolean functions = new SubscribedBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.finddef.function", true);
    private SubscribedBoolean types = new SubscribedBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.finddef.types", true);
    private SubscribedBoolean modules = new SubscribedBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.finddef.modules", true);
    private SubscribedBoolean globalVariables = new SubscribedBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.finddef.global", true);
    private SubscribedBoolean workspaceScope = new SubscribedBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.finddef.ws", true);

    private StoredDefinitionFilter(IProject currentProject) {
        this.currentProject = currentProject;
    }

    public static StoredDefinitionFilter getInstance(IProject currentProject) {
        if (instance == null) {
            instance = new StoredDefinitionFilter(currentProject);
        } else {
            StoredDefinitionFilter.instance.currentProject = currentProject;
        }
        return instance;
    }

    public boolean isWorkspaceScope() {
        return (Boolean)this.workspaceScope.getValue();
    }

    public IProject getCurrentProject() {
        return this.currentProject;
    }

    public List<Object> filter(List<Object> obj) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object o : obj) {
            if (!this.filter(o)) continue;
            result.add(o);
        }
        return result;
    }

    public boolean filter(Object obj) {
        if (!((Boolean)this.functions.getValue()).booleanValue() && this.isFunction(obj)) {
            return false;
        }
        if (!((Boolean)this.types.getValue()).booleanValue() && this.isType(obj)) {
            return false;
        }
        if (!((Boolean)this.modules.getValue()).booleanValue() && obj instanceof Module) {
            return false;
        }
        return (Boolean)this.globalVariables.getValue() != false || !this.isGlobalVar(obj);
    }

    private boolean isFunction(Object obj) {
        return obj instanceof Def_Function || obj instanceof Def_Testcase || obj instanceof Def_Altstep || obj instanceof Def_Extfunction;
    }

    private boolean isGlobalVar(Object obj) {
        return obj instanceof Def_Var || obj instanceof Def_Const || obj instanceof Def_Timer || obj instanceof Def_Var_Template || obj instanceof Def_ExternalConst || obj instanceof Def_ModulePar;
    }

    private boolean isType(Object obj) {
        return obj instanceof Def_Type || obj instanceof Def_Template || obj instanceof ASN1Assignment;
    }

    public boolean getFunctions() {
        return (Boolean)this.functions.getValue();
    }

    public void setFunctions(boolean functions) {
        this.functions.setValue(functions);
    }

    public boolean getTypes() {
        return (Boolean)this.types.getValue();
    }

    public void setTypes(boolean types) {
        this.types.setValue(types);
    }

    public boolean getModules() {
        return (Boolean)this.modules.getValue();
    }

    public void setModules(boolean modules) {
        this.modules.setValue(modules);
    }

    public boolean getGlobalVariables() {
        return (Boolean)this.globalVariables.getValue();
    }

    public void setGlobalVariables(boolean globalVariables) {
        this.globalVariables.setValue(globalVariables);
    }

    public boolean getWorkspaceScope() {
        return (Boolean)this.workspaceScope.getValue();
    }

    public void setWorkspaceScope(boolean workspaceScope) {
        this.workspaceScope.setValue(workspaceScope);
    }

    public boolean showOnlyModules() {
        return (Boolean)this.modules.getValue() != false && (Boolean)this.functions.getValue() == false && (Boolean)this.globalVariables.getValue() == false && (Boolean)this.types.getValue() == false;
    }
}

