/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.license;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.license.Base64Decoder;
import org.eclipse.titan.designer.license.TITANDSAPublicKey;

public final class License {
    private static final String LICENSE_HEADER = "BEGIN TTCN-3 LICENSE FILE";
    private static final String LICENSE_FOOTER = "END TTCN-3 LICENSE FILE";
    private static final int LIMIT_HOST = 1;
    private static final int LIMIT_USER = 2;
    private File licenseFile;
    private byte[] rawData;
    private int uniqueID;
    private String licenseeName;
    private String licenseeEmail;
    private String licenseeCompany;
    private String licenseeDepartment;
    private Date validFrom;
    private Date validUntil;
    private int hostID;
    private String loginName;
    private int[] versionFrom = new int[3];
    private int[] versionTo = new int[3];
    private List<String> languageList = new ArrayList<String>();
    private List<String> encoderList = new ArrayList<String>();
    private List<String> applicationList = new ArrayList<String>();
    private String limitationType = "N/A";
    private int maxPTCs;
    private boolean isValid = false;

    public License(String licenseFile) {
        this.licenseFile = new File(licenseFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        byte[] array;
        FileReader fr = null;
        BufferedReader br = null;
        try {
            fr = new FileReader(this.licenseFile);
            br = new BufferedReader(fr);
            String tempLine = br.readLine();
            while (tempLine != null && !tempLine.contains(LICENSE_HEADER)) {
                tempLine = br.readLine();
            }
            StringBuilder licenseContents = new StringBuilder(400);
            while (tempLine != null && !tempLine.contains(LICENSE_FOOTER)) {
                tempLine = br.readLine();
                licenseContents.append(tempLine);
            }
            array = licenseContents.toString().getBytes();
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            return;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
            }
        }
        if (array.length == 0) {
            return;
        }
        this.rawData = Base64Decoder.decode(array);
        this.isValid = this.checkLicense();
        if (!this.isValid) {
            return;
        }
        byte[] tempUniqueID = new byte[4];
        System.arraycopy(this.rawData, 0, tempUniqueID, 0, 4);
        this.uniqueID = this.createInt(tempUniqueID);
        byte[] tempLicenseeName = new byte[48];
        System.arraycopy(this.rawData, 4, tempLicenseeName, 0, 48);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 48; ++i) {
            char ch = (char)this.unsignedByteToInt(tempLicenseeName[i]);
            if (ch == '\u0000') continue;
            sb.append(ch);
        }
        this.licenseeName = sb.toString();
        byte[] tempLicenseeEmail = new byte[48];
        System.arraycopy(this.rawData, 52, tempLicenseeEmail, 0, 48);
        sb = new StringBuilder();
        for (int i = 0; i < 48; ++i) {
            char ch = (char)this.unsignedByteToInt(tempLicenseeEmail[i]);
            if (ch == '\u0000') continue;
            sb.append(ch);
        }
        this.licenseeEmail = sb.toString();
        byte[] tempLicenseeCompany = new byte[48];
        System.arraycopy(this.rawData, 100, tempLicenseeCompany, 0, 48);
        sb = new StringBuilder();
        for (int i = 0; i < 48; ++i) {
            char ch = (char)this.unsignedByteToInt(tempLicenseeCompany[i]);
            if (ch == '\u0000') continue;
            sb.append(ch);
        }
        this.licenseeCompany = sb.toString();
        byte[] tempLicenseeDepartment = new byte[16];
        System.arraycopy(this.rawData, 148, tempLicenseeDepartment, 0, 16);
        sb = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            char ch = (char)this.unsignedByteToInt(tempLicenseeDepartment[i]);
            if (ch == '\u0000') continue;
            sb.append(ch);
        }
        this.licenseeDepartment = sb.toString();
        byte[] tempValidFrom = new byte[4];
        System.arraycopy(this.rawData, 164, tempValidFrom, 0, 4);
        this.validFrom = new Date((long)this.createInt(tempValidFrom) * 1000L);
        byte[] tempValidUntil = new byte[4];
        System.arraycopy(this.rawData, 168, tempValidUntil, 0, 4);
        this.validUntil = new Date((long)this.createInt(tempValidUntil) * 1000L);
        byte[] tempHostID = new byte[4];
        System.arraycopy(this.rawData, 172, tempHostID, 0, 4);
        this.hostID = this.createInt(tempHostID);
        byte[] tempLoginName = new byte[8];
        System.arraycopy(this.rawData, 176, tempLoginName, 0, 8);
        sb = new StringBuilder();
        for (int i = 0; i < 8; ++i) {
            char ch = (char)this.unsignedByteToInt(tempLoginName[i]);
            if (ch == '\u0000') continue;
            sb.append(ch);
        }
        this.loginName = sb.toString();
        byte[] from = new byte[4];
        System.arraycopy(this.rawData, 184, from, 0, 4);
        this.versionFrom[0] = this.createInt(from);
        System.arraycopy(this.rawData, 188, from, 0, 4);
        this.versionFrom[1] = this.createInt(from);
        System.arraycopy(this.rawData, 192, from, 0, 4);
        this.versionFrom[2] = this.createInt(from);
        byte[] to = new byte[4];
        System.arraycopy(this.rawData, 196, to, 0, 4);
        this.versionTo[0] = this.createInt(to);
        System.arraycopy(this.rawData, 200, to, 0, 4);
        this.versionTo[1] = this.createInt(to);
        System.arraycopy(this.rawData, 204, to, 0, 4);
        this.versionTo[2] = this.createInt(to);
        byte[] temp = new byte[4];
        System.arraycopy(this.rawData, 208, temp, 0, 4);
        int features = this.createInt(temp);
        if ((features & Feature.TTCN3.value()) == Feature.TTCN3.value()) {
            this.languageList.add(Feature.TTCN3.text());
        }
        if ((features & Feature.ASN1.value()) == Feature.ASN1.value()) {
            this.languageList.add(Feature.ASN1.text());
        }
        if ((features & Feature.RAW.value()) == Feature.RAW.value()) {
            this.encoderList.add(Feature.RAW.text());
        }
        if ((features & Feature.TEXT.value()) == Feature.TEXT.value()) {
            this.encoderList.add(Feature.TEXT.text());
        }
        if ((features & Feature.BER.value()) == Feature.BER.value()) {
            this.encoderList.add(Feature.BER.text());
        }
        if ((features & Feature.PER.value()) == Feature.PER.value()) {
            this.encoderList.add(Feature.PER.text());
        }
        if ((features & Feature.XER.value()) == Feature.XER.value()) {
            this.encoderList.add(Feature.XER.text());
        }
        if ((features & Feature.CODEGEN.value()) == Feature.CODEGEN.value()) {
            this.applicationList.add(Feature.CODEGEN.text());
        }
        if ((features & Feature.TPGEN.value()) == Feature.TPGEN.value()) {
            this.applicationList.add(Feature.TPGEN.text());
        }
        if ((features & Feature.SINGLE.value()) == Feature.SINGLE.value()) {
            this.applicationList.add(Feature.SINGLE.text());
        }
        if ((features & Feature.MCTR.value()) == Feature.MCTR.value()) {
            this.applicationList.add(Feature.MCTR.text());
        }
        if ((features & Feature.HC.value()) == Feature.HC.value()) {
            this.applicationList.add(Feature.HC.text());
        }
        if ((features & Feature.LOGFORMAT.value()) == Feature.LOGFORMAT.value()) {
            this.applicationList.add(Feature.LOGFORMAT.text());
        }
        if ((features & Feature.GUI.value()) == Feature.GUI.value()) {
            this.applicationList.add(Feature.GUI.text());
        }
        System.arraycopy(this.rawData, 212, temp, 0, 4);
        int limitations = this.createInt(temp);
        if ((limitations & 1) == 1) {
            this.limitationType = "HOST";
        } else if ((limitations & 2) == 2) {
            this.limitationType = "USER";
        }
        System.arraycopy(this.rawData, 216, temp, 0, 4);
        this.maxPTCs = this.createInt(temp);
    }

    private boolean checkLicense() {
        byte[] message = new byte[220];
        System.arraycopy(this.rawData, 0, message, 0, 220);
        byte[] dsaSignature = new byte[48];
        System.arraycopy(this.rawData, 220, dsaSignature, 0, 48);
        boolean result = false;
        Signature dsa = null;
        try {
            dsa = Signature.getInstance("DSA");
            dsa.initVerify(new TITANDSAPublicKey());
        }
        catch (NoSuchAlgorithmException e) {
            ErrorReporter.logExceptionStackTrace((String)"DSA algorithm is not known by Java", (Throwable)e);
            return false;
        }
        catch (InvalidKeyException e) {
            ErrorReporter.logExceptionStackTrace((String)"TITAN public key is invalid", (Throwable)e);
            return false;
        }
        try {
            dsa.update(message);
            result = dsa.verify(dsaSignature);
        }
        catch (SignatureException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        return result;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public int getUniqueID() {
        return this.uniqueID;
    }

    public String getLicenseeName() {
        return this.licenseeName;
    }

    public String getLicenseeEmail() {
        return this.licenseeEmail;
    }

    public String getLicenseeCompany() {
        return this.licenseeCompany;
    }

    public String getLicenseeDepartment() {
        return this.licenseeDepartment;
    }

    public Date getValidFrom() {
        return (Date)this.validFrom.clone();
    }

    public Date getValidUntil() {
        return (Date)this.validUntil.clone();
    }

    public int getHostID() {
        return this.hostID;
    }

    public String getLoginName() {
        return this.loginName;
    }

    public int[] getVersionFrom() {
        return (int[])this.versionFrom.clone();
    }

    public int[] getVersionTo() {
        return (int[])this.versionTo.clone();
    }

    public List<String> getLanguageList() {
        return this.languageList;
    }

    public List<String> getEncoderList() {
        return this.encoderList;
    }

    public List<String> getApplicationList() {
        return this.applicationList;
    }

    public String getLimitationType() {
        return this.limitationType;
    }

    public int getMaxPTCs() {
        return this.maxPTCs;
    }

    public int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    public int createInt(byte[] number) {
        if (number.length != 4) {
            return -1;
        }
        return (this.unsignedByteToInt(number[0]) << 24) + (this.unsignedByteToInt(number[1]) << 16) + (this.unsignedByteToInt(number[2]) << 8) + this.unsignedByteToInt(number[3]);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(300);
        builder.append("Unique ID\t: ").append(this.getUniqueID()).append('\n');
        builder.append("Licensee\t: ").append(this.getLicenseeName()).append('\n');
        builder.append("E-mail\t\t: ").append(this.getLicenseeEmail()).append('\n');
        builder.append("Company\t: ").append(this.getLicenseeCompany()).append('\n');
        builder.append("Department\t: ").append(this.getLicenseeDepartment()).append('\n');
        SimpleDateFormat dFormat = new SimpleDateFormat("yyyy-MM-dd E HH:mm:ss z");
        dFormat.setTimeZone(TimeZone.getTimeZone("GMT+2"));
        builder.append("Valid from\t: ").append(dFormat.format(this.getValidFrom())).append('\n');
        builder.append("Valid until\t: ").append(dFormat.format(this.getValidUntil())).append('\n');
        builder.append("Limitation\t: ").append(this.getLimitationType()).append('\n');
        builder.append("Host ID\t: ").append(this.getHostID()).append('\n');
        builder.append("Login name\t: ").append(this.getLoginName()).append('\n');
        int[] from = this.getVersionFrom();
        int[] until = this.getVersionTo();
        builder.append("Versions\t: from ").append(from[0]).append('.').append(from[1]).append(".pl").append(from[2]);
        builder.append(" until ").append(until[0]).append('.').append(until[1]).append(".pl").append(until[2]).append('\n');
        builder.append("Languages\t:");
        for (String temp : this.getLanguageList()) {
            builder.append(' ').append(temp);
        }
        builder.append('\n');
        builder.append("Encoders\t:");
        for (String temp : this.getEncoderList()) {
            builder.append(' ').append(temp);
        }
        builder.append('\n');
        builder.append("Applications\t:");
        for (String temp : this.getApplicationList()) {
            builder.append(' ').append(temp);
        }
        builder.append('\n');
        builder.append("Max PTCs\t: ").append(this.getMaxPTCs()).append('\n');
        return builder.toString();
    }

    public static boolean isLicenseNeeded() {
        return false;
    }

    private static enum Feature {
        TTCN3("TTCN3", 1),
        CODEGEN("CODEGEN", 2),
        TPGEN("TPGEN", 4),
        SINGLE("SINGLE", 8),
        MCTR("MCTR", 16),
        HC("HC", 32),
        LOGFORMAT("LOGFORMAT", 64),
        ASN1("ASN1", 128),
        RAW("RAW", 256),
        BER("BER", 512),
        PER("PER", 1024),
        GUI("GUI", 2048),
        TEXT("TEXT", 4096),
        XER("XER", 8192);

        private final int value;
        private final String text;

        private Feature(String text, int value) {
            this.text = text;
            this.value = value;
        }

        public String text() {
            return this.text;
        }

        public int value() {
            return this.value;
        }
    }
}

