/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.parsers;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.TITANMarker;
import org.eclipse.titan.designer.AST.ASN1.Ass_pard;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.MarkerHandler;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ModuleImportationChain;
import org.eclipse.titan.designer.AST.brokenpartsanalyzers.BrokenPartsChecker;
import org.eclipse.titan.designer.AST.brokenpartsanalyzers.BrokenPartsViaReferences;
import org.eclipse.titan.designer.AST.brokenpartsanalyzers.SelectionAlgorithm;
import org.eclipse.titan.designer.AST.brokenpartsanalyzers.SelectionMethodBase;
import org.eclipse.titan.designer.OutOfMemoryCheck;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.core.TITANNature;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.GlobalProjectStructureTracker;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titan.designer.parsers.ProjectSourceSyntacticAnalyzer;
import org.eclipse.titan.designer.parsers.ProjectStructureDataCollector;
import org.eclipse.ui.console.MessageConsoleStream;

public class ProjectSourceSemanticAnalyzer {
    private static final String DUPLICATEMODULE = "Modules must be unique, but `{0}'' was declared multiple times";
    public static final String CIRCULARIMPORTCHAIN = "Circular import chain is not recommended: {0}";
    private final ProjectSourceParser sourceParser;
    private Map<IFile, Module> fileModuleMap;
    private Map<String, Module> moduleMap;
    private Map<String, Module> outdatedModuleMap;
    private Set<String> semanticallyUptodateModules;

    public ProjectSourceSemanticAnalyzer(ProjectSourceParser sourceParser) {
        this.sourceParser = sourceParser;
        this.fileModuleMap = new ConcurrentHashMap<IFile, Module>();
        this.moduleMap = new ConcurrentHashMap<String, Module>();
        this.outdatedModuleMap = new HashMap<String, Module>();
        this.semanticallyUptodateModules = new HashSet<String>();
    }

    public boolean isOutdated(IFile file) {
        Module module = this.fileModuleMap.get(file);
        return module == null || !this.semanticallyUptodateModules.contains(module.getName());
    }

    Module internalGetModuleByName(String name, boolean uptodateOnly) {
        if (this.moduleMap.containsKey(name)) {
            return this.moduleMap.get(name);
        }
        if (!uptodateOnly && this.outdatedModuleMap.containsKey(name)) {
            return this.outdatedModuleMap.get(name);
        }
        return null;
    }

    Set<String> internalGetKnownModuleNames() {
        HashSet<String> temp = new HashSet<String>();
        temp.addAll(this.moduleMap.keySet());
        return temp;
    }

    Collection<Module> internalGetModules() {
        return this.moduleMap.values();
    }

    Module getModulebyFile(IFile file) {
        return this.fileModuleMap.get(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportOutdating(IFile outdatedFile, boolean useOnTheFlyParsing) {
        if (!useOnTheFlyParsing) {
            return;
        }
        Module module = this.fileModuleMap.get(outdatedFile);
        if (module == null) {
            return;
        }
        IResource moduleFile = module.getIdentifier().getLocation().getFile();
        if (!outdatedFile.equals(moduleFile)) {
            return;
        }
        String moduleName = module.getName();
        this.moduleMap.remove(moduleName);
        this.fileModuleMap.remove(moduleFile);
        Object object = this.outdatedModuleMap;
        synchronized (object) {
            this.outdatedModuleMap.put(moduleName, module);
        }
        object = this.semanticallyUptodateModules;
        synchronized (object) {
            this.semanticallyUptodateModules.remove(moduleName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportSemanticOutdating(IFile outdatedFile) {
        Module module = this.fileModuleMap.get(outdatedFile);
        if (module != null) {
            Set<String> set = this.semanticallyUptodateModules;
            synchronized (set) {
                this.semanticallyUptodateModules.remove(module.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearSemanticInformation() {
        Set<String> set = this.semanticallyUptodateModules;
        synchronized (set) {
            this.semanticallyUptodateModules.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removedReferencestoRemovedFiles(IFile file, String moduleName) {
        Object object = this.semanticallyUptodateModules;
        synchronized (object) {
            this.semanticallyUptodateModules.remove(moduleName);
        }
        this.moduleMap.remove(moduleName);
        this.fileModuleMap.remove(file);
        object = this.outdatedModuleMap;
        synchronized (object) {
            this.outdatedModuleMap.remove(moduleName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeModule(String moduleName) {
        Module module = this.internalGetModuleByName(moduleName, false);
        if (module == null) {
            return;
        }
        this.fileModuleMap.remove(module.getLocation().getFile());
        Map<String, Module> map = this.outdatedModuleMap;
        synchronized (map) {
            this.outdatedModuleMap.remove(moduleName);
        }
        this.moduleMap.remove(moduleName);
    }

    public void addModule(Module module) {
        this.fileModuleMap.put((IFile)module.getLocation().getFile(), module);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IStatus analyzeMultipleProjectsSemantically(List<IProject> tobeSemanticallyAnalyzed, IProgressMonitor monitor, CompilationTimeStamp compilationCounter) {
        for (int i = 0; i < tobeSemanticallyAnalyzed.size(); ++i) {
            if (tobeSemanticallyAnalyzed.get(i).isAccessible() && TITANNature.hasTITANNature(tobeSemanticallyAnalyzed.get(i))) continue;
            return Status.CANCEL_STATUS;
        }
        long semanticCheckStart = System.nanoTime();
        IPreferencesService preferenceService = Platform.getPreferencesService();
        for (int i = 0; i < tobeSemanticallyAnalyzed.size(); ++i) {
            ProjectSourceSemanticAnalyzer semanticAnalyzer = GlobalParser.getProjectSourceParser(tobeSemanticallyAnalyzed.get(i)).getSemanticAnalyzer();
            Map<String, Module> map = semanticAnalyzer.outdatedModuleMap;
            synchronized (map) {
                semanticAnalyzer.outdatedModuleMap.clear();
            }
            semanticAnalyzer.moduleMap.clear();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        progress.setTaskName("On-the-fly semantic checking of everything ");
        progress.subTask("Checking the importations of the modules");
        try {
            String option = preferenceService.getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportUnsupportedConstructs", "warning", null);
            for (int i = 0; i < tobeSemanticallyAnalyzed.size(); ++i) {
                ProjectSourceSyntacticAnalyzer syntacticAnalyzer = GlobalParser.getProjectSourceParser(tobeSemanticallyAnalyzed.get(i)).getSyntacticAnalyzer();
                for (IFile file : syntacticAnalyzer.unsupportedConstructMap.keySet()) {
                    List<TITANMarker> markers = syntacticAnalyzer.unsupportedConstructMap.get(file);
                    if (markers == null || !file.isAccessible()) continue;
                    for (TITANMarker marker : markers) {
                        Location location = new Location((IResource)file, marker.getLine(), marker.getOffset(), marker.getEndOffset());
                        location.reportConfigurableSemanticProblem(option, marker.getMessage());
                    }
                }
            }
            Ass_pard.resetAllInstanceCounters();
            HashMap<String, Module> uniqueModules = new HashMap<String, Module>();
            HashSet<String> duplicatedModules = new HashSet<String>();
            ArrayList<Module> allModules = new ArrayList<Module>();
            ArrayList<String> semanticallyChecked = new ArrayList<String>();
            for (int i = 0; i < tobeSemanticallyAnalyzed.size(); ++i) {
                ProjectSourceSemanticAnalyzer semanticAnalyzer = GlobalParser.getProjectSourceParser(tobeSemanticallyAnalyzed.get(i)).getSemanticAnalyzer();
                for (Module module : semanticAnalyzer.fileModuleMap.values()) {
                    String name = module.getIdentifier().getName();
                    allModules.add(module);
                    if (uniqueModules.containsKey(name)) {
                        Location location = ((Module)uniqueModules.get(name)).getIdentifier().getLocation();
                        Location location2 = module.getIdentifier().getLocation();
                        location.reportSemanticError(MessageFormat.format(DUPLICATEMODULE, module.getIdentifier().getDisplayName()));
                        location2.reportSemanticError(MessageFormat.format(DUPLICATEMODULE, module.getIdentifier().getDisplayName()));
                        duplicatedModules.add(name);
                        semanticAnalyzer.semanticallyUptodateModules.remove(name);
                        continue;
                    }
                    uniqueModules.put(name, module);
                    semanticAnalyzer.moduleMap.put(name, module);
                    if (!semanticAnalyzer.semanticallyUptodateModules.contains(name)) continue;
                    semanticallyChecked.add(name);
                }
            }
            int nofModulesTobeChecked = 0;
            if (allModules.size() > semanticallyChecked.size()) {
                ModuleImportationChain referenceChain = new ModuleImportationChain(CIRCULARIMPORTCHAIN, false);
                for (Module module : allModules) {
                    module.checkImports(compilationCounter, referenceChain, new ArrayList<Module>());
                    referenceChain.clear();
                }
                progress.subTask("Calculating the list of modules to be checked");
                BrokenPartsViaReferences selectionMethod = new BrokenPartsViaReferences(SelectionAlgorithm.BROKENREFERENCESINVERTED, compilationCounter);
                SelectionMethodBase selectionMethodBase = selectionMethod;
                selectionMethodBase.setModules(allModules, semanticallyChecked);
                selectionMethod.execute();
                if (OutOfMemoryCheck.isOutOfMemory()) {
                    OutOfMemoryCheck.outOfMemoryEvent();
                    return Status.CANCEL_STATUS;
                }
                BrokenPartsChecker brokenPartsChecker = new BrokenPartsChecker(progress.newChild(1), compilationCounter, selectionMethodBase);
                brokenPartsChecker.doChecking();
                for (Module module2 : selectionMethodBase.getModulesToSkip()) {
                    MarkerHandler.reEnableAllMarkers((IFile)module2.getLocation().getFile());
                }
                nofModulesTobeChecked = selectionMethodBase.getModulesToCheck().size();
            } else {
                for (Module module2 : allModules) {
                    MarkerHandler.reEnableAllMarkers((IFile)module2.getLocation().getFile());
                }
            }
            if (preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null)) {
                MessageConsoleStream stream = TITANDebugConsole.getConsole().newMessageStream();
                TITANDebugConsole.println("  ** Had to start checking at " + nofModulesTobeChecked + " modules. ", stream);
                TITANDebugConsole.println("  **On-the-fly semantic checking of projects (" + allModules.size() + " modules) took " + (double)(System.nanoTime() - semanticCheckStart) * 1.0E-9 + " seconds", stream);
            }
            progress.subTask("Cleanup operations");
            for (int i = 0; i < tobeSemanticallyAnalyzed.size(); ++i) {
                ProjectSourceSemanticAnalyzer semanticAnalyzer = GlobalParser.getProjectSourceParser(tobeSemanticallyAnalyzed.get(i)).getSemanticAnalyzer();
                Set<String> set = semanticAnalyzer.semanticallyUptodateModules;
                synchronized (set) {
                    semanticAnalyzer.semanticallyUptodateModules.clear();
                    semanticAnalyzer.semanticallyUptodateModules.addAll(semanticAnalyzer.moduleMap.keySet());
                    for (String name : duplicatedModules) {
                        semanticAnalyzer.semanticallyUptodateModules.remove(name);
                    }
                    continue;
                }
            }
        }
        catch (Exception e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        progress.done();
        for (int i = 0; i < tobeSemanticallyAnalyzed.size(); ++i) {
            GlobalParser.getProjectSourceParser(tobeSemanticallyAnalyzed.get(i)).setLastTimeChecked(compilationCounter);
            ProjectStructureDataCollector collector = GlobalProjectStructureTracker.getDataCollector(tobeSemanticallyAnalyzed.get(i));
            for (Module module : GlobalParser.getProjectSourceParser((IProject)tobeSemanticallyAnalyzed.get((int)i)).getSemanticAnalyzer().moduleMap.values()) {
                collector.addKnownModule(module.getIdentifier());
                module.extractStructuralInformation(collector);
            }
            MarkerHandler.removeAllOnTheFlyMarkedMarkers((IResource)tobeSemanticallyAnalyzed.get(i));
        }
        return Status.OK_STATUS;
    }
}

