/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.parsers.ttcn3parser;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BufferedTokenStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenFactory;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenFactory;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.UnbufferedCharStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.SyntacticErrorStorage;
import org.eclipse.titan.common.parsers.TITANMarker;
import org.eclipse.titan.common.parsers.TitanListener;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.MarkerHandler;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.parsers.ParserMarkerSupport;
import org.eclipse.titan.designer.parsers.ttcn3parser.ITTCN3ReparseBase;
import org.eclipse.titan.designer.parsers.ttcn3parser.Ttcn3Lexer;
import org.eclipse.titan.designer.parsers.ttcn3parser.Ttcn3Reparser;

public final class TTCN3ReparseUpdater {
    private List<SyntacticErrorStorage> mErrors;
    private List<TITANMarker> warnings;
    private List<TITANMarker> unsupportedConstructs;
    private Map<IFile, List<TITANMarker>> unsupportedConstructMap;
    private final IFile file;
    private final String code;
    private int firstLine;
    private int lineShift;
    private int modificationStartOffset;
    private int modificationEndOffset;
    private int shift;
    private boolean namechanged = false;

    public TTCN3ReparseUpdater(IFile file, String code, int firstLine, int lineShift, int startOffset, int endOffset, int shift) {
        this.file = file;
        this.code = code;
        this.firstLine = firstLine;
        this.lineShift = lineShift;
        this.modificationStartOffset = startOffset;
        this.modificationEndOffset = endOffset;
        this.shift = shift;
        this.unsupportedConstructs = new ArrayList<TITANMarker>();
        this.unsupportedConstructMap = new ConcurrentHashMap<IFile, List<TITANMarker>>();
    }

    public void setUnsupportedConstructs(Map<IFile, List<TITANMarker>> unsupportedConstructMap) {
        this.unsupportedConstructMap = unsupportedConstructMap;
        if (unsupportedConstructMap.containsKey(this.file)) {
            this.unsupportedConstructs = unsupportedConstructMap.get(this.file);
        }
    }

    public final int getDamageStart() {
        return this.modificationStartOffset;
    }

    public final int getDamageEnd() {
        return this.modificationEndOffset;
    }

    public final int getFirstLine() {
        return this.firstLine;
    }

    public final int getLineShift() {
        return this.lineShift;
    }

    public final int getShift() {
        return this.shift;
    }

    public final boolean isAffected(Location location) {
        return location.getEndOffset() > this.modificationStartOffset;
    }

    public final boolean isAffectedAppended(Location location) {
        return location.getEndOffset() >= this.modificationStartOffset;
    }

    public final boolean envelopsDamage(Location location) {
        return location.getOffset() < this.modificationStartOffset && location.getEndOffset() > this.modificationEndOffset;
    }

    public final boolean isDamaged(Location location) {
        if (location.getEndOffset() < this.modificationStartOffset) {
            return false;
        }
        return location.getOffset() <= this.modificationEndOffset;
    }

    public final boolean isExtending(Location location) {
        return location.getEndOffset() == this.modificationStartOffset;
    }

    public final void updateLocation(Location location) {
        int line;
        if (NULL_Location.INSTANCE == location) {
            return;
        }
        int offset = location.getOffset();
        if (offset >= this.modificationStartOffset) {
            location.setOffset(Math.max(offset + this.shift, this.modificationStartOffset));
        }
        if ((offset = location.getEndOffset()) > this.modificationStartOffset) {
            location.setEndOffset(Math.max(offset + this.shift, this.modificationStartOffset));
        }
        if ((line = location.getLine()) > this.firstLine) {
            location.setLine(line + this.lineShift);
        } else if (line == this.firstLine && offset > this.modificationStartOffset) {
            location.setLine(line + this.lineShift);
        }
    }

    public boolean startsWithFollow(List<Integer> followSet) {
        if (followSet == null || followSet.isEmpty()) {
            return false;
        }
        if (this.code == null) {
            return false;
        }
        int line = TTCN3ReparseUpdater.getLineOfOfset(this.code, this.modificationStartOffset);
        int column = TTCN3ReparseUpdater.getPositionInLine(this.code, this.modificationStartOffset);
        String substring = this.code.length() <= this.modificationEndOffset + this.shift ? this.code.substring(this.modificationStartOffset) : this.code.substring(this.modificationStartOffset, this.modificationEndOffset + this.shift);
        StringReader reader = new StringReader(substring);
        UnbufferedCharStream charStream = new UnbufferedCharStream((Reader)reader);
        Ttcn3Lexer lexer = new Ttcn3Lexer((CharStream)charStream);
        lexer.setTokenFactory((TokenFactory)new CommonTokenFactory(true));
        lexer.setLine(line + 1);
        lexer.setCharPositionInLine(column);
        lexer.initRootInterval(this.modificationEndOffset - this.modificationStartOffset + 1);
        Token token = lexer.nextToken();
        if (token == null) {
            return false;
        }
        return followSet.contains(token.getType());
    }

    public boolean endsWithToken(List<Integer> followSet) {
        if (followSet == null || followSet.isEmpty()) {
            return false;
        }
        if (this.code == null) {
            return false;
        }
        int line = TTCN3ReparseUpdater.getLineOfOfset(this.code, this.modificationStartOffset);
        int column = TTCN3ReparseUpdater.getPositionInLine(this.code, this.modificationStartOffset);
        String substring = this.code.length() <= this.modificationEndOffset + this.shift ? this.code.substring(this.modificationStartOffset) : this.code.substring(this.modificationStartOffset, this.modificationEndOffset + this.shift);
        StringReader reader = new StringReader(substring);
        UnbufferedCharStream charStream = new UnbufferedCharStream((Reader)reader);
        Ttcn3Lexer lexer = new Ttcn3Lexer((CharStream)charStream);
        lexer.setTokenFactory((TokenFactory)new CommonTokenFactory(true));
        lexer.setLine(line + 1);
        lexer.setCharPositionInLine(column);
        lexer.initRootInterval(this.modificationEndOffset - this.modificationStartOffset + 1);
        Token token = lexer.nextToken();
        if (token == null) {
            return false;
        }
        return followSet.contains(token.getType());
    }

    public final void extendDamagedRegion(Location location) {
        if (location.getOffset() < this.modificationStartOffset) {
            this.modificationStartOffset = location.getOffset();
        }
        if (location.getEndOffset() > this.modificationEndOffset) {
            this.modificationEndOffset = location.getEndOffset();
        }
    }

    public final void extendDamagedRegion(int start, int end) {
        if (start < this.modificationStartOffset) {
            this.modificationStartOffset = start;
        }
        if (end > this.modificationEndOffset) {
            this.modificationEndOffset = end;
        }
    }

    public final void extendDamagedRegionTillFileEnd() {
        this.modificationEndOffset = this.code.length() - this.shift;
    }

    public final void maxDamage() {
        this.modificationStartOffset = 0;
        this.modificationEndOffset = this.code.length() - this.shift;
    }

    public void setNameChanged(boolean namechanged) {
        this.namechanged = namechanged;
    }

    public boolean getNameChanged() {
        return this.namechanged;
    }

    protected int measureIntervallDamage() {
        String substring = this.code.length() <= this.modificationEndOffset + this.shift ? this.code.substring(this.modificationStartOffset) : this.code.substring(this.modificationStartOffset, this.modificationEndOffset + this.shift);
        int rangeEnd = substring.length();
        boolean insideString = false;
        boolean insideSingleComment = false;
        boolean insideMultiComment = false;
        Stack<String> elements = new Stack<String>();
        int unclosedStarting = 0;
        int unclosedEnding = 0;
        try {
            block17: for (int nextPos = 0; nextPos < rangeEnd; ++nextPos) {
                switch (substring.charAt(nextPos)) {
                    case '(': {
                        elements.push("(");
                        ++unclosedStarting;
                        continue block17;
                    }
                    case ')': {
                        if (!elements.isEmpty() && "(".equals(elements.peek())) {
                            elements.pop();
                            --unclosedStarting;
                            continue block17;
                        }
                        elements.push(")");
                        ++unclosedEnding;
                        continue block17;
                    }
                    case '[': {
                        elements.push("[");
                        ++unclosedStarting;
                        continue block17;
                    }
                    case ']': {
                        if (!elements.isEmpty() && "[".equals(elements.peek())) {
                            elements.pop();
                            --unclosedStarting;
                            continue block17;
                        }
                        elements.push("]");
                        ++unclosedEnding;
                        continue block17;
                    }
                    case '{': {
                        elements.push("{");
                        ++unclosedStarting;
                        continue block17;
                    }
                    case '}': {
                        if (!elements.isEmpty() && "{".equals(elements.peek())) {
                            elements.pop();
                            --unclosedStarting;
                            continue block17;
                        }
                        elements.push("}");
                        ++unclosedEnding;
                        continue block17;
                    }
                    case '/': {
                        if (nextPos + 1 >= rangeEnd) continue block17;
                        switch (substring.charAt(nextPos + 1)) {
                            case '*': {
                                insideMultiComment = true;
                                nextPos += 2;
                                while (nextPos < rangeEnd && ('*' != substring.charAt(nextPos) || nextPos + 1 >= rangeEnd || '/' != substring.charAt(nextPos + 1))) {
                                    ++nextPos;
                                }
                                if (nextPos < rangeEnd) {
                                    insideMultiComment = false;
                                    continue block17;
                                }
                                ++nextPos;
                                continue block17;
                            }
                            case '/': {
                                insideSingleComment = true;
                                nextPos += 2;
                                while (nextPos < rangeEnd && '\n' != substring.charAt(nextPos)) {
                                    ++nextPos;
                                }
                                if (nextPos >= rangeEnd) continue block17;
                                insideSingleComment = false;
                                continue block17;
                            }
                        }
                        continue block17;
                    }
                    case '\"': {
                        insideString = true;
                        ++nextPos;
                        while (nextPos < rangeEnd && ('\"' != substring.charAt(nextPos) || '\"' == substring.charAt(nextPos - 1))) {
                            if ('\"' != substring.charAt(nextPos)) {
                                ++nextPos;
                                continue;
                            }
                            if (nextPos + 1 >= rangeEnd || '\"' != substring.charAt(nextPos + 1)) break;
                            nextPos += 2;
                        }
                        if (nextPos >= rangeEnd) continue block17;
                        insideString = false;
                        continue block17;
                    }
                    case '#': {
                        insideSingleComment = true;
                        ++nextPos;
                        while (nextPos < rangeEnd && '\n' != substring.charAt(nextPos)) {
                            ++nextPos;
                        }
                        if (nextPos >= rangeEnd) continue block17;
                        insideSingleComment = false;
                        continue block17;
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        if (insideSingleComment || insideMultiComment || insideString) {
            return Integer.MAX_VALUE;
        }
        return Math.max(unclosedStarting, unclosedEnding);
    }

    private void reportSpecificSyntaxErrors() {
        if (this.mErrors != null) {
            Location temp = new Location((IResource)this.file, this.firstLine, this.modificationStartOffset, this.modificationEndOffset + this.shift);
            for (int i = 0; i < this.mErrors.size(); ++i) {
                ParserMarkerSupport.createOnTheFlySyntacticMarker(this.file, this.mErrors.get(i), 2, temp);
            }
        }
    }

    public final void reportSyntaxErrors() {
        this.reportSpecificSyntaxErrors();
        if (this.warnings != null) {
            for (TITANMarker marker : this.warnings) {
                if (!this.file.isAccessible()) continue;
                Location location = new Location((IResource)this.file, marker.getLine(), marker.getOffset(), marker.getEndOffset());
                location.reportExternalProblem(marker.getMessage(), marker.getSeverity(), "org.eclipse.titan.designer.ontheflySyntacticMarker");
            }
        }
        if (this.unsupportedConstructs != null && !this.unsupportedConstructs.isEmpty()) {
            for (TITANMarker marker : this.unsupportedConstructs) {
                if (marker.getOffset() < this.modificationEndOffset) continue;
                marker.setOffset(marker.getOffset() + this.shift);
                marker.setEndOffset(marker.getEndOffset() + this.shift);
            }
            this.unsupportedConstructMap.put(this.file, this.unsupportedConstructs);
        }
    }

    public static final int getLineOfOfset(String text, int offset) {
        int lineCounter = 0;
        for (int i = 0; i < offset; ++i) {
            if ('\n' != text.charAt(i)) continue;
            ++lineCounter;
        }
        return lineCounter;
    }

    public static final int getPositionInLine(String text, int offset) {
        int columnCounter = 0;
        for (int i = offset - 1; i > 0; --i) {
            if ('\n' == text.charAt(i)) {
                return columnCounter;
            }
            ++columnCounter;
        }
        return columnCounter;
    }

    public int parse(ITTCN3ReparseBase userDefined) {
        if (this.modificationStartOffset == this.modificationEndOffset + this.shift) {
            return 0;
        }
        this.mErrors = null;
        this.warnings = null;
        Iterator<TITANMarker> iterator = this.unsupportedConstructs.iterator();
        while (iterator.hasNext()) {
            TITANMarker marker = iterator.next();
            if ((marker.getOffset() <= this.modificationStartOffset || marker.getOffset() > this.modificationEndOffset) && (marker.getEndOffset() <= this.modificationStartOffset || marker.getEndOffset() > this.modificationEndOffset)) continue;
            iterator.remove();
        }
        MarkerHandler.markAllOnTheFlyMarkersForRemoval((IResource)this.file, this.modificationStartOffset, this.modificationEndOffset + this.shift);
        if (this.code == null) {
            return Integer.MAX_VALUE;
        }
        int line = TTCN3ReparseUpdater.getLineOfOfset(this.code, this.modificationStartOffset);
        String substring = this.code.length() <= this.modificationEndOffset + this.shift ? this.code.substring(this.modificationStartOffset) : this.code.substring(this.modificationStartOffset, this.modificationEndOffset + this.shift);
        StringReader reader = new StringReader(substring);
        UnbufferedCharStream charStream = new UnbufferedCharStream((Reader)reader);
        Ttcn3Lexer lexer = new Ttcn3Lexer((CharStream)charStream);
        lexer.setTokenFactory((TokenFactory)new CommonTokenFactory(true));
        lexer.initRootInterval(this.modificationEndOffset - this.modificationStartOffset + 1);
        TitanListener parserListener = new TitanListener();
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)parserListener);
        BufferedTokenStream tokens = new BufferedTokenStream((TokenSource)lexer);
        Ttcn3Reparser parser = new Ttcn3Reparser((TokenStream)tokens);
        lexer.setActualFile(this.file);
        parser.setActualFile(this.file);
        parser.setProject(this.file.getProject());
        parser.setLexer(lexer);
        parser.setOffset(this.modificationStartOffset);
        parser.setLine(line + 1);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)parserListener);
        userDefined.reparse(parser);
        this.mErrors = parserListener.getErrorsStored();
        this.warnings = parser.getWarnings();
        this.unsupportedConstructs.addAll(parser.getUnsupportedConstructs());
        int result = this.measureIntervallDamage();
        if (!parser.isErrorListEmpty()) {
            ++result;
        }
        return result;
    }
}

