/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.preferences.pages;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.preferences.pages.ComboFieldEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public final class ErrorsWarningsPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String DESCRIPTION = "Preferences of the on-the-fly analyzer";
    private static final String REPORTUNSUPPORTEDCONSTRUCTS = "Language constructs not supported yet:";
    private static final String REPORTUNSUPPORTEDCONSTRUCTS_TOOLTIP = "For example pattern subtyping in TTCN-3.";
    private static final String REPORTMISSINGIMPORTATION = "Report missing imported modules:";
    private static final String REPORTMISSINGIMPORTATION_TOOLTIP = "When a module referred to in an import statement could not be found.";
    private static final String REPORTUNUSEDMODULEIMPORTATION = "Report unused module importation:";
    private static final String REPORTUNUSEDMODULEIMPORTATION_TOOLTIP = "When nothing is used in the module from the imported module.";
    private static final String REPORTMISSINGFRIEND = "Report friend declarations with missing modules:";
    private static final String REPORTMISSINGFRIEND_TOOLTIP = "When the module referred to in a friend declaration doulc not be found..";
    private static final String REPORTUNUSEDGLOBALDEFINITION = "Report unused module level definition:";
    private static final String REPORTUNUSEDGLOBALDEFINITIONTOOLTIP = "When a module level definition is never read/written.\n Also when a type is not used to declare other definitions.";
    private static final String REPORTUNUSEDLOCALDEFINITION = "Report unused local definition:";
    private static final String REPORTUNUSEDLOCALDEFINITIONTOOLTIP = "When a local variable or formal parameter is never read/written.";
    private static final String REPORTUNUSEDFUNTIONRETURNVALUES = "Report unused function return values:";
    private static final String REPORTUNUSEDFUNCTIONRETURNVALUESTOOLTIP = "When a function returns a value or a template, but it is not used.";
    private static final String REPORT_INFINITE_LOOP = "Report infinite loops";
    private static final String REPORT_INFINITE_LOOP_TOOLTIP = "When there is no way to escape the loop";
    private static final String REPORT_READONLY = "Report read only variables";
    private static final String REPORT_READONLY_TOOLTIP = "When a definition was declared to be changeable, but is never modified";
    private static final String REPORT_NONPRIVATE_PRIVATE = "Report TTCN-3 definitions that could be private, but are not set so";
    private static final String REPORT_NONPRIVATE_PRIVATE_TOOLTIP = "By default all definitions are public, but by declaring some private one can make them invisible for importing modules.\nThis might be usefull in case of internal functions, types, constants";
    private static final String REPORT_TOOMANY_PARAMETERS = "Report TTCN-3 definitions that have too many parameters";
    private static final String REPORT_TOOMANY_PARAMETERS_SIZE = "The size the amount of parameters should not exceed";
    private static final String REPORT_TOOMANY_PARAMETERS_TOOLTIP = "The more parameters some entity has, the harder it becomes to fill them out correctly without introducing faults";
    private static final String REPORT_EMPTY_STATEMENT_BLOCK = "Report empty statement blocks";
    private static final String REPORT_EMPTY_STATEMENT_BLOCK_TOOLTIP = "Empty statement blocks in the source code usually means,\nthat the developer planned to write some code there to handle some use cases,\nbut forgot to finish his work ... or is right now in the process of finishing it";
    private static final String REPORT_TOOMANY_STATEMENTS = "Report statement blocks that have too many statements";
    private static final String REPORT_TOOMANY_STATEMENTS_SIZE = "The size the amount of statements should not exceed";
    private static final String REPORT_TOOMANY_STATEMENTS_TOOLTIP = "Rationale: If a statement block becomes very long it is hard to understand. Therefore long statemen tblocks should usually be refactored into several individual ones, or into individual functions that focus on a specific task. ";
    private static final String HANDLEDEFAULTASOPTIONAL = "DEFAULT elements of ASN.1 sequence and set types as OPTIONAL:";
    private static final String HANDLEDEFAULTASOPTIONALTOOTIP = "Handle the DEFAULT elements of set and sequence ASN.1 types as being optional.\nThis is compatibility opition.";
    private static final String REPORTINCORRECTSHIFTROTATESIZE = "Report too big or too small shift and rotation sizes:";
    private static final String REPORTINCORRECTSHIFTROTATESIZE_TOOLTIP = "Report too big (bigger than the string itself) or negative shift and rotation sizes.";
    private static final String REPORT_IF_WITHOUT_ELSE = "Report conditional statements without else block";
    private static final String REPORT_IF_WITHOUT_ELSE_TOOLTIP = "All possible execution paths should be handled, at least on the level of logging information in case of unexpected events";
    private static final String REPORT_SETVERDICT_WITHOUT_REASON = "Report setverdict without reason";
    private static final String REPORT_SETVERDICT_WITHOUT_REASON_TOOLTIP = "Setting any other verdict reason then pass, should be accompanied with a reason, with details for the verdict";
    private static final String REPORTUNNECESSARYCONTROLS = "Report unnecessary controls:";
    private static final String REPORTUNNECESSARYCONTROLS_TOOLTIP = "Report controls that can be identified to be unnecessary in compilation time.\nFor example when the conditional expression of an if statements evaluates to false in compilation time.";
    private static final String REPORT_IGNORED_PREPROCESSOR_DIRECTIVES = "Report ignored preprocessor directives:";
    private static final String REPORT_IGNORED_PREPROCESSOR_DIRECTIVES_TOOLTIP = "Some preprocessor directives (#line,#pragma,etc.) are ignored.\nThese should either be removed or the file is an intermediate file (already preprocessed ttcnpp) that contains line markers.\nIt is probably a bad idea to edit the intermediate file instead of the original ttcnpp file.";
    private static final String REPORTTYPECOMPATIBILITY = "Report uses of structured-type compatibility:";
    private static final String REPORTTYPECOMPATIBILITY_TOOLTIP = "When structured-type compatibility is used in the code.";
    private static final String REPORTERRORSINEXTENSIONSYNTAX = "Report incorrect syntax in extension attributes:";
    private static final String REPORTERRORSINEXTENSIONSYNTAX_TOOLTIP = "According to the standard syntax errors in the extension attribute should not be reported, but should be assumed as correct for some other tool.";
    private static final String REPORT_STRICT_CONSTANTS = "Use stricter checks for constants";
    private static final String REPORT_STRICT_CONSTANTS_TOOLTIP = "Although it is valid to leave fields of constants and literals unbound, in some cases this was not the intention.";
    private static final String REPORT_GOTO = "Report the usage of label and goto statements";
    private static final String REPORT_GOTO_TOOLTIP = "In almost all cases the usage of goto should be forbidden as it can very easily breaks the principles of structured/well designed source code.";
    private static final String[][] IGNORE_WARNING_ERROR = new String[][]{{"Ignore", "ignore"}, {"Warning", "warning"}, {"Error", "error"}};
    private boolean changed = false;
    private Composite pagecomp;

    public ErrorsWarningsPreferencePage() {
        super(1);
    }

    private ExpandableComposite createExtendableComposite(final Composite parent, String title) {
        ExpandableComposite ex = new ExpandableComposite(parent, 0, 50);
        ex.setText(title);
        ex.setExpanded(false);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        ex.setLayoutData((Object)data);
        ex.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                Composite temp;
                for (temp = parent; temp != null && !(temp instanceof ScrolledComposite); temp = temp.getParent()) {
                }
                if (temp != null) {
                    Point point = ErrorsWarningsPreferencePage.this.pagecomp.computeSize(-1, -1);
                    ((ScrolledComposite)temp).setMinSize(point);
                    ((ScrolledComposite)temp).layout(true, true);
                }
            }
        });
        return ex;
    }

    protected Control createContents(Composite parent) {
        this.pagecomp = new Composite(parent, 0);
        this.pagecomp.setLayout((Layout)new GridLayout(1, false));
        this.pagecomp.setLayoutData((Object)new GridData(1808));
        return super.createContents(this.pagecomp);
    }

    protected void createFieldEditors() {
        Composite tempParent = this.getFieldEditorParent();
        this.createCodeStyleSection(tempParent);
        this.createUnnecessaryCodeSection(tempParent);
        this.createPotentialProgrammingProblemsSection(tempParent);
    }

    private void createCodeStyleSection(Composite parent) {
        ExpandableComposite expandable = this.createExtendableComposite(parent, "Code style problems");
        Composite comp = new Composite((Composite)expandable, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(768));
        expandable.setClient((Control)comp);
        expandable.setExpanded(true);
        ComboFieldEditor comboedit = new ComboFieldEditor("org.eclipse.titan.designer.reportUnsupportedConstructs", REPORTUNSUPPORTEDCONSTRUCTS, IGNORE_WARNING_ERROR, comp);
        Label text = comboedit.getLabelControl(comp);
        text.setToolTipText(REPORTUNSUPPORTEDCONSTRUCTS_TOOLTIP);
        comboedit.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ErrorsWarningsPreferencePage.this.changed = true;
            }
        });
        this.addField(comboedit);
        BooleanFieldEditor defaultAsOptional = new BooleanFieldEditor("org.eclipse.titan.designer.defaultAsOptional", HANDLEDEFAULTASOPTIONAL, 1, comp);
        defaultAsOptional.getLabelControl(comp).setToolTipText(HANDLEDEFAULTASOPTIONALTOOTIP);
        defaultAsOptional.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ErrorsWarningsPreferencePage.this.changed = true;
            }
        });
        this.addField((FieldEditor)defaultAsOptional);
        comboedit = new ComboFieldEditor("org.eclipse.titan.designer.reportTypeCompatibility", REPORTTYPECOMPATIBILITY, IGNORE_WARNING_ERROR, comp);
        text = comboedit.getLabelControl(comp);
        text.setToolTipText(REPORTTYPECOMPATIBILITY_TOOLTIP);
        comboedit.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ErrorsWarningsPreferencePage.this.changed = true;
            }
        });
        this.addField(comboedit);
        defaultAsOptional = new BooleanFieldEditor("org.eclipse.titan.designer.reportStrictConstants", REPORT_STRICT_CONSTANTS, 1, comp);
        defaultAsOptional.getLabelControl(comp).setToolTipText(REPORT_STRICT_CONSTANTS_TOOLTIP);
        defaultAsOptional.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ErrorsWarningsPreferencePage.this.changed = true;
            }
        });
        this.addField((FieldEditor)defaultAsOptional);
        comboedit = new ComboFieldEditor("org.eclipse.titan.designer.reportGOTO", REPORT_GOTO, IGNORE_WARNING_ERROR, comp);
        text = comboedit.getLabelControl(comp);
        text.setToolTipText(REPORT_GOTO_TOOLTIP);
        comboedit.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ErrorsWarningsPreferencePage.this.changed = true;
            }
        });
        this.addField(comboedit);
    }

    private void createPotentialProgrammingProblemsSection(Composite parent) {
        ExpandableComposite expandable = this.createExtendableComposite(parent, "Potential programming problems");
        Composite comp = new Composite((Composite)expandable, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(768));
        expandable.setClient((Control)comp);
        expandable.setExpanded(false);
        ComboFieldEditor comboedit = new ComboFieldEditor("org.eclipse.titan.designer.reportMissingImportedModule", REPORTMISSINGIMPORTATION, IGNORE_WARNING_ERROR, comp);
        Label text = comboedit.getLabelControl(comp);
        text.setToolTipText(REPORTMISSINGIMPORTATION_TOOLTIP);
        comboedit.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ErrorsWarningsPreferencePage.this.changed = true;
            }
        });
        this.addField(comboedit);
        comboedit = new ComboFieldEditor("org.eclipse.titan.designer.reportMissingFriendModule", REPORTMISSINGFRIEND, IGNORE_WARNING_ERROR, comp);
        text = comboedit.getLabelControl(comp);
        text.setToolTipText(REPORTMISSINGFRIEND_TOOLTIP);
        comboedit.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ErrorsWarningsPreferencePage.this.changed = true;
            }
        });
        this.addField(comboedit);
        comboedit = new ComboFieldEditor("org.eclipse.titan.designer.reportUnusedFunctionReturnValues", REPORTUNUSEDFUNTIONRETURNVALUES, IGNORE_WARNING_ERROR, comp);
        text = comboedit.getLabelControl(comp);
        text.setToolTipText(REPORTUNUSEDFUNCTIONRETURNVALUESTOOLTIP);
        comboedit.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ErrorsWarningsPreferencePage.this.changed = true;
            }
        });
        this.addField(comboedit);
        comboedit = new ComboFieldEditor("org.eclipse.titan.designer.reportInifinteLoops", REPORT_INFINITE_LOOP, IGNORE_WARNING_ERROR, comp);
        text = comboedit.getLabelControl(comp);
        text.setToolTipText(REPORT_INFINITE_LOOP_TOOLTIP);
        comboedit.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ErrorsWarningsPreferencePage.this.changed = true;
            }
        });
        this.addField(comboedit);
        comboedit = new ComboFieldEditor("org.eclipse.titan.designer.reportReadOnly", REPORT_READONLY, IGNORE_WARNING_ERROR, comp);
        text = comboedit.getLabelControl(comp);
        text.setToolTipText(REPORT_READONLY_TOOLTIP);
        comboedit.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ErrorsWarningsPreferencePage.this.changed = true;
            }
        });
        this.addField(comboedit);
        comboedit = new ComboFieldEditor("org.eclipse.titan.designer.reportNonPrivatePrivate", REPORT_NONPRIVATE_PRIVATE, IGNORE_WARNING_ERROR, comp);
        text = comboedit.getLabelControl(comp);
        text.setToolTipText(REPORT_NONPRIVATE_PRIVATE_TOOLTIP);
        comboedit.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ErrorsWarningsPreferencePage.this.changed = true;
            }
        });
        this.addField(comboedit);
        comboedit = new ComboFieldEditor("org.eclipse.titan.designer.reportTooManyParameters", REPORT_TOOMANY_PARAMETERS, IGNORE_WARNING_ERROR, comp);
        text = comboedit.getLabelControl(comp);
        text.setToolTipText(REPORT_TOOMANY_PARAMETERS_TOOLTIP);
        comboedit.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ErrorsWarningsPreferencePage.this.changed = true;
            }
        });
        this.addField(comboedit);
        IntegerFieldEditor integeredit = new IntegerFieldEditor("org.eclipse.titan.designer.reportTooManyParametersSize", REPORT_TOOMANY_PARAMETERS_SIZE, comp);
        text = integeredit.getLabelControl(comp);
        text.setToolTipText(REPORT_TOOMANY_PARAMETERS_TOOLTIP);
        integeredit.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ErrorsWarningsPreferencePage.this.changed = true;
            }
        });
        this.addField((FieldEditor)integeredit);
        comboedit = new ComboFieldEditor("org.eclipse.titan.designer.reportEmptyStatementBlock", REPORT_EMPTY_STATEMENT_BLOCK, IGNORE_WARNING_ERROR, comp);
        text = comboedit.getLabelControl(comp);
        text.setToolTipText(REPORT_EMPTY_STATEMENT_BLOCK_TOOLTIP);
        comboedit.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ErrorsWarningsPreferencePage.this.changed = true;
            }
        });
        this.addField(comboedit);
        comboedit = new ComboFieldEditor("org.eclipse.titan.designer.reportTooManyStatements", REPORT_TOOMANY_STATEMENTS, IGNORE_WARNING_ERROR, comp);
        text = comboedit.getLabelControl(comp);
        text.setToolTipText(REPORT_TOOMANY_STATEMENTS_TOOLTIP);
        comboedit.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ErrorsWarningsPreferencePage.this.changed = true;
            }
        });
        this.addField(comboedit);
        integeredit = new IntegerFieldEditor("org.eclipse.titan.designer.reportTooManyStatementsSize", REPORT_TOOMANY_STATEMENTS_SIZE, comp);
        text = integeredit.getLabelControl(comp);
        text.setToolTipText(REPORT_TOOMANY_STATEMENTS_TOOLTIP);
        integeredit.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ErrorsWarningsPreferencePage.this.changed = true;
            }
        });
        this.addField((FieldEditor)integeredit);
        comboedit = new ComboFieldEditor("org.eclipse.titan.designer.reportIncorrectShiftRotateSize", REPORTINCORRECTSHIFTROTATESIZE, IGNORE_WARNING_ERROR, comp);
        text = comboedit.getLabelControl(comp);
        text.setToolTipText(REPORTINCORRECTSHIFTROTATESIZE_TOOLTIP);
        comboedit.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ErrorsWarningsPreferencePage.this.changed = true;
            }
        });
        this.addField(comboedit);
        comboedit = new ComboFieldEditor("org.eclipse.titan.designer.reportIfWithoutElse", REPORT_IF_WITHOUT_ELSE, IGNORE_WARNING_ERROR, comp);
        text = comboedit.getLabelControl(comp);
        text.setToolTipText(REPORT_IF_WITHOUT_ELSE_TOOLTIP);
        comboedit.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ErrorsWarningsPreferencePage.this.changed = true;
            }
        });
        this.addField(comboedit);
        comboedit = new ComboFieldEditor("org.eclipse.titan.designer.reportSetverdictWithoutReason", REPORT_SETVERDICT_WITHOUT_REASON, IGNORE_WARNING_ERROR, comp);
        text = comboedit.getLabelControl(comp);
        text.setToolTipText(REPORT_SETVERDICT_WITHOUT_REASON_TOOLTIP);
        comboedit.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ErrorsWarningsPreferencePage.this.changed = true;
            }
        });
        this.addField(comboedit);
        comboedit = new ComboFieldEditor("org.eclipse.titan.designer.reportErrorsInExtensionSyntax", REPORTERRORSINEXTENSIONSYNTAX, IGNORE_WARNING_ERROR, comp);
        text = comboedit.getLabelControl(comp);
        text.setToolTipText(REPORTERRORSINEXTENSIONSYNTAX_TOOLTIP);
        comboedit.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ErrorsWarningsPreferencePage.this.changed = true;
            }
        });
        this.addField(comboedit);
    }

    private void createUnnecessaryCodeSection(Composite parent) {
        ExpandableComposite expandable = this.createExtendableComposite(parent, "Unnecessary code");
        Composite comp = new Composite((Composite)expandable, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(768));
        expandable.setClient((Control)comp);
        expandable.setExpanded(false);
        ComboFieldEditor comboedit = new ComboFieldEditor("org.eclipse.titan.designer.reportUnusedModuleImportation", REPORTUNUSEDMODULEIMPORTATION, IGNORE_WARNING_ERROR, comp);
        Label text = comboedit.getLabelControl(comp);
        text.setToolTipText(REPORTUNUSEDMODULEIMPORTATION_TOOLTIP);
        comboedit.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ErrorsWarningsPreferencePage.this.changed = true;
            }
        });
        this.addField(comboedit);
        comboedit = new ComboFieldEditor("org.eclipse.titan.designer.reportUnusedGlobalDefinition", REPORTUNUSEDGLOBALDEFINITION, IGNORE_WARNING_ERROR, comp);
        text = comboedit.getLabelControl(comp);
        text.setToolTipText(REPORTUNUSEDGLOBALDEFINITIONTOOLTIP);
        comboedit.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ErrorsWarningsPreferencePage.this.changed = true;
            }
        });
        this.addField(comboedit);
        comboedit = new ComboFieldEditor("org.eclipse.titan.designer.reportUnusedLocalDefinition", REPORTUNUSEDLOCALDEFINITION, IGNORE_WARNING_ERROR, comp);
        text = comboedit.getLabelControl(comp);
        text.setToolTipText(REPORTUNUSEDLOCALDEFINITIONTOOLTIP);
        comboedit.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ErrorsWarningsPreferencePage.this.changed = true;
            }
        });
        this.addField(comboedit);
        comboedit = new ComboFieldEditor("org.eclipse.titan.designer.reportUnnecessaryControls", REPORTUNNECESSARYCONTROLS, IGNORE_WARNING_ERROR, comp);
        text = comboedit.getLabelControl(comp);
        text.setToolTipText(REPORTUNNECESSARYCONTROLS_TOOLTIP);
        comboedit.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ErrorsWarningsPreferencePage.this.changed = true;
            }
        });
        this.addField(comboedit);
        comboedit = new ComboFieldEditor("org.eclipse.titan.designer.reportIgnoredPreprocessorDirectives", REPORT_IGNORED_PREPROCESSOR_DIRECTIVES, IGNORE_WARNING_ERROR, comp);
        text = comboedit.getLabelControl(comp);
        text.setToolTipText(REPORT_IGNORED_PREPROCESSOR_DIRECTIVES_TOOLTIP);
        comboedit.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ErrorsWarningsPreferencePage.this.changed = true;
            }
        });
        this.addField(comboedit);
    }

    public void init(IWorkbench workbench) {
        this.setDescription(DESCRIPTION);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.changed = true;
        super.propertyChange(event);
    }

    public boolean performOk() {
        boolean result = super.performOk();
        if (this.changed && this.getPreferenceStore().getBoolean("org.eclipse.titan.designer.useOnTheFlyParsing")) {
            this.changed = false;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openWarning(null, (String)"Error/Warning settings changed", (String)"Error/Warning settings have changed, the known projects have to be re-analyzed completly.\nThis might take some time.");
                }
            });
            GlobalParser.clearSemanticInformation();
            GlobalParser.reAnalyzeSemantically();
        }
        return result;
    }
}

