/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.data;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.core.ProjectBasedBuilder;
import org.eclipse.titan.designer.properties.data.DOMErrorHandlerImpl;
import org.eclipse.titan.designer.properties.data.FileBuildPropertyData;
import org.eclipse.titan.designer.properties.data.FolderBuildPropertyData;
import org.eclipse.titan.designer.properties.data.ProjectBuildPropertyData;
import org.eclipse.titan.designer.properties.data.ProjectConfigurationsPropertyData;
import org.eclipse.titan.designer.properties.data.ProjectDocumentHandlingUtility;
import org.eclipse.titan.designer.properties.data.ProjectNamingConventionPropertyData;
import org.eclipse.titan.designer.properties.data.ProjectRemoteBuildPropertyData;
import org.eclipse.titan.designer.wizards.projectFormat.TITANAutomaticProjectExporter;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSSerializer;

public final class ProjectFileHandler {
    private static final String DOM_IMPLEMENTATION_SOURCE = "com.sun.org.apache.xerces.internal.dom.DOMImplementationSourceImpl";
    private static final String LOAD_SAVE_VERSION = "LS 3.0";
    private static final String XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String XSD_PATH = "/project.xsd";
    public static final String XML_TITAN_PROPERTIES_FILE = ".TITAN_properties";
    private static final String DOT = ".";
    public static final String PROJECTPROPERTIESXMLNODE = "ProjectProperties";
    public static final String FILEPROPERTIESXMLNODE = "FileProperties";
    public static final String FOLDERPROPERTIESXMLNODE = "FolderProperties";
    public static final String CONFIGURATIONSXMLNODE = "Configurations";
    public static final String CONFIGURATIONXMLNODE = "Configuration";
    public static final String ACTIVECONFIGURATIONXMLNODE = "ActiveConfiguration";
    public static final String DEFAULTCONFIGURATIONNAME = "Default";
    private static final String SAVING_PROPERTIES = "saving TITAN properties";
    private static final String LOADING_PROPERTIES = "loading TITAN properties";
    private static final String ENCODING = "UTF-8";
    private static StringBuilder xmlFormatterString = new StringBuilder("\n           ");
    private final IProject project;
    private DOMImplementation domImpl;
    private DOMImplementationLS domImplLS;
    private LSParser parser;
    private DOMConfiguration config;
    private static final List<IProject> PROJECTS_LOCKED_FOR_LOADING = new ArrayList<IProject>();

    public static Map<String, IFile> getFiles(IProject project) {
        IContainer[] workingDirectories = ProjectBasedBuilder.getProjectBasedBuilder(project).getWorkingDirectoryResources(false);
        ResourceVisitor saveVisitor = new ResourceVisitor(workingDirectories);
        try {
            project.accept((IResourceVisitor)saveVisitor);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While collecting resources of `" + project.getName() + "'"), (Throwable)e);
        }
        Map<String, IFile> files = saveVisitor.getFiles();
        return files;
    }

    public static List<IFile> getCfgFiles(IProject project) {
        Map<String, IFile> files = ProjectFileHandler.getFiles(project);
        ArrayList<IFile> cfgFiles = new ArrayList<IFile>();
        for (IFile file : files.values()) {
            if (!"cfg".equals(file.getFileExtension())) continue;
            cfgFiles.add(file);
        }
        return cfgFiles;
    }

    public static Map<String, IFolder> getFoldersOfProject(IProject project) {
        IContainer[] workingDirectories = ProjectBasedBuilder.getProjectBasedBuilder(project).getWorkingDirectoryResources(false);
        ResourceVisitor saveVisitor = new ResourceVisitor(workingDirectories);
        try {
            project.accept((IResourceVisitor)saveVisitor);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While collecting resources of `" + project.getName() + "'"), (Throwable)e);
        }
        Map<String, IFolder> folders = saveVisitor.getFolders();
        return folders;
    }

    public ProjectFileHandler(IProject project) {
        this.project = project;
        System.setProperty("org.w3c.dom.DOMImplementationSourceList", DOM_IMPLEMENTATION_SOURCE);
        DOMImplementationRegistry registry = null;
        try {
            registry = DOMImplementationRegistry.newInstance();
        }
        catch (Exception e) {
            ErrorReporter.logExceptionStackTrace((String)("While create project handler for `" + project.getName() + "'"), (Throwable)e);
            return;
        }
        this.domImpl = registry.getDOMImplementation(LOAD_SAVE_VERSION);
        this.domImplLS = (DOMImplementationLS)((Object)this.domImpl);
        this.parser = this.domImplLS.createLSParser((short)1, XML_SCHEMA);
        this.config = this.parser.getDomConfig();
        DOMErrorHandlerImpl errorHandler = new DOMErrorHandlerImpl();
        this.config.setParameter("error-handler", errorHandler);
        this.config.setParameter("validate", Boolean.TRUE);
        this.config.setParameter("schema-type", XML_SCHEMA);
        this.config.setParameter("validate-if-schema", Boolean.TRUE);
    }

    private static String getXMLIndentation(int level) {
        while (xmlFormatterString.length() < level + 2) {
            xmlFormatterString.append(xmlFormatterString.substring(2));
        }
        return xmlFormatterString.substring(0, level);
    }

    public boolean projectFileExists() {
        IFile fileResource = this.project.getFile("/.TITAN_properties");
        return fileResource.isAccessible();
    }

    private static Node saveProjectProperties(IProject project, Document document) {
        Element root = document.createElement(PROJECTPROPERTIESXMLNODE);
        root.appendChild(ProjectBuildPropertyData.saveMakefileSettings(document, project));
        root.appendChild(ProjectBuildPropertyData.saveLocalBuildSettings(document, project));
        Element element = ProjectRemoteBuildPropertyData.saveRemoteBuildProperties(document, project);
        if (element != null) {
            root.appendChild(element);
        }
        if ((element = ProjectNamingConventionPropertyData.saveProperties(document, project)) != null) {
            root.appendChild(element);
        }
        if ((element = ProjectConfigurationsPropertyData.saveProperties(document, project)) != null) {
            root.appendChild(element);
        }
        return root;
    }

    private static Element saveFolderProperties(Document document, IContainer[] workingDirectories, Map<String, IFolder> folders) {
        Element root = null;
        for (Map.Entry<String, IFolder> entry : folders.entrySet()) {
            IFolder folder = entry.getValue();
            for (IContainer workingDirectory : workingDirectories) {
                if (!workingDirectory.equals(folder)) continue;
            }
            if (FolderBuildPropertyData.hasDefaultProperties(folder)) continue;
            if (root == null) {
                root = document.createElement(FOLDERPROPERTIESXMLNODE);
            }
            root.appendChild(FolderBuildPropertyData.saveFolderProperties(document, folder));
        }
        return root;
    }

    private static Element saveFileProperties(Document document, IContainer[] workingDirectories, Map<String, IFile> files) {
        Element root = null;
        for (Map.Entry<String, IFile> entry : files.entrySet()) {
            IFile file = entry.getValue();
            for (IContainer workingDirectory : workingDirectories) {
                if (!workingDirectory.equals(file.getParent())) continue;
            }
            if (FileBuildPropertyData.hasDefaultProperties(file)) continue;
            if (root == null) {
                root = document.createElement(FILEPROPERTIESXMLNODE);
            }
            root.appendChild(FileBuildPropertyData.saveFileProperties(document, file));
        }
        return root;
    }

    public WorkspaceJob saveProjectSettingsJob() {
        if (PROJECTS_LOCKED_FOR_LOADING.contains(this.project)) {
            return null;
        }
        WorkspaceJob saveJob = new WorkspaceJob(SAVING_PROPERTIES){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                if (!ProjectFileHandler.this.project.isAccessible()) {
                    return Status.OK_STATUS;
                }
                Document document = ProjectDocumentHandlingUtility.getDocument(ProjectFileHandler.this.project);
                if (document == null) {
                    document = ProjectDocumentHandlingUtility.createDocument(ProjectFileHandler.this.project);
                }
                ProjectFileHandler.this.saveProjectInfoToDocument(document);
                ProjectFileHandler.clearNode(document.getDocumentElement());
                ProjectFileHandler.indentNode(document, document.getDocumentElement(), 1);
                ProjectDocumentHandlingUtility.saveDocument(ProjectFileHandler.this.project);
                TITANAutomaticProjectExporter.saveAllAutomatically(ProjectFileHandler.this.project);
                return Status.OK_STATUS;
            }
        };
        saveJob.setPriority(30);
        saveJob.setUser(false);
        saveJob.setSystem(true);
        saveJob.setRule(this.project.getWorkspace().getRuleFactory().refreshRule((IResource)this.project));
        saveJob.schedule();
        return saveJob;
    }

    public void saveProjectInfoToDocument(Document document) {
        ProjectFileHandler.saveActualConfigurationInfoToNode(this.project, document);
        String activeConfigurationName = ProjectFileHandler.getActiveConfigurationName(this.project);
        if (DEFAULTCONFIGURATIONNAME.equals(activeConfigurationName)) {
            ProjectFileHandler.saveProjectInfoToNode(this.project, document.getDocumentElement(), document);
        } else {
            Node configurationRoot;
            Node configurationsRoot = ProjectFileHandler.getNodebyName(document.getDocumentElement().getChildNodes(), CONFIGURATIONSXMLNODE);
            if (configurationsRoot == null) {
                configurationsRoot = document.createElement(CONFIGURATIONSXMLNODE);
                document.getDocumentElement().appendChild(configurationsRoot);
            }
            if ((configurationRoot = ProjectFileHandler.findConfigurationNode(document.getDocumentElement(), activeConfigurationName)) == null) {
                Element temp = document.createElement(CONFIGURATIONXMLNODE);
                temp.setAttribute("name", activeConfigurationName);
                configurationsRoot.appendChild(temp);
                configurationRoot = temp;
            }
            ProjectFileHandler.saveProjectInfoToNode(this.project, configurationRoot, document);
        }
    }

    public static Node createConfigurationNode(Document document, String configurationName) {
        Node configurationRoot;
        if (DEFAULTCONFIGURATIONNAME.equals(configurationName)) {
            return document.getDocumentElement();
        }
        Node configurationsRoot = ProjectFileHandler.getNodebyName(document.getDocumentElement().getChildNodes(), CONFIGURATIONSXMLNODE);
        if (configurationsRoot == null) {
            configurationsRoot = document.createElement(CONFIGURATIONSXMLNODE);
            document.getDocumentElement().appendChild(configurationsRoot);
        }
        if ((configurationRoot = ProjectFileHandler.findConfigurationNode(document.getDocumentElement(), configurationName)) == null) {
            Element temp = document.createElement(CONFIGURATIONXMLNODE);
            temp.setAttribute("name", configurationName);
            configurationsRoot.appendChild(temp);
            configurationRoot = temp;
        }
        return configurationRoot;
    }

    public void saveProjectSettings() {
        this.saveProjectSettingsJob();
    }

    private void loadProjectProperties(Node node, Set<IResource> changedResources) {
        NodeList resourceList = node.getChildNodes();
        Node namingConventionsNode = null;
        int size = resourceList.getLength();
        for (int i = 0; i < size; ++i) {
            Node tempNode = resourceList.item(i);
            String nodeName = tempNode.getNodeName();
            if ("MakefileSettings".equals(nodeName)) {
                ProjectBuildPropertyData.loadMakefileSettings(tempNode, this.project, changedResources);
                continue;
            }
            if ("LocalBuildSettings".equals(nodeName)) {
                ProjectBuildPropertyData.loadLocalBuildSettings(tempNode, this.project, changedResources);
                continue;
            }
            if ("RemoteBuildProperties".equals(nodeName)) {
                ProjectRemoteBuildPropertyData.loadRemoteBuildProperties(tempNode, this.project, changedResources);
                continue;
            }
            if ("ConfigurationRequirements".equals(nodeName)) {
                ProjectConfigurationsPropertyData.loadProperties(tempNode, this.project, changedResources);
                continue;
            }
            if (!"NamingCoventions".equals(nodeName)) continue;
            namingConventionsNode = tempNode;
        }
        ProjectNamingConventionPropertyData.loadProperties(namingConventionsNode, this.project);
    }

    private void loadFileProperties(Node node, Collection<IFile> files, Set<IResource> changedResources) {
        HashSet<IFile> notYetReachedFiles = new HashSet<IFile>();
        notYetReachedFiles.addAll(files);
        if (node != null) {
            NodeList resourceList = node.getChildNodes();
            int size = resourceList.getLength();
            for (int i = 0; i < size; ++i) {
                Node tempNode = resourceList.item(i);
                if (!"FileResource".equals(tempNode.getNodeName())) continue;
                FileBuildPropertyData.loadFileProperties(tempNode, this.project, notYetReachedFiles, changedResources);
            }
        }
        for (IFile file : notYetReachedFiles) {
            FileBuildPropertyData.loadDefaultProperties(file, changedResources);
        }
    }

    private void loadFolderProperties(Node node, Collection<IFolder> folders, Set<IResource> changedResources) {
        HashSet<IFolder> notYetReachedFolders = new HashSet<IFolder>();
        notYetReachedFolders.addAll(folders);
        if (node != null) {
            NodeList resourceList = node.getChildNodes();
            int size = resourceList.getLength();
            for (int i = 0; i < size; ++i) {
                Node tempNode = resourceList.item(i);
                if (!"FolderResource".equals(tempNode.getNodeName())) continue;
                FolderBuildPropertyData.loadFolderProperties(tempNode, this.project, notYetReachedFolders, changedResources);
            }
        }
        for (IFolder folder : notYetReachedFolders) {
            FolderBuildPropertyData.loadDefaultProperties(folder, changedResources);
        }
    }

    public void loadProjectSettings() {
        if (PROJECTS_LOCKED_FOR_LOADING.contains(this.project)) {
            return;
        }
        PROJECTS_LOCKED_FOR_LOADING.add(this.project);
        if (!this.project.isAccessible()) {
            PROJECTS_LOCKED_FOR_LOADING.remove(this.project);
            return;
        }
        WorkspaceJob loadJob = new WorkspaceJob(LOADING_PROPERTIES){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                if (!ProjectFileHandler.this.project.isAccessible()) {
                    PROJECTS_LOCKED_FOR_LOADING.remove(ProjectFileHandler.this.project);
                    return Status.OK_STATUS;
                }
                try {
                    ProjectFileHandler.this.project.refreshLocal(2, monitor);
                }
                catch (CoreException e) {
                    ErrorReporter.logExceptionStackTrace((String)("While refreshing `" + ProjectFileHandler.this.project.getName() + "'"), (Throwable)e);
                }
                ProjectDocumentHandlingUtility.clearDocument(ProjectFileHandler.this.project);
                Document document = ProjectDocumentHandlingUtility.getDocument(ProjectFileHandler.this.project);
                PROJECTS_LOCKED_FOR_LOADING.remove(ProjectFileHandler.this.project);
                if (document != null) {
                    ProjectFileHandler.this.loadProjectSettingsFromDocument(document);
                }
                return Status.OK_STATUS;
            }
        };
        loadJob.setPriority(30);
        loadJob.setUser(false);
        loadJob.setSystem(true);
        loadJob.setRule(this.project.getWorkspace().getRuleFactory().refreshRule((IResource)this.project));
        loadJob.schedule();
    }

    public void loadProjectSettingsFromDocument(Document document) {
        Node activeConfiguration = ProjectFileHandler.getNodebyName(document.getDocumentElement().getChildNodes(), ACTIVECONFIGURATIONXMLNODE);
        String activeConfigurationName = activeConfiguration == null ? DEFAULTCONFIGURATIONNAME : activeConfiguration.getTextContent();
        try {
            this.project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "org.eclipse.titan.designer.activeConfiguration"), activeConfigurationName);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While setting configuration property for `" + this.project.getName() + "'"), (Throwable)e);
        }
        HashSet<IResource> changedResources = new HashSet<IResource>();
        Node configuration = ProjectFileHandler.findConfigurationNode(document.getDocumentElement(), activeConfigurationName);
        if (configuration == null) {
            ErrorReporter.logError((String)("The configuration `" + activeConfigurationName + "' for project `" + this.project.getName() + "' does not exist."));
        } else {
            this.loadProjectInfoFromNode(configuration, changedResources);
        }
    }

    public void saveDocumentToFile(IFile file, Document document) {
        LSSerializer dom3Writer = this.domImplLS.createLSSerializer();
        LSOutput output = this.domImplLS.createLSOutput();
        File localFile = file.getLocation().toFile();
        try {
            file.refreshLocal(0, null);
            StringWriter sw = new StringWriter();
            output.setCharacterStream(sw);
            output.setEncoding(ENCODING);
            dom3Writer.write(document, output);
            String temporaloutput = sw.getBuffer().toString();
            String temporalStorage = null;
            if (file.isAccessible() && file.exists() && localFile.canRead()) {
                String line;
                InputStream is = file.getContents(true);
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                StringBuilder sb = new StringBuilder();
                boolean firstLine = true;
                while ((line = br.readLine()) != null) {
                    if (firstLine) {
                        firstLine = false;
                    } else {
                        sb.append('\n');
                    }
                    sb.append(line);
                }
                temporalStorage = sb.toString();
                br.close();
            }
            if (temporalStorage == null || !temporalStorage.equals(temporaloutput)) {
                if (file.exists()) {
                    file.setContents((InputStream)new ByteArrayInputStream(temporaloutput.getBytes()), 3, null);
                } else {
                    file.create((InputStream)new ByteArrayInputStream(temporaloutput.getBytes()), 1, null);
                }
                try {
                    file.refreshLocal(0, null);
                }
                catch (CoreException e) {
                    ErrorReporter.logExceptionStackTrace((String)("While refreshing `" + file.getName() + "'"), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            ErrorReporter.logExceptionStackTrace((String)("The properties of project '" + this.project.getName() + "' could not be saved"), (Throwable)e);
        }
    }

    public Document getDocumentFromFile(IFile file) {
        if (!file.isAccessible()) {
            return null;
        }
        LSInput lsInput = this.domImplLS.createLSInput();
        Document document = null;
        try {
            InputStream istream = file.getContents(true);
            lsInput.setByteStream(istream);
            document = this.parser.parse(lsInput);
            istream.close();
            file.refreshLocal(0, null);
        }
        catch (Exception e) {
            ErrorReporter.logExceptionStackTrace((String)("While parsing `" + file.getName() + "'"), (Throwable)e);
        }
        return document;
    }

    public static Node getNodebyName(NodeList nodeList, String name) {
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            Node temp = nodeList.item(i);
            if (!temp.getNodeName().equals(name)) continue;
            return temp;
        }
        return null;
    }

    public static void saveActualConfigurationInfoToNode(IProject project, Document document) {
        Node activeConfiguration = ProjectFileHandler.getNodebyName(document.getDocumentElement().getChildNodes(), ACTIVECONFIGURATIONXMLNODE);
        if (activeConfiguration == null) {
            activeConfiguration = document.createElement(ACTIVECONFIGURATIONXMLNODE);
            document.getDocumentElement().appendChild(activeConfiguration);
        } else {
            Node firstChild = activeConfiguration.getFirstChild();
            while (firstChild != null) {
                activeConfiguration.removeChild(firstChild);
                firstChild = activeConfiguration.getFirstChild();
            }
        }
        String activeConfigurationName = ProjectFileHandler.getActiveConfigurationName(project);
        activeConfiguration.appendChild(document.createTextNode(activeConfigurationName));
    }

    public static void saveProjectInfoToNode(IProject project, Node root, Document document) {
        IContainer[] workingDirectories = ProjectBasedBuilder.getProjectBasedBuilder(project).getWorkingDirectoryResources(false);
        ResourceVisitor saveVisitor = new ResourceVisitor(workingDirectories);
        try {
            project.accept((IResourceVisitor)saveVisitor);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While collecting resources of `" + project.getName() + "'"), (Throwable)e);
        }
        Map<String, IFile> files = saveVisitor.getFiles();
        Map<String, IFolder> folders = saveVisitor.getFolders();
        Node oldProjectRoot = ProjectFileHandler.getNodebyName(root.getChildNodes(), PROJECTPROPERTIESXMLNODE);
        Node newProjectRoot = ProjectFileHandler.saveProjectProperties(project, document);
        if (oldProjectRoot == null) {
            root.appendChild(newProjectRoot);
        } else {
            root.replaceChild(newProjectRoot, oldProjectRoot);
        }
        Node oldFolderRoot = ProjectFileHandler.getNodebyName(root.getChildNodes(), FOLDERPROPERTIESXMLNODE);
        Element newFolderRoot = ProjectFileHandler.saveFolderProperties(document, workingDirectories, folders);
        if (newFolderRoot != null) {
            if (oldFolderRoot == null) {
                root.appendChild(newFolderRoot);
            } else {
                root.replaceChild(newFolderRoot, oldFolderRoot);
            }
        } else if (oldFolderRoot != null) {
            root.removeChild(oldFolderRoot);
        }
        Node oldFileRoot = ProjectFileHandler.getNodebyName(root.getChildNodes(), FILEPROPERTIESXMLNODE);
        Element newFileRoot = ProjectFileHandler.saveFileProperties(document, workingDirectories, files);
        if (newFileRoot != null) {
            if (oldFileRoot == null) {
                root.appendChild(newFileRoot);
            } else {
                root.replaceChild(newFileRoot, oldFileRoot);
            }
        } else if (oldFileRoot != null) {
            root.removeChild(oldFileRoot);
        }
    }

    public void loadProjectInfoFromNode(Node node, Set<IResource> changedResources) {
        NodeList rootList = node.getChildNodes();
        Node filePropertiesNode = null;
        Node folderPropertiesNode = null;
        int size = rootList.getLength();
        for (int i = 0; i < size; ++i) {
            Node tempNode = rootList.item(i);
            String nodeName = tempNode.getNodeName();
            if (PROJECTPROPERTIESXMLNODE.equals(nodeName)) {
                this.loadProjectProperties(tempNode, changedResources);
                continue;
            }
            if (FOLDERPROPERTIESXMLNODE.equals(nodeName)) {
                folderPropertiesNode = tempNode;
                continue;
            }
            if (!FILEPROPERTIESXMLNODE.equals(nodeName)) continue;
            filePropertiesNode = tempNode;
        }
        IContainer[] workingDirectories = ProjectBasedBuilder.getProjectBasedBuilder(this.project).getWorkingDirectoryResources(false);
        ResourceVisitor saveVisitor = new ResourceVisitor(workingDirectories);
        try {
            this.project.accept((IResourceVisitor)saveVisitor);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While collecting project resources of `" + this.project.getName() + "'"), (Throwable)e);
        }
        Map<String, IFile> files = saveVisitor.getFiles();
        Map<String, IFolder> folders = saveVisitor.getFolders();
        this.loadFileProperties(filePropertiesNode, files.values(), changedResources);
        this.loadFolderProperties(folderPropertiesNode, folders.values(), changedResources);
    }

    public static Node copyFileProperties(Node sourceNode, Document document, IProject project, Map<String, IFile> files, boolean saveDefaultValues) {
        HashSet<String> notYetReachedFiles = new HashSet<String>();
        notYetReachedFiles.addAll(files.keySet());
        Node root = null;
        if (sourceNode != null) {
            NodeList resourceList = sourceNode.getChildNodes();
            int size = resourceList.getLength();
            for (int i = 0; i < size; ++i) {
                Node newNode;
                Node tempNode = resourceList.item(i);
                if (!"FileResource".equals(tempNode.getNodeName()) || (newNode = FileBuildPropertyData.copyFileProperties(tempNode, document, project, notYetReachedFiles, saveDefaultValues)) == null) continue;
                if (root == null) {
                    root = document.createElement(FILEPROPERTIESXMLNODE);
                }
                root.appendChild(newNode);
            }
        }
        if (saveDefaultValues) {
            for (String fileName : notYetReachedFiles) {
                Node newNode = FileBuildPropertyData.copyDefaultFileProperties(document, files.get(fileName));
                if (newNode == null) continue;
                if (root == null) {
                    root = document.createElement(FILEPROPERTIESXMLNODE);
                }
                root.appendChild(newNode);
            }
        }
        return root;
    }

    public static Node copyFolderProperties(Node sourceNode, Document document, IProject project, Map<String, IFolder> folders, boolean saveDefaultValues) {
        HashSet<String> notYetReachedFolders = new HashSet<String>();
        notYetReachedFolders.addAll(folders.keySet());
        Node root = null;
        if (sourceNode != null) {
            NodeList resourceList = sourceNode.getChildNodes();
            int size = resourceList.getLength();
            for (int i = 0; i < size; ++i) {
                Node newNode;
                Node tempNode = resourceList.item(i);
                if (!"FolderResource".equals(tempNode.getNodeName()) || (newNode = FolderBuildPropertyData.copyFolderProperties(tempNode, document, project, notYetReachedFolders, saveDefaultValues)) == null) continue;
                if (root == null) {
                    root = document.createElement(FOLDERPROPERTIESXMLNODE);
                }
                root.appendChild(newNode);
            }
        }
        if (saveDefaultValues) {
            for (String folderName : notYetReachedFolders) {
                Node newNode = FolderBuildPropertyData.copyDefaultFolderProperties(document, folders.get(folderName));
                if (newNode == null) continue;
                if (root == null) {
                    root = document.createElement(FOLDERPROPERTIESXMLNODE);
                }
                root.appendChild(newNode);
            }
        }
        return root;
    }

    public static Node copyProjectProperties(Node sourceNode, Document document, boolean saveDefaultValues) {
        if (sourceNode == null) {
            return null;
        }
        NodeList resourceList = sourceNode.getChildNodes();
        Node namingConventionsNode = null;
        Node makefileSettingsNode = null;
        Node localBuildSettingsNode = null;
        Node remoteBuildSettingsNode = null;
        Node configurationPropertiesNode = null;
        int size = resourceList.getLength();
        for (int i = 0; i < size; ++i) {
            Node tempNode = resourceList.item(i);
            String nodeName = tempNode.getNodeName();
            if ("MakefileSettings".equals(nodeName)) {
                makefileSettingsNode = tempNode;
                continue;
            }
            if ("LocalBuildSettings".equals(nodeName)) {
                localBuildSettingsNode = tempNode;
                continue;
            }
            if ("RemoteBuildProperties".equals(nodeName)) {
                remoteBuildSettingsNode = tempNode;
                continue;
            }
            if ("ConfigurationRequirements".equals(nodeName)) {
                configurationPropertiesNode = tempNode;
                continue;
            }
            if (!"NamingCoventions".equals(nodeName)) continue;
            namingConventionsNode = tempNode;
        }
        Element root = document.createElement(PROJECTPROPERTIESXMLNODE);
        root.appendChild(ProjectBuildPropertyData.copyMakefileSettings(makefileSettingsNode, document, saveDefaultValues));
        root.appendChild(ProjectBuildPropertyData.copyLocalBuildSettings(localBuildSettingsNode, document, saveDefaultValues));
        Element element = ProjectRemoteBuildPropertyData.copyRemoteBuildProperties(remoteBuildSettingsNode, document, saveDefaultValues);
        if (element != null) {
            root.appendChild(element);
        }
        if ((element = ProjectNamingConventionPropertyData.copyProperties(namingConventionsNode, document, saveDefaultValues)) != null) {
            root.appendChild(element);
        }
        if ((element = ProjectConfigurationsPropertyData.copyProperties(configurationPropertiesNode, document)) != null) {
            root.appendChild(element);
        }
        return root;
    }

    public static void copyProjectInfo(Node sourceNode, Node targetNode, IProject project, Map<String, IFile> files, Map<String, IFolder> folders, boolean saveDefaultValues) {
        NodeList rootList = sourceNode.getChildNodes();
        Node projectPropertiesNode = null;
        Node filePropertiesNode = null;
        Node folderPropertiesNode = null;
        int size = rootList.getLength();
        for (int i = 0; i < size; ++i) {
            Node tempNode = rootList.item(i);
            String nodeName = tempNode.getNodeName();
            if (PROJECTPROPERTIESXMLNODE.equals(nodeName)) {
                projectPropertiesNode = tempNode;
                continue;
            }
            if (FOLDERPROPERTIESXMLNODE.equals(nodeName)) {
                folderPropertiesNode = tempNode;
                continue;
            }
            if (!FILEPROPERTIESXMLNODE.equals(nodeName)) continue;
            filePropertiesNode = tempNode;
        }
        Document document = targetNode.getOwnerDocument();
        Node newNode = ProjectFileHandler.copyProjectProperties(projectPropertiesNode, document, saveDefaultValues);
        if (newNode != null) {
            targetNode.appendChild(newNode);
        }
        if ((newNode = ProjectFileHandler.copyFolderProperties(folderPropertiesNode, document, project, folders, saveDefaultValues)) != null) {
            targetNode.appendChild(newNode);
        }
        if ((newNode = ProjectFileHandler.copyFileProperties(filePropertiesNode, document, project, files, saveDefaultValues)) != null) {
            targetNode.appendChild(newNode);
        }
    }

    public static String getActiveConfigurationName(IProject project) {
        String activeConfigurationName = null;
        try {
            activeConfigurationName = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "org.eclipse.titan.designer.activeConfiguration"));
            if (activeConfigurationName == null || activeConfigurationName.length() == 0) {
                activeConfigurationName = DEFAULTCONFIGURATIONNAME;
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While getting the active configuration of `" + project.getName() + "'"), (Throwable)e);
            activeConfigurationName = DEFAULTCONFIGURATIONNAME;
        }
        return activeConfigurationName;
    }

    public static List<String> getConfigurations(Document document) {
        ArrayList<String> configurationNames = new ArrayList<String>();
        configurationNames.add(DEFAULTCONFIGURATIONNAME);
        if (document != null) {
            NodeList rootList = document.getDocumentElement().getChildNodes();
            int size = rootList.getLength();
            for (int i = 0; i < size; ++i) {
                Node temp = rootList.item(i);
                if (!CONFIGURATIONSXMLNODE.equals(temp.getNodeName())) continue;
                NodeList configurationList = temp.getChildNodes();
                int size2 = configurationList.getLength();
                for (int j = 0; j < size2; ++j) {
                    Node temp2 = configurationList.item(j);
                    if (!CONFIGURATIONXMLNODE.equals(temp2.getNodeName())) continue;
                    Node attribute = temp2.getAttributes().getNamedItem("name");
                    configurationNames.add(attribute.getTextContent());
                }
            }
        }
        return configurationNames;
    }

    public static Node findConfigurationNode(Node root, String configurationName) {
        if (configurationName == null || DEFAULTCONFIGURATIONNAME.equals(configurationName)) {
            return root;
        }
        NodeList rootList = root.getChildNodes();
        int size = rootList.getLength();
        for (int i = 0; i < size; ++i) {
            Node temp = rootList.item(i);
            if (!CONFIGURATIONSXMLNODE.equals(temp.getNodeName())) continue;
            NodeList configurationList = temp.getChildNodes();
            int size2 = configurationList.getLength();
            for (int j = 0; j < size2; ++j) {
                Node attribute;
                Node temp2 = configurationList.item(j);
                if (!CONFIGURATIONXMLNODE.equals(temp2.getNodeName()) || (attribute = temp2.getAttributes().getNamedItem("name")) == null || !configurationName.equals(attribute.getTextContent())) continue;
                return temp2;
            }
        }
        return null;
    }

    public void removeConfigurationNode(Node root, String configurationName) {
        if (configurationName == null || DEFAULTCONFIGURATIONNAME.equals(configurationName)) {
            return;
        }
        NodeList rootList = root.getChildNodes();
        int size = rootList.getLength();
        for (int i = 0; i < size; ++i) {
            Node temp = rootList.item(i);
            if (!CONFIGURATIONSXMLNODE.equals(temp.getNodeName())) continue;
            NodeList configurationList = temp.getChildNodes();
            int size2 = configurationList.getLength();
            for (int j = 0; j < size2; ++j) {
                Node attribute;
                Node temp2 = configurationList.item(j);
                if (!CONFIGURATIONXMLNODE.equals(temp2.getNodeName()) || (attribute = temp2.getAttributes().getNamedItem("name")) == null || !configurationName.equals(attribute.getTextContent())) continue;
                temp.removeChild(temp2);
                return;
            }
        }
    }

    public static void clearNode(Node root) {
        if (root == null) {
            return;
        }
        Node child = root.getFirstChild();
        while (child != null) {
            Node sibling = child.getNextSibling();
            if (3 == child.getNodeType()) {
                String content = child.getNodeValue().trim();
                if (content.isEmpty()) {
                    root.removeChild(child);
                }
            } else {
                ProjectFileHandler.clearNode(child);
            }
            child = sibling;
        }
    }

    public static void indentNode(Document document, Node root, int level) {
        Node child = root.getFirstChild();
        if ((child == null || 8 != child.getNodeType()) && child != null && 3 != child.getNodeType()) {
            root.insertBefore(document.createTextNode(ProjectFileHandler.getXMLIndentation(level + 2)), child);
        }
        while (child != null) {
            Node sibling = child.getNextSibling();
            if (3 == child.getNodeType()) {
                child.setTextContent(child.getNodeValue().replaceAll("\\s", ""));
            } else {
                if (8 == child.getNodeType()) {
                    root.removeChild(child);
                } else if (sibling == null) {
                    root.appendChild(document.createTextNode(ProjectFileHandler.getXMLIndentation(level)));
                } else if (3 != sibling.getNodeType()) {
                    root.insertBefore(document.createTextNode(ProjectFileHandler.getXMLIndentation(level + 2)), sibling);
                }
                ProjectFileHandler.indentNode(document, child, level + 2);
            }
            child = sibling;
        }
    }

    private static class ResourceVisitor
    implements IResourceVisitor {
        private final IContainer[] workingDirectories;
        private final Map<String, IFolder> visitedFolders;
        private final Map<String, IFile> visitedFiles;

        public ResourceVisitor(IContainer[] workingDirectories) {
            this.workingDirectories = workingDirectories;
            this.visitedFiles = new TreeMap<String, IFile>();
            this.visitedFolders = new TreeMap<String, IFolder>();
        }

        public Map<String, IFile> getFiles() {
            return this.visitedFiles;
        }

        public Map<String, IFolder> getFolders() {
            return this.visitedFolders;
        }

        public boolean visit(IResource resource) {
            if (resource == null || !resource.isAccessible()) {
                return false;
            }
            switch (resource.getType()) {
                case 1: {
                    if (resource.getProjectRelativePath().lastSegment().startsWith(ProjectFileHandler.DOT)) {
                        return false;
                    }
                    this.visitedFiles.put(resource.getProjectRelativePath().toPortableString(), (IFile)resource);
                    break;
                }
                case 2: {
                    if (resource.getProjectRelativePath().lastSegment().startsWith(ProjectFileHandler.DOT)) {
                        return false;
                    }
                    for (IContainer workingDirectory : this.workingDirectories) {
                        if (!workingDirectory.equals(resource)) continue;
                        return false;
                    }
                    this.visitedFolders.put(resource.getProjectRelativePath().toPortableString(), (IFolder)resource);
                    break;
                }
            }
            return true;
        }
    }
}

