/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportReferencesCollector;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.corext.util.TypeNameMatchCollector;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.text.edits.TextEdit;

public class OrganizeImportsOperation
implements IWorkspaceRunnable {
    private static ImportRewrite.ImportRewriteContext UNRESOLVABLE_IMPORT_CONTEXT = new ImportRewrite.ImportRewriteContext(){

        public int findInContext(String qualifier, String name, int kind) {
            return 4;
        }
    };
    private boolean fDoSave;
    private boolean fIgnoreLowerCaseNames;
    private IChooseImportQuery fChooseImportQuery;
    private int fNumberOfImportsAdded;
    private int fNumberOfImportsRemoved;
    private IProblem fParsingError;
    private ICompilationUnit fCompilationUnit;
    private CompilationUnit fASTRoot;
    private final boolean fAllowSyntaxErrors;

    public OrganizeImportsOperation(ICompilationUnit cu, CompilationUnit astRoot, boolean ignoreLowerCaseNames, boolean save, boolean allowSyntaxErrors, IChooseImportQuery chooseImportQuery) {
        this.fCompilationUnit = cu;
        this.fASTRoot = astRoot;
        this.fDoSave = save;
        this.fIgnoreLowerCaseNames = ignoreLowerCaseNames;
        this.fAllowSyntaxErrors = allowSyntaxErrors;
        this.fChooseImportQuery = chooseImportQuery;
        this.fNumberOfImportsAdded = 0;
        this.fNumberOfImportsRemoved = 0;
        this.fParsingError = null;
    }

    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(Messages.format(CodeGenerationMessages.OrganizeImportsOperation_description, BasicElementLabels.getFileName((ITypeRoot)this.fCompilationUnit)), 10);
            TextEdit edit = this.createTextEdit((IProgressMonitor)new SubProgressMonitor(monitor, 9));
            if (edit == null) {
                return;
            }
            JavaModelUtil.applyEdit(this.fCompilationUnit, edit, this.fDoSave, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            monitor.done();
        }
    }

    public TextEdit createTextEdit(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            this.fNumberOfImportsAdded = 0;
            this.fNumberOfImportsRemoved = 0;
            monitor.beginTask(Messages.format(CodeGenerationMessages.OrganizeImportsOperation_description, BasicElementLabels.getFileName((ITypeRoot)this.fCompilationUnit)), 9);
            CompilationUnit astRoot = this.fASTRoot;
            if (astRoot == null) {
                astRoot = SharedASTProvider.getAST((ITypeRoot)this.fCompilationUnit, SharedASTProvider.WAIT_YES, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
            } else {
                monitor.worked(2);
            }
            ImportRewrite importsRewrite = StubUtility.createImportRewrite(astRoot, false);
            ArrayList<SimpleName> typeReferences = new ArrayList<SimpleName>();
            ArrayList<SimpleName> staticReferences = new ArrayList<SimpleName>();
            HashSet<String> oldSingleImports = new HashSet<String>();
            HashSet<String> oldDemandImports = new HashSet<String>();
            if (!this.collectReferences(astRoot, typeReferences, staticReferences, oldSingleImports, oldDemandImports)) {
                return null;
            }
            monitor.worked(1);
            UnresolvableImportMatcher unresolvableImportMatcher = UnresolvableImportMatcher.forCompilationUnit(astRoot);
            TypeReferenceProcessor processor = new TypeReferenceProcessor(oldSingleImports, oldDemandImports, astRoot, importsRewrite, this.fIgnoreLowerCaseNames, unresolvableImportMatcher);
            for (SimpleName typeRef : typeReferences) {
                processor.add(typeRef);
            }
            boolean hasOpenChoices = processor.process((IProgressMonitor)new SubProgressMonitor(monitor, 3));
            this.addStaticImports(staticReferences, importsRewrite, unresolvableImportMatcher);
            if (hasOpenChoices && this.fChooseImportQuery != null) {
                ISourceRange[] ranges;
                TypeNameMatch[][] choices = processor.getChoices();
                TypeNameMatch[] chosen = this.fChooseImportQuery.chooseImports(choices, ranges = processor.getChoicesSourceRanges());
                if (chosen == null) {
                    throw new OperationCanceledException();
                }
                int i = 0;
                while (i < chosen.length) {
                    TypeNameMatch typeInfo = chosen[i];
                    if (typeInfo != null) {
                        importsRewrite.addImport(typeInfo.getFullyQualifiedName());
                    } else {
                        String typeName = choices[i][0].getSimpleTypeName();
                        Set<String> matchingUnresolvableImports = unresolvableImportMatcher.matchTypeImports(typeName);
                        if (!matchingUnresolvableImports.isEmpty()) {
                            for (String string : matchingUnresolvableImports) {
                                importsRewrite.addImport(string, UNRESOLVABLE_IMPORT_CONTEXT);
                            }
                        }
                    }
                    ++i;
                }
            }
            TextEdit result = importsRewrite.rewriteImports((IProgressMonitor)new SubProgressMonitor(monitor, 3));
            this.determineImportDifferences(importsRewrite, oldSingleImports, oldDemandImports);
            TextEdit textEdit = result;
            return textEdit;
        }
        finally {
            monitor.done();
        }
    }

    private void determineImportDifferences(ImportRewrite importsStructure, Set<String> oldSingleImports, Set<String> oldDemandImports) {
        String importName;
        ArrayList<String> importsAdded = new ArrayList<String>();
        importsAdded.addAll(Arrays.asList(importsStructure.getCreatedImports()));
        importsAdded.addAll(Arrays.asList(importsStructure.getCreatedStaticImports()));
        Object[] content = oldSingleImports.toArray();
        int i = 0;
        while (i < content.length) {
            importName = (String)content[i];
            if (importsAdded.remove(importName)) {
                oldSingleImports.remove(importName);
            }
            ++i;
        }
        content = oldDemandImports.toArray();
        i = 0;
        while (i < content.length) {
            importName = (String)content[i];
            if (importsAdded.remove(String.valueOf(importName) + ".*")) {
                oldDemandImports.remove(importName);
            }
            ++i;
        }
        this.fNumberOfImportsAdded = importsAdded.size();
        this.fNumberOfImportsRemoved = oldSingleImports.size() + oldDemandImports.size();
    }

    private void addStaticImports(Collection<SimpleName> staticReferences, ImportRewrite importRewrite, UnresolvableImportMatcher unresolvableImportMatcher) {
        for (SimpleName name : staticReferences) {
            IBinding binding = name.resolveBinding();
            if (binding != null) {
                importRewrite.addStaticImport(binding);
                continue;
            }
            String identifier = name.getIdentifier();
            Set<String> unresolvableImports = unresolvableImportMatcher.matchStaticImports(identifier);
            for (String unresolvableImport : unresolvableImports) {
                int lastDotIndex = unresolvableImport.lastIndexOf(46);
                if (lastDotIndex == -1) continue;
                String declaringTypeName = unresolvableImport.substring(0, lastDotIndex);
                String simpleName = unresolvableImport.substring(lastDotIndex + 1);
                boolean isField = false;
                importRewrite.addStaticImport(declaringTypeName, simpleName, isField, UNRESOLVABLE_IMPORT_CONTEXT);
            }
        }
    }

    private boolean collectReferences(CompilationUnit astRoot, List<SimpleName> typeReferences, List<SimpleName> staticReferences, Set<String> oldSingleImports, Set<String> oldDemandImports) {
        IProblem curr;
        int i;
        if (!this.fAllowSyntaxErrors) {
            IProblem[] problems = astRoot.getProblems();
            i = 0;
            while (i < problems.length) {
                curr = problems[i];
                if (curr.isError() && (curr.getID() & 0x40000000) != 0) {
                    this.fParsingError = problems[i];
                    return false;
                }
                ++i;
            }
        }
        List imports = astRoot.imports();
        i = 0;
        while (i < imports.size()) {
            curr = (ImportDeclaration)imports.get(i);
            String id = ASTResolving.getFullName(curr.getName());
            if (curr.isOnDemand()) {
                oldDemandImports.add(id);
            } else {
                oldSingleImports.add(id);
            }
            ++i;
        }
        IJavaProject project = this.fCompilationUnit.getJavaProject();
        ImportReferencesCollector.collect((ASTNode)astRoot, project, null, typeReferences, staticReferences);
        return true;
    }

    public IProblem getParseError() {
        return this.fParsingError;
    }

    public int getNumberOfImportsAdded() {
        return this.fNumberOfImportsAdded;
    }

    public int getNumberOfImportsRemoved() {
        return this.fNumberOfImportsRemoved;
    }

    public ISchedulingRule getScheduleRule() {
        return this.fCompilationUnit.getResource();
    }

    public static interface IChooseImportQuery {
        public TypeNameMatch[] chooseImports(TypeNameMatch[][] var1, ISourceRange[] var2);
    }

    private static class TypeReferenceProcessor {
        private Set<String> fOldSingleImports;
        private Set<String> fOldDemandImports;
        private Set<String> fImplicitImports;
        private ImportRewrite fImpStructure;
        private boolean fDoIgnoreLowerCaseNames;
        private final UnresolvableImportMatcher fUnresolvableImportMatcher;
        private IPackageFragment fCurrPackage;
        private ScopeAnalyzer fAnalyzer;
        private boolean fAllowDefaultPackageImports;
        private Map<String, UnresolvedTypeData> fUnresolvedTypes;
        private Set<String> fImportsAdded;
        private TypeNameMatch[][] fOpenChoices;
        private SourceRange[] fSourceRanges;

        public TypeReferenceProcessor(Set<String> oldSingleImports, Set<String> oldDemandImports, CompilationUnit root, ImportRewrite impStructure, boolean ignoreLowerCaseNames, UnresolvableImportMatcher unresolvableImportMatcher) {
            this.fOldSingleImports = oldSingleImports;
            this.fOldDemandImports = oldDemandImports;
            this.fImpStructure = impStructure;
            this.fDoIgnoreLowerCaseNames = ignoreLowerCaseNames;
            this.fUnresolvableImportMatcher = unresolvableImportMatcher;
            ICompilationUnit cu = impStructure.getCompilationUnit();
            this.fImplicitImports = new HashSet<String>(3);
            this.fImplicitImports.add("");
            this.fImplicitImports.add("java.lang");
            this.fImplicitImports.add(cu.getParent().getElementName());
            this.fAnalyzer = new ScopeAnalyzer(root);
            this.fCurrPackage = (IPackageFragment)cu.getParent();
            this.fAllowDefaultPackageImports = cu.getJavaProject().getOption("org.eclipse.jdt.core.compiler.source", true).equals("1.3");
            this.fImportsAdded = new HashSet<String>();
            this.fUnresolvedTypes = new HashMap<String, UnresolvedTypeData>();
        }

        private boolean needsImport(ITypeBinding typeBinding, SimpleName ref) {
            if (!typeBinding.isTopLevel() && !typeBinding.isMember() || typeBinding.isRecovered()) {
                return false;
            }
            int modifiers = typeBinding.getModifiers();
            if (Modifier.isPrivate((int)modifiers)) {
                return false;
            }
            ITypeBinding currTypeBinding = Bindings.getBindingOfParentType((ASTNode)ref);
            if (currTypeBinding == null) {
                return ASTNodes.getParent((ASTNode)ref, 35) != null;
            }
            if (!Modifier.isPublic((int)modifiers) && !currTypeBinding.getPackage().getName().equals(typeBinding.getPackage().getName())) {
                return false;
            }
            ASTNode parent = ref.getParent();
            while (parent instanceof Type) {
                parent = parent.getParent();
            }
            if (parent instanceof AbstractTypeDeclaration && parent.getParent() instanceof CompilationUnit) {
                return true;
            }
            return !typeBinding.isMember() || !this.fAnalyzer.isDeclaredInScope((IBinding)typeBinding, ref, 20);
        }

        public void add(SimpleName ref) {
            char ch;
            String typeName = ref.getIdentifier();
            if (this.fImportsAdded.contains(typeName)) {
                return;
            }
            IBinding binding = ref.resolveBinding();
            if (binding != null) {
                if (binding.getKind() != 2) {
                    return;
                }
                ITypeBinding typeBinding = (ITypeBinding)binding;
                if (typeBinding.isArray()) {
                    typeBinding = typeBinding.getElementType();
                }
                if (!(typeBinding = typeBinding.getTypeDeclaration()).isRecovered()) {
                    if (this.needsImport(typeBinding, ref)) {
                        this.fImpStructure.addImport(typeBinding);
                        this.fImportsAdded.add(typeName);
                    }
                    return;
                }
            } else if (this.fDoIgnoreLowerCaseNames && typeName.length() > 0 && Strings.isLowerCase(ch = typeName.charAt(0)) && Character.isLetter(ch)) {
                return;
            }
            this.fImportsAdded.add(typeName);
            this.fUnresolvedTypes.put(typeName, new UnresolvedTypeData(ref));
        }

        public boolean process(IProgressMonitor monitor) throws JavaModelException {
            try {
                int nUnresolved = this.fUnresolvedTypes.size();
                if (nUnresolved == 0) {
                    return false;
                }
                char[][] allTypes = new char[nUnresolved][];
                int i = 0;
                Iterator<String> iter = this.fUnresolvedTypes.keySet().iterator();
                while (iter.hasNext()) {
                    allTypes[i++] = iter.next().toCharArray();
                }
                ArrayList<TypeNameMatch> typesFound = new ArrayList<TypeNameMatch>();
                IJavaProject project = this.fCurrPackage.getJavaProject();
                IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{project});
                TypeNameMatchCollector collector = new TypeNameMatchCollector(typesFound);
                new SearchEngine().searchAllTypeNames(null, (char[][])allTypes, scope, (TypeNameMatchRequestor)collector, 3, monitor);
                boolean is50OrHigher = JavaModelUtil.is50OrHigher(project);
                i = 0;
                while (i < typesFound.size()) {
                    TypeNameMatch curr = typesFound.get(i);
                    UnresolvedTypeData data = this.fUnresolvedTypes.get(curr.getSimpleTypeName());
                    if (data != null && this.isVisible(curr) && this.isOfKind(curr, data.typeKinds, is50OrHigher) && (this.fAllowDefaultPackageImports || curr.getPackageName().length() > 0)) {
                        data.addInfo(curr);
                    }
                    ++i;
                }
                for (Map.Entry<String, UnresolvedTypeData> entry : this.fUnresolvedTypes.entrySet()) {
                    Set<String> matchingUnresolvableImports;
                    if (entry.getValue().foundInfos.size() != 0 || (matchingUnresolvableImports = this.fUnresolvableImportMatcher.matchTypeImports(entry.getKey())).isEmpty()) continue;
                    for (String string : matchingUnresolvableImports) {
                        this.fImpStructure.addImport(string, UNRESOLVABLE_IMPORT_CONTEXT);
                    }
                }
                ArrayList<TypeNameMatch[]> openChoices = new ArrayList<TypeNameMatch[]>(nUnresolved);
                ArrayList<SourceRange> sourceRanges = new ArrayList<SourceRange>(nUnresolved);
                for (UnresolvedTypeData data : this.fUnresolvedTypes.values()) {
                    TypeNameMatch[] openChoice = this.processTypeInfo(data.foundInfos);
                    if (openChoice == null) continue;
                    openChoices.add(openChoice);
                    sourceRanges.add(new SourceRange(data.ref.getStartPosition(), data.ref.getLength()));
                }
                if (openChoices.isEmpty()) {
                    return false;
                }
                this.fOpenChoices = (TypeNameMatch[][])openChoices.toArray((T[])new TypeNameMatch[openChoices.size()][]);
                this.fSourceRanges = sourceRanges.toArray(new SourceRange[sourceRanges.size()]);
                return true;
            }
            finally {
                monitor.done();
            }
        }

        private TypeNameMatch[] processTypeInfo(List<TypeNameMatch> typeRefsFound) {
            int nFound = typeRefsFound.size();
            if (nFound == 0) {
                return null;
            }
            if (nFound == 1) {
                TypeNameMatch typeRef = typeRefsFound.get(0);
                this.fImpStructure.addImport(typeRef.getFullyQualifiedName());
                return null;
            }
            String typeToImport = null;
            boolean ambiguousImports = false;
            int i = 0;
            while (i < nFound) {
                TypeNameMatch typeRef = typeRefsFound.get(i);
                String fullName = typeRef.getFullyQualifiedName();
                String containerName = typeRef.getTypeContainerName();
                if (this.fOldSingleImports.contains(fullName)) {
                    this.fImpStructure.addImport(fullName);
                    return null;
                }
                if (this.fOldDemandImports.contains(containerName) || this.fImplicitImports.contains(containerName)) {
                    if (typeToImport == null) {
                        typeToImport = fullName;
                    } else {
                        ambiguousImports = true;
                    }
                }
                ++i;
            }
            if (typeToImport != null && !ambiguousImports) {
                this.fImpStructure.addImport(typeToImport);
                return null;
            }
            return typeRefsFound.toArray(new TypeNameMatch[nFound]);
        }

        private boolean isOfKind(TypeNameMatch curr, int typeKinds, boolean is50OrHigher) {
            int flags = curr.getModifiers();
            if (Flags.isAnnotation((int)flags)) {
                return is50OrHigher && (typeKinds & 8) != 0;
            }
            if (Flags.isEnum((int)flags)) {
                return is50OrHigher && (typeKinds & 0x10) != 0;
            }
            if (Flags.isInterface((int)flags)) {
                return (typeKinds & 4) != 0;
            }
            return (typeKinds & 2) != 0;
        }

        private boolean isVisible(TypeNameMatch curr) {
            int flags = curr.getModifiers();
            if (Flags.isPrivate((int)flags)) {
                return false;
            }
            if (Flags.isPublic((int)flags) || Flags.isProtected((int)flags)) {
                return true;
            }
            return curr.getPackageName().equals(this.fCurrPackage.getElementName());
        }

        public TypeNameMatch[][] getChoices() {
            return this.fOpenChoices;
        }

        public ISourceRange[] getChoicesSourceRanges() {
            return this.fSourceRanges;
        }

        private static class UnresolvedTypeData {
            final SimpleName ref;
            final int typeKinds;
            final List<TypeNameMatch> foundInfos;

            public UnresolvedTypeData(SimpleName ref) {
                this.ref = ref;
                this.typeKinds = ASTResolving.getPossibleTypeKinds((ASTNode)ref, true);
                this.foundInfos = new ArrayList<TypeNameMatch>(3);
            }

            public void addInfo(TypeNameMatch info) {
                int i = this.foundInfos.size() - 1;
                while (i >= 0) {
                    TypeNameMatch curr = this.foundInfos.get(i);
                    if (curr.getTypeContainerName().equals(info.getTypeContainerName())) {
                        return;
                    }
                    --i;
                }
                this.foundInfos.add(info);
            }
        }
    }

    private static class UnresolvableImportMatcher {
        private final Map<String, Set<String>> fTypeImportsBySimpleName;
        private final Map<String, Set<String>> fStaticImportsBySimpleName;

        static UnresolvableImportMatcher forCompilationUnit(CompilationUnit cu) {
            Collection<ImportDeclaration> unresolvableImports = UnresolvableImportMatcher.determineUnresolvableImports(cu);
            HashMap<String, Set<String>> typeImportsBySimpleName = new HashMap<String, Set<String>>();
            HashMap<String, Set<String>> staticImportsBySimpleName = new HashMap<String, Set<String>>();
            for (ImportDeclaration importDeclaration : unresolvableImports) {
                String qualifiedName = importDeclaration.isOnDemand() ? String.valueOf(importDeclaration.getName().getFullyQualifiedName()) + ".*" : importDeclaration.getName().getFullyQualifiedName();
                String simpleName = qualifiedName.substring(qualifiedName.lastIndexOf(46) + 1);
                HashMap<String, Set<String>> importsBySimpleName = importDeclaration.isStatic() ? staticImportsBySimpleName : typeImportsBySimpleName;
                HashSet<String> importsWithSimpleName = (HashSet<String>)importsBySimpleName.get(simpleName);
                if (importsWithSimpleName == null) {
                    importsWithSimpleName = new HashSet<String>();
                    importsBySimpleName.put(simpleName, importsWithSimpleName);
                }
                importsWithSimpleName.add(qualifiedName);
            }
            return new UnresolvableImportMatcher(typeImportsBySimpleName, staticImportsBySimpleName);
        }

        private static Collection<ImportDeclaration> determineUnresolvableImports(CompilationUnit cu) {
            ArrayList<ImportDeclaration> unresolvableImports = new ArrayList<ImportDeclaration>(cu.imports().size());
            IProblem[] iProblemArray = cu.getProblems();
            int n = iProblemArray.length;
            int n2 = 0;
            while (n2 < n) {
                ImportDeclaration problematicImport;
                IProblem problem = iProblemArray[n2];
                if (problem.getID() == 268435846 && (problematicImport = UnresolvableImportMatcher.getProblematicImport(problem, cu)) != null) {
                    unresolvableImports.add(problematicImport);
                }
                ++n2;
            }
            return unresolvableImports;
        }

        private static ImportDeclaration getProblematicImport(IProblem problem, CompilationUnit cu) {
            ASTNode importNode;
            ASTNode coveringNode = new ProblemLocation(problem).getCoveringNode(cu);
            if (coveringNode != null && (importNode = ASTNodes.getParent(coveringNode, 26)) instanceof ImportDeclaration) {
                return (ImportDeclaration)importNode;
            }
            return null;
        }

        private UnresolvableImportMatcher(Map<String, Set<String>> typeImportsBySimpleName, Map<String, Set<String>> staticImportsBySimpleName) {
            this.fTypeImportsBySimpleName = typeImportsBySimpleName;
            this.fStaticImportsBySimpleName = staticImportsBySimpleName;
        }

        private Set<String> matchImports(boolean isStatic, String simpleName) {
            Map<String, Set<String>> importsBySimpleName = isStatic ? this.fStaticImportsBySimpleName : this.fTypeImportsBySimpleName;
            Set<String> matchingSingleImports = importsBySimpleName.get(simpleName);
            if (matchingSingleImports != null) {
                return Collections.unmodifiableSet(matchingSingleImports);
            }
            Set<String> matchingOnDemandImports = importsBySimpleName.get("*");
            if (matchingOnDemandImports != null) {
                return Collections.unmodifiableSet(matchingOnDemandImports);
            }
            return Collections.emptySet();
        }

        Set<String> matchTypeImports(String simpleName) {
            return this.matchImports(false, simpleName);
        }

        Set<String> matchStaticImports(String simpleName) {
            return this.matchImports(true, simpleName);
        }
    }
}

