/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposal;

public class MissingReturnTypeCorrectionProposal
extends LinkedCorrectionProposal {
    protected static final String RETURN_EXPRESSION_KEY = "value";
    private MethodDeclaration fMethodDecl;
    protected ReturnStatement fExistingReturn;

    public MissingReturnTypeCorrectionProposal(ICompilationUnit cu, MethodDeclaration decl, ReturnStatement existingReturn, int relevance) {
        super("", cu, (ASTRewrite)null, relevance, JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif"));
        this.fMethodDecl = decl;
        this.fExistingReturn = existingReturn;
    }

    @Override
    public String getName() {
        if (this.fExistingReturn != null) {
            return CorrectionMessages.MissingReturnTypeCorrectionProposal_changereturnstatement_description;
        }
        return CorrectionMessages.MissingReturnTypeCorrectionProposal_addreturnstatement_description;
    }

    @Override
    protected ASTRewrite getRewrite() {
        AST ast = this.getAST();
        ITypeBinding returnBinding = this.getReturnTypeBinding();
        if (this.fExistingReturn != null) {
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            Expression expression = this.evaluateReturnExpressions(ast, returnBinding, this.fExistingReturn.getStartPosition());
            if (expression != null) {
                rewrite.set((ASTNode)this.fExistingReturn, (StructuralPropertyDescriptor)ReturnStatement.EXPRESSION_PROPERTY, (Object)expression, null);
                this.addLinkedPosition(rewrite.track((ASTNode)expression), true, RETURN_EXPRESSION_KEY);
            }
            return rewrite;
        }
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ASTNode body = this.getBody();
        if (body instanceof Block) {
            Expression expression;
            ITypeBinding binding;
            Block block = (Block)body;
            List statements = block.statements();
            int nStatements = statements.size();
            ASTNode lastStatement = null;
            if (nStatements > 0) {
                lastStatement = (ASTNode)statements.get(nStatements - 1);
            }
            if (returnBinding != null && lastStatement instanceof ExpressionStatement && lastStatement.getNodeType() != 7 && (binding = (expression = ((ExpressionStatement)lastStatement).getExpression()).resolveTypeBinding()) != null && binding.isAssignmentCompatible(returnBinding)) {
                Expression placeHolder = (Expression)rewrite.createMoveTarget((ASTNode)expression);
                ReturnStatement returnStatement = ast.newReturnStatement();
                returnStatement.setExpression(placeHolder);
                rewrite.replace(lastStatement, (ASTNode)returnStatement, null);
                return rewrite;
            }
            int offset = lastStatement == null ? block.getStartPosition() + 1 : lastStatement.getStartPosition() + lastStatement.getLength();
            ReturnStatement returnStatement = ast.newReturnStatement();
            Expression expression2 = this.evaluateReturnExpressions(ast, returnBinding, offset);
            returnStatement.setExpression(expression2);
            rewrite.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY).insertLast((ASTNode)returnStatement, null);
            this.addLinkedPosition(rewrite.track((ASTNode)returnStatement.getExpression()), true, RETURN_EXPRESSION_KEY);
        }
        return rewrite;
    }

    private Expression evaluateReturnExpressions(AST ast, ITypeBinding returnBinding, int returnOffset) {
        CompilationUnit root = this.getCU();
        Expression result = null;
        if (returnBinding != null) {
            result = this.computeProposals(ast, returnBinding, returnOffset, root, result);
        }
        Expression defaultExpression = this.createDefaultExpression(ast);
        this.addLinkedPositionProposal(RETURN_EXPRESSION_KEY, ASTNodes.asString((ASTNode)defaultExpression), null);
        if (result == null) {
            return defaultExpression;
        }
        return result;
    }

    protected Expression computeProposals(AST ast, ITypeBinding returnBinding, int returnOffset, CompilationUnit root, Expression result) {
        ScopeAnalyzer analyzer = new ScopeAnalyzer(root);
        IBinding[] bindings = analyzer.getDeclarationsInScope(returnOffset, 18);
        int i = 0;
        while (i < bindings.length) {
            IVariableBinding curr = (IVariableBinding)bindings[i];
            ITypeBinding type = curr.getType();
            if (type != null && type.isAssignmentCompatible(returnBinding) && this.testModifier(curr)) {
                if (result == null) {
                    result = ast.newSimpleName(curr.getName());
                }
                this.addLinkedPositionProposal(RETURN_EXPRESSION_KEY, curr.getName(), null);
            }
            ++i;
        }
        return result;
    }

    protected boolean testModifier(IVariableBinding curr) {
        int staticFinal;
        int modifiers = curr.getModifiers();
        if ((modifiers & (staticFinal = 24)) == staticFinal) {
            return false;
        }
        return !Modifier.isStatic((int)modifiers) || Modifier.isStatic((int)this.getModifiers());
    }

    protected Expression createDefaultExpression(AST ast) {
        return ASTNodeFactory.newDefaultExpression(ast, this.fMethodDecl.getReturnType2(), this.fMethodDecl.getExtraDimensions());
    }

    protected CompilationUnit getCU() {
        return (CompilationUnit)this.fMethodDecl.getRoot();
    }

    protected ASTNode getBody() {
        return this.fMethodDecl.getBody();
    }

    protected AST getAST() {
        return this.fMethodDecl.getAST();
    }

    protected ITypeBinding getReturnTypeBinding() {
        IMethodBinding methodBinding = this.fMethodDecl.resolveBinding();
        if (methodBinding != null && methodBinding.getReturnType() != null) {
            return methodBinding.getReturnType();
        }
        return null;
    }

    protected int getModifiers() {
        return this.fMethodDecl.getModifiers();
    }
}

