/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.osgi.fxloader.jpms;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.fx.osgi.fxloader.jpms.ConfigurationWrapper;
import org.eclipse.fx.osgi.fxloader.jpms.ModuleWrapper;

public class ModuleLayerWrapper {
    private static Class<?> CLASS;
    private static Method boot;
    private static Method configuration;
    private static Method defineModules;
    private static Method defineModulesWithOneLoader;
    private static Method findLoader;
    private static Method findModule;
    private static Method modules;
    public final Object self;

    public ModuleLayerWrapper(Object self) {
        this.self = self;
        ModuleLayerWrapper.init();
    }

    public static Class<?> CLASS() {
        ModuleLayerWrapper.init();
        return CLASS;
    }

    private static void init() {
        if (CLASS == null) {
            try {
                CLASS = ModuleLayerWrapper.class.getClassLoader().loadClass("java.lang.ModuleLayer");
                boot = CLASS.getMethod("boot", new Class[0]);
                configuration = CLASS.getMethod("configuration", new Class[0]);
                defineModules = CLASS.getMethod("defineModules", ConfigurationWrapper.CLASS(), List.class, Function.class);
                defineModulesWithOneLoader = CLASS.getMethod("defineModulesWithOneLoader", ConfigurationWrapper.CLASS(), ClassLoader.class);
                findLoader = CLASS.getMethod("findLoader", String.class);
                findModule = CLASS.getMethod("findModule", String.class);
                modules = CLASS.getMethod("modules", new Class[0]);
            }
            catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static ModuleLayerWrapper boot() {
        ModuleLayerWrapper.init();
        try {
            return new ModuleLayerWrapper(boot.invoke(null, new Object[0]));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public ConfigurationWrapper configuration() {
        ModuleLayerWrapper.init();
        try {
            return new ConfigurationWrapper(configuration.invoke(this.self, new Object[0]));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static ControllerWrapper defineModules(ConfigurationWrapper cf, List<ModuleLayerWrapper> parentLayers, Function<String, ClassLoader> clf) {
        ModuleLayerWrapper.init();
        List _parentLayers = parentLayers.stream().map(w -> w.self).collect(Collectors.toList());
        try {
            return new ControllerWrapper(defineModules.invoke(null, cf.self, _parentLayers, clf));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public ModuleLayerWrapper defineModulesWithOneLoader(ConfigurationWrapper cf, ClassLoader parentLoader) {
        ModuleLayerWrapper.init();
        try {
            return new ModuleLayerWrapper(defineModulesWithOneLoader.invoke(this.self, cf.self, parentLoader));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public ClassLoader findLoader(String name) {
        ModuleLayerWrapper.init();
        try {
            return (ClassLoader)findLoader.invoke(this.self, name);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public Optional<ModuleWrapper> findModule(String n) {
        ModuleLayerWrapper.init();
        try {
            Optional invoke = (Optional)findModule.invoke(this.self, n);
            return invoke.map(o -> new ModuleWrapper(o));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public Set<ModuleWrapper> modules() {
        ModuleLayerWrapper.init();
        try {
            Set invoke = (Set)modules.invoke(this.self, new Object[0]);
            HashSet<ModuleWrapper> rv = new HashSet<ModuleWrapper>(invoke.size());
            for (Object o : invoke) {
                rv.add(new ModuleWrapper(o));
            }
            return rv;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static class ControllerWrapper {
        private static Class<?> CLASS;
        private static Method layer;
        private static Method addExports;
        private static Method addOpens;
        private static Method addReads;
        public final Object self;

        public ControllerWrapper(Object self) {
            this.self = self;
            if (CLASS == null) {
                CLASS = self.getClass();
                try {
                    layer = CLASS.getMethod("layer", new Class[0]);
                    addReads = CLASS.getMethod("addReads", ModuleWrapper.CLASS(), ModuleWrapper.CLASS());
                    addExports = CLASS.getMethod("addExports", ModuleWrapper.CLASS(), String.class, ModuleWrapper.CLASS());
                    addOpens = CLASS.getMethod("addOpens", ModuleWrapper.CLASS(), String.class, ModuleWrapper.CLASS());
                }
                catch (NoSuchMethodException | SecurityException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public ModuleLayerWrapper layer() {
            try {
                return new ModuleLayerWrapper(layer.invoke(this.self, new Object[0]));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        public ControllerWrapper addExports(ModuleWrapper source, String pn, ModuleWrapper target) {
            try {
                addExports.invoke(this.self, source.self, pn, target.self);
                return this;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        public ControllerWrapper addOpens(ModuleWrapper source, String pn, ModuleWrapper target) {
            try {
                addOpens.invoke(this.self, source.self, pn, target.self);
                return this;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        public ControllerWrapper addReads(ModuleWrapper source, ModuleWrapper target) {
            try {
                addReads.invoke(this.self, source.self, target.self);
                return this;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

