/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.computation;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typesystem.computation.ResolvingTypeParameterHintCollector;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgumentSource;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;

public class AbstractTypeComputer {
    @Inject
    private CommonTypeComputationServices services;

    protected LightweightTypeReference getTypeForName(Class<?> clazz, ITypeComputationState state) {
        ResourceSet resourceSet = state.getReferenceOwner().getContextResourceSet();
        JvmTypeReference typeReference = this.services.getTypeReferences().getTypeForName(clazz, (Notifier)resourceSet, new JvmTypeReference[0]);
        if (typeReference == null) {
            return state.getReferenceOwner().newUnknownTypeReference(clazz.getName());
        }
        return state.getReferenceOwner().toLightweightTypeReference(typeReference);
    }

    protected LightweightTypeReference getRawTypeForName(Class<?> clazz, ITypeReferenceOwner owner) {
        Object clazzType = this.findDeclaredType(clazz, owner);
        if (clazzType == null) {
            return owner.newUnknownTypeReference(clazz.getName());
        }
        LightweightTypeReference result = owner.toPlainTypeReference((JvmType)clazzType);
        return result;
    }

    protected <Type extends JvmType> Type findDeclaredType(Class<?> clazz, ITypeComputationState state) {
        return this.findDeclaredType(clazz, state.getReferenceOwner());
    }

    protected <Type extends JvmType> Type findDeclaredType(Class<?> clazz, ITypeReferenceOwner owner) {
        JvmType result = this.services.getTypeReferences().findDeclaredType(clazz, (Notifier)owner.getContextResourceSet());
        return (Type)result;
    }

    protected LightweightTypeReference getPrimitiveVoid(ITypeComputationState state) {
        return this.getRawTypeForName(Void.TYPE, state.getReferenceOwner());
    }

    protected LightweightTypeReference getCommonSuperType(List<LightweightTypeReference> types, ITypeComputationState state) {
        return this.getCommonSuperType(types, state.getReferenceOwner());
    }

    protected LightweightTypeReference getCommonSuperType(List<LightweightTypeReference> types, ITypeReferenceOwner owner) {
        return this.services.getTypeConformanceComputer().getCommonSuperType(types, owner);
    }

    protected void deferredBindTypeArgument(LightweightTypeReference declared, LightweightTypeReference actual, ITypeComputationState state) {
        if (declared != null && actual != null) {
            ResolvingTypeParameterHintCollector collector = new ResolvingTypeParameterHintCollector(state.getReferenceOwner(), BoundTypeArgumentSource.INFERRED);
            collector.processPairedReferences(declared, actual.getWrapperTypeIfPrimitive());
        }
    }
}

