/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

public class DiffUtil {
    public static String diff(String one, String two) {
        int start = 0;
        int end = 0;
        int minLength = Math.min(one.length(), two.length());
        int i = 0;
        while (i < minLength) {
            if (one.charAt(i) != two.charAt(i)) break;
            start = i + 1;
            ++i;
        }
        if (start == one.length() && start == two.length()) {
            return null;
        }
        if (start != 0 || one.length() != two.length()) {
            i = 1;
            while (i <= minLength - start) {
                if (one.charAt(one.length() - i) != two.charAt(two.length() - i)) break;
                end = i++;
            }
        }
        String commonPrefix = start == 0 ? "" : DiffUtil.shorten(one.substring(0, start), true);
        String commonSuffix = end == 0 ? "" : DiffUtil.shorten(one.substring(one.length() - end, one.length()), false);
        return String.valueOf(commonPrefix) + "[" + one.substring(start, one.length() - end) + "]" + commonSuffix + "\nvs\n" + commonPrefix + "[" + two.substring(start, two.length() - end) + "]" + commonSuffix;
    }

    protected static String shorten(String string, boolean isPrefix) {
        if (string.length() > 10) {
            if (isPrefix) {
                return "..." + string.substring(string.length() - 10);
            }
            return String.valueOf(string.substring(0, 10)) + "...";
        }
        return string;
    }
}

