/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.NoExpectation;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;

public class TypeLiteralHelper {
    private ExpressionTypeComputationState state;

    protected TypeLiteralHelper(ExpressionTypeComputationState state) {
        this.state = state;
    }

    protected LightweightTypeReference getRawTypeForName(Class<?> clazz, ITypeReferenceOwner owner) {
        JvmType clazzType = owner.getServices().getTypeReferences().findDeclaredType(clazz, (Notifier)owner.getContextResourceSet());
        if (clazzType == null) {
            return null;
        }
        LightweightTypeReference result = owner.toPlainTypeReference(clazzType);
        return result;
    }

    protected LightweightTypeReference getAsClassLiteral(JvmIdentifiableElement feature) {
        if (feature instanceof JvmType) {
            LightweightTypeReference voidType;
            ITypeReferenceOwner owner = this.state.getReferenceOwner();
            LightweightTypeReference result = this.getRawTypeForName(Class.class, owner);
            if (result == null) {
                return owner.newUnknownTypeReference(Class.class.getName());
            }
            LightweightTypeReference argumentType = owner.newParameterizedTypeReference((JvmType)feature);
            argumentType = ((LightweightTypeReference)argumentType).isPrimitiveVoid() ? ((voidType = this.getRawTypeForName(Void.class, owner)) == null ? owner.newUnknownTypeReference(Void.class.getName()) : voidType) : ((LightweightTypeReference)argumentType).getWrapperTypeIfPrimitive();
            ((ParameterizedTypeReference)result).addTypeArgument(argumentType);
            return result;
        }
        throw new IllegalArgumentException(String.valueOf(feature));
    }

    protected void applyPackageFragment(XMemberFeatureCall memberFeatureCall, JvmDeclaredType type) {
        XExpression target = memberFeatureCall.getMemberCallTarget();
        this.state.getResolvedTypes().acceptType(target, new NoExpectation(this.state, false), this.state.getReferenceOwner().newParameterizedTypeReference((JvmType)type), false, 0x100200);
        if (target instanceof XMemberFeatureCall) {
            this.applyPackageFragment((XMemberFeatureCall)target, type);
        }
    }
}

