/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.text.ui.source;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javafx.application.Platform;
import org.eclipse.fx.text.ui.ITextInputListener;
import org.eclipse.fx.text.ui.ITextPresentationListener;
import org.eclipse.fx.text.ui.ITextViewerExtension2;
import org.eclipse.fx.text.ui.ITextViewerExtension5;
import org.eclipse.fx.text.ui.TextPresentation;
import org.eclipse.fx.text.ui.source.IAnnotationAccess;
import org.eclipse.fx.text.ui.source.IAnnotationAccessExtension;
import org.eclipse.fx.text.ui.source.ISourceViewer;
import org.eclipse.fx.ui.controls.styledtext.StyleRange;
import org.eclipse.fx.ui.controls.styledtext.StyledTextArea;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationModelListenerExtension;

public class AnnotationPainter
implements IAnnotationModelListener,
IAnnotationModelListenerExtension,
ITextPresentationListener {
    private Object fHighlightedDecorationsMapLock = new Object();
    private Map<Annotation, Decoration> fHighlightedDecorationsMap = new HashMap<Annotation, Decoration>();
    private ISourceViewer fSourceViewer;
    private StyledTextArea fTextWidget;
    private IAnnotationAccess fAnnotationAccess;
    private Object fDecorationMapLock = new Object();
    private Position fTotalHighlightAnnotationRange = null;
    private Position fCurrentHighlightAnnotationRange = null;
    private Map fCachedAnnotationType2PaintingStrategy = new HashMap();
    private Map fPaintingStrategyId2PaintingStrategy = new HashMap();
    private Map fAnnotationType2PaintingStrategyId = new HashMap();
    private Map fCachedAnnotationType2Color = new HashMap();
    private Map fAnnotationType2Color = new HashMap();
    private volatile boolean fIsSettingModel = false;
    private boolean fInputDocumentAboutToBeChanged;
    private ITextInputListener fTextInputListener;

    public AnnotationPainter(ISourceViewer sourceViewer, IAnnotationAccess access) {
        this.fSourceViewer = sourceViewer;
        this.fAnnotationAccess = access;
        this.fTextWidget = sourceViewer.getTextWidget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void catchupWithModel(AnnotationModelEvent event) {
        Iterator<Annotation> e;
        Object object = this.fDecorationMapLock;
        // MONITORENTER : object
        // MONITOREXIT : object
        if (this.fSourceViewer.getAnnotationModel() == null) {
            Object object2 = this.fHighlightedDecorationsMapLock;
            // MONITORENTER : object2
            this.fHighlightedDecorationsMap.clear();
            // MONITOREXIT : object2
            return;
        }
        this.fSourceViewer.getDocument();
        int highlightAnnotationRangeStart = Integer.MAX_VALUE;
        int highlightAnnotationRangeEnd = -1;
        int drawRangeStart = Integer.MAX_VALUE;
        int drawRangeEnd = -1;
        Object object3 = this.fHighlightedDecorationsMapLock;
        // MONITORENTER : object3
        HashMap<Annotation, Decoration> highlightedDecorationsMap = new HashMap<Annotation, Decoration>(this.fHighlightedDecorationsMap);
        // MONITOREXIT : object3
        boolean isWorldChange = false;
        if (event == null || event.isWorldChange()) {
            isWorldChange = true;
            highlightedDecorationsMap.clear();
            e = this.fSourceViewer.getAnnotationModel().getAnnotationIterator();
        } else {
            Annotation[] removedAnnotations = event.getRemovedAnnotations();
            int i = 0;
            int length = removedAnnotations.length;
            while (i < length) {
                Position position;
                Annotation annotation = removedAnnotations[i];
                Decoration decoration = (Decoration)highlightedDecorationsMap.remove(annotation);
                if (decoration != null && (position = decoration.fPosition) != null) {
                    highlightAnnotationRangeStart = Math.min(highlightAnnotationRangeStart, position.offset);
                    highlightAnnotationRangeEnd = Math.max(highlightAnnotationRangeEnd, position.offset + position.length);
                }
                ++i;
            }
            Annotation[] changedAnnotations = event.getChangedAnnotations();
            int i2 = 0;
            int length2 = changedAnnotations.length;
            while (i2 < length2) {
                Annotation annotation = changedAnnotations[i2];
                boolean isHighlighting = false;
                Decoration decoration = (Decoration)highlightedDecorationsMap.get(annotation);
                if (decoration != null) {
                    Decoration removedDecoration;
                    isHighlighting = true;
                    if ((decoration = this.getDecoration(annotation, decoration)) == null && (removedDecoration = (Decoration)highlightedDecorationsMap.remove(annotation)) != null) {
                        highlightAnnotationRangeStart = Math.min(highlightAnnotationRangeStart, ((Decoration)removedDecoration).fPosition.offset);
                        highlightAnnotationRangeEnd = Math.max(highlightAnnotationRangeEnd, ((Decoration)removedDecoration).fPosition.offset + ((Decoration)removedDecoration).fPosition.length);
                    }
                } else if ((decoration = this.getDecoration(annotation, decoration)) != null && decoration.fPaintingStrategy instanceof ITextStyleStrategy) {
                    highlightedDecorationsMap.put(annotation, decoration);
                    isHighlighting = true;
                }
                boolean usesDrawingStrategy = !isHighlighting && decoration != null;
                Position position = null;
                position = decoration == null ? this.fSourceViewer.getAnnotationModel().getPosition(annotation) : decoration.fPosition;
                if (position != null && !position.isDeleted()) {
                    if (isHighlighting) {
                        highlightAnnotationRangeStart = Math.min(highlightAnnotationRangeStart, position.offset);
                        highlightAnnotationRangeEnd = Math.max(highlightAnnotationRangeEnd, position.offset + position.length);
                    }
                    if (usesDrawingStrategy) {
                        drawRangeStart = Math.min(drawRangeStart, position.offset);
                        drawRangeEnd = Math.max(drawRangeEnd, position.offset + position.length);
                    }
                } else {
                    Decoration removedDecoration = (Decoration)highlightedDecorationsMap.remove(annotation);
                    if (removedDecoration != null) {
                        highlightAnnotationRangeStart = Math.min(highlightAnnotationRangeStart, ((Decoration)removedDecoration).fPosition.offset);
                        highlightAnnotationRangeEnd = Math.max(highlightAnnotationRangeEnd, ((Decoration)removedDecoration).fPosition.offset + ((Decoration)removedDecoration).fPosition.length);
                    }
                }
                ++i2;
            }
            e = Arrays.asList(event.getAddedAnnotations()).iterator();
        }
        while (e.hasNext()) {
            Annotation annotation = (Annotation)e.next();
            Decoration pp = this.getDecoration(annotation, null);
            if (pp == null || !(pp.fPaintingStrategy instanceof ITextStyleStrategy)) continue;
            highlightedDecorationsMap.put(annotation, pp);
            highlightAnnotationRangeStart = Math.min(highlightAnnotationRangeStart, ((Decoration)pp).fPosition.offset);
            highlightAnnotationRangeEnd = Math.max(highlightAnnotationRangeEnd, ((Decoration)pp).fPosition.offset + ((Decoration)pp).fPosition.length);
        }
        Object object4 = this.fHighlightedDecorationsMapLock;
        // MONITORENTER : object4
        this.fHighlightedDecorationsMap = highlightedDecorationsMap;
        this.updateHighlightRanges(highlightAnnotationRangeStart, highlightAnnotationRangeEnd, isWorldChange);
        // MONITOREXIT : object4
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyTextPresentation(TextPresentation tp) {
        HashSet<Map.Entry<Annotation, Decoration>> decorations;
        Object object = this.fHighlightedDecorationsMapLock;
        synchronized (object) {
            if (this.fHighlightedDecorationsMap == null || this.fHighlightedDecorationsMap.isEmpty()) {
                return;
            }
            decorations = new HashSet<Map.Entry<Annotation, Decoration>>(this.fHighlightedDecorationsMap.entrySet());
        }
        IRegion region = tp.getExtent();
        int layer = 0;
        int maxLayer = 1;
        while (layer < maxLayer) {
            for (Map.Entry entry : decorations) {
                ITextViewerExtension5 extension3;
                Annotation a = (Annotation)entry.getKey();
                if (a.isMarkedDeleted()) continue;
                Decoration pp = (Decoration)entry.getValue();
                maxLayer = Math.max(maxLayer, pp.fLayer + 1);
                if (pp.fLayer != layer) continue;
                Position p = pp.fPosition;
                if (this.fSourceViewer instanceof ITextViewerExtension5 ? (extension3 = (ITextViewerExtension5)((Object)this.fSourceViewer)).modelRange2WidgetRange((IRegion)new Region(p.getOffset(), p.getLength())) == null : !this.fSourceViewer.overlapsWithVisibleRegion(p.offset, p.length)) continue;
                int regionEnd = region.getOffset() + region.getLength();
                int pEnd = p.getOffset() + p.getLength();
                if (pEnd < region.getOffset() || regionEnd <= p.getOffset()) continue;
                int start = Math.max(p.getOffset(), region.getOffset());
                int end = Math.min(regionEnd, pEnd);
                int length = Math.max(end - start, 0);
                StyleRange styleRange = new StyleRange(null, start, length, null, null);
                ((ITextStyleStrategy)pp.fPaintingStrategy).applyTextStyle(styleRange, pp.fAnnotationClass);
                tp.mergeStyleRange(styleRange);
            }
            ++layer;
        }
    }

    private Decoration getDecoration(Annotation annotation, Decoration decoration) {
        if (annotation.isMarkedDeleted()) {
            return null;
        }
        String type = annotation.getType();
        Object paintingStrategy = this.getPaintingStrategy(type);
        if (paintingStrategy == null) {
            return null;
        }
        String color = this.getColor(type);
        if (color == null) {
            return null;
        }
        Position position = this.fSourceViewer.getAnnotationModel().getPosition(annotation);
        if (position == null || position.isDeleted()) {
            return null;
        }
        if (decoration == null) {
            decoration = new Decoration();
        }
        decoration.fPosition = position;
        decoration.fAnnotationClass = color;
        decoration.fPaintingStrategy = paintingStrategy;
        return decoration;
    }

    private void updateHighlightRanges(int highlightAnnotationRangeStart, int highlightAnnotationRangeEnd, boolean isWorldChange) {
        if (highlightAnnotationRangeStart != Integer.MAX_VALUE) {
            int maxRangeStart = highlightAnnotationRangeStart;
            int maxRangeEnd = highlightAnnotationRangeEnd;
            if (this.fTotalHighlightAnnotationRange != null) {
                maxRangeStart = Math.min(maxRangeStart, this.fTotalHighlightAnnotationRange.offset);
                maxRangeEnd = Math.max(maxRangeEnd, this.fTotalHighlightAnnotationRange.offset + this.fTotalHighlightAnnotationRange.length);
            }
            if (this.fTotalHighlightAnnotationRange == null) {
                this.fTotalHighlightAnnotationRange = new Position(0);
            }
            if (this.fCurrentHighlightAnnotationRange == null) {
                this.fCurrentHighlightAnnotationRange = new Position(0);
            }
            if (isWorldChange) {
                this.fTotalHighlightAnnotationRange.offset = highlightAnnotationRangeStart;
                this.fTotalHighlightAnnotationRange.length = highlightAnnotationRangeEnd - highlightAnnotationRangeStart;
                this.fCurrentHighlightAnnotationRange.offset = maxRangeStart;
                this.fCurrentHighlightAnnotationRange.length = maxRangeEnd - maxRangeStart;
            } else {
                this.fTotalHighlightAnnotationRange.offset = maxRangeStart;
                this.fTotalHighlightAnnotationRange.length = maxRangeEnd - maxRangeStart;
                this.fCurrentHighlightAnnotationRange.offset = highlightAnnotationRangeStart;
                this.fCurrentHighlightAnnotationRange.length = highlightAnnotationRangeEnd - highlightAnnotationRangeStart;
            }
        } else if (isWorldChange) {
            this.fCurrentHighlightAnnotationRange = this.fTotalHighlightAnnotationRange;
            this.fTotalHighlightAnnotationRange = null;
        } else {
            this.fCurrentHighlightAnnotationRange = null;
        }
        this.adaptToDocumentLength(this.fCurrentHighlightAnnotationRange);
        this.adaptToDocumentLength(this.fTotalHighlightAnnotationRange);
    }

    private void adaptToDocumentLength(Position position) {
        if (position == null) {
            return;
        }
        int length = this.fSourceViewer.getDocument().getLength();
        position.offset = Math.min(position.offset, length);
        position.length = Math.min(position.length, length - position.offset);
    }

    private Object getPaintingStrategy(String type) {
        Object strategy = this.fCachedAnnotationType2PaintingStrategy.get(type);
        if (strategy != null) {
            return strategy;
        }
        strategy = this.fPaintingStrategyId2PaintingStrategy.get(this.fAnnotationType2PaintingStrategyId.get(type));
        if (strategy != null) {
            this.fCachedAnnotationType2PaintingStrategy.put(type, strategy);
            return strategy;
        }
        if (this.fAnnotationAccess instanceof IAnnotationAccessExtension) {
            IAnnotationAccessExtension ext = (IAnnotationAccessExtension)((Object)this.fAnnotationAccess);
            Object[] sts = ext.getSupertypes(type);
            int i = 0;
            while (i < sts.length) {
                strategy = this.fPaintingStrategyId2PaintingStrategy.get(this.fAnnotationType2PaintingStrategyId.get(sts[i]));
                if (strategy != null) {
                    this.fCachedAnnotationType2PaintingStrategy.put(type, strategy);
                    return strategy;
                }
                ++i;
            }
        }
        this.fCachedAnnotationType2PaintingStrategy.put(type, null);
        return null;
    }

    private String getColor(Object annotationType) {
        IAnnotationAccessExtension extension;
        Object[] superTypes;
        String color = (String)this.fCachedAnnotationType2Color.get(annotationType);
        if (color != null) {
            return color;
        }
        color = (String)this.fAnnotationType2Color.get(annotationType);
        if (color != null) {
            this.fCachedAnnotationType2Color.put(annotationType, color);
            return color;
        }
        if (this.fAnnotationAccess instanceof IAnnotationAccessExtension && (superTypes = (extension = (IAnnotationAccessExtension)((Object)this.fAnnotationAccess)).getSupertypes(annotationType)) != null) {
            int i = 0;
            while (i < superTypes.length) {
                color = (String)this.fAnnotationType2Color.get(superTypes[i]);
                if (color != null) {
                    this.fCachedAnnotationType2Color.put(annotationType, color);
                    return color;
                }
                ++i;
            }
        }
        return null;
    }

    private void updatePainting(AnnotationModelEvent event) {
        this.catchupWithModel(event);
        if (!this.fInputDocumentAboutToBeChanged) {
            this.invalidateTextPresentation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateTextPresentation() {
        Region r = null;
        Object object = this.fHighlightedDecorationsMapLock;
        synchronized (object) {
            if (this.fCurrentHighlightAnnotationRange != null) {
                r = new Region(this.fCurrentHighlightAnnotationRange.getOffset(), this.fCurrentHighlightAnnotationRange.getLength());
            }
        }
        if (r == null) {
            return;
        }
        if (this.fSourceViewer instanceof ITextViewerExtension2) {
            ((ITextViewerExtension2)((Object)this.fSourceViewer)).invalidateTextPresentation(r.getOffset(), r.getLength());
        } else {
            this.fSourceViewer.invalidateTextPresentation();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void modelChanged(AnnotationModelEvent event) {
        if (this.fIsSettingModel) {
            if (!Platform.isFxApplicationThread()) return;
            this.updatePainting(event);
            return;
        } else {
            Platform.runLater(() -> this.updatePainting(event));
        }
    }

    public void modelChanged(IAnnotationModel model) {
        this.modelChanged(new AnnotationModelEvent(model));
    }

    public void addAnnotationType(Object annotationType, Object strategyID) {
        this.fAnnotationType2PaintingStrategyId.put(annotationType, strategyID);
        this.fCachedAnnotationType2PaintingStrategy.clear();
        if (this.fTextInputListener == null) {
            this.fTextInputListener = new ITextInputListener(){

                @Override
                public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
                    AnnotationPainter.this.fInputDocumentAboutToBeChanged = true;
                }

                @Override
                public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
                    AnnotationPainter.this.fInputDocumentAboutToBeChanged = false;
                }
            };
            this.fSourceViewer.addTextInputListener(this.fTextInputListener);
        }
    }

    public void setAnnotationTypeColor(Object annotationType, String color) {
        if (color != null) {
            this.fAnnotationType2Color.put(annotationType, color);
        } else {
            this.fAnnotationType2Color.remove(annotationType);
        }
        this.fCachedAnnotationType2Color.clear();
    }

    public void addTextStyleStrategy(Object id, ITextStyleStrategy strategy) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        this.fPaintingStrategyId2PaintingStrategy.put(id, strategy);
        this.fCachedAnnotationType2PaintingStrategy.clear();
    }

    private static class Decoration {
        private Position fPosition;
        private String fAnnotationClass;
        private int fLayer;
        private Object fPaintingStrategy;

        private Decoration() {
        }
    }

    public static interface ITextStyleStrategy {
        public void applyTextStyle(StyleRange var1, String var2);
    }
}

