/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.util.ULocale;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Locale;

public abstract class BreakIterator
implements Cloneable {
    public static final int DONE = -1;
    public static final int KIND_CHARACTER = 0;
    public static final int KIND_WORD = 1;
    public static final int KIND_LINE = 2;
    public static final int KIND_SENTENCE = 3;

    protected BreakIterator() {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException();
        }
    }

    public abstract int first();

    public abstract int last();

    public abstract int next(int var1);

    public abstract int next();

    public abstract int previous();

    public abstract int following(int var1);

    public int preceding(int offset) {
        int pos = this.following(offset);
        while (pos >= offset && pos != -1) {
            pos = this.previous();
        }
        return pos;
    }

    public boolean isBoundary(int offset) {
        if (offset == 0) {
            return true;
        }
        return this.following(offset - 1) == offset;
    }

    public abstract int current();

    public abstract CharacterIterator getText();

    public void setText(String newText) {
        this.setText(new StringCharacterIterator(newText));
    }

    public abstract void setText(CharacterIterator var1);

    public static BreakIterator getWordInstance() {
        return BreakIterator.getWordInstance(Locale.getDefault());
    }

    public static BreakIterator getWordInstance(Locale where) {
        return BreakIterator.getBreakInstance(where, 1);
    }

    public static BreakIterator getWordInstance(ULocale where) {
        return BreakIterator.getBreakInstance(where.toLocale(), 1);
    }

    public static BreakIterator getLineInstance() {
        return BreakIterator.getLineInstance(Locale.getDefault());
    }

    public static BreakIterator getLineInstance(Locale where) {
        return BreakIterator.getBreakInstance(where, 2);
    }

    public static BreakIterator getLineInstance(ULocale where) {
        return BreakIterator.getBreakInstance(where.toLocale(), 2);
    }

    public static BreakIterator getCharacterInstance() {
        return BreakIterator.getCharacterInstance(Locale.getDefault());
    }

    public static BreakIterator getCharacterInstance(Locale where) {
        return BreakIterator.getBreakInstance(where, 0);
    }

    public static BreakIterator getCharacterInstance(ULocale where) {
        return BreakIterator.getBreakInstance(where.toLocale(), 0);
    }

    public static BreakIterator getSentenceInstance() {
        return BreakIterator.getSentenceInstance(Locale.getDefault());
    }

    public static BreakIterator getSentenceInstance(Locale where) {
        return BreakIterator.getBreakInstance(where, 3);
    }

    public static BreakIterator getSentenceInstance(ULocale where) {
        return BreakIterator.getBreakInstance(where.toLocale(), 3);
    }

    public static BreakIterator getBreakInstance(ULocale where, int kind) {
        return BreakIterator.getBreakInstance(where.toLocale(), 3);
    }

    private static BreakIterator getBreakInstance(Locale where, int kind) {
        java.text.BreakIterator br = null;
        switch (kind) {
            case 0: {
                br = java.text.BreakIterator.getCharacterInstance(where);
                break;
            }
            case 1: {
                br = java.text.BreakIterator.getWordInstance(where);
                break;
            }
            case 2: {
                br = java.text.BreakIterator.getLineInstance(where);
                break;
            }
            case 3: {
                br = java.text.BreakIterator.getSentenceInstance(where);
            }
        }
        return new BreakIteratorHandle(br);
    }

    public static synchronized Locale[] getAvailableLocales() {
        return java.text.BreakIterator.getAvailableLocales();
    }

    public static synchronized ULocale[] getAvailableULocales() {
        Locale[] locales = java.text.BreakIterator.getAvailableLocales();
        ULocale[] ulocales = new ULocale[locales.length];
        int i = 0;
        while (i < locales.length) {
            ulocales[i] = ULocale.forLocale(locales[i]);
            ++i;
        }
        return ulocales;
    }

    static final class BreakIteratorHandle
    extends BreakIterator {
        public final java.text.BreakIterator breakIterator;

        public BreakIteratorHandle(java.text.BreakIterator delegate) {
            this.breakIterator = delegate;
        }

        public int first() {
            return this.breakIterator.first();
        }

        public int last() {
            return this.breakIterator.last();
        }

        public int next(int n) {
            return this.breakIterator.next(n);
        }

        public int next() {
            return this.breakIterator.next();
        }

        public int previous() {
            return this.breakIterator.previous();
        }

        public int following(int offset) {
            return this.breakIterator.following(offset);
        }

        public int preceding(int offset) {
            return this.breakIterator.preceding(offset);
        }

        public boolean isBoundary(int offset) {
            return this.breakIterator.isBoundary(offset);
        }

        public int current() {
            return this.breakIterator.current();
        }

        public CharacterIterator getText() {
            return this.breakIterator.getText();
        }

        public void setText(CharacterIterator newText) {
            this.breakIterator.setText(newText);
        }

        public String toString() {
            return this.breakIterator.toString();
        }

        public Object clone() {
            return new BreakIteratorHandle((java.text.BreakIterator)this.breakIterator.clone());
        }

        public boolean equals(Object rhs) {
            try {
                return this.breakIterator.equals(((BreakIteratorHandle)rhs).breakIterator);
            }
            catch (Exception exception) {
                return false;
            }
        }

        public int hashCode() {
            return this.breakIterator.hashCode();
        }
    }
}

