/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.base.internal;

import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.fx.core.command.CommandService;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CommandServiceImpl
implements CommandService {
    private final @NonNull ECommandService commandService;
    private final @NonNull EHandlerService handlerService;

    @Inject
    public CommandServiceImpl(@NonNull ECommandService commandService, @NonNull EHandlerService handlerService) {
        this.commandService = commandService;
        this.handlerService = handlerService;
    }

    public boolean exists(@NonNull String commandId) {
        return this.commandService.getCommand(commandId) != null;
    }

    public boolean canExecute(@NonNull String commandId, @NonNull Map<@NonNull String, @Nullable Object> parameters) {
        ParameterizedCommand cmd = this.commandService.createCommand(commandId, parameters);
        return this.handlerService.canExecute(cmd);
    }

    public <O> Optional<@NonNull O> execute(@NonNull String commandId, @NonNull Map<@NonNull String, @Nullable Object> parameters) {
        ParameterizedCommand cmd = this.commandService.createCommand(commandId, parameters);
        return Optional.ofNullable(this.handlerService.executeHandler(cmd));
    }
}

