/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.fx;

import java.util.Collection;
import java.util.Hashtable;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.PersistState;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MContribution;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.ui.keybindings.e4.EBindingService;
import org.eclipse.fx.ui.services.theme.MultiURLStylesheet;
import org.eclipse.fx.ui.services.theme.MultiURLStylesheetTypeProvider;
import org.eclipse.fx.ui.services.theme.Stylesheet;
import org.eclipse.fx.ui.services.theme.StylesheetTypeProvider;
import org.eclipse.fx.ui.services.theme.ThemeManager;
import org.eclipse.fx.ui.workbench.base.Util;
import org.eclipse.fx.ui.workbench.base.rendering.ElementRenderer;
import org.eclipse.fx.ui.workbench.base.rendering.RendererFactory;
import org.eclipse.fx.ui.workbench.fx.key.KeyBindingDispatcher;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WWidget;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class PartRenderingEngine
implements IPresentationEngine {
    public static final @NonNull String engineURI = "bundleclass://org.eclipse.fx.ui.workbench.fx/org.eclipse.fx.ui.workbench.fx.PartRenderingEngine";
    private static final @NonNull String defaultFactoryUrl = "bundleclass://org.eclipse.fx.ui.workbench.renderers.fx/org.eclipse.fx.ui.workbench.renderers.fx.DefWorkbenchRendererFactory";
    private final @NonNull RendererFactory factory;
    private final @NonNull EModelService modelService;
    private MApplication app;
    private final @NonNull Logger logger;
    private final @NonNull IEventBroker eventBroker;

    @Inject
    PartRenderingEngine(@Named(value="rendererFactoryUri") @Optional @Nullable String _factoryUrl, @NonNull IEclipseContext context, @NonNull EModelService modelService, @NonNull IEventBroker eventBroker, @NonNull ThemeManager themeManager, @Preference(nodePath="org.eclipse.fx.ui.workbench.fx", value="cssTheme") String themeId, @Log @NonNull Logger logger) {
        PartRenderingEngine.registerDIStylesheets(context);
        this.logger = logger;
        String factoryUrl = _factoryUrl == null ? defaultFactoryUrl : _factoryUrl;
        IContributionFactory contribFactory = (IContributionFactory)context.get(IContributionFactory.class);
        RendererFactory factory = (RendererFactory)contribFactory.create(factoryUrl, context);
        if (factory == null) {
            throw new IllegalStateException("No renderer factory was created");
        }
        this.factory = factory;
        this.modelService = modelService;
        this.eventBroker = eventBroker;
        if (context.get(EBindingService.class.getName()) != null) {
            KeyBindingDispatcher dispatcher = (KeyBindingDispatcher)ContextInjectionFactory.make(KeyBindingDispatcher.class, (IEclipseContext)context);
            context.set(KeyBindingDispatcher.class, (Object)dispatcher);
        }
        this.setupEventListener(eventBroker);
        if (themeId != null && !themeId.isEmpty()) {
            try {
                themeManager.setCurrentThemeId(themeId);
            }
            catch (Throwable t) {
                this.logger.error("Unknown theme '" + themeId + "'", t);
            }
        }
        if (themeManager.getCurrentTheme() == null) {
            Object object = context.get("cssTheme");
            if (object != null && object instanceof String) {
                themeManager.setCurrentThemeId((String)object);
            } else {
                this.logger.info("No current theme is set");
            }
        }
    }

    private static void registerDIStylesheets(IEclipseContext context) {
        try {
            BundleContext bundleContext = FrameworkUtil.getBundle(PartRenderingEngine.class).getBundleContext();
            Collection list = bundleContext.getServiceReferences(StylesheetTypeProvider.class, null);
            for (ServiceReference r : list) {
                bundleContext.registerService(Stylesheet.class, (Object)((Stylesheet)ContextInjectionFactory.make((Class)((StylesheetTypeProvider)bundleContext.getService(r)).getType(), (IEclipseContext)context)), new Hashtable());
            }
            list = bundleContext.getServiceReferences(MultiURLStylesheetTypeProvider.class, null);
            for (ServiceReference r : list) {
                bundleContext.registerService(MultiURLStylesheet.class, (Object)((MultiURLStylesheet)ContextInjectionFactory.make((Class)((MultiURLStylesheetTypeProvider)bundleContext.getService(r)).getType(), (IEclipseContext)context)), new Hashtable());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    void setupEventListener(IEventBroker eventBroker) {
        EventHandler tbrEventHandler = new EventHandler(){

            public void handleEvent(Event event) {
                MUIElement changedObj = (MUIElement)event.getProperty("ChangedElement");
                if (changedObj.isToBeRendered()) {
                    PartRenderingEngine.this.createGui(changedObj);
                } else {
                    PartRenderingEngine.this.removeGui(changedObj);
                }
            }
        };
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/toBeRendered/*", tbrEventHandler);
        EventHandler childrenHandler = new EventHandler(){

            public void handleEvent(Event event) {
                block2: {
                    block3: {
                        Object changedObj = event.getProperty("ChangedElement");
                        if (!(changedObj instanceof MApplication)) break block2;
                        if (!UIEvents.isADD((Event)event)) break block3;
                        Iterable iterable = UIEvents.asIterable((Event)event, (String)"NewValue");
                        for (MWindow win : iterable) {
                            PartRenderingEngine.this.createGui((MUIElement)win);
                        }
                        break block2;
                    }
                    if (!UIEvents.isREMOVE((Event)event)) break block2;
                    Iterable iterable = UIEvents.asIterable((Event)event, (String)"OldValue");
                    for (MWindow win : iterable) {
                        PartRenderingEngine.this.removeGui((MUIElement)win);
                    }
                }
            }
        };
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/children/*", childrenHandler);
        EventHandler selectedElementHandler = new EventHandler(){

            public void handleEvent(Event event) {
                MWindow m;
                Object activeWindow;
                Object changedObj = event.getProperty("ChangedElement");
                if (changedObj instanceof MApplication && (activeWindow = event.getProperty("NewValue")) != null && activeWindow instanceof MWindow && (m = (MWindow)activeWindow).getWidget() instanceof WWidget) {
                    WWidget w = (WWidget)m.getWidget();
                    w.activate();
                }
            }
        };
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/*", selectedElementHandler);
    }

    public Object createGui(MUIElement element, Object parentWidget, IEclipseContext parentContext) {
        MContext ctxt;
        IEclipseContext lclContext;
        Object widget;
        if (!element.isToBeRendered()) {
            return null;
        }
        if (element.getWidget() != null) {
            return element.getWidget();
        }
        if (element instanceof MContext && ((MContext)element).getContext() == null) {
            PartRenderingEngine.createContext((MContext)element, parentContext);
        }
        if ((widget = this.createWidget(element)) != null) {
            MUIElement parentElement;
            Object parentRenderer;
            MPlaceholder parent;
            Object r = this.getRendererFor(element);
            r.processContent(element);
            r.postProcess(element);
            Object object = parent = element.getCurSharedRef() == null ? ((EObject)element).eContainer() : element.getCurSharedRef();
            if (parent instanceof MUIElement && (parentRenderer = this.getRendererFor(parentElement = (MUIElement)parent)) != null) {
                parentRenderer.childRendered(parentElement, element);
            }
        } else if (element instanceof MContext && (lclContext = (ctxt = (MContext)element).getContext()) != null) {
            lclContext.dispose();
            ctxt.setContext(null);
        }
        return widget;
    }

    private Object createWidget(@NonNull MUIElement element) {
        ElementRenderer<MUIElement, Object> renderer = this.getRenderer(element);
        if (renderer != null) {
            element.setRenderer(renderer);
            Object newWidget = renderer.createWidget(element);
            renderer.bindWidget(element, newWidget);
            return newWidget;
        }
        return null;
    }

    private ElementRenderer<@NonNull MUIElement, Object> getRenderer(@NonNull MUIElement uiElement) {
        return this.factory.getRenderer(uiElement);
    }

    protected <R extends ElementRenderer<? extends M, Object>, M extends MUIElement> R getRendererFor(@NonNull M element) {
        return (R)((ElementRenderer)element.getRenderer());
    }

    private static IEclipseContext createContext(MContext model, IEclipseContext parentContext) {
        IEclipseContext lclContext = parentContext.createChild(PartRenderingEngine.getContextName((MApplicationElement)model));
        Util.setup((MContext)model, (IEclipseContext)lclContext);
        return lclContext;
    }

    private static String getContextName(MApplicationElement element) {
        StringBuilder builder = new StringBuilder(element.getClass().getSimpleName());
        String elementId = element.getElementId();
        if (elementId != null && elementId.length() != 0) {
            builder.append(" (").append(elementId).append(") ");
        }
        builder.append("Context");
        return builder.toString();
    }

    public Object createGui(MUIElement element) {
        IEclipseContext parentContext = null;
        if (element.getCurSharedRef() != null) {
            MPlaceholder ph = element.getCurSharedRef();
            parentContext = this.getContext((MUIElement)ph.getParent());
        } else if (element.getParent() != null) {
            parentContext = this.getContext((MUIElement)element.getParent());
        } else if (element.getParent() == null) {
            parentContext = this.getContext((MUIElement)((EObject)element).eContainer());
        }
        return this.createGui(element, null, parentContext);
    }

    private IEclipseContext getContext(MUIElement parent) {
        if (parent instanceof MContext) {
            return ((MContext)parent).getContext();
        }
        return this.modelService.getContainingContext(parent);
    }

    public void removeGui(MUIElement element) {
        MPlaceholder container;
        Object object = container = element.getCurSharedRef() != null ? element.getCurSharedRef() : (MUIElement)((EObject)element).eContainer();
        if (container != null || element instanceof MWindow) {
            Object parentRenderer = container == null ? null : this.getRendererFor(container);
            Object renderer = this.getRendererFor(element);
            if (renderer != null) {
                renderer.preDestroy(element);
            }
            if (renderer != null) {
                MContribution contribution;
                if (!(element instanceof MWindow) && parentRenderer != null && container != null) {
                    try {
                        parentRenderer.hideChild((MUIElement)container, element);
                    }
                    catch (Throwable t) {
                        this.logger.error(t.getMessage(), t);
                    }
                }
                EObject eo = (EObject)element;
                EObject[] l = (EObject[])eo.eContents().toArray((Object[])new EObject[0]);
                MUIElement selectedElement = null;
                if (element instanceof MElementContainer) {
                    selectedElement = ((MElementContainer)element).getSelectedElement();
                }
                EObject[] eObjectArray = l;
                int n = l.length;
                int n2 = 0;
                while (n2 < n) {
                    EObject c = eObjectArray[n2];
                    if (c instanceof MUIElement && selectedElement != c) {
                        this.removeGui((MUIElement)c);
                    }
                    ++n2;
                }
                if (selectedElement != null && eo.eContents().contains((Object)selectedElement)) {
                    this.removeGui(selectedElement);
                }
                if (element instanceof MWindow && parentRenderer != null && container != null) {
                    try {
                        parentRenderer.hideChild((MUIElement)container, element);
                    }
                    catch (Throwable t) {
                        this.logger.error(t.getMessage(), t);
                    }
                }
                if (element instanceof MContribution) {
                    contribution = (MContribution)element;
                    Object client = contribution.getObject();
                    IEclipseContext parentContext = renderer.getModelContext(element);
                    if (parentContext != null && client != null) {
                        try {
                            ContextInjectionFactory.invoke((Object)client, PersistState.class, (IEclipseContext)parentContext, null);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                renderer.destroyWidget(element);
                if (element instanceof MContribution) {
                    contribution = (MContribution)element;
                    Object client = contribution.getObject();
                    IEclipseContext parentContext = renderer.getModelContext(element);
                    if (parentContext != null && client != null) {
                        try {
                            ContextInjectionFactory.uninject((Object)client, (IEclipseContext)parentContext);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    contribution.setObject(null);
                }
                if (element instanceof MContext) {
                    PartRenderingEngine.clearContext((MContext)element);
                }
                element.setRenderer(null);
            } else {
                ElementRenderer<@NonNull MUIElement, Object> r = this.getRenderer(element);
                if (r != null) {
                    r.destroyRenderingContext(element);
                }
            }
        }
    }

    private static void clearContext(MContext contextME) {
        MContext ctxt = contextME;
        IEclipseContext lclContext = ctxt.getContext();
        if (lclContext != null) {
            IEclipseContext parentContext = lclContext.getParent();
            if (parentContext != null) {
                IEclipseContext child = parentContext.getActiveChild();
                if (child == lclContext) {
                    child.deactivate();
                }
            } else {
                System.err.println("Strange: " + lclContext + " has no parent!");
            }
            ctxt.setContext(null);
            lclContext.dispose();
        }
    }

    public Object run(MApplicationElement uiRoot, IEclipseContext appContext) {
        this.app = (MApplication)uiRoot;
        MWindow selected = (MWindow)this.app.getSelectedElement();
        if (selected == null) {
            for (MWindow window : this.app.getChildren()) {
                this.createGui((MUIElement)window);
            }
            this.eventBroker.post("org/eclipse/e4/ui/LifeCycle/appStartupComplete", (Object)this.app);
        } else {
            this.createGui((MUIElement)selected);
            for (MWindow window : this.app.getChildren()) {
                if (selected == window) continue;
                this.createGui((MUIElement)window);
            }
            this.focusGui((MUIElement)selected);
            this.eventBroker.post("org/eclipse/e4/ui/LifeCycle/appStartupComplete", (Object)this.app);
            int deadlockCount = 0;
            MWindow element = selected;
            while (element != null) {
                if (element instanceof MElementContainer) {
                    if (((MElementContainer)element).getSelectedElement() == null && element instanceof MPart) break;
                    element = ((MElementContainer)element).getSelectedElement();
                }
                if (element instanceof MPlaceholder) {
                    element = ((MPlaceholder)element).getRef();
                }
                if (deadlockCount++ > 100) {
                    this.logger.error("Possible deadlock - Unable to restore focus to appropriate element");
                    return null;
                }
                if (element instanceof MPart && !(element instanceof MElementContainer)) break;
            }
            if (element != null) {
                this.focusGui((MUIElement)element);
            }
        }
        return null;
    }

    public void stop() {
        if (this.app != null) {
            this.app.getContext().set("__efx_engine_shutdown", (Object)Boolean.TRUE);
            for (MWindow w : this.app.getChildren()) {
                ElementRenderer<MUIElement, Object> r = this.getRenderer((MUIElement)w);
                if (r == null) continue;
                this.removeGui((MUIElement)w);
            }
        }
    }

    public void focusGui(MUIElement element) {
        Object implementation;
        ElementRenderer renderer = (ElementRenderer)element.getRenderer();
        if (renderer == null || element.getWidget() == null) {
            return;
        }
        Object object = implementation = element instanceof MContribution ? ((MContribution)element).getObject() : null;
        if (implementation == null) {
            renderer.focus(element);
            return;
        }
        try {
            IEclipseContext context = this.getContext(element);
            Object defaultValue = new Object();
            Object returnValue = ContextInjectionFactory.invoke((Object)implementation, Focus.class, (IEclipseContext)context, (Object)defaultValue);
            if (returnValue == defaultValue) {
                renderer.focus(element);
            }
        }
        catch (InjectionException e) {
            this.logger.errorf("Failed to grant focus to element (%s)", (Throwable)e, new Object[]{element.getElementId()});
        }
        catch (RuntimeException e) {
            this.logger.errorf("Failed to grant focus via DI to element (%s)", (Throwable)e, new Object[]{element.getElementId()});
        }
    }
}

