/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.observable;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import org.eclipse.fx.core.DisposeableCollector;
import org.eclipse.fx.core.Subscription;

public class FXObservableUtil {
    public static Subscription onInvalidate(Observable o, InvalidationListener l) {
        o.addListener(l);
        return () -> o.removeListener(l);
    }

    public static Subscription onInvalidate(Observable o, Runnable r) {
        InvalidationListener listener = l -> r.run();
        o.addListener(listener);
        return () -> o.removeListener(listener);
    }

    public static <T> Subscription onChange(ObservableValue<T> o, ChangeListener<? super T> l) {
        o.addListener(l);
        return () -> o.removeListener(l);
    }

    public static <T> Subscription onChange(ObservableValue<T> o, Consumer<? super T> l) {
        ChangeListener listener = (ob, ol, ne) -> l.accept(ne);
        o.addListener(listener);
        return () -> o.removeListener(listener);
    }

    public static <T> Subscription onChange(ObservableValue<T> o, BiConsumer<? super T, ? super T> l) {
        ChangeListener listener = (ob, ol, ne) -> l.accept(ol, ne);
        o.addListener(listener);
        return () -> o.removeListener(listener);
    }

    public static <E> Subscription onChange(ObservableList<E> o, ListChangeListener<? super E> l) {
        o.addListener(l);
        return () -> o.removeListener(l);
    }

    public static <E> Subscription onChange(ObservableSet<E> o, SetChangeListener<? super E> l) {
        o.addListener(l);
        return () -> o.removeListener(l);
    }

    public static <K, V> Subscription onChange(ObservableMap<K, V> o, MapChangeListener<K, V> l) {
        o.addListener(l);
        return () -> o.removeListener(l);
    }

    public static class Instance
    extends DisposeableCollector<Subscription> {
        public Instance() {
            super(Subscription::dispose);
        }

        public Subscription onInvalidate(Observable o, InvalidationListener l) {
            o.addListener(l);
            return this.wrap(() -> o.removeListener(l));
        }

        private Subscription wrap(Subscription subscription) {
            this.register(subscription);
            return () -> {
                this.unregister(subscription);
                subscription.dispose();
            };
        }

        public Subscription onInvalidate(Observable o, Runnable r) {
            return this.onInvalidate(o, l -> r.run());
        }

        public <T> Subscription onChange(ObservableValue<T> o, ChangeListener<? super T> l) {
            o.addListener(l);
            return this.wrap(() -> o.removeListener(l));
        }

        public <T> Subscription onChange(ObservableValue<T> o, Consumer<? super T> l) {
            return this.onChange(o, (ob, ol, ne) -> l.accept(ne));
        }

        public <T> Subscription onChange(ObservableValue<T> o, BiConsumer<? super T, ? super T> l) {
            return this.onChange(o, (ob, ol, ne) -> l.accept(ol, ne));
        }

        public <E> Subscription onChange(ObservableList<E> o, ListChangeListener<? super E> l) {
            o.addListener(l);
            return this.wrap(() -> o.removeListener(l));
        }

        public <E> Subscription onChange(ObservableSet<E> o, SetChangeListener<? super E> l) {
            o.addListener(l);
            return this.wrap(() -> o.removeListener(l));
        }

        public <K, V> Subscription onChange(ObservableMap<K, V> o, MapChangeListener<K, V> l) {
            o.addListener(l);
            return this.wrap(() -> o.removeListener(l));
        }
    }
}

