/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.fx.e4.internal;

import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.fx.code.editor.Input;
import org.eclipse.fx.code.editor.fx.services.Outline;
import org.eclipse.fx.code.editor.fx.services.OutlineTypeProviderService;
import org.eclipse.fx.core.RankedObjectRegistry;
import org.eclipse.fx.core.di.context.ServiceContextFunction;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={IContextFunction.class}, property={"service.context.key=activeOutline"})
public class ActiveOutlineContextFunction
extends ServiceContextFunction<OutlineTypeProviderService> {
    private Map<Input<?>, Outline> outlineCache = new WeakHashMap();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void registerService(OutlineTypeProviderService service, Map<String, Object> properties) {
        super.registerService((Object)service, properties);
    }

    protected void unregisterService(OutlineTypeProviderService service) {
        super.unregisterService((Object)service);
    }

    public Object compute(final IEclipseContext outerContext, String contextKey) {
        if (outerContext.containsKey("_local_rat")) {
            return null;
        }
        outerContext.set("_local_rat", (Object)Boolean.TRUE);
        outerContext.runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                outerContext.set("activeOutline", (Object)ActiveOutlineContextFunction.this.createOutline(context));
                return true;
            }
        });
        Outline outline = this.createOutline(outerContext);
        return outline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Outline createOutline(IEclipseContext context) {
        Input input = (Input)context.get("activeInput");
        context.set(Input.class, (Object)input);
        if (input != null) {
            Outline rv = this.outlineCache.get(input);
            if (rv == null) {
                RankedObjectRegistry rankedObjectRegistry = this.registry;
                synchronized (rankedObjectRegistry) {
                    this.registry.unsynchronizedStream().filter(p -> p.test((Object)input)).findFirst().ifPresent(p -> this.outlineCache.put(input, (Outline)ContextInjectionFactory.make((Class)p.getType((Object)input), (IEclipseContext)context)));
                    rv = this.outlineCache.get(input);
                }
            }
            return rv;
        }
        return null;
    }
}

