/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.fx;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.geometry.Point2D;
import javafx.scene.image.Image;
import javafx.stage.Screen;
import javafx.stage.Stage;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.workbench.IResourceUtilities;
import org.eclipse.e4.ui.workbench.lifecycle.PreSave;
import org.eclipse.emf.common.util.URI;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.fx.core.SystemUtils;
import org.eclipse.fx.core.ThreadSynchronize;
import org.eclipse.fx.core.app.ApplicationContext;
import org.eclipse.fx.core.app.ApplicationInstance;
import org.eclipse.fx.core.app.ApplicationLocation;
import org.eclipse.fx.core.app.ExitStatus;
import org.eclipse.fx.core.databinding.JFXRealm;
import org.eclipse.fx.core.event.EventBus;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.core.log.LoggerCreator;
import org.eclipse.fx.osgi.util.AbstractJFXApplication;
import org.eclipse.fx.ui.services.resources.GraphicsLoader;
import org.eclipse.fx.ui.services.startup.StartupProgressTrackerService;
import org.eclipse.fx.ui.services.theme.Theme;
import org.eclipse.fx.ui.services.theme.ThemeManager;
import org.eclipse.fx.ui.workbench.base.AbstractE4Application;
import org.eclipse.fx.ui.workbench.fx.DefaultJFXApp;
import org.eclipse.fx.ui.workbench.fx.EMFUri;
import org.eclipse.fx.ui.workbench.fx.internal.GraphicsLoaderImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.prefs.BackingStoreException;

public class E4Application
extends AbstractE4Application
implements IApplication,
ApplicationInstance {
    static Logger LOGGER = LoggerCreator.createLogger(E4Application.class);
    E4Workbench workbench;
    ApplicationLocation instanceLocation;
    IEclipseContext workbenchContext;
    private static final String PRIMARY_STAGE_KEY = "primaryStage";
    private static final String CREATE_WORKBENCH_ON_NON_UI_THREAD_ARG = "createWorkbenchOnNonUIThread";
    private static final String NO_IMPLICIT_EXIT = "noImplicitExit";
    static E4Application SELF;
    ApplicationContext applicationContext;
    ExitStatus returnValue;
    protected EventAdmin eventAdmin;
    StartupProgressTrackerService startupService;

    public static @NonNull E4Application getE4Application() {
        E4Application self = SELF;
        if (self == null) {
            throw new IllegalStateException("Application not yet initialized");
        }
        return self;
    }

    public CompletableFuture<ExitStatus> launch(ApplicationContext context) {
        ServiceReference serviceReference;
        SELF = this;
        this.applicationContext = context;
        Bundle b = FrameworkUtil.getBundle(AbstractJFXApplication.class);
        BundleContext bundleContext = b.getBundleContext();
        ServiceReference ref = bundleContext.getServiceReference(EventAdmin.class);
        if (ref != null) {
            this.eventAdmin = (EventAdmin)bundleContext.getService(ref);
        }
        if ((serviceReference = bundleContext.getServiceReference(StartupProgressTrackerService.class)) != null) {
            this.startupService = (StartupProgressTrackerService)bundleContext.getService(serviceReference);
            this.startupService.applicationLaunched(this.applicationContext);
        } else {
            this.applicationContext.applicationRunning();
        }
        CompletableFuture<ExitStatus> rv = CompletableFuture.supplyAsync(() -> {
            try {
                this.launchE4JavaFxApplication();
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
            try {
                ExitStatus exitStatus = this.returnValue == null ? ExitStatus.OK : this.returnValue;
                return exitStatus;
            }
            finally {
                this.returnValue = null;
            }
        }, Executors.newSingleThreadExecutor());
        return rv;
    }

    public Object start(IApplicationContext context) throws Exception {
        ServiceReference serviceReference;
        SELF = this;
        this.applicationContext = new ApplicationContextImpl(context);
        Bundle b = FrameworkUtil.getBundle(AbstractJFXApplication.class);
        BundleContext bundleContext = b.getBundleContext();
        ServiceReference ref = bundleContext.getServiceReference(EventAdmin.class);
        if (ref != null) {
            this.eventAdmin = (EventAdmin)bundleContext.getService(ref);
        }
        if ((serviceReference = bundleContext.getServiceReference(StartupProgressTrackerService.class)) != null) {
            this.startupService = (StartupProgressTrackerService)bundleContext.getService(serviceReference);
            this.startupService.applicationLaunched(this.applicationContext);
        } else {
            this.applicationContext.applicationRunning();
        }
        this.launchE4JavaFxApplication();
        if (this.returnValue == null) {
            return IApplication.EXIT_OK;
        }
        if (this.returnValue == ExitStatus.OK) {
            return IApplication.EXIT_OK;
        }
        return IApplication.EXIT_RESTART;
    }

    public void jfxStart(final ApplicationContext context, final Application jfxApplication, final Stage primaryStage) {
        this.updateStartupState((StartupProgressTrackerService.ProgressState)StartupProgressTrackerService.DefaultProgressState.JAVAFX_INITIALIZED);
        Runnable startRunnable = new Runnable(){

            @Override
            public void run() {
                if (E4Application.this.workbench == null && !E4Application.this.initE4Workbench(context, jfxApplication, primaryStage)) {
                    E4Application.this.calculateReturnValue();
                    return;
                }
                E4Workbench workbench = E4Application.this.workbench;
                if (workbench == null) {
                    throw new IllegalStateException("Not workbench instance yet available");
                }
                IEclipseContext wbContext = workbench.getContext();
                if (wbContext == null) {
                    throw new IllegalStateException("The workbench has no context assigned");
                }
                ThreadSynchronize uiSync = (ThreadSynchronize)workbench.getContext().get(ThreadSynchronize.class);
                uiSync.syncExec(() -> {
                    E4Application.this.instanceLocation = (ApplicationLocation)wbContext.get("instanceLocation");
                    try {
                        if (!E4Application.this.checkInstanceLocation(E4Application.this.instanceLocation, wbContext)) {
                            E4Application.this.updateStartupState((StartupProgressTrackerService.ProgressState)StartupProgressTrackerService.DefaultProgressState.LOCATION_CHECK_FAILED);
                            return;
                        }
                        workbench.createAndRunUI((MApplicationElement)E4Application.this.workbench.getApplication());
                    }
                    finally {
                        E4Application.this.postJfxStarted(context);
                    }
                });
            }
        };
        if (E4Application.getArgValue((String)CREATE_WORKBENCH_ON_NON_UI_THREAD_ARG, (ApplicationContext)context, (boolean)true) != null) {
            Thread t = new Thread(startRunnable);
            t.start();
        } else {
            startRunnable.run();
        }
    }

    protected void preLifecycle(IEclipseContext appContext) {
        super.preLifecycle(appContext);
        appContext.set(GraphicsLoader.class, (Object)((GraphicsLoader)ContextInjectionFactory.make(GraphicsLoaderImpl.class, (IEclipseContext)appContext)));
    }

    public void jfxStop() {
        block8: {
            this.calculateReturnValue();
            try {
                ThemeManager manager;
                Theme theme;
                if (this.workbenchContext == null || this.workbench == null) break block8;
                if (this.getLifecycleManager() != null) {
                    ContextInjectionFactory.invoke((Object)this.getLifecycleManager(), PreSave.class, (IEclipseContext)this.workbenchContext, null);
                }
                if ((theme = (manager = (ThemeManager)this.workbenchContext.get(ThemeManager.class)).getCurrentTheme()) != null) {
                    IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.fx.ui.workbench.fx");
                    node.put("cssTheme", theme.getId());
                    try {
                        node.flush();
                    }
                    catch (BackingStoreException e) {
                        LOGGER.error("Failed to remember the theme id", (Throwable)e);
                    }
                }
                this.workbench.close();
                this.saveModel();
            }
            finally {
                if (this.instanceLocation != null) {
                    this.instanceLocation.release();
                }
            }
        }
    }

    void calculateReturnValue() {
        Object result = null;
        if (this.workbenchContext != null && (result = this.workbenchContext.get("e4.osgi.exit.code")) == null && this.workbench != null && this.workbench.isRestart()) {
            result = ExitStatus.RESTART;
        }
        if (result != null && result instanceof ExitStatus) {
            this.returnValue = (ExitStatus)result;
        } else if (this.returnValue == null) {
            this.returnValue = ExitStatus.OK;
        }
    }

    public void stop(ExitStatus status) {
        this.returnValue = status;
    }

    public void stop() {
    }

    public boolean initE4Workbench(ApplicationContext context, Application jfxApplication, Stage primaryStage) {
        this.workbenchContext = this.createApplicationContext();
        if (Boolean.parseBoolean(E4Application.getArgValue((String)NO_IMPLICIT_EXIT, (ApplicationContext)this.applicationContext, (boolean)true))) {
            Platform.setImplicitExit((boolean)false);
            ((EventBus)this.workbenchContext.get(EventBus.class)).subscribe("org/eclipse/e4/ui/LifeCycle/appShutdownStarted", e -> Platform.exit());
        }
        this.workbenchContext.set(Application.class, (Object)jfxApplication);
        this.workbenchContext.set(ApplicationContext.class, (Object)context);
        this.workbenchContext.set(PRIMARY_STAGE_KEY, (Object)primaryStage);
        this.workbench = this.createE4Workbench(context, this.workbenchContext);
        return this.workbench != null;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    protected void launchE4JavaFxApplication() throws Exception {
        Application.launch(this.getJfxApplicationClass(), (String[])new String[0]);
    }

    protected Class<? extends Application> getJfxApplicationClass() {
        return DefaultJFXApp.class;
    }

    protected void postJfxStarted(ApplicationContext context) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.sendEvent("org/eclipse/fx/E4Application/Launched", map);
        this.updateStartupState((StartupProgressTrackerService.ProgressState)StartupProgressTrackerService.DefaultProgressState.WORKBENCH_GUI_SHOWING);
    }

    protected Realm createRealm(IEclipseContext appContext) {
        return JFXRealm.createDefault();
    }

    protected void updateStartupState(StartupProgressTrackerService.ProgressState progressState) {
        if (this.startupService != null) {
            this.startupService.stateReached(progressState);
        }
    }

    protected IResourceUtilities<Image> createResourceUtility(final IEclipseContext appContext) {
        return new IResourceUtilities<Image>(){

            public Image imageDescriptorFromURI(URI iconPath) {
                if (iconPath == null) {
                    return null;
                }
                GraphicsLoader l = (GraphicsLoader)appContext.get(GraphicsLoader.class);
                return l.getImage((org.eclipse.fx.core.URI)new EMFUri(iconPath));
            }
        };
    }

    protected String getDefaultPresentationEngineURI(IEclipseContext appContext) {
        return "bundleclass://org.eclipse.fx.ui.workbench.fx/org.eclipse.fx.ui.workbench.fx.PartRenderingEngine";
    }

    protected void sendEvent(String topic, Map<String, Object> map) {
        if (this.eventAdmin != null) {
            this.eventAdmin.sendEvent(new Event(topic, map));
        } else {
            LOGGER.warningf("Could not send the %s event. EventAdmin is missing.", new Object[]{topic});
        }
    }

    static class ApplicationContextImpl
    implements ApplicationContext {
        private final IApplicationContext application;

        public ApplicationContextImpl(IApplicationContext application) {
            this.application = application;
        }

        public void applicationRunning() {
            this.application.applicationRunning();
        }

        public Optional<ApplicationContext.Splash> getSplashImage() {
            URL url;
            Bundle bundle = this.application.getBrandingBundle();
            if (bundle != null && (url = bundle.getResource("splash.bmp")) != null) {
                return Optional.of(new SplashImpl(url));
            }
            return Optional.empty();
        }

        public String[] getApplicationArguments() {
            return (String[])this.application.getArguments().get("application.args");
        }

        public Object getApplicationProperty(String key) {
            return this.application.getBrandingProperty(key);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public Optional<ApplicationLocation> getInstanceLocation() {
            BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
            try {
                @NonNull Collection references = context.getServiceReferences(Location.class, Location.INSTANCE_FILTER);
                if (!references.isEmpty()) {
                    return Optional.of(new ApplicationLocationImpl((Location)context.getService((ServiceReference)references.iterator().next())));
                }
                LoggerCreator.createLogger(this.getClass()).error("Could not find an instance location service");
            }
            catch (InvalidSyntaxException e) {
                LoggerCreator.createLogger(this.getClass()).error("Failed to create a filter '" + Location.INSTANCE_FILTER + "'", (Throwable)e);
            }
            return Optional.empty();
        }
    }

    static class ApplicationLocationImpl
    implements ApplicationLocation,
    Location {
        private final Location location;

        public ApplicationLocationImpl(Location location) {
            this.location = location;
        }

        public boolean lock() throws IOException {
            return this.location.lock();
        }

        public void release() {
            this.location.release();
        }

        public Path getPath() {
            URL url = this.location.getURL();
            try {
                return Paths.get(url.toURI());
            }
            catch (URISyntaxException e) {
                LoggerCreator.createLogger(this.getClass()).error("Failed to get the path for '" + url + "'", (Throwable)e);
                return null;
            }
        }

        public URL getURL() {
            return this.location.getURL();
        }

        public boolean isReadOnly() {
            return this.location.isReadOnly();
        }

        public boolean allowsDefault() {
            return this.location.allowsDefault();
        }

        public URL getDefault() {
            return this.location.getDefault();
        }

        public Location getParentLocation() {
            return this.location.getParentLocation();
        }

        public boolean isSet() {
            return this.location.isSet();
        }

        public boolean setURL(URL value, boolean lock) throws IllegalStateException {
            return this.location.setURL(value, lock);
        }

        public boolean set(URL value, boolean lock) throws IllegalStateException, IOException {
            return this.location.set(value, lock);
        }

        public boolean set(URL value, boolean lock, String lockFilePath) throws IllegalStateException, IOException {
            return this.location.set(value, lock, lockFilePath);
        }

        public boolean isLocked() throws IOException {
            return this.location.isLocked();
        }

        public Location createLocation(Location parent, URL defaultValue, boolean readonly) {
            return this.location.createLocation(parent, defaultValue, readonly);
        }

        public URL getDataArea(String path) throws IOException {
            return this.location.getDataArea(path);
        }
    }

    static class SplashImpl
    implements ApplicationContext.Splash {
        private final URL url;
        private Point2D location;

        public SplashImpl(URL url) {
            this.url = url;
        }

        public URL getUrl() {
            return this.url;
        }

        public Point2D getLocation() {
            if (this.location == null) {
                Image img = new Image(this.getUrl().toExternalForm());
                double x = SystemUtils.isMacOS() ? Screen.getPrimary().getVisualBounds().getWidth() / 2.0 - img.getWidth() / 2.0 - 1.0 : Screen.getPrimary().getBounds().getWidth() / 2.0 - img.getWidth() / 2.0 - 1.0;
                double y = SystemUtils.isMacOS() ? 227.0 : Screen.getPrimary().getBounds().getHeight() / 2.0 - img.getHeight() / 2.0;
                this.location = new Point2D(x, y);
            }
            return this.location;
        }
    }
}

