/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.fx.internal;

import java.util.ArrayList;
import java.util.Collection;
import javafx.beans.property.Property;
import javafx.collections.FXCollections;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.emf.common.util.URI;
import org.eclipse.fx.ui.services.resources.GraphicsLoader;
import org.eclipse.fx.ui.workbench.fx.EMFUri;
import org.eclipse.fx.ui.workbench.renderers.fx.internal.Row;

public class MultiMessageDialogContent
extends BorderPane {
    public final ListView<Row> tabView;

    public MultiMessageDialogContent(String message, Collection<MPart> parts, GraphicsLoader graphicsLoader) {
        Label l = new Label(message);
        this.setTop((Node)l);
        this.tabView = new ListView();
        this.tabView.setPrefHeight(200.0);
        this.tabView.setCellFactory(v -> new CheckboxCell(graphicsLoader));
        ArrayList<Row> list = new ArrayList<Row>();
        for (MPart m : parts) {
            list.add(new Row(m));
        }
        this.tabView.setItems(FXCollections.observableArrayList(list));
        this.setCenter((Node)this.tabView);
    }

    static class CheckboxCell
    extends ListCell<Row> {
        private CheckBox checkbox = new CheckBox();
        private Row row;
        private GraphicsLoader loader;

        public CheckboxCell(GraphicsLoader loader) {
            this.loader = loader;
        }

        protected void updateItem(Row item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (this.row != null) {
                this.checkbox.selectedProperty().unbindBidirectional((Property)this.row.selectedProperty());
            }
            this.row = item;
            if (this.row != null && !empty) {
                this.checkbox.selectedProperty().bindBidirectional((Property)this.row.selectedProperty());
                String uri = item.getElement().getIconURI();
                Node n = null;
                if (uri != null) {
                    n = this.loader.getGraphicsNode((org.eclipse.fx.core.URI)new EMFUri(URI.createURI((String)uri)));
                }
                this.setGraphic((Node)new HBox(new Node[]{this.checkbox, new Label(this.row.getElement().getLocalizedLabel(), n)}));
            }
        }
    }
}

