/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools.encoding;

import org.sat4j.core.ConstrGroup;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.tools.encoding.EncodingStrategyAdapter;

public class Binary
extends EncodingStrategyAdapter {
    private static final long serialVersionUID = 1L;

    public IConstr addAtMostOne(ISolver solver, IVecInt literals) throws ContradictionException {
        int j;
        ConstrGroup group = new ConstrGroup(false);
        int n = literals.size();
        int p = (int)Math.ceil(Math.log(n) / Math.log(2.0));
        int k = (int)Math.pow(2.0, p) - n;
        VecInt clause = new VecInt();
        String binary = "";
        if (p == 0) {
            return group;
        }
        int[] y = new int[p];
        int i = 0;
        while (i < p) {
            y[i] = solver.nextFreeVarId(true);
            ++i;
        }
        i = 0;
        while (i < k) {
            binary = Integer.toBinaryString(i);
            while (binary.length() != p - 1) {
                binary = "0" + binary;
            }
            j = 0;
            while (j < p - 1) {
                clause.push(-literals.get(i));
                if (binary.charAt(j) == '0') {
                    clause.push(-y[j]);
                } else {
                    clause.push(y[j]);
                }
                group.add(solver.addClause(clause));
                clause.clear();
                ++j;
            }
            ++i;
        }
        i = k;
        while (i < n) {
            binary = Integer.toBinaryString(2 * k + i - k);
            while (binary.length() != p) {
                binary = "0" + binary;
            }
            j = 0;
            while (j < p) {
                clause.push(-literals.get(i));
                if (binary.charAt(j) == '0') {
                    clause.push(-y[j]);
                } else {
                    clause.push(y[j]);
                }
                group.add(solver.addClause(clause));
                clause.clear();
                ++j;
            }
            ++i;
        }
        return group;
    }

    public IConstr addAtMost(ISolver solver, IVecInt literals, int k) throws ContradictionException {
        int n = literals.size();
        int p = (int)Math.ceil(Math.log(n) / Math.log(2.0));
        ConstrGroup group = new ConstrGroup(false);
        int[][] b = new int[k][p];
        int i = 0;
        while (i < k) {
            int j = 0;
            while (j < p) {
                b[i][j] = solver.nextFreeVarId(true);
                ++j;
            }
            ++i;
        }
        int[][] t = new int[k][n];
        int i2 = 0;
        while (i2 < k) {
            int j = 0;
            while (j < n) {
                t[i2][j] = solver.nextFreeVarId(true);
                ++j;
            }
            ++i2;
        }
        VecInt clause1 = new VecInt();
        VecInt clause2 = new VecInt();
        String binary = "";
        int i3 = 0;
        while (i3 < n) {
            int max = Math.max(1, k - n + i3 + 1);
            int min = Math.min(i3 + 1, k);
            clause1.push(-literals.get(i3));
            binary = Integer.toBinaryString(i3);
            while (binary.length() != p) {
                binary = "0" + binary;
            }
            int g = max - 1;
            while (g < min) {
                clause1.push(t[g][i3]);
                int j = 0;
                while (j < p) {
                    clause2.push(-t[g][i3]);
                    if (binary.charAt(j) == '0') {
                        clause2.push(-b[g][j]);
                    } else {
                        clause2.push(b[g][j]);
                    }
                    group.add(solver.addClause(clause2));
                    clause2.clear();
                    ++j;
                }
                ++g;
            }
            group.add(solver.addClause(clause1));
            clause1.clear();
            ++i3;
        }
        return group;
    }

    public IConstr addExactlyOne(ISolver solver, IVecInt literals) throws ContradictionException {
        ConstrGroup group = new ConstrGroup();
        group.add(this.addAtLeastOne(solver, literals));
        group.add(this.addAtMostOne(solver, literals));
        return group;
    }

    public IConstr addExactly(ISolver solver, IVecInt literals, int degree) throws ContradictionException {
        ConstrGroup group = new ConstrGroup();
        group.add(this.addAtLeast(solver, literals, degree));
        group.add(this.addAtMost(solver, literals, degree));
        return group;
    }
}

