/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.controlflow;

import com.google.inject.Inject;
import java.util.Map;
import java.util.Stack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.util.RecursionGuard;

public class EvaluationContext {
    @Inject
    private IBatchTypeResolver typeResolver;
    private RecursionGuard<EObject> visiting = new RecursionGuard();
    private Map<Resource, IResolvedTypes> resolvedTypesPerResource = CollectionLiterals.newHashMap();
    private Stack<IResolvedTypes> resolvedTypesStack = new Stack();

    public boolean tryNext(XExpression expression) {
        boolean _tryNext = this.visiting.tryNext(expression);
        if (_tryNext) {
            this.resolveTypes(expression);
            return true;
        }
        return false;
    }

    public void addResolvedTypes(Resource resource, IResolvedTypes resolvedTypes) {
        this.resolvedTypesPerResource.put(resource, resolvedTypes);
    }

    private void resolveTypes(XExpression expression) {
        Resource resource = expression.eResource();
        IResolvedTypes resolvedTypes = this.resolvedTypesPerResource.get(resource);
        if (resolvedTypes == null) {
            resolvedTypes = this.typeResolver.resolveTypes(expression);
            this.resolvedTypesPerResource.put(resource, resolvedTypes);
        }
        this.resolvedTypesStack.push(resolvedTypes);
    }

    public IResolvedTypes getResolvedTypes() {
        return this.resolvedTypesStack.peek();
    }

    public void done(XExpression expression) {
        this.resolvedTypesStack.pop();
        this.visiting.done(expression);
    }
}

